/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.util.NameTable;

public class CharBasedPNameTable
extends NameTable {
    protected PNameC[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected boolean _dirty;

    public CharBasedPNameTable(int initialSize) {
        int currSize;
        this._dirty = true;
        if (initialSize < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + initialSize);
        }
        for (currSize = 16; currSize < initialSize; currSize += currSize) {
        }
        initialSize = currSize;
        this._symbols = new PNameC[initialSize];
        this._buckets = new Bucket[initialSize >> 1];
        this._indexMask = initialSize - 1;
        this._size = 0;
        this._sizeThreshold = initialSize * 3 + 3 >> 2;
    }

    CharBasedPNameTable(CharBasedPNameTable parent2) {
        this._symbols = parent2._symbols;
        this._buckets = parent2._buckets;
        this._size = parent2._size;
        this._sizeThreshold = parent2._sizeThreshold;
        this._indexMask = parent2._indexMask;
        this._dirty = false;
    }

    public synchronized void mergeFromChild(CharBasedPNameTable child) {
        if (child.size() <= this.size()) {
            return;
        }
        this._symbols = child._symbols;
        this._buckets = child._buckets;
        this._size = child._size;
        this._sizeThreshold = child._sizeThreshold;
        this._indexMask = child._indexMask;
        this._dirty = false;
        child._dirty = false;
    }

    public int size() {
        return this._size;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public PNameC findSymbol(char[] buffer, int start, int len, int hash) {
        int index2 = hash & this._indexMask;
        PNameC sym = this._symbols[index2];
        if (sym != null) {
            if (sym.equalsPName(buffer, start, len, hash)) {
                return sym;
            }
            Bucket b = this._buckets[index2 >> 1];
            if (b != null && (sym = b.find(buffer, start, len, hash)) != null) {
                return sym;
            }
        }
        return null;
    }

    public PNameC addSymbol(char[] buffer, int start, int len, int hash) {
        boolean primary;
        String newStr = new String(buffer, start, len).intern();
        PNameC pname = PNameC.construct(newStr, hash);
        int index2 = hash & this._indexMask;
        if (null == this._symbols[index2]) {
            primary = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            index2 = hash & this._indexMask;
            primary = null == this._symbols[index2];
        } else {
            primary = false;
        }
        if (!this._dirty) {
            this.copyArrays();
        }
        ++this._size;
        if (primary) {
            this._symbols[index2] = pname;
        } else {
            int bix = index2 >> 1;
            this._buckets[bix] = new Bucket(pname, this._buckets[bix]);
        }
        return pname;
    }

    private void copyArrays() {
        PNameC[] oldSyms = this._symbols;
        int size = oldSyms.length;
        this._symbols = new PNameC[size];
        System.arraycopy(oldSyms, 0, this._symbols, 0, size);
        Bucket[] oldBuckets = this._buckets;
        size = oldBuckets.length;
        this._buckets = new Bucket[size];
        System.arraycopy(oldBuckets, 0, this._buckets, 0, size);
        this._dirty = true;
    }

    private void rehash() {
        int i;
        int size = this._symbols.length;
        int newSize = size + size;
        PNameC[] oldSyms = this._symbols;
        Bucket[] oldBuckets = this._buckets;
        this._symbols = new PNameC[newSize];
        this._buckets = new Bucket[newSize >> 1];
        this._indexMask = newSize - 1;
        this._sizeThreshold += this._sizeThreshold;
        int count = 0;
        for (i = 0; i < size; ++i) {
            PNameC symbol2 = oldSyms[i];
            if (symbol2 == null) continue;
            ++count;
            int index2 = symbol2.getCustomHash() & this._indexMask;
            if (this._symbols[index2] == null) {
                this._symbols[index2] = symbol2;
                continue;
            }
            int bix = index2 >> 1;
            this._buckets[bix] = new Bucket(symbol2, this._buckets[bix]);
        }
        size >>= 1;
        for (i = 0; i < size; ++i) {
            for (Bucket b = oldBuckets[i]; b != null; b = b.getNext()) {
                ++count;
                PNameC symbol3 = b.getSymbol();
                int index3 = symbol3.getCustomHash() & this._indexMask;
                if (this._symbols[index3] == null) {
                    this._symbols[index3] = symbol3;
                    continue;
                }
                int bix = index3 >> 1;
                this._buckets[bix] = new Bucket(symbol3, this._buckets[bix]);
            }
        }
        if (count != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + count + ".");
        }
    }

    static final class Bucket {
        private final PNameC mSymbol;
        private final Bucket mNext;

        public Bucket(PNameC symbol2, Bucket next) {
            this.mSymbol = symbol2;
            this.mNext = next;
        }

        public PNameC getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public PNameC find(char[] buf, int start, int len, int hash) {
            Bucket b = this;
            do {
                PNameC sym;
                if (!(sym = b.mSymbol).equalsPName(buf, start, len, hash)) continue;
                return sym;
            } while ((b = b.getNext()) != null);
            return null;
        }
    }
}

