/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.pipeline.AnalyseKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.session.SourcesToPathsMapper;
import org.jetbrains.kotlin.fir.session.SourcesToPathsMapperKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\f\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u001aH\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005*\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\f2\u001c\b\u0002\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013\u00a8\u0006\u0016"}, d2={"buildResolveAndCheckFir", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "resolveAndCheckFir", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "buildFirFromKtFiles", "", "buildFirViaLightTree", "files", "Lorg/jetbrains/kotlin/KtSourceFile;", "reportFilesAndLines", "Lkotlin/Function2;", "", "", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nfirUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/fir/pipeline/FirUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n1549#2:78\n1620#2,3:79\n*S KotlinDebug\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/fir/pipeline/FirUtilsKt\n*L\n31#1:74\n31#1:75,3\n50#1:78\n50#1:79,3\n*E\n"})
public final class FirUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirFile> buildFirViaLightTree(@NotNull FirSession $this$buildFirViaLightTree, @NotNull Collection<? extends KtSourceFile> files2, @Nullable DiagnosticReporter diagnosticsReporter, @Nullable Function2<? super Integer, ? super Integer, Unit> reportFilesAndLines) {
        List firFiles2;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$buildFirViaLightTree, "<this>");
            Intrinsics.checkNotNullParameter(files2, "files");
            FirProvider firProvider = FirProviderKt.getFirProvider($this$buildFirViaLightTree);
            Intrinsics.checkNotNull(firProvider, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
            FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
            SourcesToPathsMapper sourcesToPathsMapper = SourcesToPathsMapperKt.getSourcesToPathsMapper($this$buildFirViaLightTree);
            LightTree2Fir builder2 = new LightTree2Fir($this$buildFirViaLightTree, firProvider2.getKotlinScopeProvider(), diagnosticsReporter);
            boolean shouldCountLines = reportFilesAndLines != null;
            int linesCount = 0;
            Iterable $this$map$iv = files2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void file2;
                KtSourceFile ktSourceFile = (KtSourceFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Closeable closeable = new InputStreamReader(file2.getContentsAsStream(), Charsets.UTF_8);
                Throwable throwable = null;
                try {
                    InputStreamReader it = (InputStreamReader)closeable;
                    boolean bl2 = false;
                    object = KtSourceFileLinesMappingKt.readSourceFileWithMapping(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                Pair<CharSequence, KtSourceFileLinesMapping> pair = object;
                CharSequence code = pair.component1();
                KtSourceFileLinesMapping linesMapping = pair.component2();
                if (shouldCountLines) {
                    linesCount += linesMapping.getLinesCount();
                }
                Object firFile = object = builder2.buildFirFile(code, (KtSourceFile)file2, linesMapping);
                boolean bl3 = false;
                firProvider2.recordFile((FirFile)firFile);
                KtSourceElement ktSourceElement = ((FirFile)firFile).getSource();
                Intrinsics.checkNotNull(ktSourceElement);
                String string2 = file2.getPath();
                if (string2 == null) {
                    string2 = file2.getName();
                }
                sourcesToPathsMapper.registerFileSource(ktSourceElement, string2);
                collection.add(object);
            }
            firFiles2 = (List)destination$iv$iv;
            Function2<? super Integer, ? super Integer, Unit> function2 = reportFilesAndLines;
            if (function2 == null) break block9;
            function2.invoke((Integer)files2.size(), (Integer)linesCount);
        }
        return firFiles2;
    }

    public static /* synthetic */ List buildFirViaLightTree$default(FirSession firSession, Collection collection, DiagnosticReporter diagnosticReporter, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            diagnosticReporter = null;
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        return FirUtilsKt.buildFirViaLightTree(firSession, collection, diagnosticReporter, function2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirFile> buildFirFromKtFiles(@NotNull FirSession $this$buildFirFromKtFiles, @NotNull Collection<? extends KtFile> ktFiles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$buildFirFromKtFiles, "<this>");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        FirProvider firProvider = FirProviderKt.getFirProvider($this$buildFirFromKtFiles);
        Intrinsics.checkNotNull(firProvider, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl");
        FirProviderImpl firProvider2 = (FirProviderImpl)firProvider;
        RawFirBuilder builder2 = new RawFirBuilder($this$buildFirFromKtFiles, firProvider2.getKotlinScopeProvider(), null, 4, null);
        Iterable $this$map$iv = ktFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirFile firFile;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirFile firFile2 = firFile = builder2.buildFirFile((KtFile)it);
            boolean bl2 = false;
            firProvider2.recordFile(firFile2);
            collection.add(firFile);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ModuleCompilerAnalyzedOutput buildResolveAndCheckFir(@NotNull FirSession session, @NotNull List<? extends KtFile> ktFiles, @NotNull BaseDiagnosticsCollector diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        Intrinsics.checkNotNullParameter(diagnosticsReporter, "diagnosticsReporter");
        return FirUtilsKt.resolveAndCheckFir(session, FirUtilsKt.buildFirFromKtFiles(session, (Collection<? extends KtFile>)ktFiles), diagnosticsReporter);
    }

    @NotNull
    public static final ModuleCompilerAnalyzedOutput resolveAndCheckFir(@NotNull FirSession session, @NotNull List<? extends FirFile> firFiles2, @NotNull DiagnosticReporter diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(firFiles2, "firFiles");
        Intrinsics.checkNotNullParameter(diagnosticsReporter, "diagnosticsReporter");
        Pair<ScopeSession, List<FirFile>> pair = AnalyseKt.runResolution(session, firFiles2);
        ScopeSession scopeSession = pair.component1();
        List<FirFile> fir = pair.component2();
        AnalyseKt.runCheckers(session, scopeSession, fir, diagnosticsReporter);
        return new ModuleCompilerAnalyzedOutput(session, scopeSession, fir);
    }
}

