/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"getInlineClassBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassUnderlyingType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "ir.tree"})
public final class InlineClassesKt {
    @NotNull
    public static final IrSimpleType getInlineClassUnderlyingType(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(irClass2);
        if (inlineClassRepresentation == null) {
            throw new IllegalStateException(("Not an inline class: " + RenderIrElementKt.render(irClass2)).toString());
        }
        InlineClassRepresentation<IrSimpleType> representation = inlineClassRepresentation;
        return representation.getUnderlyingType();
    }

    @NotNull
    public static final IrField getInlineClassBackingField(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        for (IrDeclaration declaration : irClass2.getDeclarations()) {
            IrField backingField2;
            if (declaration instanceof IrField && !((IrField)declaration).isStatic()) {
                return (IrField)declaration;
            }
            if (!(declaration instanceof IrProperty) || (backingField2 = ((IrProperty)declaration).getBackingField()) == null || backingField2.isStatic()) continue;
            return backingField2;
        }
        throw new IllegalStateException(("Inline class has no field: " + IrUtilsKt.getFqNameWhenAvailable(irClass2)).toString());
    }
}

