/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.util;

import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.VisibleNamedKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\n"}, d2={"defaultTargetSubstitutions", "", "", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "substitute", "", "properties", "Ljava/util/Properties;", "substitutions", "kotlin-native-utils"})
public final class SubstitutionKt {
    @NotNull
    public static final Map<String, String> defaultTargetSubstitutions(@NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return MapsKt.mapOf(TuplesKt.to("target", target.getVisibleName()), TuplesKt.to("arch", VisibleNamedKt.getVisibleName((Enum)target.getArchitecture())), TuplesKt.to("family", VisibleNamedKt.getVisibleName((Enum)target.getFamily())));
    }

    public static final void substitute(@NotNull Properties properties2, @NotNull Map<String, String> substitutions) {
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(substitutions, "substitutions");
        for (String key : properties2.stringPropertyNames()) {
            for (String substitution : substitutions.values()) {
                String suffix = '.' + substitution;
                String string2 = key;
                Intrinsics.checkNotNullExpressionValue(string2, "key");
                if (!StringsKt.endsWith$default(string2, suffix, false, 2, null)) continue;
                String baseKey = StringsKt.removeSuffix(key, (CharSequence)suffix);
                String oldValue = properties2.getProperty(baseKey, "");
                String appendedValue = properties2.getProperty(key, "");
                String newValue2 = Intrinsics.areEqual(oldValue, "") ^ true ? oldValue + ' ' + appendedValue : appendedValue;
                properties2.setProperty(baseKey, newValue2);
            }
        }
    }
}

