/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class OperatorConventions {
    public static final Name DOUBLE = Name.identifier("toDouble");
    public static final Name FLOAT = Name.identifier("toFloat");
    public static final Name LONG = Name.identifier("toLong");
    public static final Name INT = Name.identifier("toInt");
    public static final Name CHAR = Name.identifier("toChar");
    public static final Name SHORT = Name.identifier("toShort");
    public static final Name BYTE = Name.identifier("toByte");
    public static final ImmutableSet<Name> NUMBER_CONVERSIONS = ImmutableSet.of(DOUBLE, FLOAT, LONG, INT, SHORT, BYTE, new Name[]{CHAR});
    public static final ImmutableBiMap<KtSingleValueToken, Name> UNARY_OPERATION_NAMES = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.PLUSPLUS, OperatorNameConventions.INC)).put(KtTokens.MINUSMINUS, OperatorNameConventions.DEC)).put(KtTokens.PLUS, OperatorNameConventions.UNARY_PLUS)).put(KtTokens.MINUS, OperatorNameConventions.UNARY_MINUS)).put(KtTokens.EXCL, OperatorNameConventions.NOT)).build();
    public static final ImmutableBiMap<KtSingleValueToken, Name> BINARY_OPERATION_NAMES = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.MUL, OperatorNameConventions.TIMES)).put(KtTokens.PLUS, OperatorNameConventions.PLUS)).put(KtTokens.MINUS, OperatorNameConventions.MINUS)).put(KtTokens.DIV, OperatorNameConventions.DIV)).put(KtTokens.PERC, OperatorNameConventions.REM)).put(KtTokens.RANGE, OperatorNameConventions.RANGE_TO)).put(KtTokens.RANGE_UNTIL, OperatorNameConventions.RANGE_UNTIL)).build();
    public static final ImmutableBiMap<Name, Name> REM_TO_MOD_OPERATION_NAMES = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(OperatorNameConventions.REM, OperatorNameConventions.MOD)).put(OperatorNameConventions.REM_ASSIGN, OperatorNameConventions.MOD_ASSIGN)).build();
    public static final ImmutableSet<KtSingleValueToken> NOT_OVERLOADABLE = ImmutableSet.of(KtTokens.ANDAND, KtTokens.OROR, KtTokens.ELVIS, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ);
    public static final ImmutableSet<KtSingleValueToken> INCREMENT_OPERATIONS = ImmutableSet.of(KtTokens.PLUSPLUS, KtTokens.MINUSMINUS);
    public static final ImmutableSet<KtSingleValueToken> COMPARISON_OPERATIONS = ImmutableSet.of(KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ);
    public static final ImmutableSet<KtSingleValueToken> EQUALS_OPERATIONS = ImmutableSet.of(KtTokens.EQEQ, KtTokens.EXCLEQ);
    public static final ImmutableSet<KtSingleValueToken> IDENTITY_EQUALS_OPERATIONS = ImmutableSet.of(KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ);
    public static final ImmutableSet<KtSingleValueToken> IN_OPERATIONS = ImmutableSet.of(KtTokens.IN_KEYWORD, KtTokens.NOT_IN);
    public static final ImmutableBiMap<KtSingleValueToken, Name> ASSIGNMENT_OPERATIONS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.MULTEQ, OperatorNameConventions.TIMES_ASSIGN)).put(KtTokens.DIVEQ, OperatorNameConventions.DIV_ASSIGN)).put(KtTokens.PERCEQ, OperatorNameConventions.REM_ASSIGN)).put(KtTokens.PLUSEQ, OperatorNameConventions.PLUS_ASSIGN)).put(KtTokens.MINUSEQ, OperatorNameConventions.MINUS_ASSIGN)).build();
    public static final ImmutableBiMap<KtSingleValueToken, KtSingleValueToken> ASSIGNMENT_OPERATION_COUNTERPARTS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.MULTEQ, KtTokens.MUL)).put(KtTokens.DIVEQ, KtTokens.DIV)).put(KtTokens.PERCEQ, KtTokens.PERC)).put(KtTokens.PLUSEQ, KtTokens.PLUS)).put(KtTokens.MINUSEQ, KtTokens.MINUS)).build();
    public static final ImmutableBiMap<KtSingleValueToken, Name> BOOLEAN_OPERATIONS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(KtTokens.ANDAND, OperatorNameConventions.AND)).put(KtTokens.OROR, OperatorNameConventions.OR)).build();
    public static final ImmutableSet<Name> CONVENTION_NAMES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET, OperatorNameConventions.INVOKE, OperatorNameConventions.CONTAINS, OperatorNameConventions.ITERATOR, OperatorNameConventions.NEXT, OperatorNameConventions.HAS_NEXT, OperatorNameConventions.EQUALS, OperatorNameConventions.COMPARE_TO, OperatorNameConventions.GET_VALUE, OperatorNameConventions.SET_VALUE})).addAll((Iterable)UNARY_OPERATION_NAMES.values())).addAll((Iterable)BINARY_OPERATION_NAMES.values())).addAll((Iterable)ASSIGNMENT_OPERATIONS.values())).build();

    private OperatorConventions() {
    }

    @Nullable
    public static Name getNameForOperationSymbol(@NotNull KtToken token) {
        if (token == null) {
            OperatorConventions.$$$reportNull$$$0(0);
        }
        return OperatorConventions.getNameForOperationSymbol(token, true, true);
    }

    @Nullable
    public static Name getNameForOperationSymbol(@NotNull KtToken token, boolean unaryOperations, boolean binaryOperations) {
        Name name2;
        if (token == null) {
            OperatorConventions.$$$reportNull$$$0(1);
        }
        if (binaryOperations && (name2 = (Name)BINARY_OPERATION_NAMES.get(token)) != null) {
            return name2;
        }
        if (unaryOperations && (name2 = (Name)UNARY_OPERATION_NAMES.get(token)) != null) {
            return name2;
        }
        name2 = (Name)ASSIGNMENT_OPERATIONS.get(token);
        if (name2 != null) {
            return name2;
        }
        if (COMPARISON_OPERATIONS.contains(token)) {
            return OperatorNameConventions.COMPARE_TO;
        }
        if (EQUALS_OPERATIONS.contains(token)) {
            return OperatorNameConventions.EQUALS;
        }
        if (IN_OPERATIONS.contains(token)) {
            return OperatorNameConventions.CONTAINS;
        }
        return null;
    }

    @Nullable
    public static KtToken getOperationSymbolForName(@NotNull Name name2) {
        if (name2 == null) {
            OperatorConventions.$$$reportNull$$$0(2);
        }
        if (!OperatorConventions.isConventionName(name2)) {
            return null;
        }
        KtToken token = (KtToken)((ImmutableMap)((Object)BINARY_OPERATION_NAMES.inverse())).get(name2);
        if (token != null) {
            return token;
        }
        token = (KtToken)((ImmutableMap)((Object)UNARY_OPERATION_NAMES.inverse())).get(name2);
        if (token != null) {
            return token;
        }
        token = (KtToken)((ImmutableMap)((Object)ASSIGNMENT_OPERATIONS.inverse())).get(name2);
        if (token != null) {
            return token;
        }
        return null;
    }

    public static boolean isConventionName(@NotNull Name name2) {
        if (name2 == null) {
            OperatorConventions.$$$reportNull$$$0(3);
        }
        return CONVENTION_NAMES.contains(name2) || OperatorNameConventions.COMPONENT_REGEX.matches(name2.asString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/types/expressions/OperatorConventions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForOperationSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperationSymbolForName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isConventionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

