/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0005\u001a\u00020\u0014H\u0002J\u0018\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0005\u001a\u00020\u0015H\u0002J\u0018\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0005\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0005\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0005\u001a\u00020\u000bH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter;", "", "()V", "represent", "", "it", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "representClassLike", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "appendRepresentation", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/name/ClassId;", "appendRepresentationBeforeCallableId", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "appendValueParameters", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirRedeclarationPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirRedeclarationPresenter.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,122:1\n1855#2,2:123\n1855#2,2:126\n41#3:125\n*S KotlinDebug\n*F\n+ 1 FirRedeclarationPresenter.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter\n*L\n61#1:123,2\n115#1:126,2\n78#1:125\n*E\n"})
public final class FirRedeclarationPresenter {
    @NotNull
    public static final FirRedeclarationPresenter INSTANCE = new FirRedeclarationPresenter();

    private FirRedeclarationPresenter() {
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, ClassId it) {
        $this$appendRepresentation.append(it.getPackageFqName().asString());
        $this$appendRepresentation.append('/');
        $this$appendRepresentation.append(it.getRelativeClassName().asString());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, CallableId it) {
        $this$appendRepresentation.append(it.getPackageName().asString());
        $this$appendRepresentation.append('/');
        if (it.getClassName() != null) {
            $this$appendRepresentation.append(it.getClassName());
            $this$appendRepresentation.append('.');
        }
        $this$appendRepresentation.append(it.getCallableName());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, FirValueParameter it) {
        if (it.isVararg()) {
            $this$appendRepresentation.append("vararg ");
        }
    }

    private final void appendRepresentationBeforeCallableId(StringBuilder $this$appendRepresentationBeforeCallableId, FirCallableDeclaration it) {
        int it2;
        int n = it.getContextReceivers().size();
        int n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('<');
        n = it.getTypeParameters().size();
        n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('>');
        $this$appendRepresentationBeforeCallableId.append('[');
        FirPureAbstractElement firPureAbstractElement = it.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it3 = firPureAbstractElement;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append(']');
    }

    private final void appendValueParameters(StringBuilder $this$appendValueParameters, FirSimpleFunction it) {
        $this$appendValueParameters.append('(');
        Iterable $this$forEach$iv = it.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it2 = (FirValueParameter)element$iv;
            boolean bl = false;
            INSTANCE.appendRepresentation($this$appendValueParameters, it2);
            $this$appendValueParameters.append(',');
        }
        $this$appendValueParameters.append(')');
    }

    @Nullable
    public final String represent(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirDeclaration firDeclaration = declaration;
        return firDeclaration instanceof FirSimpleFunction ? this.represent((FirSimpleFunction)declaration) : (firDeclaration instanceof FirRegularClass ? this.represent((FirRegularClass)declaration) : (firDeclaration instanceof FirTypeAlias ? this.represent((FirTypeAlias)declaration) : (firDeclaration instanceof FirProperty ? this.represent((FirVariable)declaration) : null)));
    }

    @NotNull
    public final String represent(@NotNull FirSimpleFunction it) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter(it, "it");
        StringBuilder $this$represent_u24lambda_u244 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u244, it);
        FirMemberDeclaration $this$isOperator$iv = it;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator()) {
            $this$represent_u24lambda_u244.append("operator ");
        }
        INSTANCE.appendRepresentation($this$represent_u24lambda_u244, it.getSymbol().getCallableId());
        INSTANCE.appendValueParameters($this$represent_u24lambda_u244, it);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String represent(@NotNull FirVariable it) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter(it, "it");
        StringBuilder $this$represent_u24lambda_u245 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u245, it);
        INSTANCE.appendRepresentation($this$represent_u24lambda_u245, it.getSymbol().getCallableId());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String represent(@NotNull FirTypeAlias it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.representClassLike(it);
    }

    @NotNull
    public final String represent(@NotNull FirRegularClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.representClassLike(it);
    }

    private final String representClassLike(FirClassLikeDeclaration it) {
        StringBuilder stringBuilder2;
        StringBuilder $this$representClassLike_u24lambda_u246 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$representClassLike_u24lambda_u246.append('<');
        $this$representClassLike_u24lambda_u246.append('>');
        $this$representClassLike_u24lambda_u246.append('[');
        $this$representClassLike_u24lambda_u246.append(']');
        INSTANCE.appendRepresentation($this$representClassLike_u24lambda_u246, it.getSymbol().getClassId());
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public final String represent(@NotNull FirConstructor it, @NotNull FirRegularClass owner) {
        int it2;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(owner, "owner");
        StringBuilder $this$represent_u24lambda_u2410 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        int n = it.getContextReceivers().size();
        int n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl2 = false;
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('<');
        n = it.getTypeParameters().size();
        n2 = 0;
        while (n2 < n) {
            it2 = n2++;
            boolean bl3 = false;
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append('>');
        $this$represent_u24lambda_u2410.append('[');
        $this$represent_u24lambda_u2410.append(']');
        INSTANCE.appendRepresentation($this$represent_u24lambda_u2410, owner.getSymbol().getClassId());
        $this$represent_u24lambda_u2410.append('(');
        Iterable $this$forEach$iv = it.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it3 = (FirValueParameter)element$iv;
            boolean bl4 = false;
            INSTANCE.appendRepresentation($this$represent_u24lambda_u2410, it3);
            $this$represent_u24lambda_u2410.append(',');
        }
        $this$represent_u24lambda_u2410.append(')');
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }
}

