/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a>\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"removeDuplicateImports", "", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "existingImports", "", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "replacements", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class RemoveDuplicateImportsKt {
    public static final void removeDuplicateImports(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        node.accept(new RecursiveJsVisitor(){

            public void visitBlock(@NotNull JsBlock x) {
                Intrinsics.checkNotNullParameter(x, "x");
                super.visitBlock(x);
                List<JsStatement> list2 = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
                RemoveDuplicateImportsKt.access$removeDuplicateImports(list2);
            }
        });
    }

    private static final void removeDuplicateImports(List<JsStatement> statements2) {
        Map existingImports = new LinkedHashMap();
        Map replacements = new LinkedHashMap();
        RemoveDuplicateImportsKt.removeDuplicateImports(statements2, existingImports, replacements);
        for (JsStatement statement2 : statements2) {
            RewriteUtilsKt.replaceNames((JsNode)statement2, replacements);
        }
    }

    private static final void removeDuplicateImports(List<JsStatement> statements2, Map<String, JsName> existingImports, Map<JsName, JsExpression> replacements) {
        int index2 = 0;
        while (index2 < statements2.size()) {
            JsStatement statement2 = statements2.get(index2);
            if (statement2 instanceof JsVars) {
                String importTag = CollectUtilsKt.getImportTag((JsVars)statement2);
                if (importTag != null) {
                    JsName name2 = ((JsVars)statement2).getVars().get(0).getName();
                    JsName existingName = existingImports.get(importTag);
                    if (existingName != null) {
                        JsNameRef jsNameRef;
                        Map<JsName, JsExpression> map = replacements;
                        Intrinsics.checkNotNull(name2);
                        JsName jsName = name2;
                        Intrinsics.checkNotNullExpressionValue(existingName.makeRef(), "makeRef(...)");
                        map.put(jsName, jsNameRef);
                        statements2.remove(index2);
                        continue;
                    }
                    Intrinsics.checkNotNull(name2);
                    existingImports.put(importTag, name2);
                }
            } else if (statement2 instanceof JsBlock) {
                List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
                RemoveDuplicateImportsKt.removeDuplicateImports(list2, existingImports, replacements);
            }
            ++index2;
        }
    }

    public static final /* synthetic */ void access$removeDuplicateImports(List statements2) {
        RemoveDuplicateImportsKt.removeDuplicateImports(statements2);
    }
}

