/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.AppendableDataExternalizer;
import org.jetbrains.kotlin.incremental.storage.AppendableLazyStorage;
import org.jetbrains.kotlin.incremental.storage.CachingLazyStorage;
import org.jetbrains.kotlin.incremental.storage.DefaultInMemoryStorageWrapper;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorageWrapper;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aJ\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u001aJ\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\f\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\r2\u0006\u0010\n\u001a\u00020\u000b\u001aL\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\f\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"createLazyStorage", "Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "K", "V", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "Lorg/jetbrains/kotlin/incremental/storage/AppendableLazyStorage;", "Lorg/jetbrains/kotlin/incremental/storage/AppendableDataExternalizer;", "createLazyStorageImpl", "kotlin-build-common"})
public final class CachingLazyStorageKt {
    private static final <K, V> AppendableLazyStorage<K, V> createLazyStorageImpl(File storageFile, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer, IncrementalCompilationContext icContext) {
        AppendableLazyStorage appendableLazyStorage;
        CachingLazyStorage<K, V> it = new CachingLazyStorage<K, V>(storageFile, keyDescriptor, valueExternalizer);
        boolean bl = false;
        if (icContext.getKeepIncrementalCompilationCachesInMemory()) {
            DefaultInMemoryStorageWrapper<K, V> defaultInMemoryStorageWrapper;
            DefaultInMemoryStorageWrapper<K, V> wrapper = defaultInMemoryStorageWrapper = new DefaultInMemoryStorageWrapper<K, V>(it, valueExternalizer);
            boolean bl2 = false;
            icContext.getTransaction().registerInMemoryStorageWrapper((InMemoryStorageWrapper)wrapper);
            appendableLazyStorage = defaultInMemoryStorageWrapper;
        } else {
            appendableLazyStorage = it;
        }
        return appendableLazyStorage;
    }

    @NotNull
    public static final <K, V> LazyStorage<K, V> createLazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        return CachingLazyStorageKt.createLazyStorageImpl(storageFile, keyDescriptor, valueExternalizer, icContext);
    }

    @NotNull
    public static final <K, V> AppendableLazyStorage<K, V> createLazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull AppendableDataExternalizer<V> valueExternalizer, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        return CachingLazyStorageKt.createLazyStorageImpl(storageFile, keyDescriptor, (DataExternalizer)valueExternalizer, icContext);
    }
}

