/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.AbstractDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005H\u0016J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u000eJ$\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\b\u0010#\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\"\u00101\u001a\u00020\u00182\u0006\u0010,\u001a\u0002022\u0006\u00103\u001a\u00020.2\b\u00104\u001a\u0004\u0018\u00010.H\u0016J\u0010\u00105\u001a\u00020.2\u0006\u0010,\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor;", "Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "containingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "enumInitializer", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "enumEntryOrdinal", "", "initializerStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getInitializerStatements", "()Ljava/util/List;", "enumEntries", "getEnumEntries", "enumInitializerName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getEnumInitializerName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "needCompanionInitializer", "", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "visitAnonymousInitializer", "expression", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "data", "addInitializerStatement", "statement", "addFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lorg/jetbrains/kotlin/psi/KtElement;", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "getBackingFieldReference", "js.translator"})
@SourceDebugExtension(value={"SMAP\nDeclarationBodyVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationBodyVisitor.kt\norg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1557#3:178\n1628#3,3:179\n1557#3:182\n1628#3,3:183\n*S KotlinDebug\n*F\n+ 1 DeclarationBodyVisitor.kt\norg/jetbrains/kotlin/js/translate/declaration/DeclarationBodyVisitor\n*L\n140#1:178\n140#1:179,3\n141#1:182\n141#1:183,3\n*E\n"})
public final class DeclarationBodyVisitor
extends AbstractDeclarationVisitor {
    @NotNull
    private final ClassDescriptor containingClass;
    @NotNull
    private final TranslationContext context;
    @Nullable
    private final JsFunction enumInitializer;
    private int enumEntryOrdinal;
    @NotNull
    private final List<JsStatement> initializerStatements;
    @NotNull
    private final List<ClassDescriptor> enumEntries;

    public DeclarationBodyVisitor(@NotNull ClassDescriptor containingClass, @NotNull TranslationContext context2, @Nullable JsFunction enumInitializer) {
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.containingClass = containingClass;
        this.context = context2;
        this.enumInitializer = enumInitializer;
        this.initializerStatements = new ArrayList();
        this.enumEntries = new ArrayList();
    }

    @NotNull
    public final List<JsStatement> getInitializerStatements() {
        return this.initializerStatements;
    }

    @NotNull
    public final List<ClassDescriptor> getEnumEntries() {
        return this.enumEntries;
    }

    @Override
    @Nullable
    public JsName getEnumInitializerName() {
        JsFunction jsFunction = this.enumInitializer;
        return jsFunction != null ? jsFunction.getName() : null;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(context2, "context");
        super.visitClassOrObject(classOrObject, context2);
        if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion() && this.containingClass.getKind() != ClassKind.ENUM_CLASS) {
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(context2.bindingContext(), classOrObject);
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassDescriptor descriptor = (ClassDescriptor)declarationDescriptor;
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)context2.getNameForObjectInstance(descriptor).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
            this.addInitializerStatement(jsStatement);
        }
    }

    public final void generateClassOrObject(@NotNull KtPureClassOrObject classOrObject, @NotNull TranslationContext context2, boolean needCompanionInitializer) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(context2, "context");
        ClassTranslator.Companion.translate(classOrObject, context2);
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), classOrObject);
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "getClassDescriptor(...)");
        ClassDescriptor descriptor = classDescriptor;
        context2.export(descriptor);
        if (needCompanionInitializer) {
            JsStatement jsStatement = ((JsExpression)new JsInvocation((JsExpression)context2.getNameForObjectInstance(descriptor).makeRef(), new JsExpression[0]).source(classOrObject)).makeStmt();
            Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
            this.addInitializerStatement(jsStatement);
        }
    }

    public static /* synthetic */ void generateClassOrObject$default(DeclarationBodyVisitor declarationBodyVisitor, KtPureClassOrObject ktPureClassOrObject, TranslationContext translationContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        declarationBodyVisitor.generateClassOrObject(ktPureClassOrObject, translationContext, bl);
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsFunction jsFunction = this.enumInitializer;
        Intrinsics.checkNotNull(jsFunction);
        JsFunction enumInitializer = jsFunction;
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), enumEntry);
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "getClassDescriptor(...)");
        ClassDescriptor descriptor = classDescriptor;
        List<KotlinType> list = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor);
        Intrinsics.checkNotNullExpressionValue(list, "getSupertypesWithoutFakes(...)");
        List<KotlinType> supertypes = list;
        ((Collection)this.enumEntries).add(descriptor);
        if (enumEntry.getBody() != null || supertypes.size() > 1) {
            JsName jsName = enumInitializer.getName();
            Intrinsics.checkNotNullExpressionValue(jsName, "getName(...)");
            ClassTranslator.Companion.translate(enumEntry, context2, jsName, this.enumEntryOrdinal);
            List<JsStatement> list2 = enumInitializer.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
            Collection collection = list2;
            collection.add(((JsExpression)new JsNew(context2.getInnerReference(descriptor)).source(enumEntry)).makeStmt());
        } else {
            JsReturn jsReturn;
            boolean bl;
            JsName jsName = context2.getInnerNameForDescriptor(descriptor);
            Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
            JsName enumName = jsName;
            JsName jsName2 = JsScope.declareTemporaryName(enumName.getIdent() + "_instance");
            Intrinsics.checkNotNullExpressionValue(jsName2, "declareTemporaryName(...)");
            JsName enumInstanceName = jsName2;
            boolean bl2 = bl = supertypes.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = false;
                String $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = "Simple Enum entry must have one supertype";
                throw new AssertionError((Object)$i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22);
            }
            JsExpression jsExpression = ClassInitializerTranslator.generateEnumEntryInstanceCreation(context2, enumEntry, this.enumEntryOrdinal);
            Intrinsics.checkNotNullExpressionValue(jsExpression, "generateEnumEntryInstanceCreation(...)");
            JsExpression jsEnumEntryCreation = jsExpression;
            context2.addDeclarationStatement(JsAstUtils.newVar(enumInstanceName, null));
            List<JsStatement> list3 = enumInitializer.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
            Collection $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22 = list3;
            Object object = JsAstUtils.assignment(JsAstUtils.pureFqn(enumInstanceName, null), jsEnumEntryCreation).source(enumEntry).makeStmt();
            $i$a$-assert-DeclarationBodyVisitor$visitEnumEntry$22.add(object);
            JsFunction jsFunction2 = context2.createRootScopedFunction(descriptor);
            Intrinsics.checkNotNullExpressionValue(jsFunction2, "createRootScopedFunction(...)");
            JsFunction enumInstanceFunction = jsFunction2;
            enumInstanceFunction.setSource(enumEntry);
            enumInstanceFunction.setName(context2.getNameForObjectInstance(descriptor));
            context2.addDeclarationStatement(enumInstanceFunction.makeStmt());
            List<JsStatement> list4 = enumInstanceFunction.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, "getStatements(...)");
            object = list4;
            object.add(((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(enumInitializer.getName(), null), new JsExpression[0]).source(enumEntry)).makeStmt());
            List<JsStatement> list5 = enumInstanceFunction.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list5, "getStatements(...)");
            object = list5;
            JsReturn $this$visitEnumEntry_u24lambda_u241 = jsReturn = new JsReturn(enumInstanceName.makeRef().source(enumEntry));
            boolean bl3 = false;
            $this$visitEnumEntry_u24lambda_u241.setSource(enumEntry);
            object.add(jsReturn);
        }
        context2.export(descriptor);
        int n = this.enumEntryOrdinal;
        this.enumEntryOrdinal = n + 1;
    }

    @Override
    public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer expression2, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull TranslationContext data) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(data, "data");
    }

    public final void addInitializerStatement(@NotNull JsStatement statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        this.initializerStatements.add(statement);
    }

    @Override
    public void addFunction(@NotNull FunctionDescriptor descriptor, @Nullable JsExpression expression2, @Nullable KtElement psi) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (!UtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor) || !ModalityUtilsKt.isOverridableOrOverrides(descriptor)) {
            if (expression2 != null) {
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor, expression2));
            }
        } else {
            JsName jsName = this.context.scope().declareName(this.context.getNameForDescriptor(descriptor).getIdent() + "$default");
            Intrinsics.checkNotNullExpressionValue(jsName, "declareName(...)");
            JsName bodyName = jsName;
            if (expression2 != null) {
                JsExpression jsExpression = JsAstUtils.prototypeOf(this.context.getInnerReference(this.containingClass));
                Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
                JsExpression prototypeRef = jsExpression;
                JsNameRef functionRef = new JsNameRef(bodyName, prototypeRef);
                this.context.addDeclarationStatement(JsAstUtils.assignment(functionRef, expression2).makeStmt());
            }
            if (UtilsKt.hasOwnParametersWithDefaultValue(descriptor)) {
                JsExpression it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                JsInvocation jsInvocation;
                JsFunction caller = new JsFunction(this.context.getScopeForDescriptor(this.containingClass), new JsBlock(), "");
                KtElement ktElement = psi;
                caller.setSource(ktElement != null ? UtilsKt.getFinalElement(ktElement) : null);
                TranslationContext translationContext = this.context.newDeclaration(descriptor);
                Intrinsics.checkNotNullExpressionValue(translationContext, "newDeclaration(...)");
                List<JsParameter> list = caller.getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                TranslationContext translationContext2 = FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor, list).innerBlock(caller.getBody());
                Intrinsics.checkNotNullExpressionValue(translationContext2, "innerBlock(...)");
                TranslationContext callerContext = translationContext2;
                JsName jsName2 = JsScope.declareTemporaryName("callback$default");
                Intrinsics.checkNotNullExpressionValue(jsName2, "declareTemporaryName(...)");
                JsName callbackName = jsName2;
                JsExpression callee = new JsNameRef(bodyName, (JsExpression)new JsThisRef()).source(psi);
                JsInvocation $this$addFunction_u24lambda_u242 = jsInvocation = new JsInvocation(callee, CollectionsKt.emptyList());
                boolean bl = false;
                $this$addFunction_u24lambda_u242.setSource(psi);
                JsInvocation defaultInvocation = jsInvocation;
                $this$addFunction_u24lambda_u242 = new JsInvocation((JsExpression)callbackName.makeRef(), new JsExpression[0]);
                Object $this$addFunction_u24lambda_u243 = $this$addFunction_u24lambda_u242;
                boolean bl2 = false;
                ((SourceInfoAwareJsNode)$this$addFunction_u24lambda_u243).setSource(psi);
                JsInvocation callbackInvocation = $this$addFunction_u24lambda_u242;
                JsExpression chosenInvocation = new JsConditional(callbackName.makeRef(), callbackInvocation, defaultInvocation).source(psi);
                List<JsExpression> list2 = defaultInvocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
                $this$addFunction_u24lambda_u243 = list2;
                List<JsParameter> list3 = caller.getParameters();
                Intrinsics.checkNotNullExpressionValue(list3, "getParameters(...)");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(((JsParameter)((Object)it)).getName().makeRef());
                }
                $this$map$iv = (List)destination$iv$iv;
                CollectionsKt.addAll($this$addFunction_u24lambda_u243, $this$map$iv);
                List<JsExpression> list4 = callbackInvocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list4, "getArguments(...)");
                $this$addFunction_u24lambda_u243 = list4;
                List<JsExpression> list5 = defaultInvocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list5, "getArguments(...)");
                $this$map$iv = list5;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (JsExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.deepCopy());
                }
                $this$map$iv = (List)destination$iv$iv;
                CollectionsKt.addAll($this$addFunction_u24lambda_u243, $this$map$iv);
                caller.getParameters().add(new JsParameter(callbackName));
                List<JsStatement> list6 = caller.getBody().getStatements();
                Intrinsics.checkNotNullExpressionValue(list6, "getStatements(...)");
                $this$addFunction_u24lambda_u243 = list6;
                List<JsStatement> list7 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor, callerContext);
                Intrinsics.checkNotNullExpressionValue(list7, "setDefaultValueForArguments(...)");
                CollectionsKt.addAll($this$addFunction_u24lambda_u243, (Iterable)list7);
                KotlinType kotlinType = descriptor.getReturnType();
                Intrinsics.checkNotNull(kotlinType);
                KotlinType returnType = kotlinType;
                JsStatement jsStatement = KotlinBuiltIns.isUnit(returnType) && !descriptor.isSuspend() ? chosenInvocation.makeStmt() : (JsStatement)new JsReturn(chosenInvocation);
                Intrinsics.checkNotNull(jsStatement);
                JsStatement statement = jsStatement;
                List<JsStatement> list8 = caller.getBody().getStatements();
                Intrinsics.checkNotNullExpressionValue(list8, "getStatements(...)");
                ((Collection)list8).add(statement);
                this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, this.containingClass, descriptor, caller));
            }
        }
    }

    @Override
    public void addProperty(@NotNull PropertyDescriptor descriptor, @NotNull JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(getter2, "getter");
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor)) {
            JsObjectLiteral jsObjectLiteral;
            JsObjectLiteral $this$addProperty_u24lambda_u246 = jsObjectLiteral = new JsObjectLiteral(true);
            boolean bl = false;
            List<JsPropertyInitializer> list = $this$addProperty_u24lambda_u246.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list, "getPropertyInitializers(...)");
            Collection collection = list;
            collection.add(new JsPropertyInitializer(new JsStringLiteral("configurable"), new JsBooleanLiteral(true)));
            List<JsPropertyInitializer> list2 = $this$addProperty_u24lambda_u246.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list2, "getPropertyInitializers(...)");
            collection = list2;
            collection.add(new JsPropertyInitializer(new JsStringLiteral("get"), getter2));
            if (setter2 != null) {
                List<JsPropertyInitializer> list3 = $this$addProperty_u24lambda_u246.getPropertyInitializers();
                Intrinsics.checkNotNullExpressionValue(list3, "getPropertyInitializers(...)");
                collection = list3;
                collection.add(new JsPropertyInitializer(new JsStringLiteral("set"), setter2));
            }
            JsObjectLiteral literal = jsObjectLiteral;
            UtilsKt.addAccessorsToPrototype(this.context, this.containingClass, descriptor, literal);
        }
    }

    @Override
    @NotNull
    public JsExpression getBackingFieldReference(@NotNull PropertyDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return new JsNameRef(this.context.getNameForBackingField(descriptor), (JsExpression)new JsThisRef());
    }
}

