/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformSpecificCastChecker;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ConditionalDataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.ConfusingWhenBranchSyntaxChecker;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonCallChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.EnumCompatibilityCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.DefinitelyNotNullDeprecationKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001DB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J8\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001b2\u0006\u0010\b\u001a\u00020\rH\u0002J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J4\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J.\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0002J(\u0010+\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017H\u0002J \u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J \u00102\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u00105\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J8\u00106\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020%H\u0002J@\u0010=\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00102\u0006\u0010<\u001a\u00020%2\u0006\u0010?\u001a\u00020\u0010H\u0002J\u0010\u0010@\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J(\u0010A\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010C\u001a\u000208H\u0002\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "visitIsExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "contextWithExpectedType", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "isStatement", "", "processVariableSubject", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "subjectVariable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "contextBeforeSubject", "inferTypeForWhenExpression", "Lorg/jetbrains/kotlin/types/KotlinType;", "subject", "contextAfterSubject", "dataFlowInfoForEntries", "", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "wrapWhenEntryExpressionsAsSpecialCallArguments", "Lorg/jetbrains/kotlin/psi/KtExpression;", "analyzeConditionsInWhenEntries", "Ljava/util/ArrayList;", "joinWhenExpressionBranches", "resultType", "jumpOutPossibleInSubject", "whenResultValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "checkSmartCastsInSubjectIfRequired", "", "subjectType", "possibleTypesForSubject", "", "checkSmartCastToExpectedTypeInSubject", "subjectExpression", "expectedType", "analyzeWhenEntryConditions", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ConditionalDataFlowInfo;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "checkWhenCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "checkTypeForExpressionCondition", "checkTypeForIs", "isCheck", "Lorg/jetbrains/kotlin/psi/KtElement;", "negated", "typeReferenceAfterIs", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "subjectDataFlowValue", "detectRedundantIs", "targetType", "typesAreCompatible", "noChange", "checkTypeCompatibility", "type", "reportErrorOn", "Subject", "frontend"})
@SourceDebugExtension(value={"SMAP\nPatternMatchingTypingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternMatchingTypingVisitor.kt\norg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,717:1\n1863#2,2:718\n1734#2,3:721\n1611#2,9:724\n1863#2:733\n1864#2:735\n1620#2:736\n827#2:737\n855#2,2:738\n2632#2,3:740\n1#3:720\n1#3:734\n*S KotlinDebug\n*F\n+ 1 PatternMatchingTypingVisitor.kt\norg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor\n*L\n82#1:718,2\n307#1:721,3\n338#1:724,9\n338#1:733\n338#1:735\n338#1:736\n677#1:737\n677#1:738,2\n681#1:740,3\n338#1:734\n*E\n"})
public final class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    public PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkNotNullParameter(facade, "facade");
        super(facade);
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(contextWithExpectedType, "contextWithExpectedType");
        Object Context2 = ((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
        ExpressionTypingContext context2 = (ExpressionTypingContext)Context2;
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue(ktExpression, "getLeftHandSide(...)");
        KtExpression leftHandSide = ktExpression;
        KotlinTypeInfo kotlinTypeInfo = this.facade.safeGetTypeInfo(leftHandSide, context2);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "safeGetTypeInfo(...)");
        KotlinTypeInfo typeInfo = kotlinTypeInfo;
        KotlinType knownType = typeInfo.getType();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (typeReference != null && knownType != null) {
            DataFlowValue dataFlowValue = this.components.dataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context2);
            DataFlowInfo conditionInfo = this.checkTypeForIs(context2, expression2, expression2.isNegated(), knownType, typeReference, dataFlowValue).getThenInfo();
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context2.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2, newDataFlowInfo);
        }
        DefinitelyNotNullDeprecationKt.reportDeprecatedDefinitelyNotNullSyntax(expression2, expression2.getTypeReference(), contextWithExpectedType);
        KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getBooleanType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo2, "checkType(...)");
        KotlinTypeInfo resultTypeInfo = kotlinTypeInfo2;
        if (typeReference != null) {
            KotlinType rhsType = (KotlinType)context2.trace.get(BindingContext.TYPE, typeReference);
            RttiExpressionInformation rttiInformation = new RttiExpressionInformation(leftHandSide, knownType, rhsType, expression2.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
            Iterable<RttiExpressionChecker> iterable = this.components.rttiExpressionCheckers;
            Intrinsics.checkNotNullExpressionValue(iterable, "rttiExpressionCheckers");
            Iterable<RttiExpressionChecker> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<RttiExpressionChecker> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                RttiExpressionChecker element$iv;
                RttiExpressionChecker it = element$iv = iterator2.next();
                boolean bl = false;
                PsiElement psiElement = expression2;
                BindingTrace bindingTrace = context2.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                it.check(rttiInformation, psiElement, bindingTrace);
            }
        }
        return resultTypeInfo;
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.visitWhenExpression(expression2, context2, false);
    }

    @NotNull
    public final KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        DataFlowInfo resultDataFlowInfo;
        DataFlowInfo dataFlowInfo;
        DataFlowValue dataFlowValue;
        KotlinType whenReturnType;
        Object object;
        Object contextWithExpectedTypeAndSubjectVariable;
        ExpressionTypingContext contextAfterSubject;
        Subject subject;
        ExpressionTypingContext contextBeforeSubject;
        BindingTrace trace;
        block23: {
            block22: {
                Object object2;
                block21: {
                    block20: {
                        Object it;
                        Subject subject2;
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        Intrinsics.checkNotNullParameter(contextWithExpectedType, "contextWithExpectedType");
                        BindingTrace bindingTrace = contextWithExpectedType.trace;
                        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                        trace = bindingTrace;
                        WhenChecker.INSTANCE.checkDeprecatedWhenSyntax(trace, expression2);
                        DiagnosticSink diagnosticSink = trace;
                        PsiElement psiElement = expression2.getWhenKeyword();
                        Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
                        WhenChecker.INSTANCE.checkSealedWhenIsReserved(diagnosticSink, psiElement);
                        this.components.dataFlowAnalyzer.recordExpectedType(trace, expression2, contextWithExpectedType.expectedType);
                        Object Context2 = ((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
                        Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
                        contextBeforeSubject = (ExpressionTypingContext)Context2;
                        KtExpression subjectExpression = expression2.getSubjectExpression();
                        KtProperty subjectVariable = expression2.getSubjectVariable();
                        if (subjectVariable != null) {
                            subject2 = this.processVariableSubject(subjectVariable, contextBeforeSubject);
                        } else if (subjectExpression != null) {
                            KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(subjectExpression, contextBeforeSubject);
                            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getTypeInfo(...)");
                            DataFlowValueFactory dataFlowValueFactory = this.components.dataFlowValueFactory;
                            Intrinsics.checkNotNullExpressionValue(dataFlowValueFactory, "dataFlowValueFactory");
                            subject2 = new Subject.Expression(subjectExpression, kotlinTypeInfo, dataFlowValueFactory);
                        } else {
                            subject2 = new Subject.None();
                        }
                        subject = subject2;
                        PatternMatchingTypingVisitor $this$visitWhenExpression_u24lambda_u243 = this;
                        boolean bl = false;
                        ExpressionTypingContext result2 = null;
                        result2 = contextBeforeSubject;
                        LexicalScope lexicalScope = subject.getScopeWithSubject();
                        if (lexicalScope != null) {
                            it = lexicalScope;
                            boolean bl2 = false;
                            result2 = result2.replaceScope((LexicalScope)it);
                        }
                        DataFlowInfo dataFlowInfo2 = subject.getDataFlowInfo();
                        if (dataFlowInfo2 != null) {
                            it = dataFlowInfo2;
                            boolean bl3 = false;
                            result2 = result2.replaceDataFlowInfo((DataFlowInfo)it);
                        }
                        contextAfterSubject = result2;
                        object2 = subject.getScopeWithSubject();
                        if (object2 == null) break block20;
                        it = object2;
                        boolean bl4 = false;
                        ExpressionTypingContext expressionTypingContext = (ExpressionTypingContext)contextWithExpectedType.replaceScope((LexicalScope)it);
                        object2 = expressionTypingContext;
                        if (expressionTypingContext != null) break block21;
                    }
                    object2 = contextWithExpectedType;
                }
                contextWithExpectedTypeAndSubjectVariable = object2;
                KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
                Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "builtIns");
                subject.initDataFlowValue(contextAfterSubject, kotlinBuiltIns);
                object = subject.getTypeInfo();
                if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) break block22;
                DataFlowValue dataFlowValue2 = subject.getDataFlowValue();
                LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
                Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
                if ((object = object.getStableTypes(dataFlowValue2, languageVersionSettings)) != null) break block23;
            }
            object = SetsKt.emptySet();
        }
        Set possibleTypesForSubject = object;
        this.checkSmartCastsInSubjectIfRequired(expression2, contextBeforeSubject, subject.getType(), possibleTypesForSubject);
        ArrayList<DataFlowInfo> dataFlowInfoForEntries = this.analyzeConditionsInWhenEntries(expression2, contextAfterSubject, subject);
        KotlinType kotlinType = whenReturnType = this.inferTypeForWhenExpression(expression2, subject, (ExpressionTypingContext)contextWithExpectedTypeAndSubjectVariable, contextAfterSubject, (List<? extends DataFlowInfo>)dataFlowInfoForEntries);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            dataFlowValue = this.facade.getComponents().dataFlowValueFactory.createDataFlowValue(expression2, it, contextAfterSubject);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue whenResultValue = dataFlowValue;
        KotlinTypeInfo branchesTypeInfo = this.joinWhenExpressionBranches(expression2, contextAfterSubject, whenReturnType, subject.getJumpOutPossible(), whenResultValue);
        boolean isExhaustive = WhenChecker.isWhenExhaustive(expression2, trace);
        DataFlowInfo branchesDataFlowInfo = branchesTypeInfo.getDataFlowInfo();
        if (expression2.getElseExpression() == null && !isExhaustive) {
            DataFlowInfo dataFlowInfo3 = contextAfterSubject.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo3, "dataFlowInfo");
            dataFlowInfo = branchesDataFlowInfo.or(dataFlowInfo3);
        } else {
            dataFlowInfo = resultDataFlowInfo = branchesDataFlowInfo;
        }
        if (whenReturnType != null && isExhaustive && expression2.getElseExpression() == null && KotlinBuiltIns.isNothing(whenReturnType)) {
            trace.record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, expression2);
        }
        KotlinType kotlinType2 = branchesTypeInfo.getType();
        if (kotlinType2 == null) {
            return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
        }
        KotlinType branchesType = kotlinType2;
        KotlinType resultType = this.components.dataFlowAnalyzer.checkType(branchesType, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        LanguageVersionSettings languageVersionSettings = contextWithExpectedType.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        ConfusingWhenBranchSyntaxChecker.INSTANCE.check(expression2, languageVersionSettings, trace);
        boolean bl = branchesTypeInfo.getJumpOutPossible();
        DataFlowInfo dataFlowInfo4 = contextWithExpectedType.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo4, "dataFlowInfo");
        return TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, bl, dataFlowInfo4);
    }

    private final Subject processVariableSubject(KtProperty subjectVariable, ExpressionTypingContext contextBeforeSubject) {
        BindingTrace bindingTrace = contextBeforeSubject.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        BindingTrace trace = bindingTrace;
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.VariableDeclarationInWhenSubject)) {
            trace.report(Errors.UNSUPPORTED_FEATURE.on(subjectVariable, new Pair<LanguageFeature, LanguageVersionSettings>(LanguageFeature.VariableDeclarationInWhenSubject, this.components.languageVersionSettings)));
        } else {
            String illegalDeclarationString;
            String string2 = subjectVariable.isVar() ? "var" : (subjectVariable.getInitializer() == null ? "variable without initializer" : (subjectVariable.hasDelegateExpression() ? "delegated property" : (illegalDeclarationString = subjectVariable.getGetter() != null || subjectVariable.getSetter() != null ? "property with accessors" : null)));
            if (illegalDeclarationString != null) {
                trace.report(Errors.ILLEGAL_DECLARATION_IN_WHEN_SUBJECT.on(subjectVariable, illegalDeclarationString));
            }
        }
        LexicalWritableScope lexicalWritableScope = ExpressionTypingUtils.newWritableScopeImpl(contextBeforeSubject, LexicalScopeKind.WHEN, this.components.overloadChecker);
        Intrinsics.checkNotNullExpressionValue(lexicalWritableScope, "newWritableScopeImpl(...)");
        LexicalWritableScope scopeWithSubjectVariable = lexicalWritableScope;
        LocalVariableResolver localVariableResolver = this.components.localVariableResolver;
        LexicalScope lexicalScope = contextBeforeSubject.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        ExpressionTypingInternals expressionTypingInternals = this.facade;
        Intrinsics.checkNotNullExpressionValue(expressionTypingInternals, "facade");
        Pair<KotlinTypeInfo, VariableDescriptor> pair = localVariableResolver.process(subjectVariable, contextBeforeSubject, lexicalScope, expressionTypingInternals);
        KotlinTypeInfo typeInfo = pair.component1();
        VariableDescriptor descriptor = pair.component2();
        scopeWithSubjectVariable.addVariableDescriptor(descriptor);
        KotlinTypeInfo subjectTypeInfo = typeInfo.replaceType(descriptor.getType());
        return new Subject.Variable(subjectVariable, descriptor, subjectTypeInfo, scopeWithSubjectVariable);
    }

    private final KotlinType inferTypeForWhenExpression(KtWhenExpression expression2, Subject subject, ExpressionTypingContext contextWithExpectedType, ExpressionTypingContext contextAfterSubject, List<? extends DataFlowInfo> dataFlowInfoForEntries) {
        boolean bl;
        block5: {
            List<KtWhenEntry> list = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    if (it.getExpression() == null) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return this.components.builtIns.getUnitType();
        }
        List<KtExpression> wrappedArgumentExpressions = this.wrapWhenEntryExpressionsAsSpecialCallArguments(expression2);
        KtExpression ktExpression = expression2;
        KtExpression ktExpression2 = subject.getCalleeExpressionForSpecialCall();
        if (ktExpression2 == null) {
            ktExpression2 = expression2;
        }
        Call callForWhen = ControlStructureTypingUtils.createCallForSpecialConstruction(ktExpression, ktExpression2, wrappedArgumentExpressions);
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsOfWhenCall(callForWhen, contextAfterSubject.dataFlowInfo, dataFlowInfoForEntries);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForWhen, ControlStructureTypingUtils.ResolveConstruct.WHEN, (List<String>)new AbstractList<String>(wrappedArgumentExpressions){
            final /* synthetic */ List<KtExpression> $wrappedArgumentExpressions;
            {
                this.$wrappedArgumentExpressions = $wrappedArgumentExpressions;
            }

            public String get(int index) {
                return "entry" + index;
            }

            public int getSize() {
                return this.$wrappedArgumentExpressions.size();
            }
        }, Collections.nCopies(wrappedArgumentExpressions.size(), false), contextWithExpectedType, dataFlowInfoForArguments);
        return resolvedCall2.getResultingDescriptor().getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> wrapWhenEntryExpressionsAsSpecialCallArguments(KtWhenExpression expression2) {
        void $this$mapNotNullTo$iv$iv;
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        List<KtWhenEntry> list = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtBlockExpression ktBlockExpression;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtWhenEntry whenEntry = (KtWhenEntry)element$iv$iv;
            boolean bl2 = false;
            if (whenEntry.getExpression() != null) {
                KtExpression it;
                boolean bl3 = false;
                ktBlockExpression = psiFactory.wrapInABlockWrapper(it);
            } else {
                ktBlockExpression = null;
            }
            if (ktBlockExpression == null) continue;
            KtBlockExpression it$iv$iv = ktBlockExpression;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ArrayList<DataFlowInfo> analyzeConditionsInWhenEntries(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, Subject subject) {
        ArrayList<DataFlowInfo> argumentDataFlowInfos = new ArrayList<DataFlowInfo>();
        DataFlowInfo dataFlowInfo = contextAfterSubject.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        DataFlowInfo inputDataFlowInfo = dataFlowInfo;
        for (KtWhenEntry whenEntry : expression2.getEntries()) {
            Intrinsics.checkNotNull(whenEntry);
            Object Context2 = contextAfterSubject.replaceDataFlowInfo(inputDataFlowInfo);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceDataFlowInfo(...)");
            ConditionalDataFlowInfo conditionsInfo = this.analyzeWhenEntryConditions(whenEntry, (ExpressionTypingContext)Context2, subject);
            inputDataFlowInfo = inputDataFlowInfo.and(conditionsInfo.getElseInfo());
            if (whenEntry.getExpression() == null) continue;
            argumentDataFlowInfos.add(conditionsInfo.getThenInfo());
        }
        return argumentDataFlowInfos;
    }

    private final KotlinTypeInfo joinWhenExpressionBranches(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, KotlinType resultType, boolean jumpOutPossibleInSubject, DataFlowValue whenResultValue) {
        BindingContext bindingContext = contextAfterSubject.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        DataFlowInfo currentDataFlowInfo = null;
        boolean jumpOutPossible = jumpOutPossibleInSubject;
        boolean errorTypeExistInBranch = false;
        for (KtWhenEntry whenEntry : expression2.getEntries()) {
            DataFlowInfo dataFlowInfo;
            DataFlowInfo dataFlowInfo2;
            KotlinTypeInfo entryTypeInfo;
            KtExpression entryExpression;
            if (whenEntry.getExpression() == null || BindingContextUtils.getRecordedTypeInfo(entryExpression, bindingContext2) == null) continue;
            KotlinType entryType = entryTypeInfo.getType();
            if (entryType == null) {
                errorTypeExistInBranch = true;
            }
            if (whenResultValue != null && entryType != null) {
                DataFlowValue entryValue = this.facade.getComponents().dataFlowValueFactory.createDataFlowValue(entryExpression, entryType, contextAfterSubject);
                DataFlowInfo dataFlowInfo3 = entryTypeInfo.getDataFlowInfo();
                LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
                Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
                dataFlowInfo2 = dataFlowInfo3.assign(whenResultValue, entryValue, languageVersionSettings);
            } else {
                dataFlowInfo2 = entryTypeInfo.getDataFlowInfo();
            }
            DataFlowInfo entryDataFlowInfo = dataFlowInfo2;
            if (entryType != null && KotlinBuiltIns.isNothing(entryType)) {
                dataFlowInfo = currentDataFlowInfo;
            } else {
                DataFlowInfo dataFlowInfo4 = currentDataFlowInfo;
                dataFlowInfo = dataFlowInfo4 != null ? dataFlowInfo4.or(entryDataFlowInfo) : entryDataFlowInfo;
            }
            currentDataFlowInfo = dataFlowInfo;
            jumpOutPossible |= entryTypeInfo.getJumpOutPossible();
        }
        DataFlowInfo dataFlowInfo = currentDataFlowInfo;
        if (dataFlowInfo == null) {
            DataFlowInfo dataFlowInfo5 = contextAfterSubject.dataFlowInfo;
            dataFlowInfo = dataFlowInfo5;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo5, "dataFlowInfo");
        }
        DataFlowInfo resultDataFlowInfo = dataFlowInfo;
        return resultType == null || errorTypeExistInBranch && KotlinBuiltIns.isNothing(resultType) ? TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo) : TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, jumpOutPossible, resultDataFlowInfo);
    }

    private final void checkSmartCastsInSubjectIfRequired(KtWhenExpression expression2, ExpressionTypingContext contextBeforeSubject, KotlinType subjectType, Set<? extends KotlinType> possibleTypesForSubject) {
        KtExpression ktExpression = expression2.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subjectExpression = ktExpression;
        for (KotlinType possibleCastType : CollectionsKt.reversed((Iterable)possibleTypesForSubject)) {
            ClassDescriptor possibleCastClass;
            ClassifierDescriptor classifierDescriptor = possibleCastType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null || (possibleCastClass = classDescriptor).getKind() != ClassKind.ENUM_CLASS && possibleCastClass.getModality() != Modality.SEALED || !this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, subjectExpression, subjectType, possibleCastType)) continue;
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(subjectType);
        BindingContext bindingContext = contextBeforeSubject.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (isNullableType && !WhenChecker.INSTANCE.containsNullCase(expression2, bindingContext2)) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(subjectType);
            Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(...)");
            KotlinType notNullableType = kotlinType;
            if (this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, subjectExpression, subjectType, notNullableType)) {
                return;
            }
        }
    }

    private final boolean checkSmartCastToExpectedTypeInSubject(ExpressionTypingContext contextBeforeSubject, KtExpression subjectExpression, KotlinType subjectType, KotlinType expectedType) {
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(contextBeforeSubject.trace, "Temporary trace for when subject nullability");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        Object Context2 = ((ExpressionTypingContext)contextBeforeSubject.replaceExpectedType(expectedType)).replaceBindingTrace(trace);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceBindingTrace(...)");
        ExpressionTypingContext subjectContext = (ExpressionTypingContext)Context2;
        SmartCastResult castResult = this.facade.getComponents().dataFlowAnalyzer.checkPossibleCast(subjectType, KtPsiUtil.safeDeparenthesize(subjectExpression), subjectContext);
        if (castResult != null && castResult.isCorrect()) {
            trace.commit();
            return true;
        }
        return false;
    }

    private final ConditionalDataFlowInfo analyzeWhenEntryConditions(KtWhenEntry whenEntry, ExpressionTypingContext context2, Subject subject) {
        if (whenEntry.isElse()) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        ConditionalDataFlowInfo entryInfo = null;
        ExpressionTypingContext contextForCondition = context2;
        for (KtWhenCondition condition : whenEntry.getConditions()) {
            ConditionalDataFlowInfo conditionalDataFlowInfo;
            Intrinsics.checkNotNull(condition);
            ConditionalDataFlowInfo conditionInfo = this.checkWhenCondition(subject, condition, contextForCondition);
            if (entryInfo != null) {
                ConditionalDataFlowInfo it;
                boolean bl = false;
                conditionalDataFlowInfo = new ConditionalDataFlowInfo(it.getThenInfo().or(conditionInfo.getThenInfo()), it.getElseInfo().and(conditionInfo.getElseInfo()));
            } else {
                conditionalDataFlowInfo = conditionInfo;
            }
            entryInfo = conditionalDataFlowInfo;
            contextForCondition = (ExpressionTypingContext)contextForCondition.replaceDataFlowInfo(conditionInfo.getElseInfo());
        }
        ConditionalDataFlowInfo conditionalDataFlowInfo = entryInfo;
        if (conditionalDataFlowInfo == null) {
            DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            conditionalDataFlowInfo = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        return conditionalDataFlowInfo;
    }

    private final ConditionalDataFlowInfo checkWhenCondition(Subject subject, KtWhenCondition condition, ExpressionTypingContext context2) {
        Ref.ObjectRef<ConditionalDataFlowInfo> newDataFlowInfo = new Ref.ObjectRef<ConditionalDataFlowInfo>();
        newDataFlowInfo.element = this.noChange(context2);
        condition.accept(new KtVisitorVoid(subject, context2, this, newDataFlowInfo){
            final /* synthetic */ Subject $subject;
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ PatternMatchingTypingVisitor this$0;
            final /* synthetic */ Ref.ObjectRef<ConditionalDataFlowInfo> $newDataFlowInfo;
            {
                this.$subject = $subject;
                this.$context = $context;
                this.this$0 = $receiver;
                this.$newDataFlowInfo = $newDataFlowInfo;
            }

            public void visitWhenConditionInRange(KtWhenConditionInRange condition) {
                Intrinsics.checkNotNullParameter(condition, "condition");
                KtExpression ktExpression = condition.getRangeExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression rangeExpression = ktExpression;
                if (this.$subject instanceof Subject.None) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                    DataFlowInfo dataFlowInfo = this.this$0.facade.getTypeInfo(rangeExpression, this.$context).getDataFlowInfo();
                    this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                    return;
                }
                ValueArgument valueArgument = this.$subject.makeValueArgument();
                if (valueArgument == null) {
                    return;
                }
                ValueArgument argumentForSubject = valueArgument;
                KotlinTypeInfo kotlinTypeInfo = this.this$0.facade.checkInExpression(condition, condition.getOperationReference(), argumentForSubject, rangeExpression, this.$context);
                Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "checkInExpression(...)");
                KotlinTypeInfo typeInfo = kotlinTypeInfo;
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                KotlinType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    this.$context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on((KtWhenConditionInRange)((PsiElement)condition)));
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitWhenConditionIsPattern(KtWhenConditionIsPattern condition) {
                Intrinsics.checkNotNullParameter(condition, "condition");
                if (this.$subject instanceof Subject.None) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition)));
                }
                KtTypeReference ktTypeReference = condition.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                KtTypeReference typeReference = ktTypeReference;
                ConditionalDataFlowInfo result2 = PatternMatchingTypingVisitor.access$checkTypeForIs(this.this$0, this.$context, condition, condition.isNegated(), this.$subject.getType(), typeReference, this.$subject.getDataFlowValue());
                this.$newDataFlowInfo.element = condition.isNegated() ? new ConditionalDataFlowInfo(result2.getElseInfo(), result2.getThenInfo()) : result2;
                KotlinType rhsType = (KotlinType)this.$context.trace.get(BindingContext.TYPE, typeReference);
                if (!(this.$subject instanceof Subject.None)) {
                    void $this$forEach$iv;
                    KtElement ktElement = this.$subject.getElement();
                    Intrinsics.checkNotNull(ktElement);
                    RttiExpressionInformation rttiInformation = new RttiExpressionInformation(ktElement, this.$subject.getType(), rhsType, condition.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
                    Iterable<RttiExpressionChecker> iterable = this.this$0.components.rttiExpressionCheckers;
                    Intrinsics.checkNotNullExpressionValue(iterable, "rttiExpressionCheckers");
                    Iterable<RttiExpressionChecker> iterable2 = iterable;
                    ExpressionTypingContext expressionTypingContext = this.$context;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        RttiExpressionChecker it = (RttiExpressionChecker)element$iv;
                        boolean bl = false;
                        PsiElement psiElement = condition;
                        BindingTrace bindingTrace = expressionTypingContext.trace;
                        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                        it.check(rttiInformation, psiElement, bindingTrace);
                    }
                }
            }

            public void visitWhenConditionWithExpression(KtWhenConditionWithExpression condition) {
                Intrinsics.checkNotNullParameter(condition, "condition");
                KtExpression ktExpression = condition.getExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression expression2 = ktExpression;
                ConditionalDataFlowInfo basicDataFlowInfo = PatternMatchingTypingVisitor.access$checkTypeForExpressionCondition(this.this$0, this.$context, expression2, this.$subject);
                ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(this.$context.scope.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(...)");
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                EffectSystem effectSystem = this.this$0.components.effectSystem;
                KtExpression ktExpression2 = this.$subject.getValueExpression();
                BindingTrace bindingTrace = this.$context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                ConditionalDataFlowInfo dataFlowInfoFromES = effectSystem.getDataFlowInfoWhenEquals(ktExpression2, expression2, bindingTrace, moduleDescriptor2);
                this.$newDataFlowInfo.element = basicDataFlowInfo.and(dataFlowInfoFromES);
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                this.$context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
        });
        return (ConditionalDataFlowInfo)newDataFlowInfo.element;
    }

    private final ConditionalDataFlowInfo checkTypeForExpressionCondition(ExpressionTypingContext context2, KtExpression expression2, Subject subject) {
        ExpressionTypingContext newContext = context2;
        KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(expression2, newContext);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getTypeInfo(...)");
        KotlinTypeInfo typeInfo = kotlinTypeInfo;
        KotlinType kotlinType = typeInfo.getType();
        if (kotlinType == null) {
            return this.noChange(newContext);
        }
        KotlinType type2 = kotlinType;
        newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (subject instanceof Subject.None) {
            SimpleType simpleType = this.components.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType, "getBooleanType(...)");
            SimpleType booleanType = simpleType;
            KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.checkType(typeInfo, expression2, (ResolutionContext)newContext.replaceExpectedType(booleanType));
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo2, "checkType(...)");
            KotlinTypeInfo checkedTypeInfo = kotlinTypeInfo2;
            KotlinType kotlinType2 = booleanType;
            KotlinType kotlinType3 = checkedTypeInfo.getType();
            if (kotlinType3 == null) {
                kotlinType3 = type2;
            }
            if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinType2, kotlinType3)) {
                DataFlowInfo dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, true, newContext);
                Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "extractDataFlowInfoFromCondition(...)");
                DataFlowInfo ifInfo = dataFlowInfo;
                DataFlowInfo dataFlowInfo2 = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, false, newContext);
                Intrinsics.checkNotNullExpressionValue(dataFlowInfo2, "extractDataFlowInfoFromCondition(...)");
                DataFlowInfo elseInfo = dataFlowInfo2;
                return new ConditionalDataFlowInfo(ifInfo, elseInfo);
            }
            return this.noChange(newContext);
        }
        this.checkTypeCompatibility(newContext, type2, subject.getType(), expression2);
        DataFlowValue expressionDataFlowValue = this.facade.getComponents().dataFlowValueFactory.createDataFlowValue(expression2, type2, newContext);
        Collection collection = CollectionsKt.listOf(subject.getType());
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        DataFlowValue dataFlowValue = subject.getDataFlowValue();
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        List subjectStableTypes = CollectionsKt.plus(collection, (Iterable)dataFlowInfo.getStableTypes(dataFlowValue, languageVersionSettings));
        Collection collection2 = CollectionsKt.listOf(type2);
        DataFlowInfo dataFlowInfo3 = newContext.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings2 = this.components.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings2, "languageVersionSettings");
        List expressionStableTypes = CollectionsKt.plus(collection2, (Iterable)dataFlowInfo3.getStableTypes(expressionDataFlowValue, languageVersionSettings2));
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        PrimitiveNumericComparisonCallChecker.INSTANCE.inferPrimitiveNumericComparisonType(bindingTrace, subjectStableTypes, expressionStableTypes, expression2);
        ConditionalDataFlowInfo result2 = this.noChange(newContext);
        DataFlowInfo dataFlowInfo4 = result2.getThenInfo();
        DataFlowValue dataFlowValue2 = subject.getDataFlowValue();
        boolean bl = this.facade.getComponents().dataFlowAnalyzer.typeHasEqualsFromAny(subject.getType(), expression2);
        LanguageVersionSettings languageVersionSettings3 = this.components.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings3, "languageVersionSettings");
        DataFlowInfo dataFlowInfo5 = dataFlowInfo4.equate(dataFlowValue2, expressionDataFlowValue, bl, languageVersionSettings3);
        DataFlowInfo dataFlowInfo6 = result2.getElseInfo();
        DataFlowValue dataFlowValue3 = subject.getDataFlowValue();
        LanguageVersionSettings languageVersionSettings4 = this.components.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings4, "languageVersionSettings");
        return new ConditionalDataFlowInfo(dataFlowInfo5, dataFlowInfo6.disequate(dataFlowValue3, expressionDataFlowValue, languageVersionSettings4));
    }

    private final ConditionalDataFlowInfo checkTypeForIs(ExpressionTypingContext context2, KtElement isCheck, boolean negated, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        ClassDescriptor targetDescriptor;
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, true, context2.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        KotlinType kotlinType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context2.trace, this.components.builtIns);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "reconstructBareType(...)");
        KotlinType targetType = kotlinType;
        if (DynamicTypesKt.isDynamic(targetType)) {
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context2.trace.report(Errors.IS_ENUM_ENTRY.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if (!TypeUtilsKt.containsError(subjectType) && !TypeUtils.isNullableType(subjectType) && targetType.isMarkedNullable()) {
            KtTypeElement element = typeReferenceAfterIs.getTypeElement();
            boolean bl = element instanceof KtNullableType;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-PatternMatchingTypingVisitor$checkTypeForIs$22 = false;
                String $i$a$-assert-PatternMatchingTypingVisitor$checkTypeForIs$22 = "element must be instance of " + KtNullableType.class.getName();
                throw new AssertionError((Object)$i$a$-assert-PatternMatchingTypingVisitor$checkTypeForIs$22);
            }
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNullableType");
            bindingTrace.report(Errors.USELESS_NULLABLE_CHECK.on((KtNullableType)((PsiElement)((KtNullableType)element))));
        }
        boolean typesAreCompatible = this.checkTypeCompatibility(context2, targetType, subjectType, typeReferenceAfterIs);
        this.detectRedundantIs(context2, subjectType, targetType, isCheck, negated, subjectDataFlowValue, typesAreCompatible);
        if (context2.languageVersionSettings.supportsFeature(LanguageFeature.ProperCheckAnnotationsTargetInTypeUsePositions)) {
            AnnotationChecker annotationChecker = this.components.annotationChecker;
            KtAnnotated ktAnnotated = typeReferenceAfterIs;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            AnnotationChecker.check$default(annotationChecker, ktAnnotated, bindingTrace, null, 4, null);
        }
        KotlinTypeChecker kotlinTypeChecker = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkNotNullExpressionValue(kotlinTypeChecker, "DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, kotlinTypeChecker)) {
            context2.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on((KtElement)((PsiElement)typeReferenceAfterIs), targetType));
        }
        DataFlowInfo it = context2.dataFlowInfo;
        boolean bl = false;
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        DataFlowInfo dataFlowInfo = it.establishSubtyping(subjectDataFlowValue, targetType, languageVersionSettings);
        Intrinsics.checkNotNull(it);
        return new ConditionalDataFlowInfo(dataFlowInfo, it);
    }

    /*
     * WARNING - void declaration
     */
    private final void detectRedundantIs(ExpressionTypingContext context2, KotlinType subjectType, KotlinType targetType, KtElement isCheck, boolean negated, DataFlowValue subjectDataFlowValue, boolean typesAreCompatible) {
        if (TypeUtilsKt.containsError(subjectType) || TypeUtilsKt.containsError(targetType)) {
            return;
        }
        Collection<KotlinType> collection = DataFlowAnalyzer.getAllPossibleTypes(subjectType, context2, subjectDataFlowValue, context2.languageVersionSettings);
        Intrinsics.checkNotNullExpressionValue(collection, "getAllPossibleTypes(...)");
        Collection<KotlinType> possibleTypes = collection;
        if (typesAreCompatible && !KotlinTypeKt.isError(targetType)) {
            boolean bl;
            block8: {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = possibleTypes;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    KotlinType it = (KotlinType)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (TypeUtilsKt.isAnyOrNullableAny(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable it = $this$filterNot$iv = (List)destination$iv$iv;
                boolean bl3 = false;
                Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filterNot$iv : null;
                Collection<KotlinType> nonTrivialTypes = iterable2 != null ? (Collection<KotlinType>)iterable2 : possibleTypes;
                Iterable $this$none$iv = nonTrivialTypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KotlinType it2 = (KotlinType)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull(it2);
                        PlatformToKotlinClassMapper platformToKotlinClassMapper = this.components.platformToKotlinClassMapper;
                        Intrinsics.checkNotNullExpressionValue(platformToKotlinClassMapper, "platformToKotlinClassMapper");
                        PlatformSpecificCastChecker platformSpecificCastChecker = this.components.platformSpecificCastChecker;
                        Intrinsics.checkNotNullExpressionValue(platformSpecificCastChecker, "platformSpecificCastChecker");
                        if (!CastDiagnosticsUtil.isCastPossible(it2, targetType, platformToKotlinClassMapper, platformSpecificCastChecker)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                context2.trace.report(Errors.USELESS_IS_CHECK.on((KtElement)((PsiElement)isCheck), negated));
            }
        }
        if (CastDiagnosticsUtil.INSTANCE.isRefinementUseless(possibleTypes, targetType, false)) {
            context2.trace.report(Errors.USELESS_IS_CHECK.on((KtElement)((PsiElement)isCheck), !negated));
        }
    }

    private final ConditionalDataFlowInfo noChange(ExpressionTypingContext context2) {
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
    }

    private final boolean checkTypeCompatibility(ExpressionTypingContext context2, KotlinType type2, KotlinType subjectType, KtElement reportErrorOn) {
        if (TypeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context2.trace.report(Errors.INCOMPATIBLE_TYPES.on((KtElement)((PsiElement)reportErrorOn), type2, subjectType));
            return false;
        }
        EnumCompatibilityCheckerKt.checkEnumsForCompatibility(context2, reportErrorOn, subjectType, type2);
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context2.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on((KtElement)((PsiElement)reportErrorOn)));
        }
        return true;
    }

    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForIs(PatternMatchingTypingVisitor $this, ExpressionTypingContext context2, KtElement isCheck, boolean negated, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForIs(context2, isCheck, negated, subjectType, typeReferenceAfterIs, subjectDataFlowValue);
    }

    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForExpressionCondition(PatternMatchingTypingVisitor $this, ExpressionTypingContext context2, KtExpression expression2, Subject subject) {
        return $this.checkTypeForExpressionCondition(context2, expression2, subject);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\"\u0018\u00002\u00020\u0001:\u0003/01B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H$J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\n\u0010 \u001a\u0004\u0018\u00010\u001dH\u0016J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "scopeWithSubject", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getTypeInfo", "()Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "getScopeWithSubject", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getCalleeExpressionForSpecialCall", "value", "dataFlowValue", "getDataFlowValue", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "initDataFlowValue", "", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "jumpOutPossible", "", "getJumpOutPossible", "()Z", "Expression", "Variable", "None", "frontend"})
    private static abstract class Subject {
        @Nullable
        private final KtElement element;
        @Nullable
        private final KotlinTypeInfo typeInfo;
        @Nullable
        private final LexicalScope scopeWithSubject;
        @NotNull
        private final KotlinType type;
        private DataFlowValue dataFlowValue;

        public Subject(@Nullable KtElement element, @Nullable KotlinTypeInfo typeInfo, @Nullable LexicalScope scopeWithSubject, @NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            this.element = element;
            this.typeInfo = typeInfo;
            this.scopeWithSubject = scopeWithSubject;
            this.type = type2;
        }

        public /* synthetic */ Subject(KtElement ktElement, KotlinTypeInfo kotlinTypeInfo, LexicalScope lexicalScope, KotlinType object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                Object object2 = kotlinTypeInfo;
                if (object2 == null || (object2 = ((KotlinTypeInfo)object2).getType()) == null) {
                    object2 = ErrorUtils.createErrorType(ErrorTypeKind.UNKNOWN_TYPE, new String[0]);
                }
                object = object2;
            }
            this(ktElement, kotlinTypeInfo, lexicalScope, (KotlinType)object);
        }

        @Nullable
        public final KtElement getElement() {
            return this.element;
        }

        @Nullable
        public final KotlinTypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        @Nullable
        public final LexicalScope getScopeWithSubject() {
            return this.scopeWithSubject;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @NotNull
        protected abstract DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext var1, @NotNull KotlinBuiltIns var2);

        @Nullable
        public abstract ValueArgument makeValueArgument();

        @Nullable
        public abstract KtExpression getValueExpression();

        @Nullable
        public KtExpression getCalleeExpressionForSpecialCall() {
            return null;
        }

        @NotNull
        public final DataFlowValue getDataFlowValue() {
            DataFlowValue dataFlowValue = this.dataFlowValue;
            if (dataFlowValue != null) {
                return dataFlowValue;
            }
            Intrinsics.throwUninitializedPropertyAccessException("dataFlowValue");
            return null;
        }

        public final void initDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
            Intrinsics.checkNotNullParameter(contextAfterSubject, "contextAfterSubject");
            Intrinsics.checkNotNullParameter(builtIns, "builtIns");
            this.dataFlowValue = this.createDataFlowValue(contextAfterSubject, builtIns);
        }

        @Nullable
        public final DataFlowInfo getDataFlowInfo() {
            KotlinTypeInfo kotlinTypeInfo = this.typeInfo;
            return kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
        }

        public final boolean getJumpOutPossible() {
            KotlinTypeInfo kotlinTypeInfo = this.typeInfo;
            return kotlinTypeInfo != null ? kotlinTypeInfo.getJumpOutPossible() : false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$Expression;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueExpression", "getValueExpression", "frontend"})
        public static final class Expression
        extends Subject {
            @NotNull
            private final KtExpression expression;
            @NotNull
            private final DataFlowValueFactory dataFlowValueFactory;

            public Expression(@NotNull KtExpression expression2, @NotNull KotlinTypeInfo typeInfo, @NotNull DataFlowValueFactory dataFlowValueFactory) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(typeInfo, "typeInfo");
                Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
                super(expression2, typeInfo, null, null, 8, null);
                this.expression = expression2;
                this.dataFlowValueFactory = dataFlowValueFactory;
            }

            @NotNull
            public final KtExpression getExpression() {
                return this.expression;
            }

            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkNotNullParameter(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkNotNullParameter(builtIns, "builtIns");
                return this.dataFlowValueFactory.createDataFlowValue(this.expression, this.getType(), contextAfterSubject);
            }

            @Override
            @NotNull
            public ValueArgument makeValueArgument() {
                ValueArgument valueArgument = CallMaker.makeExternalValueArgument(this.expression);
                Intrinsics.checkNotNullExpressionValue(valueArgument, "makeExternalValueArgument(...)");
                return valueArgument;
            }

            @Override
            @NotNull
            public KtExpression getValueExpression() {
                return this.expression;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$None;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "<init>", "()V", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
        public static final class None
        extends Subject {
            public None() {
                super(null, null, null, null, 8, null);
            }

            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkNotNullParameter(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkNotNullParameter(builtIns, "builtIns");
                return DataFlowValue.Companion.nullValue(builtIns);
            }

            @Override
            @Nullable
            public ValueArgument makeValueArgument() {
                return null;
            }

            @Override
            @Nullable
            public KtExpression getValueExpression() {
                return null;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject$Variable;", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$Subject;", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "typeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "scopeWithSubject", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;)V", "getVariable", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeValueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getCalleeExpressionForSpecialCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "valueExpression", "getValueExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
        public static final class Variable
        extends Subject {
            @NotNull
            private final KtProperty variable;
            @NotNull
            private final VariableDescriptor descriptor;

            public Variable(@NotNull KtProperty variable, @NotNull VariableDescriptor descriptor, @NotNull KotlinTypeInfo typeInfo, @NotNull LexicalScope scopeWithSubject) {
                Intrinsics.checkNotNullParameter(variable, "variable");
                Intrinsics.checkNotNullParameter(descriptor, "descriptor");
                Intrinsics.checkNotNullParameter(typeInfo, "typeInfo");
                Intrinsics.checkNotNullParameter(scopeWithSubject, "scopeWithSubject");
                super(variable, typeInfo, scopeWithSubject, null, 8, null);
                this.variable = variable;
                this.descriptor = descriptor;
            }

            @NotNull
            public final KtProperty getVariable() {
                return this.variable;
            }

            @NotNull
            public final VariableDescriptor getDescriptor() {
                return this.descriptor;
            }

            @Override
            @NotNull
            protected DataFlowValue createDataFlowValue(@NotNull ExpressionTypingContext contextAfterSubject, @NotNull KotlinBuiltIns builtIns) {
                Intrinsics.checkNotNullParameter(contextAfterSubject, "contextAfterSubject");
                Intrinsics.checkNotNullParameter(builtIns, "builtIns");
                IdentifierInfo identifierInfo = new IdentifierInfo.Variable(this.descriptor, DataFlowValue.Kind.STABLE_VALUE, (DataFlowValue)contextAfterSubject.trace.getBindingContext().get(BindingContext.BOUND_INITIALIZER_VALUE, this.descriptor));
                KotlinType kotlinType = this.descriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
            }

            @Override
            @Nullable
            public ValueArgument makeValueArgument() {
                ValueArgument valueArgument;
                KtExpression ktExpression = this.variable.getInitializer();
                if (ktExpression != null) {
                    KtExpression it = ktExpression;
                    boolean bl = false;
                    Project project = this.variable.getProject();
                    Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
                    KtPsiFactory ktPsiFactory = new KtPsiFactory(project, true);
                    String string2 = this.variable.getName();
                    Intrinsics.checkNotNull(string2);
                    valueArgument = CallMaker.makeExternalValueArgument(ktPsiFactory.createExpression(string2), it);
                } else {
                    valueArgument = null;
                }
                return valueArgument;
            }

            @Override
            @NotNull
            public KtExpression getCalleeExpressionForSpecialCall() {
                return this.variable;
            }

            @Override
            @Nullable
            public KtExpression getValueExpression() {
                return this.variable.getInitializer();
            }
        }
    }
}

