/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0002=>B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!*\u00060\u0007j\u0002`\bH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020%*\u00060\u0007j\u0002`\bH\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J.\u0010)\u001a\u00020!*\u00060\u0007j\u0002`\b2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020(0\u0012H\u0002J(\u0010.\u001a\u00020,*\u00060\u0007j\u0002`\b2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\f\u00103\u001a\u00020,*\u00020,H\u0002J.\u00104\u001a\u00020!*\u00060\u0007j\u0002`\b2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010.\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020(0\u0012H\u0002J \u00106\u001a\u00020%*\u00060\u0007j\u0002`\b2\u0006\u0010#\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0010H\u0002J\u0014\u00108\u001a\u00020%*\u0002092\u0006\u00107\u001a\u00020\u0010H\u0002J \u0010:\u001a\u00020%*\u00060\u0007j\u0002`\b2\u0006\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall;", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "returnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionContext;", "Lorg/jetbrains/kotlin/fir/resolve/inference/CsCompleterContext;", "oracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionContext;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;)V", "fixationDirectionsForVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirection;", "variablesWithQueuedConstraints", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "typesToProcess", "Ljava/util/Queue;", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "postponedAtoms", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "getPostponedAtoms", "()Ljava/util/List;", "postponedAtoms$delegate", "Lkotlin/Lazy;", "computeCompletionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "computeDirections", "", "enqueueTypesFromConstraints", "variableWithConstraints", "directionRequirementsForVariablesHold", "", "updateDirection", "directionForVariable", "Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirectionForVariable;", "collectRequiredDirectionsForVariables", "type", "outerVariance", "Lorg/jetbrains/kotlin/types/model/TypeVariance;", "fixationDirectionsCollector", "compositeVariance", "argument", "Lorg/jetbrains/kotlin/types/model/TypeArgumentMarker;", "parameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "reversed", "processTypeWithoutParameters", "newRequirementsCollector", "hasProperConstraint", "direction", "hasRequiredKind", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "isLowerConstraintForPartiallyAnalyzedVariable", "constraint", "variable", "FixationDirection", "FixationDirectionForVariable", "resolve"})
@SourceDebugExtension(value={"SMAP\nCompletionModeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionModeCalculator.kt\norg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1755#2,3:260\n*S KotlinDebug\n*F\n+ 1 CompletionModeCalculator.kt\norg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall\n*L\n254#1:260,3\n*E\n"})
final class CalculatorForNestedCall {
    @NotNull
    private final Candidate candidate;
    @Nullable
    private final ConeKotlinType returnType;
    @NotNull
    private final ConstraintSystemCompletionContext context;
    @NotNull
    private final TrivialConstraintTypeInferenceOracle oracle;
    @NotNull
    private final Map<VariableWithConstraints, FixationDirection> fixationDirectionsForVariables;
    @NotNull
    private final Set<TypeVariableMarker> variablesWithQueuedConstraints;
    @NotNull
    private final Queue<KotlinTypeMarker> typesToProcess;
    @NotNull
    private final Lazy postponedAtoms$delegate;

    public CalculatorForNestedCall(@NotNull Candidate candidate2, @Nullable ConeKotlinType returnType, @NotNull ConstraintSystemCompletionContext context, @NotNull TrivialConstraintTypeInferenceOracle oracle) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(oracle, "oracle");
        this.candidate = candidate2;
        this.returnType = returnType;
        this.context = context;
        this.oracle = oracle;
        this.fixationDirectionsForVariables = CollectionsKt.newLinkedHashMapWithExpectedSize(this.context.getNotFixedTypeVariables().size());
        this.variablesWithQueuedConstraints = new LinkedHashSet();
        this.typesToProcess = new ArrayDeque();
        this.postponedAtoms$delegate = LazyKt.lazy(() -> CalculatorForNestedCall.postponedAtoms_delegate$lambda$0(this));
    }

    private final List<ConePostponedResolvedAtom> getPostponedAtoms() {
        Lazy lazy = this.postponedAtoms$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final ConstraintSystemCompletionMode computeCompletionMode() {
        ConstraintSystemCompletionContext $this$computeCompletionMode_u24lambda_u241 = this.context;
        boolean bl = false;
        this.typesToProcess.add(this.returnType);
        this.computeDirections($this$computeCompletionMode_u24lambda_u241);
        if (this.directionRequirementsForVariablesHold($this$computeCompletionMode_u24lambda_u241)) {
            return ConstraintSystemCompletionMode.FULL;
        }
        return ConstraintSystemCompletionMode.PARTIAL;
    }

    private final void computeDirections(ConstraintSystemCompletionContext $this$computeDirections) {
        while (!((Collection)this.typesToProcess).isEmpty() && this.typesToProcess.poll() != null) {
            KotlinTypeMarker type2;
            if (!$this$computeDirections.contains(type2, arg_0 -> CalculatorForNestedCall.computeDirections$lambda$2($this$computeDirections, arg_0))) continue;
            Set fixationDirectionsFromType = new LinkedHashSet();
            this.collectRequiredDirectionsForVariables($this$computeDirections, type2, TypeVariance.OUT, fixationDirectionsFromType);
            for (FixationDirectionForVariable directionForVariable : fixationDirectionsFromType) {
                this.updateDirection(directionForVariable);
                this.enqueueTypesFromConstraints(directionForVariable.getVariable());
            }
        }
    }

    private final void enqueueTypesFromConstraints(VariableWithConstraints variableWithConstraints) {
        TypeVariableMarker variable = variableWithConstraints.getTypeVariable();
        if (!this.variablesWithQueuedConstraints.contains(variable)) {
            for (Constraint constraint : variableWithConstraints.getConstraints()) {
                this.typesToProcess.add(constraint.getType());
            }
            this.variablesWithQueuedConstraints.add(variable);
        }
    }

    private final boolean directionRequirementsForVariablesHold(ConstraintSystemCompletionContext $this$directionRequirementsForVariablesHold) {
        for (Map.Entry<VariableWithConstraints, FixationDirection> entry : this.fixationDirectionsForVariables.entrySet()) {
            FixationDirection fixationDirection;
            VariableWithConstraints variable = entry.getKey();
            if (this.hasProperConstraint($this$directionRequirementsForVariablesHold, variable, fixationDirection = entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private final void updateDirection(FixationDirectionForVariable directionForVariable) {
        VariableWithConstraints variable = directionForVariable.component1();
        FixationDirection newDirection = directionForVariable.component2();
        FixationDirection fixationDirection = this.fixationDirectionsForVariables.get(variable);
        if (fixationDirection != null) {
            FixationDirection oldDirection = fixationDirection;
            boolean bl = false;
            if (oldDirection != FixationDirection.EQUALITY && oldDirection != newDirection) {
                this.fixationDirectionsForVariables.put(variable, FixationDirection.EQUALITY);
            }
        } else {
            CalculatorForNestedCall $this$updateDirection_u24lambda_u244 = this;
            boolean bl = false;
            $this$updateDirection_u24lambda_u244.fixationDirectionsForVariables.put(variable, newDirection);
        }
    }

    private final void collectRequiredDirectionsForVariables(ConstraintSystemCompletionContext $this$collectRequiredDirectionsForVariables, KotlinTypeMarker type2, TypeVariance outerVariance, Set<FixationDirectionForVariable> fixationDirectionsCollector) {
        SimpleTypeMarker unwrappedType = $this$collectRequiredDirectionsForVariables.lowerBoundIfFlexible(type2);
        int typeArgumentsCount = $this$collectRequiredDirectionsForVariables.argumentsCount(unwrappedType);
        if (typeArgumentsCount > 0 && !$this$collectRequiredDirectionsForVariables.isError(unwrappedType)) {
            for (int position = 0; position < typeArgumentsCount; ++position) {
                TypeArgumentMarker argument = $this$collectRequiredDirectionsForVariables.getArgument(unwrappedType, position);
                TypeParameterMarker parameter = $this$collectRequiredDirectionsForVariables.getParameter($this$collectRequiredDirectionsForVariables.typeConstructor(unwrappedType), position);
                if ($this$collectRequiredDirectionsForVariables.isStarProjection(argument)) continue;
                this.collectRequiredDirectionsForVariables($this$collectRequiredDirectionsForVariables, $this$collectRequiredDirectionsForVariables.getType(argument), this.compositeVariance($this$collectRequiredDirectionsForVariables, outerVariance, argument, parameter), fixationDirectionsCollector);
            }
        } else {
            this.processTypeWithoutParameters($this$collectRequiredDirectionsForVariables, type2, outerVariance, fixationDirectionsCollector);
        }
    }

    private final TypeVariance compositeVariance(ConstraintSystemCompletionContext $this$compositeVariance, TypeVariance outerVariance, TypeArgumentMarker argument, TypeParameterMarker parameter) {
        TypeVariance typeVariance;
        TypeVariance typeVariance2 = AbstractTypeChecker.INSTANCE.effectiveVariance($this$compositeVariance.getVariance(parameter), $this$compositeVariance.getVariance(argument));
        if (typeVariance2 == null) {
            typeVariance2 = TypeVariance.INV;
        }
        TypeVariance effectiveArgumentVariance = typeVariance2;
        switch (WhenMappings.$EnumSwitchMapping$0[outerVariance.ordinal()]) {
            case 1: {
                typeVariance = TypeVariance.INV;
                break;
            }
            case 2: {
                typeVariance = effectiveArgumentVariance;
                break;
            }
            case 3: {
                typeVariance = this.reversed(effectiveArgumentVariance);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeVariance;
    }

    private final TypeVariance reversed(TypeVariance $this$reversed) {
        TypeVariance typeVariance;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$reversed.ordinal()]) {
            case 3: {
                typeVariance = TypeVariance.OUT;
                break;
            }
            case 2: {
                typeVariance = TypeVariance.IN;
                break;
            }
            case 1: {
                typeVariance = TypeVariance.INV;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeVariance;
    }

    private final void processTypeWithoutParameters(ConstraintSystemCompletionContext $this$processTypeWithoutParameters, KotlinTypeMarker type2, TypeVariance compositeVariance, Set<FixationDirectionForVariable> newRequirementsCollector) {
        FixationDirection fixationDirection;
        VariableWithConstraints variableWithConstraints = $this$processTypeWithoutParameters.getNotFixedTypeVariables().get($this$processTypeWithoutParameters.typeConstructor(type2));
        if (variableWithConstraints == null) {
            return;
        }
        VariableWithConstraints variableWithConstraints2 = variableWithConstraints;
        switch (WhenMappings.$EnumSwitchMapping$0[compositeVariance.ordinal()]) {
            case 3: {
                fixationDirection = FixationDirection.EQUALITY;
                break;
            }
            case 2: {
                fixationDirection = FixationDirection.TO_SUBTYPE;
                break;
            }
            case 1: {
                fixationDirection = FixationDirection.EQUALITY;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FixationDirection direction = fixationDirection;
        FixationDirectionForVariable requirement = new FixationDirectionForVariable(variableWithConstraints2, direction);
        newRequirementsCollector.add(requirement);
    }

    private final boolean hasProperConstraint(ConstraintSystemCompletionContext $this$hasProperConstraint, VariableWithConstraints variableWithConstraints, FixationDirection direction) {
        List<Constraint> constraints = variableWithConstraints.getConstraints();
        TypeVariableMarker variable = variableWithConstraints.getTypeVariable();
        boolean iltConstraintPresent = false;
        boolean properConstraintPresent = false;
        boolean nonNothingProperConstraintPresent = false;
        for (Constraint constraint : constraints) {
            if (!this.hasRequiredKind(constraint, direction) || !$this$hasProperConstraint.isProperType(constraint.getType())) continue;
            if ($this$hasProperConstraint.isIntegerLiteralTypeConstructor($this$hasProperConstraint.typeConstructor(constraint.getType()))) {
                iltConstraintPresent = true;
                continue;
            }
            if (this.oracle.isSuitableResultedType(constraint.getType())) {
                properConstraintPresent = true;
                nonNothingProperConstraintPresent = true;
                continue;
            }
            if (this.isLowerConstraintForPartiallyAnalyzedVariable($this$hasProperConstraint, constraint, variable)) continue;
            properConstraintPresent = true;
        }
        if (!properConstraintPresent) {
            return false;
        }
        return !iltConstraintPresent || nonNothingProperConstraintPresent;
    }

    private final boolean hasRequiredKind(Constraint $this$hasRequiredKind, FixationDirection direction) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[direction.ordinal()]) {
            case 1: {
                if ($this$hasRequiredKind.getKind().isLower() || $this$hasRequiredKind.getKind().isEqual()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = $this$hasRequiredKind.getKind().isEqual();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLowerConstraintForPartiallyAnalyzedVariable(ConstraintSystemCompletionContext $this$isLowerConstraintForPartiallyAnalyzedVariable, Constraint constraint, TypeVariableMarker variable) {
        ConeKotlinType coneKotlinType;
        SimpleTypeMarker defaultType = $this$isLowerConstraintForPartiallyAnalyzedVariable.defaultType(variable);
        if (!constraint.getKind().isLower()) return false;
        Iterable $this$any$iv = this.getPostponedAtoms();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ConePostponedResolvedAtom atom = (ConePostponedResolvedAtom)element$iv;
            boolean bl = false;
            coneKotlinType = atom.getExpectedType();
        } while (!(coneKotlinType != null ? $this$isLowerConstraintForPartiallyAnalyzedVariable.contains(coneKotlinType, arg_0 -> CalculatorForNestedCall.isLowerConstraintForPartiallyAnalyzedVariable$lambda$6$lambda$5(defaultType, arg_0)) : false));
        return true;
    }

    private static final List postponedAtoms_delegate$lambda$0(CalculatorForNestedCall this$0) {
        return ConstraintSystemCompleter.Companion.getOrderedNotAnalyzedPostponedArguments$resolve(this$0.candidate);
    }

    private static final boolean computeDirections$lambda$2(ConstraintSystemCompletionContext $this_computeDirections, KotlinTypeMarker it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $this_computeDirections.getNotFixedTypeVariables().containsKey($this_computeDirections.typeConstructor(it));
    }

    private static final boolean isLowerConstraintForPartiallyAnalyzedVariable$lambda$6$lambda$5(SimpleTypeMarker $defaultType, KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return Intrinsics.areEqual($defaultType, type2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirection;", "", "<init>", "(Ljava/lang/String;I)V", "TO_SUBTYPE", "EQUALITY", "resolve"})
    private static final class FixationDirection
    extends Enum<FixationDirection> {
        public static final /* enum */ FixationDirection TO_SUBTYPE = new FixationDirection();
        public static final /* enum */ FixationDirection EQUALITY = new FixationDirection();
        private static final /* synthetic */ FixationDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FixationDirection[] values() {
            return (FixationDirection[])$VALUES.clone();
        }

        public static FixationDirection valueOf(String value2) {
            return Enum.valueOf(FixationDirection.class, value2);
        }

        @NotNull
        public static EnumEntries<FixationDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fixationDirectionArray = new FixationDirection[]{FixationDirection.TO_SUBTYPE, FixationDirection.EQUALITY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirectionForVariable;", "", "variable", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "direction", "Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirection;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirection;)V", "getVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getDirection", "()Lorg/jetbrains/kotlin/fir/resolve/inference/CalculatorForNestedCall$FixationDirection;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class FixationDirectionForVariable {
        @NotNull
        private final VariableWithConstraints variable;
        @NotNull
        private final FixationDirection direction;

        public FixationDirectionForVariable(@NotNull VariableWithConstraints variable, @NotNull FixationDirection direction) {
            Intrinsics.checkNotNullParameter(variable, "variable");
            Intrinsics.checkNotNullParameter((Object)direction, "direction");
            this.variable = variable;
            this.direction = direction;
        }

        @NotNull
        public final VariableWithConstraints getVariable() {
            return this.variable;
        }

        @NotNull
        public final FixationDirection getDirection() {
            return this.direction;
        }

        @NotNull
        public final VariableWithConstraints component1() {
            return this.variable;
        }

        @NotNull
        public final FixationDirection component2() {
            return this.direction;
        }

        @NotNull
        public final FixationDirectionForVariable copy(@NotNull VariableWithConstraints variable, @NotNull FixationDirection direction) {
            Intrinsics.checkNotNullParameter(variable, "variable");
            Intrinsics.checkNotNullParameter((Object)direction, "direction");
            return new FixationDirectionForVariable(variable, direction);
        }

        public static /* synthetic */ FixationDirectionForVariable copy$default(FixationDirectionForVariable fixationDirectionForVariable, VariableWithConstraints variableWithConstraints, FixationDirection fixationDirection, int n, Object object) {
            if ((n & 1) != 0) {
                variableWithConstraints = fixationDirectionForVariable.variable;
            }
            if ((n & 2) != 0) {
                fixationDirection = fixationDirectionForVariable.direction;
            }
            return fixationDirectionForVariable.copy(variableWithConstraints, fixationDirection);
        }

        @NotNull
        public String toString() {
            return "FixationDirectionForVariable(variable=" + this.variable + ", direction=" + (Object)((Object)this.direction) + ')';
        }

        public int hashCode() {
            int result2 = this.variable.hashCode();
            result2 = result2 * 31 + this.direction.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixationDirectionForVariable)) {
                return false;
            }
            FixationDirectionForVariable fixationDirectionForVariable = (FixationDirectionForVariable)other;
            if (!Intrinsics.areEqual(this.variable, fixationDirectionForVariable.variable)) {
                return false;
            }
            return this.direction == fixationDirectionForVariable.direction;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeVariance.values().length];
            try {
                nArray[TypeVariance.INV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FixationDirection.values().length];
            try {
                nArray[FixationDirection.TO_SUBTYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FixationDirection.EQUALITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

