/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "Flags", "ConditionChecker", "resolve"})
final class WhenOnBooleanExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnBooleanExhaustivenessChecker INSTANCE = new WhenOnBooleanExhaustivenessChecker();

    private WhenOnBooleanExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session2, "session");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(subjectType), StandardClassIds.INSTANCE.getBoolean());
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session2, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Flags flags = new Flags();
        whenExpression.accept(ConditionChecker.INSTANCE, flags);
        if (!flags.getContainsTrue()) {
            destination.add(WhenMissingCase.BooleanIsMissing.TrueIsMissing.INSTANCE);
        }
        if (!flags.getContainsFalse()) {
            destination.add(WhenMissingCase.BooleanIsMissing.FalseIsMissing.INSTANCE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$Flags;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,501:1\n1#2:502\n43#3:503\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker\n*L\n283#1:503\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Flags> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Flags data) {
            Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data, "data");
            FirOperation it = equalityOperatorCall.getOperation();
            boolean bl = false;
            boolean bl2 = it == FirOperation.EQ || it == FirOperation.IDENTITY;
            if (bl2) {
                FirCall $this$arguments$iv = equalityOperatorCall;
                boolean $i$f$getArguments = false;
                FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
                if (argument instanceof FirLiteralExpression) {
                    Object object = ((FirLiteralExpression)argument).getValue();
                    if (Intrinsics.areEqual(object, true)) {
                        data.setContainsTrue(true);
                    } else if (Intrinsics.areEqual(object, false)) {
                        data.setContainsFalse(true);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$Flags;", "", "<init>", "()V", "containsTrue", "", "getContainsTrue", "()Z", "setContainsTrue", "(Z)V", "containsFalse", "getContainsFalse", "setContainsFalse", "resolve"})
    private static final class Flags {
        private boolean containsTrue;
        private boolean containsFalse;

        public final boolean getContainsTrue() {
            return this.containsTrue;
        }

        public final void setContainsTrue(boolean bl) {
            this.containsTrue = bl;
        }

        public final boolean getContainsFalse() {
            return this.containsFalse;
        }

        public final void setContainsFalse(boolean bl) {
            this.containsFalse = bl;
        }
    }
}

