/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.GosenPartOfSpeechKeepFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class GosenPartOfSpeechKeepFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private final boolean enablePositionIncrements;
    private final String keepTagFiles;
    private Set<String> keepTags;

    public GosenPartOfSpeechKeepFilterFactory(Map<String, String> args) {
        super(args);
        this.keepTagFiles = this.require(args, "tags");
        this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public void inform(ResourceLoader loader) {
        try {
            CharArraySet cas = this.getWordSet(loader, this.keepTagFiles, false);
            this.keepTags = new HashSet<String>();
            for (Object element : cas) {
                char[] chars = (char[])element;
                this.keepTags.add(new String(chars));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream create(TokenStream stream) {
        if (this.keepTags != null) {
            GosenPartOfSpeechKeepFilter filter = new GosenPartOfSpeechKeepFilter(this.luceneMatchVersion, this.enablePositionIncrements, stream, this.keepTags);
            return filter;
        }
        return stream;
    }
}

