/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.options;

import java.util.Arrays;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.options.OptionHandler;

public class CompilerOptionHandler
extends OptionHandler {
    private OptionSpec<Void> noGuessImportsOption;
    private OptionSpec<Void> noGuessDependenciesOption;
    private OptionSpec<Boolean> autoconfigureOption;
    private OptionSpec<String> classpathOption;

    @Override
    protected final void options() {
        this.noGuessImportsOption = this.option("no-guess-imports", "Do not attempt to guess imports");
        this.noGuessDependenciesOption = this.option("no-guess-dependencies", "Do not attempt to guess dependencies");
        this.autoconfigureOption = this.option("autoconfigure", "Add autoconfigure compiler transformations").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        this.classpathOption = this.option(Arrays.asList("classpath", "cp"), "Additional classpath entries").withRequiredArg();
        this.doOptions();
    }

    protected void doOptions() {
    }

    public OptionSpec<Void> getNoGuessImportsOption() {
        return this.noGuessImportsOption;
    }

    public OptionSpec<Void> getNoGuessDependenciesOption() {
        return this.noGuessDependenciesOption;
    }

    public OptionSpec<String> getClasspathOption() {
        return this.classpathOption;
    }

    public OptionSpec<Boolean> getAutoconfigureOption() {
        return this.autoconfigureOption;
    }
}

