//*****************************************************************************
//
// Copyright (C) 2021 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
//  Redistributions of source code must retain the above copyright
//  notice, this list of conditions and the following disclaimer.
//
//  Redistributions in binary form must reproduce the above copyright
//  notice, this list of conditions and the following disclaimer in the
//  documentation and/or other materials provided with the
//  distribution.
//
//  Neither the name of Texas Instruments Incorporated nor the names of
//  its contributors may be used to endorse or promote products derived
//  from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//****************************************************************************

/********************************************************************
*
* Standard register and bit definitions for the Texas Instruments
* MSP430 microcontroller.
*
* This file supports assembler and C development for
* MSP430FR2311 devices.
*
********************************************************************/

#ifndef __MSP430FR2311
#define __MSP430FR2311

#define __MSP430_HEADER_VERSION__ 1212

#define __MSP430_HAS_MSP430XV2_CPU__  /* CPU type */
#define __MSP430FR2XX_4XX_FAMILY__

#include "in430.h"

#define __MSP430_TI_HEADERS__

#ifndef __AUTOGENERATED__
#define __AUTOGENERATED__
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <iomacros.h>

/************************************************************
* STANDARD BITS
************************************************************/

#define BIT0                (0x0001)
#define BIT1                (0x0002)
#define BIT2                (0x0004)
#define BIT3                (0x0008)
#define BIT4                (0x0010)
#define BIT5                (0x0020)
#define BIT6                (0x0040)
#define BIT7                (0x0080)
#define BIT8                (0x0100)
#define BIT9                (0x0200)
#define BITA                (0x0400)
#define BITB                (0x0800)
#define BITC                (0x1000)
#define BITD                (0x2000)
#define BITE                (0x4000)
#define BITF                (0x8000)

/************************************************************
* STATUS REGISTER BITS
************************************************************/

#define C                   (0x0001)
#define Z                   (0x0002)
#define N                   (0x0004)
#define V                   (0x0100)
#define GIE                 (0x0008)
#define CPUOFF              (0x0010)
#define OSCOFF              (0x0020)
#define SCG0                (0x0040)
#define SCG1                (0x0080)

/* Low Power Modes coded with Bits 4-7 in SR */

#ifndef __STDC__ /* Begin #defines for assembler */
#define LPM0                (CPUOFF)
#define LPM1                (SCG0+CPUOFF)
#define LPM2                (SCG1+CPUOFF)
#define LPM3                (SCG1+SCG0+CPUOFF)
#define LPM4                (SCG1+SCG0+OSCOFF+CPUOFF)
/* End #defines for assembler */

#else /* Begin #defines for C */
#define LPM0_bits           (CPUOFF)
#define LPM1_bits           (SCG0+CPUOFF)
#define LPM2_bits           (SCG1+CPUOFF)
#define LPM3_bits           (SCG1+SCG0+CPUOFF)
#define LPM4_bits           (SCG1+SCG0+OSCOFF+CPUOFF)

#define LPM0      __bis_SR_register(LPM0_bits)         /* Enter Low Power Mode 0 */
#define LPM0_EXIT __bic_SR_register_on_exit(LPM0_bits) /* Exit Low Power Mode 0 */
#define LPM1      __bis_SR_register(LPM1_bits)         /* Enter Low Power Mode 1 */
#define LPM1_EXIT __bic_SR_register_on_exit(LPM1_bits) /* Exit Low Power Mode 1 */
#define LPM2      __bis_SR_register(LPM2_bits)         /* Enter Low Power Mode 2 */
#define LPM2_EXIT __bic_SR_register_on_exit(LPM2_bits) /* Exit Low Power Mode 2 */
#define LPM3      __bis_SR_register(LPM3_bits)         /* Enter Low Power Mode 3 */
#define LPM3_EXIT __bic_SR_register_on_exit(LPM3_bits) /* Exit Low Power Mode 3 */
#define LPM4      __bis_SR_register(LPM4_bits)         /* Enter Low Power Mode 4 */
#define LPM4_EXIT __bic_SR_register_on_exit(LPM4_bits) /* Exit Low Power Mode 4 */
#endif /* End #defines for C */

/************************************************************
* PERIPHERAL FILE MAP
************************************************************/


/*****************************************************************************
 ADC Registers
*****************************************************************************/

#define __MSP430_HAS_ADC__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_ADC__ 0x0700
#define ADC_BASE               __MSP430_BASEADDRESS_ADC__

sfr_w(ADCCTL0);                               /* ADC Control 0 */
sfr_b(ADCCTL0_L);
sfr_b(ADCCTL0_H);
sfr_w(ADCCTL1);                               /* ADC Control 1 */
sfr_b(ADCCTL1_L);
sfr_b(ADCCTL1_H);
sfr_w(ADCCTL2);                               /* ADC Control 2 */
sfr_b(ADCCTL2_L);
sfr_b(ADCCTL2_H);
sfr_w(ADCLO);                                 /* ADC Window Comparator Low Threshold Register */
sfr_b(ADCLO_L);
sfr_b(ADCLO_H);
sfr_w(ADCHI);                                 /* ADC Window Comparator High Threshold Register */
sfr_b(ADCHI_L);
sfr_b(ADCHI_H);
sfr_w(ADCMCTL0);                              /* ADC Conversion Memory Control Register */
sfr_b(ADCMCTL0_L);
sfr_b(ADCMCTL0_H);
sfr_w(ADCMEM0);                               /* ADC Conversion Memory Register */
sfr_b(ADCMEM0_L);
sfr_b(ADCMEM0_H);
sfr_w(ADCIE);                                 /* ADC Interrupt Enable 0 */
sfr_b(ADCIE_L);
sfr_b(ADCIE_H);
sfr_w(ADCIFG);                                /* ADC Interrupt Flag */
sfr_b(ADCIFG_L);
sfr_b(ADCIFG_H);
sfr_w(ADCIV);                                 /* ADC Interrupt Vector */
sfr_b(ADCIV_L);
sfr_b(ADCIV_H);

/* ADC Register Offsets */
#define OFS_ADCCTL0                      (0x0000)
#define OFS_ADCCTL0_L                    OFS_ADCCTL0
#define OFS_ADCCTL0_H                    OFS_ADCCTL0+1
#define OFS_ADCCTL1                      (0x0002)
#define OFS_ADCCTL1_L                    OFS_ADCCTL1
#define OFS_ADCCTL1_H                    OFS_ADCCTL1+1
#define OFS_ADCCTL2                      (0x0004)
#define OFS_ADCCTL2_L                    OFS_ADCCTL2
#define OFS_ADCCTL2_H                    OFS_ADCCTL2+1
#define OFS_ADCLO                        (0x0006)
#define OFS_ADCLO_L                      OFS_ADCLO
#define OFS_ADCLO_H                      OFS_ADCLO+1
#define OFS_ADCHI                        (0x0008)
#define OFS_ADCHI_L                      OFS_ADCHI
#define OFS_ADCHI_H                      OFS_ADCHI+1
#define OFS_ADCMCTL0                     (0x000A)
#define OFS_ADCMCTL0_L                   OFS_ADCMCTL0
#define OFS_ADCMCTL0_H                   OFS_ADCMCTL0+1
#define OFS_ADCMEM0                      (0x0012)
#define OFS_ADCMEM0_L                    OFS_ADCMEM0
#define OFS_ADCMEM0_H                    OFS_ADCMEM0+1
#define OFS_ADCIE                        (0x001A)
#define OFS_ADCIE_L                      OFS_ADCIE
#define OFS_ADCIE_H                      OFS_ADCIE+1
#define OFS_ADCIFG                       (0x001C)
#define OFS_ADCIFG_L                     OFS_ADCIFG
#define OFS_ADCIFG_H                     OFS_ADCIFG+1
#define OFS_ADCIV                        (0x001E)
#define OFS_ADCIV_L                      OFS_ADCIV
#define OFS_ADCIV_H                      OFS_ADCIV+1

/* ADC Control Bits */

/* ADCCTL0 Control Bits */
#define ADCSC                            (0x0001)        /* start conversion */
#define ADCSC_L                          (0x0001)
#define ADCSC_0                          (0x0000)        /* No sample-and-conversion-start */
#define ADCSC_1                          (0x0001)        /* Start sample-and-conversion */
#define ADCSC_1_L                        (0x0001)
#define ADCENC                           (0x0002)        /* enable conversion */
#define ADCENC_L                         (0x0002)
#define ADCENC_0                         (0x0000)        /* ADC disabled */
#define ADCENC_1                         (0x0002)        /* ADC enabled */
#define ADCENC_1_L                       (0x0002)
#define ADCON                            (0x0010)        /* ADC on */
#define ADCON_L                          (0x0010)
#define ADCON_0                          (0x0000)        /* ADC off */
#define ADCON_1                          (0x0010)        /* ADC on */
#define ADCON_1_L                        (0x0010)
#define ADCMSC                           (0x0080)        /* sample-and-hold time. */
#define ADCMSC_L                         (0x0080)
#define ADCMSC_0                         (0x0000)        /* The sampling timer requires a rising edge of the SHI signal to
                                                            trigger each sample-and-convert. */
#define ADCMSC_1                         (0x0080)        /* The incidence of a positive(or for devices first rising edge 
                                                            of the) SHI signal triggers the sampling timer, but further 
                                                            sample-and-conversions are performed automatically as soon as 
                                                            the prior conversion is completed. */
#define ADCMSC_1_L                       (0x0080)
#define ADCSHT                           (0x0f00)        /* sample-and-hold time. */
#define ADCSHT_H                         (0x000f)
#define ADCSHT0                          (0x0100)        /* sample-and-hold time. */
#define ADCSHT0_H                        (0x0001)
#define ADCSHT1                          (0x0200)        /* sample-and-hold time. */
#define ADCSHT1_H                        (0x0002)
#define ADCSHT2                          (0x0400)        /* sample-and-hold time. */
#define ADCSHT2_H                        (0x0004)
#define ADCSHT3                          (0x0800)        /* sample-and-hold time. */
#define ADCSHT3_H                        (0x0008)
#define ADCSHT_0                         (0x0000)        /* 4 ADCCLK cycles */
#define ADCSHT_1                         (0x0100)        /* 8 ADCCLK cycles */
#define ADCSHT_1_H                       (0x0001)
#define ADCSHT_2                         (0x0200)        /* 16 ADCCLK cycles */
#define ADCSHT_2_H                       (0x0002)
#define ADCSHT_3                         (0x0300)        /* 32 ADCCLK cycles */
#define ADCSHT_3_H                       (0x0003)
#define ADCSHT_4                         (0x0400)        /* 64 ADCCLK cycles */
#define ADCSHT_4_H                       (0x0004)
#define ADCSHT_5                         (0x0500)        /* 96 ADCCLK cycles */
#define ADCSHT_5_H                       (0x0005)
#define ADCSHT_6                         (0x0600)        /* 128 ADCCLK cycles */
#define ADCSHT_6_H                       (0x0006)
#define ADCSHT_7                         (0x0700)        /* 192 ADCCLK cycles */
#define ADCSHT_7_H                       (0x0007)
#define ADCSHT_8                         (0x0800)        /* 256 ADCCLK cycles */
#define ADCSHT_8_H                       (0x0008)
#define ADCSHT_9                         (0x0900)        /* 384 ADCCLK cycles */
#define ADCSHT_9_H                       (0x0009)
#define ADCSHT_10                        (0x0a00)        /* 512 ADCCLK cycles */
#define ADCSHT_10_H                      (0x000a)
#define ADCSHT_11                        (0x0b00)        /* 768 ADCCLK cycles */
#define ADCSHT_11_H                      (0x000b)
#define ADCSHT_12                        (0x0c00)        /* 1024 ADCCLK cycles */
#define ADCSHT_12_H                      (0x000c)
#define ADCSHT_13                        (0x0d00)        /* 1024 ADCCLK cycles */
#define ADCSHT_13_H                      (0x000d)
#define ADCSHT_14                        (0x0e00)        /* 1024 ADCCLK cycles */
#define ADCSHT_14_H                      (0x000e)
#define ADCSHT_15                        (0x0f00)        /* 1024 ADCCLK cycles */
#define ADCSHT_15_H                      (0x000f)

/* ADCCTL1 Control Bits */
#define ADCBUSY                          (0x0001)        /* ADC busy */
#define ADCBUSY_L                        (0x0001)
#define ADCBUSY_0                        (0x0000)        /* No operation is active. */
#define ADCBUSY_1                        (0x0001)        /* A sequence, sample, or conversion is active. */
#define ADCBUSY_1_L                      (0x0001)
#define ADCCONSEQ                        (0x0006)        /* conversion sequence mode select */
#define ADCCONSEQ_L                      (0x0006)
#define ADCCONSEQ0                       (0x0002)        /* conversion sequence mode select */
#define ADCCONSEQ0_L                     (0x0002)
#define ADCCONSEQ1                       (0x0004)        /* conversion sequence mode select */
#define ADCCONSEQ1_L                     (0x0004)
#define ADCCONSEQ_0                      (0x0000)        /* Single-channel, single-conversion */
#define ADCCONSEQ_1                      (0x0002)        /* Sequence-of-channels */
#define ADCCONSEQ_1_L                    (0x0002)
#define ADCCONSEQ_2                      (0x0004)        /* Repeat-single-channel */
#define ADCCONSEQ_2_L                    (0x0004)
#define ADCCONSEQ_3                      (0x0006)        /* Repeat-sequence-of-channels */
#define ADCCONSEQ_3_L                    (0x0006)
#define ADCSSEL                          (0x0018)        /* clock source select */
#define ADCSSEL_L                        (0x0018)
#define ADCSSEL0                         (0x0008)        /* clock source select */
#define ADCSSEL0_L                       (0x0008)
#define ADCSSEL1                         (0x0010)        /* clock source select */
#define ADCSSEL1_L                       (0x0010)
#define ADCSSEL_0                        (0x0000)        /* ADCOSC (MODOSC) */
#define ADCSSEL_1                        (0x0008)        /* ACLK */
#define ADCSSEL_1_L                      (0x0008)
#define ADCSSEL_2                        (0x0010)        /* MCLK */
#define ADCSSEL_2_L                      (0x0010)
#define ADCSSEL_3                        (0x0018)        /* SMCLK */
#define ADCSSEL_3_L                      (0x0018)
#define ADCDIV                           (0x00e0)        /* clock divider */
#define ADCDIV_L                         (0x00e0)
#define ADCDIV0                          (0x0020)        /* clock divider */
#define ADCDIV0_L                        (0x0020)
#define ADCDIV1                          (0x0040)        /* clock divider */
#define ADCDIV1_L                        (0x0040)
#define ADCDIV2                          (0x0080)        /* clock divider */
#define ADCDIV2_L                        (0x0080)
#define ADCDIV_0                         (0x0000)        /* /1 */
#define ADCDIV_1                         (0x0020)        /* /2 */
#define ADCDIV_1_L                       (0x0020)
#define ADCDIV_2                         (0x0040)        /* /3 */
#define ADCDIV_2_L                       (0x0040)
#define ADCDIV_3                         (0x0060)        /* /4 */
#define ADCDIV_3_L                       (0x0060)
#define ADCDIV_4                         (0x0080)        /* /5 */
#define ADCDIV_4_L                       (0x0080)
#define ADCDIV_5                         (0x00a0)        /* /6 */
#define ADCDIV_5_L                       (0x00a0)
#define ADCDIV_6                         (0x00c0)        /* /7 */
#define ADCDIV_6_L                       (0x00c0)
#define ADCDIV_7                         (0x00e0)        /* /8 */
#define ADCDIV_7_L                       (0x00e0)
#define ADCISSH                          (0x0100)        /* invert signal sample-and-hold */
#define ADCISSH_H                        (0x0001)
#define ADCISSH_0                        (0x0000)        /* The sample-input signal is not inverted. */
#define ADCISSH_1                        (0x0100)        /* The sample-input signal is inverted. */
#define ADCISSH_1_H                      (0x0001)
#define ADCSHP                           (0x0200)        /* sample-and-hold pulse-mode select */
#define ADCSHP_H                         (0x0002)
#define ADCSHP_0                         (0x0000)        /* SAMPCON signal is sourced from the sample-input signal. */
#define ADCSHP_1                         (0x0200)        /* SAMPCON signal is sourced from the sampling timer. */
#define ADCSHP_1_H                       (0x0002)
#define ADCSHS                           (0x0c00)        /* sample-and-hold source select */
#define ADCSHS_H                         (0x000c)
#define ADCSHS0                          (0x0400)        /* sample-and-hold source select */
#define ADCSHS0_H                        (0x0004)
#define ADCSHS1                          (0x0800)        /* sample-and-hold source select */
#define ADCSHS1_H                        (0x0008)
#define ADCSHS_0                         (0x0000)        /* ADCSC bit */
#define ADCSHS_1                         (0x0400)        /* see the device-specific data sheet for source */
#define ADCSHS_1_H                       (0x0004)
#define ADCSHS_2                         (0x0800)        /* see the device-specific data sheet for source */
#define ADCSHS_2_H                       (0x0008)
#define ADCSHS_3                         (0x0c00)        /* see the device-specific data sheet for source */
#define ADCSHS_3_H                       (0x000c)

/* ADCCTL2 Control Bits */
#define ADCDF                            (0x0008)        /* data read-back format */
#define ADCDF_L                          (0x0008)
#define ADCDF_0                          (0x0000)        /* Binary unsigned. Theoretically the analog input voltage V(REF)
                                                            results in 0000h, the analog input voltage +V(REF) results in 
                                                            03FFh. */
#define ADCDF_1                          (0x0008)        /* Signed binary (2s complement), left aligned. Theoretically the
                                                            analog input voltage V(REF) results in 8000h, the analog input
                                                            voltage +V(REF) results in 7FC0h. */
#define ADCDF_1_L                        (0x0008)
#define ADCRES                           (0x0030)        /* resolution */
#define ADCRES_L                         (0x0030)
#define ADCRES0                          (0x0010)        /* resolution */
#define ADCRES0_L                        (0x0010)
#define ADCRES1                          (0x0020)        /* resolution */
#define ADCRES1_L                        (0x0020)
#define ADCRES_0                         (0x0000)        /* 8 bit */
#define ADCRES_1                         (0x0010)        /* 10 bit */
#define ADCRES_1_L                       (0x0010)
#define ADCRES_2                         (0x0020)        /* 12 bit */
#define ADCRES_2_L                       (0x0020)
#define ADCRES_3                         (0x0030)        /* Reserved */
#define ADCRES_3_L                       (0x0030)
#define ADCSR                            (0x0004)        /* ADC sampling rate. */
#define ADCSR_L                          (0x0004)
#define ADCPDIV                          (0x0300)        /* */
#define ADCPDIV_H                        (0x0003)
#define ADCPDIV0                         (0x0100)        /* */
#define ADCPDIV0_H                       (0x0001)
#define ADCPDIV1                         (0x0200)        /* */
#define ADCPDIV1_H                       (0x0002)
#define ADCPDIV_0                        (0x0000)        /* Predivide by 1 */
#define ADCPDIV_1                        (0x0100)        /* Predivide by 4 */
#define ADCPDIV_1_H                      (0x0001)
#define ADCPDIV_2                        (0x0200)        /* Predivide by 64 */
#define ADCPDIV_2_H                      (0x0002)
#define ADCPDIV_3                        (0x0300)        /* Reserved */
#define ADCPDIV_3_H                      (0x0003)
#define ADCPDIV__1                       (0x0000)        /* Predivide by 1 */
#define ADCPDIV__4                       (0x0100)        /* Predivide by 4 */
#define ADCPDIV__4_H                     (0x0001)
#define ADCPDIV__64                      (0x0200)        /* Predivide by 64 */
#define ADCPDIV__64_H                    (0x0002)

/* ADCLO Control Bits */
#define LOW_THRESHOLD                    (0xffff)        /* Window comparator lo threshold */
#define LOW_THRESHOLD_L                  (0x00ff)
#define LOW_THRESHOLD_H                  (0x00ff)
#define LOW_THRESHOLD0                   (0x0001)        /* Window comparator lo threshold */
#define LOW_THRESHOLD0_L                 (0x0001)
#define LOW_THRESHOLD1                   (0x0002)        /* Window comparator lo threshold */
#define LOW_THRESHOLD1_L                 (0x0002)
#define LOW_THRESHOLD2                   (0x0004)        /* Window comparator lo threshold */
#define LOW_THRESHOLD2_L                 (0x0004)
#define LOW_THRESHOLD3                   (0x0008)        /* Window comparator lo threshold */
#define LOW_THRESHOLD3_L                 (0x0008)
#define LOW_THRESHOLD4                   (0x0010)        /* Window comparator lo threshold */
#define LOW_THRESHOLD4_L                 (0x0010)
#define LOW_THRESHOLD5                   (0x0020)        /* Window comparator lo threshold */
#define LOW_THRESHOLD5_L                 (0x0020)
#define LOW_THRESHOLD6                   (0x0040)        /* Window comparator lo threshold */
#define LOW_THRESHOLD6_L                 (0x0040)
#define LOW_THRESHOLD7                   (0x0080)        /* Window comparator lo threshold */
#define LOW_THRESHOLD7_L                 (0x0080)
#define LOW_THRESHOLD8                   (0x0100)        /* Window comparator lo threshold */
#define LOW_THRESHOLD8_H                 (0x0001)
#define LOW_THRESHOLD9                   (0x0200)        /* Window comparator lo threshold */
#define LOW_THRESHOLD9_H                 (0x0002)
#define LOW_THRESHOLD10                  (0x0400)        /* Window comparator lo threshold */
#define LOW_THRESHOLD10_H                (0x0004)
#define LOW_THRESHOLD11                  (0x0800)        /* Window comparator lo threshold */
#define LOW_THRESHOLD11_H                (0x0008)
#define LOW_THRESHOLD12                  (0x1000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD12_H                (0x0010)
#define LOW_THRESHOLD13                  (0x2000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD13_H                (0x0020)
#define LOW_THRESHOLD14                  (0x4000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD14_H                (0x0040)
#define LOW_THRESHOLD15                  (0x8000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD15_H                (0x0080)

/* ADCHI Control Bits */
#define HIGH_THRESHOLD                   (0xffff)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD_L                 (0x00ff)
#define HIGH_THRESHOLD_H                 (0x00ff)
#define HIGH_THRESHOLD0                  (0x0001)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD0_L                (0x0001)
#define HIGH_THRESHOLD1                  (0x0002)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD1_L                (0x0002)
#define HIGH_THRESHOLD2                  (0x0004)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD2_L                (0x0004)
#define HIGH_THRESHOLD3                  (0x0008)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD3_L                (0x0008)
#define HIGH_THRESHOLD4                  (0x0010)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD4_L                (0x0010)
#define HIGH_THRESHOLD5                  (0x0020)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD5_L                (0x0020)
#define HIGH_THRESHOLD6                  (0x0040)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD6_L                (0x0040)
#define HIGH_THRESHOLD7                  (0x0080)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD7_L                (0x0080)
#define HIGH_THRESHOLD8                  (0x0100)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD8_H                (0x0001)
#define HIGH_THRESHOLD9                  (0x0200)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD9_H                (0x0002)
#define HIGH_THRESHOLD10                 (0x0400)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD10_H               (0x0004)
#define HIGH_THRESHOLD11                 (0x0800)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD11_H               (0x0008)
#define HIGH_THRESHOLD12                 (0x1000)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD12_H               (0x0010)
#define HIGH_THRESHOLD13                 (0x2000)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD13_H               (0x0020)
#define HIGH_THRESHOLD14                 (0x4000)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD14_H               (0x0040)
#define HIGH_THRESHOLD15                 (0x8000)        /* When ADCDF = 0, Reset Value=0x3ff; When ADCDF = 1, Reset Value
                                                            = 0x1ff */
#define HIGH_THRESHOLD15_H               (0x0080)

/* ADCMCTL0 Control Bits */
#define ADCINCH                          (0x000f)        /* Input channel select */
#define ADCINCH_L                        (0x000f)
#define ADCINCH0                         (0x0001)        /* Input channel select */
#define ADCINCH0_L                       (0x0001)
#define ADCINCH1                         (0x0002)        /* Input channel select */
#define ADCINCH1_L                       (0x0002)
#define ADCINCH2                         (0x0004)        /* Input channel select */
#define ADCINCH2_L                       (0x0004)
#define ADCINCH3                         (0x0008)        /* Input channel select */
#define ADCINCH3_L                       (0x0008)
#define ADCINCH_0                        (0x0000)        /* A0 - see device-specific data sheet */
#define ADCINCH_1                        (0x0001)        /* A1 - see device-specific data sheet */
#define ADCINCH_1_L                      (0x0001)
#define ADCINCH_2                        (0x0002)        /* A2 - see device-specific data sheet */
#define ADCINCH_2_L                      (0x0002)
#define ADCINCH_3                        (0x0003)        /* A3 - see device-specific data sheet */
#define ADCINCH_3_L                      (0x0003)
#define ADCINCH_4                        (0x0004)        /* A4 - see device-specific data sheet */
#define ADCINCH_4_L                      (0x0004)
#define ADCINCH_5                        (0x0005)        /* A5 - see device-specific data sheet */
#define ADCINCH_5_L                      (0x0005)
#define ADCINCH_6                        (0x0006)        /* A2 - see device-specific data sheet */
#define ADCINCH_6_L                      (0x0006)
#define ADCINCH_7                        (0x0007)        /* A7 - see device-specific data sheet */
#define ADCINCH_7_L                      (0x0007)
#define ADCINCH_8                        (0x0008)        /* A8 - see device-specific data sheet */
#define ADCINCH_8_L                      (0x0008)
#define ADCINCH_9                        (0x0009)        /* A9 - see device-specific data sheet */
#define ADCINCH_9_L                      (0x0009)
#define ADCINCH_10                       (0x000a)        /* A10 - see device-specific data sheet */
#define ADCINCH_10_L                     (0x000a)
#define ADCINCH_11                       (0x000b)        /* A11 - see device-specific data sheet */
#define ADCINCH_11_L                     (0x000b)
#define ADCINCH_12                       (0x000c)        /* A12 - see device-specific data sheet */
#define ADCINCH_12_L                     (0x000c)
#define ADCINCH_13                       (0x000d)        /* A13 - see device-specific data sheet */
#define ADCINCH_13_L                     (0x000d)
#define ADCINCH_14                       (0x000e)        /* A14 - see device-specific data sheet */
#define ADCINCH_14_L                     (0x000e)
#define ADCINCH_15                       (0x000f)        /* A15 - see device-specific data sheet */
#define ADCINCH_15_L                     (0x000f)
#define ADCSREF                          (0x0070)        /* */
#define ADCSREF_L                        (0x0070)
#define ADCSREF0                         (0x0010)        /* */
#define ADCSREF0_L                       (0x0010)
#define ADCSREF1                         (0x0020)        /* */
#define ADCSREF1_L                       (0x0020)
#define ADCSREF2                         (0x0040)        /* */
#define ADCSREF2_L                       (0x0040)
#define ADCSREF_0                        (0x0000)        /* 000b = V(R+) = AVCC and V(R-) = AVSS */
#define ADCSREF_1                        (0x0010)        /* 001b = V(R+) = VREF and V(R-) = AVSS */
#define ADCSREF_1_L                      (0x0010)
#define ADCSREF_2                        (0x0020)        /* 010b = V(R+) = VEREF+ buffered and V(R-) = AVSS */
#define ADCSREF_2_L                      (0x0020)
#define ADCSREF_3                        (0x0030)        /* 011b =V(R+) = VEREF+ and V(R-) = AVSS */
#define ADCSREF_3_L                      (0x0030)
#define ADCSREF_4                        (0x0040)        /* 100b = V(R+) = AVCC and V(R-) = VEREF- */
#define ADCSREF_4_L                      (0x0040)
#define ADCSREF_5                        (0x0050)        /* 101b = V(R+) = VREF and V(R-) = VEREF- */
#define ADCSREF_5_L                      (0x0050)
#define ADCSREF_6                        (0x0060)        /* 110b = V(R+) = VEREF+ buffered and V(R-) = VEREF- */
#define ADCSREF_6_L                      (0x0060)
#define ADCSREF_7                        (0x0070)        /* 111b = V(R+) = VEREF+ and V(R-) = VEREF- */
#define ADCSREF_7_L                      (0x0070)
#define EXPCHEN                          (0x0100)        /* */
#define EXPCHEN_H                        (0x0001)
#define EXPCHEN_0                        (0x0000)        /* ADC channel expanded disable */
#define EXPCHEN_1                        (0x0100)        /* ADC channel expanded enable */
#define EXPCHEN_1_H                      (0x0001)

/* ADCMEM0 Control Bits */
#define CONVERSION_RESULTS               (0xffff)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS_L             (0x00ff)
#define CONVERSION_RESULTS_H             (0x00ff)
#define CONVERSION_RESULTS0              (0x0001)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS0_L            (0x0001)
#define CONVERSION_RESULTS1              (0x0002)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS1_L            (0x0002)
#define CONVERSION_RESULTS2              (0x0004)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS2_L            (0x0004)
#define CONVERSION_RESULTS3              (0x0008)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS3_L            (0x0008)
#define CONVERSION_RESULTS4              (0x0010)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS4_L            (0x0010)
#define CONVERSION_RESULTS5              (0x0020)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS5_L            (0x0020)
#define CONVERSION_RESULTS6              (0x0040)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS6_L            (0x0040)
#define CONVERSION_RESULTS7              (0x0080)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS7_L            (0x0080)
#define CONVERSION_RESULTS8              (0x0100)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS8_H            (0x0001)
#define CONVERSION_RESULTS9              (0x0200)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS9_H            (0x0002)
#define CONVERSION_RESULTS10             (0x0400)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS10_H           (0x0004)
#define CONVERSION_RESULTS11             (0x0800)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS11_H           (0x0008)
#define CONVERSION_RESULTS12             (0x1000)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS12_H           (0x0010)
#define CONVERSION_RESULTS13             (0x2000)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS13_H           (0x0020)
#define CONVERSION_RESULTS14             (0x4000)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS14_H           (0x0040)
#define CONVERSION_RESULTS15             (0x8000)        /* Conversion Results/Reset Value is undefined */
#define CONVERSION_RESULTS15_H           (0x0080)

/* ADCIE Control Bits */
#define ADCIE0                           (0x0001)        /* */
#define ADCIE0_L                         (0x0001)
#define ADCIE0_0                         (0x0000)        /* 0b = Interrupt disabled */
#define ADCIE0_1                         (0x0001)        /* 1b = Interrupt enabled */
#define ADCIE0_1_L                       (0x0001)
#define ADCINIE                          (0x0002)        /* */
#define ADCINIE_L                        (0x0002)
#define ADCINIE_0                        (0x0000)        /* 0b = Inside of window interrupt disabled */
#define ADCINIE_1                        (0x0002)        /* 1b = Inside of window interrupt enabled */
#define ADCINIE_1_L                      (0x0002)
#define ADCLOIE                          (0x0004)        /* */
#define ADCLOIE_L                        (0x0004)
#define ADCLOIE_0                        (0x0000)        /* 0b = Below lower threshold interrupt disabled */
#define ADCLOIE_1                        (0x0004)        /* 1b = Below lower threshold interrupt enabled */
#define ADCLOIE_1_L                      (0x0004)
#define ADCHIIE                          (0x0008)        /* */
#define ADCHIIE_L                        (0x0008)
#define ADCHIIE_0                        (0x0000)        /* 0b = Above upper threshold interrupt disabled */
#define ADCHIIE_1                        (0x0008)        /* 1b = Above upper threshold interrupt enabled */
#define ADCHIIE_1_L                      (0x0008)
#define ADCOVIE                          (0x0010)        /* */
#define ADCOVIE_L                        (0x0010)
#define ADCOVIE_0                        (0x0000)        /* 0b = Overflow interrupt disabled */
#define ADCOVIE_1                        (0x0010)        /* 1b = Overflow interrupt enabled */
#define ADCOVIE_1_L                      (0x0010)
#define ADCTOVIE                         (0x0020)        /* */
#define ADCTOVIE_L                       (0x0020)
#define ADCTOVIE_0                       (0x0000)        /* 0b = Conversion time overflow interrupt disabled */
#define ADCTOVIE_1                       (0x0020)        /* 1b = Conversion time overflow interrupt enabled */
#define ADCTOVIE_1_L                     (0x0020)

/* ADCIFG Control Bits */
#define ADCIFG0                          (0x0001)        /* ADCMEM0 interrupt flag */
#define ADCIFG0_L                        (0x0001)
#define ADCIFG0_0                        (0x0000)        /* No interrupt pending */
#define ADCIFG0_1                        (0x0001)        /* Interrupt pending */
#define ADCIFG0_1_L                      (0x0001)
#define ADCINIFG                         (0x0002)        /* */
#define ADCINIFG_L                       (0x0002)
#define ADCINIFG_0                       (0x0000)        /* No interrupt pending */
#define ADCINIFG_1                       (0x0002)        /* Interrupt pending */
#define ADCINIFG_1_L                     (0x0002)
#define ADCLOIFG                         (0x0004)        /* */
#define ADCLOIFG_L                       (0x0004)
#define ADCLOIFG_0                       (0x0000)        /* No interrupt pending */
#define ADCLOIFG_1                       (0x0004)        /* Interrupt pending */
#define ADCLOIFG_1_L                     (0x0004)
#define ADCHIIFG                         (0x0008)        /* */
#define ADCHIIFG_L                       (0x0008)
#define ADCHIIFG_0                       (0x0000)        /* No interrupt pending */
#define ADCHIIFG_1                       (0x0008)        /* Interrupt pending */
#define ADCHIIFG_1_L                     (0x0008)
#define ADCOVIFG                         (0x0010)        /* */
#define ADCOVIFG_L                       (0x0010)
#define ADCOVIFG_0                       (0x0000)        /* No interrupt pending */
#define ADCOVIFG_1                       (0x0010)        /* Interrupt pending */
#define ADCOVIFG_1_L                     (0x0010)
#define ADCTOVIFG                        (0x0020)        /* */
#define ADCTOVIFG_L                      (0x0020)
#define ADCTOVIFG_1                      (0x0020)        /* Interrupt pending */
#define ADCTOVIFG_1_L                    (0x0020)

/* ADCIV Control Bits */
#define ADCIV0                           (0x0001)        /* interrupt vector value */
#define ADCIV0_L                         (0x0001)
#define ADCIV1                           (0x0002)        /* interrupt vector value */
#define ADCIV1_L                         (0x0002)
#define ADCIV2                           (0x0004)        /* interrupt vector value */
#define ADCIV2_L                         (0x0004)
#define ADCIV3                           (0x0008)        /* interrupt vector value */
#define ADCIV3_L                         (0x0008)
#define ADCIV4                           (0x0010)        /* interrupt vector value */
#define ADCIV4_L                         (0x0010)
#define ADCIV5                           (0x0020)        /* interrupt vector value */
#define ADCIV5_L                         (0x0020)
#define ADCIV6                           (0x0040)        /* interrupt vector value */
#define ADCIV6_L                         (0x0040)
#define ADCIV7                           (0x0080)        /* interrupt vector value */
#define ADCIV7_L                         (0x0080)
#define ADCIV8                           (0x0100)        /* interrupt vector value */
#define ADCIV8_H                         (0x0001)
#define ADCIV9                           (0x0200)        /* interrupt vector value */
#define ADCIV9_H                         (0x0002)
#define ADCIV10                          (0x0400)        /* interrupt vector value */
#define ADCIV10_H                        (0x0004)
#define ADCIV11                          (0x0800)        /* interrupt vector value */
#define ADCIV11_H                        (0x0008)
#define ADCIV12                          (0x1000)        /* interrupt vector value */
#define ADCIV12_H                        (0x0010)
#define ADCIV13                          (0x2000)        /* interrupt vector value */
#define ADCIV13_H                        (0x0020)
#define ADCIV14                          (0x4000)        /* interrupt vector value */
#define ADCIV14_H                        (0x0040)
#define ADCIV15                          (0x8000)        /* interrupt vector value */
#define ADCIV15_H                        (0x0080)
#define ADCIV_0                          (0x0000)        /* No interrupt pending */
#define ADCIV_2                          (0x0002)        /* Interrupt Source: ADCMEM0 overflow; Interrupt Flag: ADCOVIFG; 
                                                            Interrupt Priority: Highest */
#define ADCIV_2_L                        (0x0002)
#define ADCIV_4                          (0x0004)        /* Interrupt Source: Conversion time overflow; Interrupt Flag: 
                                                            ADCTOVIFG */
#define ADCIV_4_L                        (0x0004)
#define ADCIV_6                          (0x0006)        /* Interrupt Source: ADCHI Interrupt flag; Interrupt Flag: 
                                                            ADCHIIFG */
#define ADCIV_6_L                        (0x0006)
#define ADCIV_8                          (0x0008)        /* Interrupt Source: ADCLO Interrupt flag; Interrupt Flag: 
                                                            ADCLOIFG */
#define ADCIV_8_L                        (0x0008)
#define ADCIV_10                         (0x000a)        /* nterrupt Source: ADCIN Interrupt flag; Interrupt Flag: 
                                                            ADCINIFG */
#define ADCIV_10_L                       (0x000a)
#define ADCIV_12                         (0x000c)        /* Interrupt Source: ADC memory Interrupt flag; Interrupt Flag: 
                                                            ADCIFG0; Interrupt Priority: Lowest */
#define ADCIV_12_L                       (0x000c)
#define ADCIV__NONE                      (0x0000)        /* No interrupt pending */
#define ADCIV__ADCOVIFG                  (0x0002)        /* Interrupt Source: ADCMEM0 overflow; Interrupt Flag: ADCOVIFG; 
                                                            Interrupt Priority: Highest */
#define ADCIV__ADCOVIFG_L                (0x0002)
#define ADCIV__ADCTOVIFG                 (0x0004)        /* Interrupt Source: Conversion time overflow; Interrupt Flag: 
                                                            ADCTOVIFG */
#define ADCIV__ADCTOVIFG_L               (0x0004)
#define ADCIV__ADCHIIFG                  (0x0006)        /* Interrupt Source: ADCHI Interrupt flag; Interrupt Flag: 
                                                            ADCHIIFG */
#define ADCIV__ADCHIIFG_L                (0x0006)
#define ADCIV__ADCLOIFG                  (0x0008)        /* Interrupt Source: ADCLO Interrupt flag; Interrupt Flag: 
                                                            ADCLOIFG */
#define ADCIV__ADCLOIFG_L                (0x0008)
#define ADCIV__ADCINIFG                  (0x000a)        /* nterrupt Source: ADCIN Interrupt flag; Interrupt Flag: 
                                                            ADCINIFG */
#define ADCIV__ADCINIFG_L                (0x000a)
#define ADCIV__ADCIFG0                   (0x000c)        /* Interrupt Source: ADC memory Interrupt flag; Interrupt Flag: 
                                                            ADCIFG0; Interrupt Priority: Lowest */
#define ADCIV__ADCIFG0_L                 (0x000c)


/*****************************************************************************
 BKMEM Registers
*****************************************************************************/

#define __MSP430_HAS_BKMEM__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_BKMEM__ 0x0660
#define BKMEM_BASE             __MSP430_BASEADDRESS_BKMEM__

sfr_w(BAKMEM0);                               /* Backup Memory registers. Backup Memory 0. */
sfr_b(BAKMEM0_L);
sfr_b(BAKMEM0_H);
sfr_w(BAKMEM1);                               /* Backup Memory 1. */
sfr_b(BAKMEM1_L);
sfr_b(BAKMEM1_H);
sfr_w(BAKMEM2);                               /* Backup Memory 2. */
sfr_b(BAKMEM2_L);
sfr_b(BAKMEM2_H);
sfr_w(BAKMEM3);                               /* Backup Memory 3. */
sfr_b(BAKMEM3_L);
sfr_b(BAKMEM3_H);
sfr_w(BAKMEM4);                               /* Backup Memory 4. */
sfr_b(BAKMEM4_L);
sfr_b(BAKMEM4_H);
sfr_w(BAKMEM5);                               /* Backup Memory 5. */
sfr_b(BAKMEM5_L);
sfr_b(BAKMEM5_H);
sfr_w(BAKMEM6);                               /* Backup Memory 6. */
sfr_b(BAKMEM6_L);
sfr_b(BAKMEM6_H);
sfr_w(BAKMEM7);                               /* Backup Memory 7. */
sfr_b(BAKMEM7_L);
sfr_b(BAKMEM7_H);
sfr_w(BAKMEM8);                               /* Backup Memory 8. */
sfr_b(BAKMEM8_L);
sfr_b(BAKMEM8_H);
sfr_w(BAKMEM9);                               /* Backup Memory 9. */
sfr_b(BAKMEM9_L);
sfr_b(BAKMEM9_H);
sfr_w(BAKMEM10);                              /* Backup Memory registers. Backup Memory 10. */
sfr_b(BAKMEM10_L);
sfr_b(BAKMEM10_H);
sfr_w(BAKMEM11);                              /* Backup Memory 11. */
sfr_b(BAKMEM11_L);
sfr_b(BAKMEM11_H);
sfr_w(BAKMEM12);                              /* Backup Memory 12. */
sfr_b(BAKMEM12_L);
sfr_b(BAKMEM12_H);
sfr_w(BAKMEM13);                              /* Backup Memory 13. */
sfr_b(BAKMEM13_L);
sfr_b(BAKMEM13_H);
sfr_w(BAKMEM14);                              /* Backup Memory 14. */
sfr_b(BAKMEM14_L);
sfr_b(BAKMEM14_H);
sfr_w(BAKMEM15);                              /* Backup Memory 15. */
sfr_b(BAKMEM15_L);
sfr_b(BAKMEM15_H);

/* BKMEM Register Offsets */
#define OFS_BAKMEM0                      (0x0000)
#define OFS_BAKMEM0_L                    OFS_BAKMEM0
#define OFS_BAKMEM0_H                    OFS_BAKMEM0+1
#define OFS_BAKMEM1                      (0x0002)
#define OFS_BAKMEM1_L                    OFS_BAKMEM1
#define OFS_BAKMEM1_H                    OFS_BAKMEM1+1
#define OFS_BAKMEM2                      (0x0004)
#define OFS_BAKMEM2_L                    OFS_BAKMEM2
#define OFS_BAKMEM2_H                    OFS_BAKMEM2+1
#define OFS_BAKMEM3                      (0x0006)
#define OFS_BAKMEM3_L                    OFS_BAKMEM3
#define OFS_BAKMEM3_H                    OFS_BAKMEM3+1
#define OFS_BAKMEM4                      (0x0008)
#define OFS_BAKMEM4_L                    OFS_BAKMEM4
#define OFS_BAKMEM4_H                    OFS_BAKMEM4+1
#define OFS_BAKMEM5                      (0x000A)
#define OFS_BAKMEM5_L                    OFS_BAKMEM5
#define OFS_BAKMEM5_H                    OFS_BAKMEM5+1
#define OFS_BAKMEM6                      (0x000C)
#define OFS_BAKMEM6_L                    OFS_BAKMEM6
#define OFS_BAKMEM6_H                    OFS_BAKMEM6+1
#define OFS_BAKMEM7                      (0x000E)
#define OFS_BAKMEM7_L                    OFS_BAKMEM7
#define OFS_BAKMEM7_H                    OFS_BAKMEM7+1
#define OFS_BAKMEM8                      (0x0010)
#define OFS_BAKMEM8_L                    OFS_BAKMEM8
#define OFS_BAKMEM8_H                    OFS_BAKMEM8+1
#define OFS_BAKMEM9                      (0x0012)
#define OFS_BAKMEM9_L                    OFS_BAKMEM9
#define OFS_BAKMEM9_H                    OFS_BAKMEM9+1
#define OFS_BAKMEM10                     (0x0014)
#define OFS_BAKMEM10_L                   OFS_BAKMEM10
#define OFS_BAKMEM10_H                   OFS_BAKMEM10+1
#define OFS_BAKMEM11                     (0x0016)
#define OFS_BAKMEM11_L                   OFS_BAKMEM11
#define OFS_BAKMEM11_H                   OFS_BAKMEM11+1
#define OFS_BAKMEM12                     (0x0018)
#define OFS_BAKMEM12_L                   OFS_BAKMEM12
#define OFS_BAKMEM12_H                   OFS_BAKMEM12+1
#define OFS_BAKMEM13                     (0x001A)
#define OFS_BAKMEM13_L                   OFS_BAKMEM13
#define OFS_BAKMEM13_H                   OFS_BAKMEM13+1
#define OFS_BAKMEM14                     (0x001C)
#define OFS_BAKMEM14_L                   OFS_BAKMEM14
#define OFS_BAKMEM14_H                   OFS_BAKMEM14+1
#define OFS_BAKMEM15                     (0x001E)
#define OFS_BAKMEM15_L                   OFS_BAKMEM15
#define OFS_BAKMEM15_H                   OFS_BAKMEM15+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 CAPTIO Registers
*****************************************************************************/

#define __MSP430_HAS_CAPTIO__                 /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CAPTIO__ 0x02E0
#define CAPTIO_BASE            __MSP430_BASEADDRESS_CAPTIO__

sfr_w(CAPTIOCTL);                             /* Capacitive Touch IO x Control Register */
sfr_b(CAPTIOCTL_L);
sfr_b(CAPTIOCTL_H);

/* CAPTIO Register Offsets */
#define OFS_CAPTIOCTL                    (0x000E)
#define OFS_CAPTIOCTL_L                  OFS_CAPTIOCTL
#define OFS_CAPTIOCTL_H                  OFS_CAPTIOCTL+1

/* CAPTIO Control Bits */

/* CAPTIOCTL Control Bits */
#define CAPTIOPISEL0                     (0x0002)        /* CAPTIOPISEL Bit 0 */
#define CAPTIOPISEL0_L                   (0x0002)
#define CAPTIOPISEL1                     (0x0004)        /* CAPTIOPISEL Bit 1 */
#define CAPTIOPISEL1_L                   (0x0004)
#define CAPTIOPISEL2                     (0x0008)        /* CAPTIOPISEL Bit 2 */
#define CAPTIOPISEL2_L                   (0x0008)
#define CAPTIOPISEL                      (0x000e)        /* Capacitive Touch IO pin select */
#define CAPTIOPISEL_L                    (0x000e)
#define CAPTIOPISEL_0                    (0x0000)        /* Px.0 */
#define CAPTIOPISEL_1                    (0x0002)        /* Px.1 */
#define CAPTIOPISEL_1_L                  (0x0002)
#define CAPTIOPISEL_2                    (0x0004)        /* Px.2 */
#define CAPTIOPISEL_2_L                  (0x0004)
#define CAPTIOPISEL_3                    (0x0006)        /* Px.3 */
#define CAPTIOPISEL_3_L                  (0x0006)
#define CAPTIOPISEL_4                    (0x0008)        /* Px.4 */
#define CAPTIOPISEL_4_L                  (0x0008)
#define CAPTIOPISEL_5                    (0x000a)        /* Px.5 */
#define CAPTIOPISEL_5_L                  (0x000a)
#define CAPTIOPISEL_6                    (0x000c)        /* Px.6 */
#define CAPTIOPISEL_6_L                  (0x000c)
#define CAPTIOPISEL_7                    (0x000e)        /* Px.7 */
#define CAPTIOPISEL_7_L                  (0x000e)
#define CAPTIOPOSEL0                     (0x0010)        /* CAPTIOPOSEL Bit 0 */
#define CAPTIOPOSEL0_L                   (0x0010)
#define CAPTIOPOSEL1                     (0x0020)        /* CAPTIOPOSEL Bit 1 */
#define CAPTIOPOSEL1_L                   (0x0020)
#define CAPTIOPOSEL2                     (0x0040)        /* CAPTIOPOSEL Bit 2 */
#define CAPTIOPOSEL2_L                   (0x0040)
#define CAPTIOPOSEL3                     (0x0080)        /* CAPTIOPOSEL Bit 3 */
#define CAPTIOPOSEL3_L                   (0x0080)
#define CAPTIOPOSEL                      (0x00f0)        /* Capacitive Touch IO port select */
#define CAPTIOPOSEL_L                    (0x00f0)
#define CAPTIOPOSEL_0                    (0x0000)        /* Px = PJ */
#define CAPTIOPOSEL_1                    (0x0010)        /* Px = P1 */
#define CAPTIOPOSEL_1_L                  (0x0010)
#define CAPTIOPOSEL_2                    (0x0020)        /* Px = P2 */
#define CAPTIOPOSEL_2_L                  (0x0020)
#define CAPTIOPOSEL_3                    (0x0030)        /* Px = P3 */
#define CAPTIOPOSEL_3_L                  (0x0030)
#define CAPTIOPOSEL_4                    (0x0040)        /* Px = P4 */
#define CAPTIOPOSEL_4_L                  (0x0040)
#define CAPTIOPOSEL_5                    (0x0050)        /* Px = P5 */
#define CAPTIOPOSEL_5_L                  (0x0050)
#define CAPTIOPOSEL_6                    (0x0060)        /* Px = P6 */
#define CAPTIOPOSEL_6_L                  (0x0060)
#define CAPTIOPOSEL_7                    (0x0070)        /* Px = P7 */
#define CAPTIOPOSEL_7_L                  (0x0070)
#define CAPTIOPOSEL_8                    (0x0080)        /* Px = P8 */
#define CAPTIOPOSEL_8_L                  (0x0080)
#define CAPTIOPOSEL_9                    (0x0090)        /* Px = P9 */
#define CAPTIOPOSEL_9_L                  (0x0090)
#define CAPTIOPOSEL_10                   (0x00a0)        /* Px = P10 */
#define CAPTIOPOSEL_10_L                 (0x00a0)
#define CAPTIOPOSEL_11                   (0x00b0)        /* Px = P11 */
#define CAPTIOPOSEL_11_L                 (0x00b0)
#define CAPTIOPOSEL_12                   (0x00c0)        /* Px = P12 */
#define CAPTIOPOSEL_12_L                 (0x00c0)
#define CAPTIOPOSEL_13                   (0x00d0)        /* Px = P13 */
#define CAPTIOPOSEL_13_L                 (0x00d0)
#define CAPTIOPOSEL_14                   (0x00e0)        /* Px = P14 */
#define CAPTIOPOSEL_14_L                 (0x00e0)
#define CAPTIOPOSEL_15                   (0x00f0)        /* Px = P15 */
#define CAPTIOPOSEL_15_L                 (0x00f0)
#define CAPTIOPOSEL__PJ                  (0x0000)        /* Px = PJ */
#define CAPTIOPOSEL__P1                  (0x0010)        /* Px = P1 */
#define CAPTIOPOSEL__P1_L                (0x0010)
#define CAPTIOPOSEL__P2                  (0x0020)        /* Px = P2 */
#define CAPTIOPOSEL__P2_L                (0x0020)
#define CAPTIOPOSEL__P3                  (0x0030)        /* Px = P3 */
#define CAPTIOPOSEL__P3_L                (0x0030)
#define CAPTIOPOSEL__P4                  (0x0040)        /* Px = P4 */
#define CAPTIOPOSEL__P4_L                (0x0040)
#define CAPTIOPOSEL__P5                  (0x0050)        /* Px = P5 */
#define CAPTIOPOSEL__P5_L                (0x0050)
#define CAPTIOPOSEL__P6                  (0x0060)        /* Px = P6 */
#define CAPTIOPOSEL__P6_L                (0x0060)
#define CAPTIOPOSEL__P7                  (0x0070)        /* Px = P7 */
#define CAPTIOPOSEL__P7_L                (0x0070)
#define CAPTIOPOSEL__P8                  (0x0080)        /* Px = P8 */
#define CAPTIOPOSEL__P8_L                (0x0080)
#define CAPTIOPOSEL__P9                  (0x0090)        /* Px = P9 */
#define CAPTIOPOSEL__P9_L                (0x0090)
#define CAPTIOPOSEL__P10                 (0x00a0)        /* Px = P10 */
#define CAPTIOPOSEL__P10_L               (0x00a0)
#define CAPTIOPOSEL__P11                 (0x00b0)        /* Px = P11 */
#define CAPTIOPOSEL__P11_L               (0x00b0)
#define CAPTIOPOSEL__P12                 (0x00c0)        /* Px = P12 */
#define CAPTIOPOSEL__P12_L               (0x00c0)
#define CAPTIOPOSEL__P13                 (0x00d0)        /* Px = P13 */
#define CAPTIOPOSEL__P13_L               (0x00d0)
#define CAPTIOPOSEL__P14                 (0x00e0)        /* Px = P14 */
#define CAPTIOPOSEL__P14_L               (0x00e0)
#define CAPTIOPOSEL__P15                 (0x00f0)        /* Px = P15 */
#define CAPTIOPOSEL__P15_L               (0x00f0)
#define CAPTIOEN                         (0x0100)        /* Capacitive Touch IO enable */
#define CAPTIOEN_H                       (0x0001)
#define CAPTIOEN_0                       (0x0000)        /* All Capacitive Touch IOs are disabled. Signal towards timers 
                                                            is 0. */
#define CAPTIOEN_1                       (0x0100)        /* Selected Capacitive Touch IO is enabled */
#define CAPTIOEN_1_H                     (0x0001)
#define CAPTIOEN__OFF                    (0x0000)        /* All Capacitive Touch IOs are disabled. Signal towards timers 
                                                            is 0. */
#define CAPTIOEN__ON                     (0x0100)        /* Selected Capacitive Touch IO is enabled */
#define CAPTIOEN__ON_H                   (0x0001)
#define CAPTIO                           (0x0200)        /* Capacitive Touch IO state */
#define CAPTIO_H                         (0x0002)
#define CAPTIO_0                         (0x0000)        /* Curent state 0 or Capacitive Touch IO is disabled */
#define CAPTIO_1                         (0x0200)        /* Current state 1 */
#define CAPTIO_1_H                       (0x0002)


/*****************************************************************************
 CRC Registers
*****************************************************************************/

#define __MSP430_HAS_CRC__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CRC__ 0x01C0
#define CRC_BASE               __MSP430_BASEADDRESS_CRC__

sfr_w(CRCDI);                                 /* CRC Data In */
sfr_b(CRCDI_L);
sfr_b(CRCDI_H);
sfr_w(CRCDIRB);                               /* CRC Data In Reverse Byte */
sfr_b(CRCDIRB_L);
sfr_b(CRCDIRB_H);
sfr_w(CRCINIRES);                             /* CRC Initialization and Result */
sfr_b(CRCINIRES_L);
sfr_b(CRCINIRES_H);
sfr_w(CRCRESR);                               /* CRC Result Reverse */
sfr_b(CRCRESR_L);
sfr_b(CRCRESR_H);

/* CRC Register Offsets */
#define OFS_CRCDI                        (0x0000)
#define OFS_CRCDI_L                      OFS_CRCDI
#define OFS_CRCDI_H                      OFS_CRCDI+1
#define OFS_CRCDIRB                      (0x0002)
#define OFS_CRCDIRB_L                    OFS_CRCDIRB
#define OFS_CRCDIRB_H                    OFS_CRCDIRB+1
#define OFS_CRCINIRES                    (0x0004)
#define OFS_CRCINIRES_L                  OFS_CRCINIRES
#define OFS_CRCINIRES_H                  OFS_CRCINIRES+1
#define OFS_CRCRESR                      (0x0006)
#define OFS_CRCRESR_L                    OFS_CRCRESR
#define OFS_CRCRESR_H                    OFS_CRCRESR+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 CS Registers
*****************************************************************************/

#define __MSP430_HAS_CS__                     /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CS__ 0x0180
#define CS_BASE                __MSP430_BASEADDRESS_CS__

sfr_w(CSCTL0);                                /* Clock System Control 0 */
sfr_b(CSCTL0_L);
sfr_b(CSCTL0_H);
sfr_w(CSCTL1);                                /* Clock System Control 1 */
sfr_b(CSCTL1_L);
sfr_b(CSCTL1_H);
sfr_w(CSCTL2);                                /* Clock System Control 2 */
sfr_b(CSCTL2_L);
sfr_b(CSCTL2_H);
sfr_w(CSCTL3);                                /* Clock System Control 3 */
sfr_b(CSCTL3_L);
sfr_b(CSCTL3_H);
sfr_w(CSCTL4);                                /* Clock System Control 4 */
sfr_b(CSCTL4_L);
sfr_b(CSCTL4_H);
sfr_w(CSCTL5);                                /* Clock System Control 5 */
sfr_b(CSCTL5_L);
sfr_b(CSCTL5_H);
sfr_w(CSCTL6);                                /* Clock System Control 6 */
sfr_b(CSCTL6_L);
sfr_b(CSCTL6_H);
sfr_w(CSCTL7);                                /* Clock System Control Register 7 */
sfr_b(CSCTL7_L);
sfr_b(CSCTL7_H);
sfr_w(CSCTL8);                                /* Clock System Control Register 8 */
sfr_b(CSCTL8_L);
sfr_b(CSCTL8_H);

/* CS Register Offsets */
#define OFS_CSCTL0                       (0x0000)
#define OFS_CSCTL0_L                     OFS_CSCTL0
#define OFS_CSCTL0_H                     OFS_CSCTL0+1
#define OFS_CSCTL1                       (0x0002)
#define OFS_CSCTL1_L                     OFS_CSCTL1
#define OFS_CSCTL1_H                     OFS_CSCTL1+1
#define OFS_CSCTL2                       (0x0004)
#define OFS_CSCTL2_L                     OFS_CSCTL2
#define OFS_CSCTL2_H                     OFS_CSCTL2+1
#define OFS_CSCTL3                       (0x0006)
#define OFS_CSCTL3_L                     OFS_CSCTL3
#define OFS_CSCTL3_H                     OFS_CSCTL3+1
#define OFS_CSCTL4                       (0x0008)
#define OFS_CSCTL4_L                     OFS_CSCTL4
#define OFS_CSCTL4_H                     OFS_CSCTL4+1
#define OFS_CSCTL5                       (0x000A)
#define OFS_CSCTL5_L                     OFS_CSCTL5
#define OFS_CSCTL5_H                     OFS_CSCTL5+1
#define OFS_CSCTL6                       (0x000C)
#define OFS_CSCTL6_L                     OFS_CSCTL6
#define OFS_CSCTL6_H                     OFS_CSCTL6+1
#define OFS_CSCTL7                       (0x000E)
#define OFS_CSCTL7_L                     OFS_CSCTL7
#define OFS_CSCTL7_H                     OFS_CSCTL7+1
#define OFS_CSCTL8                       (0x0010)
#define OFS_CSCTL8_L                     OFS_CSCTL8
#define OFS_CSCTL8_H                     OFS_CSCTL8+1

/* CS Control Bits */

/* CSCTL0 Control Bits */
#define DCO                              (0x01ff)        /* */
#define DCO_L                            (0x00ff)
#define DCO_H                            (0x0001)
#define DCO0                             (0x0001)        /* */
#define DCO0_L                           (0x0001)
#define DCO1                             (0x0002)        /* */
#define DCO1_L                           (0x0002)
#define DCO2                             (0x0004)        /* */
#define DCO2_L                           (0x0004)
#define DCO3                             (0x0008)        /* */
#define DCO3_L                           (0x0008)
#define DCO4                             (0x0010)        /* */
#define DCO4_L                           (0x0010)
#define DCO5                             (0x0020)        /* */
#define DCO5_L                           (0x0020)
#define DCO6                             (0x0040)        /* */
#define DCO6_L                           (0x0040)
#define DCO7                             (0x0080)        /* */
#define DCO7_L                           (0x0080)
#define DCO8                             (0x0100)        /* */
#define DCO8_H                           (0x0001)
#define MOD                              (0x3e00)        /* */
#define MOD_H                            (0x003e)
#define MOD0                             (0x0200)        /* */
#define MOD0_H                           (0x0002)
#define MOD1                             (0x0400)        /* */
#define MOD1_H                           (0x0004)
#define MOD2                             (0x0800)        /* */
#define MOD2_H                           (0x0008)
#define MOD3                             (0x1000)        /* */
#define MOD3_H                           (0x0010)
#define MOD4                             (0x2000)        /* */
#define MOD4_H                           (0x0020)

/* CSCTL1 Control Bits */
#define DISMOD                           (0x0001)        /* */
#define DISMOD_L                         (0x0001)
#define DISMOD_0                         (0x0000)        /* Modulation enabled */
#define DISMOD_1                         (0x0001)        /* Modulation disabled */
#define DISMOD_1_L                       (0x0001)
#define DCORSEL                          (0x000e)        /* */
#define DCORSEL_L                        (0x000e)
#define DCORSEL0                         (0x0002)        /* */
#define DCORSEL0_L                       (0x0002)
#define DCORSEL1                         (0x0004)        /* */
#define DCORSEL1_L                       (0x0004)
#define DCORSEL2                         (0x0008)        /* */
#define DCORSEL2_L                       (0x0008)
#define DCORSEL_0                        (0x0000)        /* 1 MHz */
#define DCORSEL_1                        (0x0002)        /* 2 MHz */
#define DCORSEL_1_L                      (0x0002)
#define DCORSEL_2                        (0x0004)        /* 4 MHz */
#define DCORSEL_2_L                      (0x0004)
#define DCORSEL_3                        (0x0006)        /* 8 MHz */
#define DCORSEL_3_L                      (0x0006)
#define DCORSEL_4                        (0x0008)        /* 12 MHz */
#define DCORSEL_4_L                      (0x0008)
#define DCORSEL_5                        (0x000a)        /* 16 MHz */
#define DCORSEL_5_L                      (0x000a)
#define DCORSEL_6                        (0x000c)        /* Reserved */
#define DCORSEL_6_L                      (0x000c)
#define DCORSEL_7                        (0x000e)        /* Reserved */
#define DCORSEL_7_L                      (0x000e)
#define DCOFTRIM                         (0x0070)        /* */
#define DCOFTRIM_L                       (0x0070)
#define DCOFTRIM0                        (0x0010)        /* */
#define DCOFTRIM0_L                      (0x0010)
#define DCOFTRIM1                        (0x0020)        /* */
#define DCOFTRIM1_L                      (0x0020)
#define DCOFTRIM2                        (0x0040)        /* */
#define DCOFTRIM2_L                      (0x0040)
#define DCOFTRIMEN                       (0x0080)        /* */
#define DCOFTRIMEN_L                     (0x0080)
#define DCOFTRIMEN_0                     (0x0000)        /* Disable frequency trim */
#define DCOFTRIMEN_1                     (0x0080)        /* Enable frequency trim */
#define DCOFTRIMEN_1_L                   (0x0080)

/* CSCTL2 Control Bits */
#define FLLN                             (0x03ff)        /* */
#define FLLN_L                           (0x00ff)
#define FLLN_H                           (0x0003)
#define FLLN0                            (0x0001)        /* */
#define FLLN0_L                          (0x0001)
#define FLLN1                            (0x0002)        /* */
#define FLLN1_L                          (0x0002)
#define FLLN2                            (0x0004)        /* */
#define FLLN2_L                          (0x0004)
#define FLLN3                            (0x0008)        /* */
#define FLLN3_L                          (0x0008)
#define FLLN4                            (0x0010)        /* */
#define FLLN4_L                          (0x0010)
#define FLLN5                            (0x0020)        /* */
#define FLLN5_L                          (0x0020)
#define FLLN6                            (0x0040)        /* */
#define FLLN6_L                          (0x0040)
#define FLLN7                            (0x0080)        /* */
#define FLLN7_L                          (0x0080)
#define FLLN8                            (0x0100)        /* */
#define FLLN8_H                          (0x0001)
#define FLLN9                            (0x0200)        /* */
#define FLLN9_H                          (0x0002)
#define FLLD                             (0x7000)        /* */
#define FLLD_H                           (0x0070)
#define FLLD0                            (0x1000)        /* */
#define FLLD0_H                          (0x0010)
#define FLLD1                            (0x2000)        /* */
#define FLLD1_H                          (0x0020)
#define FLLD2                            (0x4000)        /* */
#define FLLD2_H                          (0x0040)
#define FLLD_0                           (0x0000)        /* fDCOCLK / 1 */
#define FLLD_1                           (0x1000)        /* fDCOCLK / 2 */
#define FLLD_1_H                         (0x0010)
#define FLLD_2                           (0x2000)        /* fDCOCLK / 4 */
#define FLLD_2_H                         (0x0020)
#define FLLD_3                           (0x3000)        /* fDCOCLK / 8 */
#define FLLD_3_H                         (0x0030)
#define FLLD_4                           (0x4000)        /* fDCOCLK / 16 */
#define FLLD_4_H                         (0x0040)
#define FLLD_5                           (0x5000)        /* fDCOCLK / 32 */
#define FLLD_5_H                         (0x0050)
#define FLLD_6                           (0x6000)        /* Reserved for future use */
#define FLLD_6_H                         (0x0060)
#define FLLD_7                           (0x7000)        /* Reserved for future use */
#define FLLD_7_H                         (0x0070)
#define FLLD__1                          (0x0000)        /* fDCOCLK / 1 */
#define FLLD__2                          (0x1000)        /* fDCOCLK / 2 */
#define FLLD__2_H                        (0x0010)
#define FLLD__4                          (0x2000)        /* fDCOCLK / 4 */
#define FLLD__4_H                        (0x0020)
#define FLLD__8                          (0x3000)        /* fDCOCLK / 8 */
#define FLLD__8_H                        (0x0030)
#define FLLD__16                         (0x4000)        /* fDCOCLK / 16 */
#define FLLD__16_H                       (0x0040)
#define FLLD__32                         (0x5000)        /* fDCOCLK / 32 */
#define FLLD__32_H                       (0x0050)

/* CSCTL3 Control Bits */
#define FLLREFDIV                        (0x0007)        /* */
#define FLLREFDIV_L                      (0x0007)
#define FLLREFDIV0                       (0x0001)        /* */
#define FLLREFDIV0_L                     (0x0001)
#define FLLREFDIV1                       (0x0002)        /* */
#define FLLREFDIV1_L                     (0x0002)
#define FLLREFDIV2                       (0x0004)        /* */
#define FLLREFDIV2_L                     (0x0004)
#define FLLREFDIV_0                      (0x0000)        /* fFLLREFCLK / 1 */
#define FLLREFDIV_1                      (0x0001)        /* fFLLREFCLK / 32 */
#define FLLREFDIV_1_L                    (0x0001)
#define FLLREFDIV_2                      (0x0002)        /* fFLLREFCLK / 64 */
#define FLLREFDIV_2_L                    (0x0002)
#define FLLREFDIV_3                      (0x0003)        /* fFLLREFCLK / 128 */
#define FLLREFDIV_3_L                    (0x0003)
#define FLLREFDIV_4                      (0x0004)        /* fFLLREFCLK / 256 */
#define FLLREFDIV_4_L                    (0x0004)
#define FLLREFDIV_5                      (0x0005)        /* fFLLREFCLK / 512 */
#define FLLREFDIV_5_L                    (0x0005)
#define FLLREFDIV_6                      (0x0006)        /* Reserved for future use */
#define FLLREFDIV_6_L                    (0x0006)
#define FLLREFDIV_7                      (0x0007)        /* Reserved for future use */
#define FLLREFDIV_7_L                    (0x0007)
#define FLLREFDIV__1                     (0x0000)        /* fFLLREFCLK / 1 */
#define FLLREFDIV__32                    (0x0001)        /* fFLLREFCLK / 32 */
#define FLLREFDIV__32_L                  (0x0001)
#define FLLREFDIV__64                    (0x0002)        /* fFLLREFCLK / 64 */
#define FLLREFDIV__64_L                  (0x0002)
#define FLLREFDIV__128                   (0x0003)        /* fFLLREFCLK / 128 */
#define FLLREFDIV__128_L                 (0x0003)
#define FLLREFDIV__256                   (0x0004)        /* fFLLREFCLK / 256 */
#define FLLREFDIV__256_L                 (0x0004)
#define FLLREFDIV__512                   (0x0005)        /* fFLLREFCLK / 512 */
#define FLLREFDIV__512_L                 (0x0005)
#define SELREF                           (0x0030)        /* */
#define SELREF_L                         (0x0030)
#define SELREF0                          (0x0010)        /* */
#define SELREF0_L                        (0x0010)
#define SELREF1                          (0x0020)        /* */
#define SELREF1_L                        (0x0020)
#define SELREF_0                         (0x0000)        /* XT1CLK */
#define SELREF_1                         (0x0010)        /* REFOCLK */
#define SELREF_1_L                       (0x0010)
#define SELREF_2                         (0x0020)        /* served for future use */
#define SELREF_2_L                       (0x0020)
#define SELREF_3                         (0x0030)        /* served for future use */
#define SELREF_3_L                       (0x0030)
#define SELREF__XT1CLK                   (0x0000)        /* XT1CLK */
#define SELREF__REFOCLK                  (0x0010)        /* REFOCLK */
#define SELREF__REFOCLK_L                (0x0010)

/* CSCTL4 Control Bits */
#define SELMS                            (0x0007)        /* */
#define SELMS_L                          (0x0007)
#define SELMS0                           (0x0001)        /* */
#define SELMS0_L                         (0x0001)
#define SELMS1                           (0x0002)        /* */
#define SELMS1_L                         (0x0002)
#define SELMS2                           (0x0004)        /* */
#define SELMS2_L                         (0x0004)
#define SELMS_0                          (0x0000)        /* DCOCLKDIV */
#define SELMS_1                          (0x0001)        /* REFOCLK */
#define SELMS_1_L                        (0x0001)
#define SELMS_2                          (0x0002)        /* XT1CLK */
#define SELMS_2_L                        (0x0002)
#define SELMS_3                          (0x0003)        /* VLOCLK */
#define SELMS_3_L                        (0x0003)
#define SELMS_4                          (0x0004)        /* Reserved for future use */
#define SELMS_4_L                        (0x0004)
#define SELMS_5                          (0x0005)        /* Reserved for future use */
#define SELMS_5_L                        (0x0005)
#define SELMS_6                          (0x0006)        /* Reserved for future use */
#define SELMS_6_L                        (0x0006)
#define SELMS_7                          (0x0007)        /* Reserved for future use */
#define SELMS_7_L                        (0x0007)
#define SELMS__DCOCLKDIV                 (0x0000)        /* DCOCLKDIV */
#define SELMS__REFOCLK                   (0x0001)        /* REFOCLK */
#define SELMS__REFOCLK_L                 (0x0001)
#define SELMS__XT1CLK                    (0x0002)        /* XT1CLK */
#define SELMS__XT1CLK_L                  (0x0002)
#define SELMS__VLOCLK                    (0x0003)        /* VLOCLK */
#define SELMS__VLOCLK_L                  (0x0003)
#define SELA                             (0x0100)        /* */
#define SELA_H                           (0x0001)
#define SELA_0                           (0x0000)        /* XT1CLK with divider (must be no more than 40 kHz) */
#define SELA_1                           (0x0100)        /* REFO (internal 32-kHz clock source) */
#define SELA_1_H                         (0x0001)
#define SELA__XT1CLK                     (0x0000)        /* XT1CLK with divider (must be no more than 40 kHz) */
#define SELA__REFOCLK                    (0x0100)        /* REFO (internal 32-kHz clock source) */
#define SELA__REFOCLK_H                  (0x0001)

/* CSCTL5 Control Bits */
#define DIVM                             (0x0007)        /* */
#define DIVM_L                           (0x0007)
#define DIVM0                            (0x0001)        /* */
#define DIVM0_L                          (0x0001)
#define DIVM1                            (0x0002)        /* */
#define DIVM1_L                          (0x0002)
#define DIVM2                            (0x0004)        /* */
#define DIVM2_L                          (0x0004)
#define DIVM_0                           (0x0000)        /* /1 */
#define DIVM_1                           (0x0001)        /* /2 */
#define DIVM_1_L                         (0x0001)
#define DIVM_2                           (0x0002)        /* /4 */
#define DIVM_2_L                         (0x0002)
#define DIVM_3                           (0x0003)        /* /8 */
#define DIVM_3_L                         (0x0003)
#define DIVM_4                           (0x0004)        /* /16 */
#define DIVM_4_L                         (0x0004)
#define DIVM_5                           (0x0005)        /* /32 */
#define DIVM_5_L                         (0x0005)
#define DIVM_6                           (0x0006)        /* /64 */
#define DIVM_6_L                         (0x0006)
#define DIVM_7                           (0x0007)        /* /128 */
#define DIVM_7_L                         (0x0007)
#define DIVM__1                          (0x0000)        /* /1 */
#define DIVM__2                          (0x0001)        /* /2 */
#define DIVM__2_L                        (0x0001)
#define DIVM__4                          (0x0002)        /* /4 */
#define DIVM__4_L                        (0x0002)
#define DIVM__8                          (0x0003)        /* /8 */
#define DIVM__8_L                        (0x0003)
#define DIVM__16                         (0x0004)        /* /16 */
#define DIVM__16_L                       (0x0004)
#define DIVM__32                         (0x0005)        /* /32 */
#define DIVM__32_L                       (0x0005)
#define DIVM__64                         (0x0006)        /* /64 */
#define DIVM__64_L                       (0x0006)
#define DIVM__128                        (0x0007)        /* /128 */
#define DIVM__128_L                      (0x0007)
#define DIVS                             (0x0030)        /* */
#define DIVS_L                           (0x0030)
#define DIVS0                            (0x0010)        /* */
#define DIVS0_L                          (0x0010)
#define DIVS1                            (0x0020)        /* */
#define DIVS1_L                          (0x0020)
#define DIVS_0                           (0x0000)        /* /1 */
#define DIVS_1                           (0x0010)        /* /2 */
#define DIVS_1_L                         (0x0010)
#define DIVS_2                           (0x0020)        /* /4 */
#define DIVS_2_L                         (0x0020)
#define DIVS_3                           (0x0030)        /* /8 */
#define DIVS_3_L                         (0x0030)
#define DIVS__1                          (0x0000)        /* /1 */
#define DIVS__2                          (0x0010)        /* /2 */
#define DIVS__2_L                        (0x0010)
#define DIVS__4                          (0x0020)        /* /4 */
#define DIVS__4_L                        (0x0020)
#define DIVS__8                          (0x0030)        /* /8 */
#define DIVS__8_L                        (0x0030)
#define SMCLKOFF                         (0x0100)        /* */
#define SMCLKOFF_H                       (0x0001)
#define SMCLKOFF_0                       (0x0000)        /* SMCLK on */
#define SMCLKOFF_1                       (0x0100)        /* SMCLK off */
#define SMCLKOFF_1_H                     (0x0001)
#define VLOAUTOOFF                       (0x1000)        /* */
#define VLOAUTOOFF_H                     (0x0010)
#define VLOAUTOOFF_0                     (0x0000)        /* VLO always on */
#define VLOAUTOOFF_1                     (0x1000)        /* VLO automatically turned off if not used(default) */
#define VLOAUTOOFF_1_H                   (0x0010)

/* CSCTL6 Control Bits */
#define XT1AUTOOFF                       (0x0001)        /* */
#define XT1AUTOOFF_L                     (0x0001)
#define XT1AUTOOFF_0                     (0x0000)        /* XT1 is on if XT1 is selected by the port selection and XT1 is 
                                                            not in bypass mode of operation. */
#define XT1AUTOOFF_1                     (0x0001)        /* XT1 is off if it is not used as a source for ACLK, MCLK, or 
                                                            SMCLK or is not used as a reference source required for FLL 
                                                            operation. */
#define XT1AUTOOFF_1_L                   (0x0001)
#define XT1AGCOFF                        (0x0002)        /* */
#define XT1AGCOFF_L                      (0x0002)
#define XT1AGCOFF_0                      (0x0000)        /* AGC on */
#define XT1AGCOFF_1                      (0x0002)        /* AGC off */
#define XT1AGCOFF_1_L                    (0x0002)
#define XT1HFFREQ                        (0x000c)        /* */
#define XT1HFFREQ_L                      (0x000c)
#define XT1HFFREQ0                       (0x0004)        /* */
#define XT1HFFREQ0_L                     (0x0004)
#define XT1HFFREQ1                       (0x0008)        /* */
#define XT1HFFREQ1_L                     (0x0008)
#define XT1HFFREQ_0                      (0x0000)        /* 1 to 4 MHz */
#define XT1HFFREQ_1                      (0x0004)        /* >4 MHz to 6 MHz */
#define XT1HFFREQ_1_L                    (0x0004)
#define XT1HFFREQ_2                      (0x0008)        /* >6 MHz to 16 MHz */
#define XT1HFFREQ_2_L                    (0x0008)
#define XT1HFFREQ_3                      (0x000c)        /* >16 MHz to 24 MHz */
#define XT1HFFREQ_3_L                    (0x000c)
#define XT1BYPASS                        (0x0010)        /* */
#define XT1BYPASS_L                      (0x0010)
#define XT1BYPASS_0                      (0x0000)        /* XT1 source internally */
#define XT1BYPASS_1                      (0x0010)        /* XT1 sources externally from pin */
#define XT1BYPASS_1_L                    (0x0010)
#define XTS                              (0x0020)        /* */
#define XTS_L                            (0x0020)
#define XTS_0                            (0x0000)        /* Low-frequency mode. */
#define XTS_1                            (0x0020)        /* High-frequency mode. */
#define XTS_1_L                          (0x0020)
#define XT1DRIVE                         (0x00c0)        /* */
#define XT1DRIVE_L                       (0x00c0)
#define XT1DRIVE0                        (0x0040)        /* */
#define XT1DRIVE0_L                      (0x0040)
#define XT1DRIVE1                        (0x0080)        /* */
#define XT1DRIVE1_L                      (0x0080)
#define XT1DRIVE_0                       (0x0000)        /* Lowest drive strength and current consumption */
#define XT1DRIVE_1                       (0x0040)        /* Lower drive strength and current consumption */
#define XT1DRIVE_1_L                     (0x0040)
#define XT1DRIVE_2                       (0x0080)        /* Higher drive strength and current consumption */
#define XT1DRIVE_2_L                     (0x0080)
#define XT1DRIVE_3                       (0x00c0)        /* Highest drive strength and current consumption */
#define XT1DRIVE_3_L                     (0x00c0)
#define DIVA                             (0x0f00)        /* */
#define DIVA_H                           (0x000f)
#define DIVA0                            (0x0100)        /* */
#define DIVA0_H                          (0x0001)
#define DIVA1                            (0x0200)        /* */
#define DIVA1_H                          (0x0002)
#define DIVA2                            (0x0400)        /* */
#define DIVA2_H                          (0x0004)
#define DIVA3                            (0x0800)        /* */
#define DIVA3_H                          (0x0008)
#define DIVA_0                           (0x0000)        /* /1 */
#define DIVA_1                           (0x0100)        /* /16 */
#define DIVA_1_H                         (0x0001)
#define DIVA_2                           (0x0200)        /* /32 */
#define DIVA_2_H                         (0x0002)
#define DIVA_3                           (0x0300)        /* /64 */
#define DIVA_3_H                         (0x0003)
#define DIVA_4                           (0x0400)        /* /128 */
#define DIVA_4_H                         (0x0004)
#define DIVA_5                           (0x0500)        /* /256 */
#define DIVA_5_H                         (0x0005)
#define DIVA_6                           (0x0600)        /* /384 */
#define DIVA_6_H                         (0x0006)
#define DIVA_7                           (0x0700)        /* /512 */
#define DIVA_7_H                         (0x0007)
#define DIVA_8                           (0x0800)        /* /768 */
#define DIVA_8_H                         (0x0008)
#define DIVA_9                           (0x0900)        /* /1024 */
#define DIVA_9_H                         (0x0009)
#define DIVA_10                          (0x0a00)        /* Reserved */
#define DIVA_10_H                        (0x000a)
#define DIVA_11                          (0x0b00)        /* Reserved */
#define DIVA_11_H                        (0x000b)
#define DIVA_12                          (0x0c00)        /* Reserved */
#define DIVA_12_H                        (0x000c)
#define DIVA_13                          (0x0d00)        /* Reserved */
#define DIVA_13_H                        (0x000d)
#define DIVA_14                          (0x0e00)        /* Reserved */
#define DIVA_14_H                        (0x000e)
#define DIVA_15                          (0x0f00)        /* Reserved */
#define DIVA_15_H                        (0x000f)
#define DIVA__1                          (0x0000)        /* /1 */
#define DIVA__16                         (0x0100)        /* /16 */
#define DIVA__16_H                       (0x0001)
#define DIVA__32                         (0x0200)        /* /32 */
#define DIVA__32_H                       (0x0002)
#define DIVA__64                         (0x0300)        /* /64 */
#define DIVA__64_H                       (0x0003)
#define DIVA__128                        (0x0400)        /* /128 */
#define DIVA__128_H                      (0x0004)
#define DIVA__256                        (0x0500)        /* /256 */
#define DIVA__256_H                      (0x0005)
#define DIVA__384                        (0x0600)        /* /384 */
#define DIVA__384_H                      (0x0006)
#define DIVA__512                        (0x0700)        /* /512 */
#define DIVA__512_H                      (0x0007)
#define DIVA__768                        (0x0800)        /* /768 */
#define DIVA__768_H                      (0x0008)
#define DIVA__1024                       (0x0900)        /* /1024 */
#define DIVA__1024_H                     (0x0009)

/* CSCTL7 Control Bits */
#define DCOFFG                           (0x0001)        /* */
#define DCOFFG_L                         (0x0001)
#define DCOFFG_0                         (0x0000)        /* No fault condition occurred after the last reset. */
#define DCOFFG_1                         (0x0001)        /* DCO fault. A DCO fault occurred after the last reset. */
#define DCOFFG_1_L                       (0x0001)
#define XT1OFFG                          (0x0002)        /* */
#define XT1OFFG_L                        (0x0002)
#define XT1OFFG_0                        (0x0000)        /* No fault condition occurred after the last reset. */
#define XT1OFFG_1                        (0x0002)        /* XT1 fault. An XT1 fault occurred after the last reset. */
#define XT1OFFG_1_L                      (0x0002)
#define FLLULIFG                         (0x0010)        /* */
#define FLLULIFG_L                       (0x0010)
#define FLLULIFG_0                       (0x0000)        /* FLLUNLOCK bits not equal to 10b */
#define FLLULIFG_1                       (0x0010)        /* FLLUNLOCK bits equal to 10b */
#define FLLULIFG_1_L                     (0x0010)
#define ENSTFCNT1                        (0x0040)        /* */
#define ENSTFCNT1_L                      (0x0040)
#define ENSTFCNT1_0                      (0x0000)        /* Startup fault counter disabled. Counter is cleared.. */
#define ENSTFCNT1_1                      (0x0040)        /* Startup fault counter enabled. */
#define ENSTFCNT1_1_L                    (0x0040)
#define FLLUNLOCK                        (0x0300)        /* */
#define FLLUNLOCK_H                      (0x0003)
#define FLLUNLOCK0                       (0x0100)        /* */
#define FLLUNLOCK0_H                     (0x0001)
#define FLLUNLOCK1                       (0x0200)        /* */
#define FLLUNLOCK1_H                     (0x0002)
#define FLLUNLOCK_0                      (0x0000)        /* FLL is locked. No unlock condition currently active. */
#define FLLUNLOCK_1                      (0x0100)        /* DCOCLK is currently too slow. */
#define FLLUNLOCK_1_H                    (0x0001)
#define FLLUNLOCK_2                      (0x0200)        /* DCOCLK is currently too fast. */
#define FLLUNLOCK_2_H                    (0x0002)
#define FLLUNLOCK_3                      (0x0300)        /* DCOERROR. DCO out of range. */
#define FLLUNLOCK_3_H                    (0x0003)
#define FLLUNLOCKHIS                     (0x0c00)        /* */
#define FLLUNLOCKHIS_H                   (0x000c)
#define FLLUNLOCKHIS0                    (0x0400)        /* */
#define FLLUNLOCKHIS0_H                  (0x0004)
#define FLLUNLOCKHIS1                    (0x0800)        /* */
#define FLLUNLOCKHIS1_H                  (0x0008)
#define FLLUNLOCKHIS_0                   (0x0000)        /* FLL is locked. No unlock situation has been detected since the
                                                            last reset of these bits. */
#define FLLUNLOCKHIS_1                   (0x0400)        /* DCOCLK has been too slow since the bits were cleared. */
#define FLLUNLOCKHIS_1_H                 (0x0004)
#define FLLUNLOCKHIS_2                   (0x0800)        /* DCOCLK has been too fast since the bits were cleared. */
#define FLLUNLOCKHIS_2_H                 (0x0008)
#define FLLUNLOCKHIS_3                   (0x0c00)        /* DCOCLK has been both too fast and too slow since the bits were
                                                            cleared. */
#define FLLUNLOCKHIS_3_H                 (0x000c)
#define FLLULPUC                         (0x1000)        /* */
#define FLLULPUC_H                       (0x0010)
#define FLLWARNEN                        (0x2000)        /* */
#define FLLWARNEN_H                      (0x0020)
#define FLLWARNEN_0                      (0x0000)        /* FLLUNLOCKHIS status cannot set OFIFG. */
#define FLLWARNEN_1                      (0x2000)        /* FLLUNLOCKHIS status can set OFIFG. */
#define FLLWARNEN_1_H                    (0x0020)

/* CSCTL8 Control Bits */
#define ACLKREQEN                        (0x0001)        /* */
#define ACLKREQEN_L                      (0x0001)
#define ACLKREQEN_0                      (0x0000)        /* ACLK conditional requests are disabled. */
#define ACLKREQEN_1                      (0x0001)        /* ACLK conditional requests are enabled. */
#define ACLKREQEN_1_L                    (0x0001)
#define MCLKREQEN                        (0x0002)        /* */
#define MCLKREQEN_L                      (0x0002)
#define MCLKREQEN_0                      (0x0000)        /* MCLK conditional requests are disabled. */
#define MCLKREQEN_1                      (0x0002)        /* MCLK conditional requests are enabled. */
#define MCLKREQEN_1_L                    (0x0002)
#define SMCLKREQEN                       (0x0004)        /* */
#define SMCLKREQEN_L                     (0x0004)
#define SMCLKREQEN_0                     (0x0000)        /* SMCLK conditional requests are disabled. */
#define SMCLKREQEN_1                     (0x0004)        /* SMCLK conditional requests are enabled. */
#define SMCLKREQEN_1_L                   (0x0004)
#define MODOSCREQEN                      (0x0008)        /* */
#define MODOSCREQEN_L                    (0x0008)
#define MODOSCREQEN_0                    (0x0000)        /* MODOSC conditional requests are disabled. */
#define MODOSCREQEN_1                    (0x0008)        /* MODOSC conditional requests are enabled. */
#define MODOSCREQEN_1_L                  (0x0008)


/*****************************************************************************
 DIO Registers
*****************************************************************************/

#define __MSP430_HAS_DIO__ 2                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_DIO__ 0x0200
#define DIO_BASE               __MSP430_BASEADDRESS_DIO__
#define __MSP430_HAS_PORTA_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTA_R__ 0x200
#define PA_BASE                __MSP430_BASEADDRESS_PORTA_R__
#define __MSP430_HAS_PORTJ_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTJ_R__ 0x320
#define PJ_BASE                __MSP430_BASEADDRESS_PORTJ_R__
#define __MSP430_HAS_PORT1_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT1_R__ 0x200
#define P1_BASE                __MSP430_BASEADDRESS_PORT1_R__
#define __MSP430_HAS_PORT2_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT2_R__ 0x200
#define P2_BASE                __MSP430_BASEADDRESS_PORT2_R__
#define __MSP430_HAS_PASEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PASEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PJSEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PJSEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P1SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P2SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P1SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P2SEL1__                 /* Define for DriverLib */

sfr_w(PAIN);                                  /* Port A Input */
sfr_b(PAIN_L);
sfr_b(PAIN_H);
sfr_w(PAOUT);                                 /* Port A Output */
sfr_b(PAOUT_L);
sfr_b(PAOUT_H);
sfr_w(PADIR);                                 /* Port A Direction */
sfr_b(PADIR_L);
sfr_b(PADIR_H);
sfr_w(PAREN);                                 /* Port A Resistor Enable */
sfr_b(PAREN_L);
sfr_b(PAREN_H);
sfr_w(PASEL0);                                /* Port A Select 0 */
sfr_b(PASEL0_L);
sfr_b(PASEL0_H);
sfr_w(PASEL1);                                /* Port A Select 1 */
sfr_b(PASEL1_L);
sfr_b(PASEL1_H);
sfr_w(P1IV);                                  /* Port 1 Interrupt Vector Register */
sfr_b(P1IV_L);
sfr_b(P1IV_H);
sfr_w(PASELC);                                /* Port A Complement Select */
sfr_b(PASELC_L);
sfr_b(PASELC_H);
sfr_w(PAIES);                                 /* Port A Interrupt Edge Select */
sfr_b(PAIES_L);
sfr_b(PAIES_H);
sfr_w(PAIE);                                  /* Port A Interrupt Enable */
sfr_b(PAIE_L);
sfr_b(PAIE_H);
sfr_w(PAIFG);                                 /* Port A Interrupt Flag */
sfr_b(PAIFG_L);
sfr_b(PAIFG_H);
sfr_w(P2IV);                                  /* Port 2 Interrupt Vector Register */
sfr_b(P2IV_L);
sfr_b(P2IV_H);
sfr_w(PJIN);                                  /* Port J Input */
sfr_b(PJIN_L);
sfr_b(PJIN_H);
sfr_w(PJOUT);                                 /* Port J Output */
sfr_b(PJOUT_L);
sfr_b(PJOUT_H);
sfr_w(PJDIR);                                 /* Port J Direction */
sfr_b(PJDIR_L);
sfr_b(PJDIR_H);
sfr_w(PJREN);                                 /* Port J Resistor Enable */
sfr_b(PJREN_L);
sfr_b(PJREN_H);
sfr_w(PJSEL0);                                /* Port J Select 0 */
sfr_b(PJSEL0_L);
sfr_b(PJSEL0_H);
sfr_w(PJSEL1);                                /* Port J Select 1 */
sfr_b(PJSEL1_L);
sfr_b(PJSEL1_H);
sfr_w(PJSELC);                                /* Port J Complement Select */
sfr_b(PJSELC_L);
sfr_b(PJSELC_H);
sfr_b(P1IN);                                  /* Port 1 Input */

sfr_b(P2IN);                                  /* Port 2 Input */

sfr_b(P2OUT);                                 /* Port 2 Output */

sfr_b(P1OUT);                                 /* Port 1 Output */

sfr_b(P1DIR);                                 /* Port 1 Direction */

sfr_b(P2DIR);                                 /* Port 2 Direction */

sfr_b(P1REN);                                 /* Port 1 Resistor Enable */

sfr_b(P2REN);                                 /* Port 2 Resistor Enable */

sfr_b(P1SEL0);                                /* Port 1 Select 0 */

sfr_b(P2SEL0);                                /* Port 2 Select 0 */

sfr_b(P1SEL1);                                /* Port 1 Select 1 */

sfr_b(P2SEL1);                                /* Port 2 Select 1 */

sfr_b(P1SELC);                                /* Port 1 Complement Select */

sfr_b(P2SELC);                                /* Port 2 Complement Select */

sfr_b(P1IES);                                 /* Port 1 Interrupt Edge Select */

sfr_b(P2IES);                                 /* Port 2 Interrupt Edge Select */

sfr_b(P1IE);                                  /* Port 1 Interrupt Enable */

sfr_b(P2IE);                                  /* Port 2 Interrupt Enable */

sfr_b(P1IFG);                                 /* Port 1 Interrupt Flag */

sfr_b(P2IFG);                                 /* Port 2 Interrupt Flag */


/* DIO Register Offsets */
#define OFS_PAIN                         (0x0000)
#define OFS_PAIN_L                       OFS_PAIN
#define OFS_PAIN_H                       OFS_PAIN+1
#define OFS_PAOUT                        (0x0002)
#define OFS_PAOUT_L                      OFS_PAOUT
#define OFS_PAOUT_H                      OFS_PAOUT+1
#define OFS_PADIR                        (0x0004)
#define OFS_PADIR_L                      OFS_PADIR
#define OFS_PADIR_H                      OFS_PADIR+1
#define OFS_PAREN                        (0x0006)
#define OFS_PAREN_L                      OFS_PAREN
#define OFS_PAREN_H                      OFS_PAREN+1
#define OFS_PASEL0                       (0x000A)
#define OFS_PASEL0_L                     OFS_PASEL0
#define OFS_PASEL0_H                     OFS_PASEL0+1
#define OFS_PASEL1                       (0x000C)
#define OFS_PASEL1_L                     OFS_PASEL1
#define OFS_PASEL1_H                     OFS_PASEL1+1
#define OFS_P1IV                         (0x000E)
#define OFS_P1IV_L                       OFS_P1IV
#define OFS_P1IV_H                       OFS_P1IV+1
#define OFS_PASELC                       (0x0016)
#define OFS_PASELC_L                     OFS_PASELC
#define OFS_PASELC_H                     OFS_PASELC+1
#define OFS_PAIES                        (0x0018)
#define OFS_PAIES_L                      OFS_PAIES
#define OFS_PAIES_H                      OFS_PAIES+1
#define OFS_PAIE                         (0x001A)
#define OFS_PAIE_L                       OFS_PAIE
#define OFS_PAIE_H                       OFS_PAIE+1
#define OFS_PAIFG                        (0x001C)
#define OFS_PAIFG_L                      OFS_PAIFG
#define OFS_PAIFG_H                      OFS_PAIFG+1
#define OFS_P2IV                         (0x001E)
#define OFS_P2IV_L                       OFS_P2IV
#define OFS_P2IV_H                       OFS_P2IV+1
#define OFS_PJIN                         (0x0000)
#define OFS_PJIN_L                       OFS_PJIN
#define OFS_PJIN_H                       OFS_PJIN+1
#define OFS_PJOUT                        (0x0002)
#define OFS_PJOUT_L                      OFS_PJOUT
#define OFS_PJOUT_H                      OFS_PJOUT+1
#define OFS_PJDIR                        (0x0004)
#define OFS_PJDIR_L                      OFS_PJDIR
#define OFS_PJDIR_H                      OFS_PJDIR+1
#define OFS_PJREN                        (0x0006)
#define OFS_PJREN_L                      OFS_PJREN
#define OFS_PJREN_H                      OFS_PJREN+1
#define OFS_PJSEL0                       (0x000A)
#define OFS_PJSEL0_L                     OFS_PJSEL0
#define OFS_PJSEL0_H                     OFS_PJSEL0+1
#define OFS_PJSEL1                       (0x000C)
#define OFS_PJSEL1_L                     OFS_PJSEL1
#define OFS_PJSEL1_H                     OFS_PJSEL1+1
#define OFS_PJSELC                       (0x0016)
#define OFS_PJSELC_L                     OFS_PJSELC
#define OFS_PJSELC_H                     OFS_PJSELC+1
#define OFS_P1IN                         (0x0000)
#define OFS_P2IN                         (0x0001)
#define OFS_P2OUT                        (0x0003)
#define OFS_P1OUT                        (0x0002)
#define OFS_P1DIR                        (0x0004)
#define OFS_P2DIR                        (0x0005)
#define OFS_P1REN                        (0x0006)
#define OFS_P2REN                        (0x0007)
#define OFS_P1SEL0                       (0x000A)
#define OFS_P2SEL0                       (0x000B)
#define OFS_P1SEL1                       (0x000C)
#define OFS_P2SEL1                       (0x000D)
#define OFS_P1SELC                       (0x0016)
#define OFS_P2SELC                       (0x0017)
#define OFS_P1IES                        (0x0018)
#define OFS_P2IES                        (0x0019)
#define OFS_P1IE                         (0x001A)
#define OFS_P2IE                         (0x001B)
#define OFS_P1IFG                        (0x001C)
#define OFS_P2IFG                        (0x001D)

/* DIO Control Bits */

/* P1IV Control Bits */
#define P1IV0                            (0x0001)        /* Port 1 interrupt vector value */
#define P1IV0_L                          (0x0001)
#define P1IV1                            (0x0002)        /* Port 1 interrupt vector value */
#define P1IV1_L                          (0x0002)
#define P1IV2                            (0x0004)        /* Port 1 interrupt vector value */
#define P1IV2_L                          (0x0004)
#define P1IV3                            (0x0008)        /* Port 1 interrupt vector value */
#define P1IV3_L                          (0x0008)
#define P1IV4                            (0x0010)        /* Port 1 interrupt vector value */
#define P1IV4_L                          (0x0010)
#define P1IV_0                           (0x0000)        /* No interrupt pending */
#define P1IV_2                           (0x0002)        /* Interrupt Source: Port 1.0 interrupt; Interrupt Flag: P1IFG0; 
                                                            Interrupt Priority: Highest */
#define P1IV_2_L                         (0x0002)
#define P1IV_4                           (0x0004)        /* Interrupt Source: Port 1.1 interrupt; Interrupt Flag: P1IFG1 */
#define P1IV_4_L                         (0x0004)
#define P1IV_6                           (0x0006)        /* Interrupt Source: Port 1.2 interrupt; Interrupt Flag: P1IFG2 */
#define P1IV_6_L                         (0x0006)
#define P1IV_8                           (0x0008)        /* Interrupt Source: Port 1.3 interrupt; Interrupt Flag: P1IFG3 */
#define P1IV_8_L                         (0x0008)
#define P1IV_10                          (0x000a)        /* Interrupt Source: Port 1.4 interrupt; Interrupt Flag: P1IFG4 */
#define P1IV_10_L                        (0x000a)
#define P1IV_12                          (0x000c)        /* Interrupt Source: Port 1.5 interrupt; Interrupt Flag: P1IFG5 */
#define P1IV_12_L                        (0x000c)
#define P1IV_14                          (0x000e)        /* Interrupt Source: Port 1.6 interrupt; Interrupt Flag: P1IFG6 */
#define P1IV_14_L                        (0x000e)
#define P1IV_16                          (0x0010)        /* Interrupt Source: Port 1.7 interrupt; Interrupt Flag: P1IFG7; 
                                                            Interrupt Priority: Lowest */
#define P1IV_16_L                        (0x0010)
#define P1IV__NONE                       (0x0000)        /* No interrupt pending */
#define P1IV__P1IFG0                     (0x0002)        /* Interrupt Source: Port 1.0 interrupt; Interrupt Flag: P1IFG0; 
                                                            Interrupt Priority: Highest */
#define P1IV__P1IFG0_L                   (0x0002)
#define P1IV__P1IFG1                     (0x0004)        /* Interrupt Source: Port 1.1 interrupt; Interrupt Flag: P1IFG1 */
#define P1IV__P1IFG1_L                   (0x0004)
#define P1IV__P1IFG2                     (0x0006)        /* Interrupt Source: Port 1.2 interrupt; Interrupt Flag: P1IFG2 */
#define P1IV__P1IFG2_L                   (0x0006)
#define P1IV__P1IFG3                     (0x0008)        /* Interrupt Source: Port 1.3 interrupt; Interrupt Flag: P1IFG3 */
#define P1IV__P1IFG3_L                   (0x0008)
#define P1IV__P1IFG4                     (0x000a)        /* Interrupt Source: Port 1.4 interrupt; Interrupt Flag: P1IFG4 */
#define P1IV__P1IFG4_L                   (0x000a)
#define P1IV__P1IFG5                     (0x000c)        /* Interrupt Source: Port 1.5 interrupt; Interrupt Flag: P1IFG5 */
#define P1IV__P1IFG5_L                   (0x000c)
#define P1IV__P1IFG6                     (0x000e)        /* Interrupt Source: Port 1.6 interrupt; Interrupt Flag: P1IFG6 */
#define P1IV__P1IFG6_L                   (0x000e)
#define P1IV__P1IFG7                     (0x0010)        /* Interrupt Source: Port 1.7 interrupt; Interrupt Flag: P1IFG7; 
                                                            Interrupt Priority: Lowest */
#define P1IV__P1IFG7_L                   (0x0010)

/* P2IV Control Bits */
#define P2IV0                            (0x0001)        /* Port 2 interrupt vector value */
#define P2IV0_L                          (0x0001)
#define P2IV1                            (0x0002)        /* Port 2 interrupt vector value */
#define P2IV1_L                          (0x0002)
#define P2IV2                            (0x0004)        /* Port 2 interrupt vector value */
#define P2IV2_L                          (0x0004)
#define P2IV3                            (0x0008)        /* Port 2 interrupt vector value */
#define P2IV3_L                          (0x0008)
#define P2IV4                            (0x0010)        /* Port 2 interrupt vector value */
#define P2IV4_L                          (0x0010)
#define P2IV_0                           (0x0000)        /* No interrupt pending */
#define P2IV_2                           (0x0002)        /* Interrupt Source: Port 2.0 interrupt; Interrupt Flag: P2IFG0; 
                                                            Interrupt Priority: Highest */
#define P2IV_2_L                         (0x0002)
#define P2IV_4                           (0x0004)        /* Interrupt Source: Port 2.1 interrupt; Interrupt Flag: P2IFG1 */
#define P2IV_4_L                         (0x0004)
#define P2IV_6                           (0x0006)        /* Interrupt Source: Port 2.2 interrupt; Interrupt Flag: P2IFG2 */
#define P2IV_6_L                         (0x0006)
#define P2IV_8                           (0x0008)        /* Interrupt Source: Port 2.3 interrupt; Interrupt Flag: P2IFG3 */
#define P2IV_8_L                         (0x0008)
#define P2IV_10                          (0x000a)        /* Interrupt Source: Port 2.4 interrupt; Interrupt Flag: P2IFG4 */
#define P2IV_10_L                        (0x000a)
#define P2IV_12                          (0x000c)        /* Interrupt Source: Port 2.5 interrupt; Interrupt Flag: P2IFG5 */
#define P2IV_12_L                        (0x000c)
#define P2IV_14                          (0x000e)        /* Interrupt Source: Port 2.6 interrupt; Interrupt Flag: P2IFG6 */
#define P2IV_14_L                        (0x000e)
#define P2IV_16                          (0x0010)        /* Interrupt Source: Port 2.7 interrupt; Interrupt Flag: P2IFG7; 
                                                            Interrupt Priority: Lowest */
#define P2IV_16_L                        (0x0010)
#define P2IV__NONE                       (0x0000)        /* No interrupt pending */
#define P2IV__P2IFG0                     (0x0002)        /* Interrupt Source: Port 2.0 interrupt; Interrupt Flag: P2IFG0; 
                                                            Interrupt Priority: Highest */
#define P2IV__P2IFG0_L                   (0x0002)
#define P2IV__P2IFG1                     (0x0004)        /* Interrupt Source: Port 2.1 interrupt; Interrupt Flag: P2IFG1 */
#define P2IV__P2IFG1_L                   (0x0004)
#define P2IV__P2IFG2                     (0x0006)        /* Interrupt Source: Port 2.2 interrupt; Interrupt Flag: P2IFG2 */
#define P2IV__P2IFG2_L                   (0x0006)
#define P2IV__P2IFG3                     (0x0008)        /* Interrupt Source: Port 2.3 interrupt; Interrupt Flag: P2IFG3 */
#define P2IV__P2IFG3_L                   (0x0008)
#define P2IV__P2IFG4                     (0x000a)        /* Interrupt Source: Port 2.4 interrupt; Interrupt Flag: P2IFG4 */
#define P2IV__P2IFG4_L                   (0x000a)
#define P2IV__P2IFG5                     (0x000c)        /* Interrupt Source: Port 2.5 interrupt; Interrupt Flag: P2IFG5 */
#define P2IV__P2IFG5_L                   (0x000c)
#define P2IV__P2IFG6                     (0x000e)        /* Interrupt Source: Port 2.6 interrupt; Interrupt Flag: P2IFG6 */
#define P2IV__P2IFG6_L                   (0x000e)
#define P2IV__P2IFG7                     (0x0010)        /* Interrupt Source: Port 2.7 interrupt; Interrupt Flag: P2IFG7; 
                                                            Interrupt Priority: Lowest */
#define P2IV__P2IFG7_L                   (0x0010)


/*****************************************************************************
 FRCTL Registers
*****************************************************************************/

#define __MSP430_HAS_FRCTL__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_FRCTL__ 0x01A0
#define FRCTL_BASE             __MSP430_BASEADDRESS_FRCTL__

sfr_w(FRCTL0);                                /* FRAM Controller Control Register 0 */
sfr_b(FRCTL0_L);
sfr_b(FRCTL0_H);
sfr_w(GCCTL0);                                /* General Control Register 0 */
sfr_b(GCCTL0_L);
sfr_b(GCCTL0_H);
sfr_w(GCCTL1);                                /* General Control Register 1 */
sfr_b(GCCTL1_L);
sfr_b(GCCTL1_H);

/* FRCTL Register Offsets */
#define OFS_FRCTL0                       (0x0000)
#define OFS_FRCTL0_L                     OFS_FRCTL0
#define OFS_FRCTL0_H                     OFS_FRCTL0+1
#define OFS_GCCTL0                       (0x0004)
#define OFS_GCCTL0_L                     OFS_GCCTL0
#define OFS_GCCTL0_H                     OFS_GCCTL0+1
#define OFS_GCCTL1                       (0x0006)
#define OFS_GCCTL1_L                     OFS_GCCTL1
#define OFS_GCCTL1_H                     OFS_GCCTL1+1

/* FRCTL Control Bits */

/* FRCTL0 Control Bits */
#define NWAITS                           (0x0070)        /* Wait state numbers */
#define NWAITS_L                         (0x0070)
#define NWAITS0                          (0x0010)        /* Wait state numbers */
#define NWAITS0_L                        (0x0010)
#define NWAITS1                          (0x0020)        /* Wait state numbers */
#define NWAITS1_L                        (0x0020)
#define NWAITS2                          (0x0040)        /* Wait state numbers */
#define NWAITS2_L                        (0x0040)
#define NWAITS_0                         (0x0000)        /* FRAM wait states: 0 */
#define NWAITS_1                         (0x0010)        /* FRAM wait states: 1 */
#define NWAITS_1_L                       (0x0010)
#define NWAITS_2                         (0x0020)        /* FRAM wait states: 2 */
#define NWAITS_2_L                       (0x0020)
#define NWAITS_3                         (0x0030)        /* FRAM wait states: 3 */
#define NWAITS_3_L                       (0x0030)
#define NWAITS_4                         (0x0040)        /* FRAM wait states: 4 */
#define NWAITS_4_L                       (0x0040)
#define NWAITS_5                         (0x0050)        /* FRAM wait states: 5 */
#define NWAITS_5_L                       (0x0050)
#define NWAITS_6                         (0x0060)        /* FRAM wait states: 6 */
#define NWAITS_6_L                       (0x0060)
#define NWAITS_7                         (0x0070)        /* FRAM wait states: 7 */
#define NWAITS_7_L                       (0x0070)
#define FRCTLPW                          (0xa500)        /* FRCTLPW password */
#define FRCTLPW_H                        (0x00a5)
#define FRCTLPW0                         (0x0100)        /* FRCTLPW password */
#define FRCTLPW0_H                       (0x0001)
#define FRCTLPW1                         (0x0200)        /* FRCTLPW password */
#define FRCTLPW1_H                       (0x0002)
#define FRCTLPW2                         (0x0400)        /* FRCTLPW password */
#define FRCTLPW2_H                       (0x0004)
#define FRCTLPW3                         (0x0800)        /* FRCTLPW password */
#define FRCTLPW3_H                       (0x0008)
#define FRCTLPW4                         (0x1000)        /* FRCTLPW password */
#define FRCTLPW4_H                       (0x0010)
#define FRCTLPW5                         (0x2000)        /* FRCTLPW password */
#define FRCTLPW5_H                       (0x0020)
#define FRCTLPW6                         (0x4000)        /* FRCTLPW password */
#define FRCTLPW6_H                       (0x0040)
#define FRCTLPW7                         (0x8000)        /* FRCTLPW password */
#define FRCTLPW7_H                       (0x0080)

/* GCCTL0 Control Bits */
#define UBDRSTEN                         (0x0080)        /* Enable Power Up Clear (PUC) reset for the uncorrectable bit 
                                                            error detection flag (UBDIFG) */
#define UBDRSTEN_L                       (0x0080)
#define UBDRSTEN_0                       (0x0000)        /* PUC not initiated on uncorrectable bit error detection flag. */
#define UBDRSTEN_1                       (0x0080)        /* PUC initiated on uncorrectable bit error detection flag. 
                                                            Generates vector in SYSRSTIV. Clear the UBDIE bit. */
#define UBDRSTEN_1_L                     (0x0080)
#define UBDIE                            (0x0040)        /* Enable NMI event for the uncorrectable bit error detection 
                                                            flag (UBDIFG) */
#define UBDIE_L                          (0x0040)
#define UBDIE_0                          (0x0000)        /* Disable NMI for the uncorrectable bit error detection flag 
                                                            (UBDIFG). */
#define UBDIE_1                          (0x0040)        /* Enable NMI for the uncorrectable bit error detection flag 
                                                            (UBDIFG). Generates vector in SYSSNIV. Clear the UBDRSTEN bit. */
#define UBDIE_1_L                        (0x0040)
#define CBDIE                            (0x0020)        /* Enable NMI event for the correctable bit error detection flag 
                                                            (CBDIFG) */
#define CBDIE_L                          (0x0020)
#define CBDIE_0                          (0x0000)        /* Disable NMI for the correctable bit error detection flag 
                                                            (CBDIFG). */
#define CBDIE_1                          (0x0020)        /* Disable NMI for the correctable bit error detection flag 
                                                            (CBDIFG). Generates vector in SYSSNIV. */
#define CBDIE_1_L                        (0x0020)
#define FRPWR                            (0x0004)        /* FRAM Memory Power Control Request */
#define FRPWR_L                          (0x0004)
#define FRPWR_0                          (0x0000)        /* Enable INACTIVE mode. */
#define FRPWR_1                          (0x0004)        /* Enable ACTIVE mode. */
#define FRPWR_1_L                        (0x0004)
#define FRLPMPWR                         (0x0002)        /* Enables FRAM auto power up after LPM */
#define FRLPMPWR_L                       (0x0002)
#define FRLPMPWR_0                       (0x0000)        /* FRAM startup is delayed to the first FRAM access after exit 
                                                            from LPM */
#define FRLPMPWR_1                       (0x0002)        /* FRAM is powered up immediately on exit from LPM */
#define FRLPMPWR_1_L                     (0x0002)

/* GCCTL1 Control Bits */
#define ACCTEIFG                         (0x0008)        /* Access time error flag */
#define ACCTEIFG_L                       (0x0008)
#define ACCTEIFG_0                       (0x0000)        /* No interrupt pending. */
#define ACCTEIFG_1                       (0x0008)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV when it is the highest pending interrupt. */
#define ACCTEIFG_1_L                     (0x0008)
#define UBDIFG                           (0x0004)        /* FRAM uncorrectable bit error detection flag */
#define UBDIFG_L                         (0x0004)
#define UBDIFG_0                         (0x0000)        /* No interrupt pending. */
#define UBDIFG_1                         (0x0004)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV when it is the highest pending interrupt. */
#define UBDIFG_1_L                       (0x0004)
#define CBDIFG                           (0x0002)        /* FRAM correctable bit error detection flag */
#define CBDIFG_L                         (0x0002)
#define CBDIFG_0                         (0x0000)        /* No interrupt is pending */
#define CBDIFG_1                         (0x0002)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV if it is the highest pending interrupt. */
#define CBDIFG_1_L                       (0x0002)


/*****************************************************************************
 PMM Registers
*****************************************************************************/

#define __MSP430_HAS_PMM__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_PMM__ 0x0120
#define PMM_BASE               __MSP430_BASEADDRESS_PMM__

sfr_w(PMMCTL0);                               /* PMM control register 0 */
sfr_b(PMMCTL0_L);
sfr_b(PMMCTL0_H);
sfr_w(PMMCTL2);                               /* Power Management Module Control Register 2 */
sfr_b(PMMCTL2_L);
sfr_b(PMMCTL2_H);
sfr_w(PMMIFG);                                /* PMM interrupt flag register */
sfr_b(PMMIFG_L);
sfr_b(PMMIFG_H);
sfr_w(PM5CTL0);                               /* Power mode 5 control register 0 */
sfr_b(PM5CTL0_L);
sfr_b(PM5CTL0_H);

/* PMM Register Offsets */
#define OFS_PMMCTL0                      (0x0000)
#define OFS_PMMCTL0_L                    OFS_PMMCTL0
#define OFS_PMMCTL0_H                    OFS_PMMCTL0+1
#define OFS_PMMCTL2                      (0x0004)
#define OFS_PMMCTL2_L                    OFS_PMMCTL2
#define OFS_PMMCTL2_H                    OFS_PMMCTL2+1
#define OFS_PMMIFG                       (0x000A)
#define OFS_PMMIFG_L                     OFS_PMMIFG
#define OFS_PMMIFG_H                     OFS_PMMIFG+1
#define OFS_PM5CTL0                      (0x0010)
#define OFS_PM5CTL0_L                    OFS_PM5CTL0
#define OFS_PM5CTL0_H                    OFS_PM5CTL0+1

/* PMM Control Bits */

/* PMMCTL0 Control Bits */
#define PMMSWBOR                         (0x0004)        /* Software brownout reset. */
#define PMMSWBOR_L                       (0x0004)
#define PMMSWBOR_0                       (0x0000)        /* Normal operation */
#define PMMSWBOR_1                       (0x0004)        /* Set to 1 to trigger a BOR */
#define PMMSWBOR_1_L                     (0x0004)
#define PMMSWPOR                         (0x0008)        /* Software POR. */
#define PMMSWPOR_L                       (0x0008)
#define PMMSWPOR_0                       (0x0000)        /* Normal operation */
#define PMMSWPOR_1                       (0x0008)        /* Set to 1 to trigger a POR */
#define PMMSWPOR_1_L                     (0x0008)
#define PMMREGOFF                        (0x0010)        /* Regulator off */
#define PMMREGOFF_L                      (0x0010)
#define PMMREGOFF_0                      (0x0000)        /* Regulator remains on when going into LPM3 or LPM4 */
#define PMMREGOFF_1                      (0x0010)        /* Regulator is turned off when going to LPM3 or LPM4. System 
                                                            enters LPM3.5 or LPM4.5, respectively. */
#define PMMREGOFF_1_L                    (0x0010)
#define SVSHE                            (0x0040)        /* High-side SVS enable. */
#define SVSHE_L                          (0x0040)
#define SVSHE_0                          (0x0000)        /* High-side SVS (SVSH) is disabled in LPM2, LPM3, LPM4, LPM3.5, 
                                                            and LPM4.5. SVSH is always enabled in active mode, LPM0, and 
                                                            LPM1. */
#define SVSHE_1                          (0x0040)        /* SVSH is always enabled. */
#define SVSHE_1_L                        (0x0040)
#define PMMPW                            (0xa500)        /* PMM password. */
#define PMMPW_H                          (0x00a5)
#define PMMPW0                           (0x0100)        /* PMM password. */
#define PMMPW0_H                         (0x0001)
#define PMMPW1                           (0x0200)        /* PMM password. */
#define PMMPW1_H                         (0x0002)
#define PMMPW2                           (0x0400)        /* PMM password. */
#define PMMPW2_H                         (0x0004)
#define PMMPW3                           (0x0800)        /* PMM password. */
#define PMMPW3_H                         (0x0008)
#define PMMPW4                           (0x1000)        /* PMM password. */
#define PMMPW4_H                         (0x0010)
#define PMMPW5                           (0x2000)        /* PMM password. */
#define PMMPW5_H                         (0x0020)
#define PMMPW6                           (0x4000)        /* PMM password. */
#define PMMPW6_H                         (0x0040)
#define PMMPW7                           (0x8000)        /* PMM password. */
#define PMMPW7_H                         (0x0080)

/* PMMCTL2 Control Bits */
#define INTREFEN                         (0x0001)        /* */
#define INTREFEN_L                       (0x0001)
#define INTREFEN_0                       (0x0000)        /* Disable internal reference */
#define INTREFEN_1                       (0x0001)        /* Enable internal reference */
#define INTREFEN_1_L                     (0x0001)
#define EXTREFEN                         (0x0002)        /* */
#define EXTREFEN_L                       (0x0002)
#define EXTREFEN_0                       (0x0000)        /* Disable external reference output */
#define EXTREFEN_1                       (0x0002)        /* Enable internal reference output */
#define EXTREFEN_1_L                     (0x0002)
#define TSENSOREN                        (0x0008)        /* */
#define TSENSOREN_L                      (0x0008)
#define TSENSOREN_0                      (0x0000)        /* Disable temperature sensor */
#define TSENSOREN_1                      (0x0008)        /* Enable temperature sensor */
#define TSENSOREN_1_L                    (0x0008)
#define REFGENACT                        (0x0100)        /* */
#define REFGENACT_H                      (0x0001)
#define REFGENACT_0                      (0x0000)        /* Reference generator not active */
#define REFGENACT_1                      (0x0100)        /* Reference generator active */
#define REFGENACT_1_H                    (0x0001)
#define REFBGACT                         (0x0200)        /* */
#define REFBGACT_H                       (0x0002)
#define REFBGACT_0                       (0x0000)        /* Reference bandgap buffer not active */
#define REFBGACT_1                       (0x0200)        /* Reference bandgap buffer active */
#define REFBGACT_1_H                     (0x0002)
#define BGMODE                           (0x0800)        /* */
#define BGMODE_H                         (0x0008)
#define BGMODE_0                         (0x0000)        /* Static mode (higher precision) */
#define BGMODE_1                         (0x0800)        /* Sampled mode (lower power consumption) */
#define BGMODE_1_H                       (0x0008)
#define REFGENRDY                        (0x1000)        /* */
#define REFGENRDY_H                      (0x0010)
#define REFGENRDY_0                      (0x0000)        /* Reference voltage output is not ready to be used. */
#define REFGENRDY_1                      (0x1000)        /* Reference voltage output is ready to be used */
#define REFGENRDY_1_H                    (0x0010)
#define REFBGRDY                         (0x2000)        /* */
#define REFBGRDY_H                       (0x0020)
#define REFBGRDY_0                       (0x0000)        /* Buffered bandgap voltage is not ready to be used */
#define REFBGRDY_1                       (0x2000)        /* Buffered bandgap voltage is ready to be used */
#define REFBGRDY_1_H                     (0x0020)

/* PMMIFG Control Bits */
#define PMMBORIFG                        (0x0100)        /* PMM software brownout reset interrupt flag. */
#define PMMBORIFG_H                      (0x0001)
#define PMMBORIFG_0                      (0x0000)        /* Reset not due to PMMSWBOR */
#define PMMBORIFG_1                      (0x0100)        /* Reset due to PMMSWBOR */
#define PMMBORIFG_1_H                    (0x0001)
#define PMMRSTIFG                        (0x0200)        /* PMM reset pin interrupt flag. */
#define PMMRSTIFG_H                      (0x0002)
#define PMMRSTIFG_0                      (0x0000)        /* Reset not due to reset pin */
#define PMMRSTIFG_1                      (0x0200)        /* Reset due to reset pin */
#define PMMRSTIFG_1_H                    (0x0002)
#define PMMPORIFG                        (0x0400)        /* PMM software POR interrupt flag. */
#define PMMPORIFG_H                      (0x0004)
#define PMMPORIFG_0                      (0x0000)        /* Reset not due to PMMSWPOR */
#define PMMPORIFG_1                      (0x0400)        /* Reset due to PMMSWPOR */
#define PMMPORIFG_1_H                    (0x0004)
#define SVSHIFG                          (0x2000)        /* High-side SVS interrupt flag. */
#define SVSHIFG_H                        (0x0020)
#define SVSHIFG_0                        (0x0000)        /* Reset not due to SVSH */
#define SVSHIFG_1                        (0x2000)        /* Reset due to SVSH */
#define SVSHIFG_1_H                      (0x0020)
#define PMMLPM5IFG                       (0x8000)        /* LPMx.5 flag. */
#define PMMLPM5IFG_H                     (0x0080)
#define PMMLPM5IFG_0                     (0x0000)        /* Reset not due to wake-up from LPMx.5 */
#define PMMLPM5IFG_1                     (0x8000)        /* Reset due to wake-up from LPMx.5 */
#define PMMLPM5IFG_1_H                   (0x0080)

/* PM5CTL0 Control Bits */
#define LOCKLPM5                         (0x0001)        /* LPMx.5 Lock Bit */
#define LOCKLPM5_L                       (0x0001)
#define LOCKLPM5_0                       (0x0000)        /* LPMx.5 configuration is not locked and defaults to its reset 
                                                            condition. */
#define LOCKLPM5_1                       (0x0001)        /* LPMx.5 configuration remains locked. Pin state is held during 
                                                            LPMx.5 entry and exit. */
#define LOCKLPM5_1_L                     (0x0001)
#define LPM5SW                           (0x0010)        /* */
#define LPM5SW_L                         (0x0010)
#define LPM5SW_0                         (0x0000)        /* LPMx.5 switch disconnected */
#define LPM5SW_1                         (0x0010)        /* LPMx.5 switch connected */
#define LPM5SW_1_L                       (0x0010)
#define LPM5SM                           (0x0020)        /* */
#define LPM5SM_L                         (0x0020)
#define LPM5SM_0                         (0x0000)        /* Automatic mode for LPM3.5 switch that the switch is fully 
                                                            handled by the circuitry during mode switch. */
#define LPM5SM_1                         (0x0020)        /* Manual mode for LPM3.5 switch that the switch is specified by 
                                                            LPM5SW bit setting in software. */
#define LPM5SM_1_L                       (0x0020)


/*****************************************************************************
 RTC Registers
*****************************************************************************/

#define __MSP430_HAS_RTC__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_RTC__ 0x0300
#define RTC_BASE               __MSP430_BASEADDRESS_RTC__

sfr_w(RTCCTL);                                /* RTCCTL0 Register */
sfr_b(RTCCTL_L);
sfr_b(RTCCTL_H);
sfr_w(RTCIV);                                 /* Real-Time Clock Interrupt Vector Register */
sfr_b(RTCIV_L);
sfr_b(RTCIV_H);
sfr_w(RTCMOD);                                /* RTC Counter Modulo Register */
sfr_b(RTCMOD_L);
sfr_b(RTCMOD_H);
sfr_w(RTCCNT);                                /* RTC Counter Register */
sfr_b(RTCCNT_L);
sfr_b(RTCCNT_H);

/* RTC Register Offsets */
#define OFS_RTCCTL                       (0x0000)
#define OFS_RTCCTL_L                     OFS_RTCCTL
#define OFS_RTCCTL_H                     OFS_RTCCTL+1
#define OFS_RTCIV                        (0x0004)
#define OFS_RTCIV_L                      OFS_RTCIV
#define OFS_RTCIV_H                      OFS_RTCIV+1
#define OFS_RTCMOD                       (0x0008)
#define OFS_RTCMOD_L                     OFS_RTCMOD
#define OFS_RTCMOD_H                     OFS_RTCMOD+1
#define OFS_RTCCNT                       (0x000C)
#define OFS_RTCCNT_L                     OFS_RTCCNT
#define OFS_RTCCNT_H                     OFS_RTCCNT+1

/* RTC Control Bits */

/* RTCCTL Control Bits */
#define RTCIFG                           (0x0001)        /* */
#define RTCIFG_L                         (0x0001)
#define RTCIFG_0                         (0x0000)        /* No interrupt pending */
#define RTCIFG_1                         (0x0001)        /* Interrupt pending */
#define RTCIFG_1_L                       (0x0001)
#define RTCIE                            (0x0002)        /* */
#define RTCIE_L                          (0x0002)
#define RTCIE_0                          (0x0000)        /* Interrupt disabled */
#define RTCIE_1                          (0x0002)        /* Interrupt enabled */
#define RTCIE_1_L                        (0x0002)
#define RTCSR                            (0x0040)        /* */
#define RTCSR_L                          (0x0040)
#define RTCSR_0                          (0x0000)        /* Write 0 has no effect */
#define RTCSR_1                          (0x0040)        /* Write 1 to this bit clears the counter value and reloads the 
                                                            shadow register value from the modulo register at the next 
                                                            tick of the selected source clock. No overflow event or 
                                                            interrupt is generated. */
#define RTCSR_1_L                        (0x0040)
#define RTCPS                            (0x0700)        /* */
#define RTCPS_H                          (0x0007)
#define RTCPS0                           (0x0100)        /* */
#define RTCPS0_H                         (0x0001)
#define RTCPS1                           (0x0200)        /* */
#define RTCPS1_H                         (0x0002)
#define RTCPS2                           (0x0400)        /* */
#define RTCPS2_H                         (0x0004)
#define RTCPS_0                          (0x0000)        /* /1 */
#define RTCPS_1                          (0x0100)        /* /10 */
#define RTCPS_1_H                        (0x0001)
#define RTCPS_2                          (0x0200)        /* /100 */
#define RTCPS_2_H                        (0x0002)
#define RTCPS_3                          (0x0300)        /* /1000 */
#define RTCPS_3_H                        (0x0003)
#define RTCPS_4                          (0x0400)        /* /16 */
#define RTCPS_4_H                        (0x0004)
#define RTCPS_5                          (0x0500)        /* /64 */
#define RTCPS_5_H                        (0x0005)
#define RTCPS_6                          (0x0600)        /* /256 */
#define RTCPS_6_H                        (0x0006)
#define RTCPS_7                          (0x0700)        /* /1024 */
#define RTCPS_7_H                        (0x0007)
#define RTCPS__1                         (0x0000)        /* /1 */
#define RTCPS__10                        (0x0100)        /* /10 */
#define RTCPS__10_H                      (0x0001)
#define RTCPS__100                       (0x0200)        /* /100 */
#define RTCPS__100_H                     (0x0002)
#define RTCPS__1000                      (0x0300)        /* /1000 */
#define RTCPS__1000_H                    (0x0003)
#define RTCPS__16                        (0x0400)        /* /16 */
#define RTCPS__16_H                      (0x0004)
#define RTCPS__64                        (0x0500)        /* /64 */
#define RTCPS__64_H                      (0x0005)
#define RTCPS__256                       (0x0600)        /* /256 */
#define RTCPS__256_H                     (0x0006)
#define RTCPS__1024                      (0x0700)        /* /1024 */
#define RTCPS__1024_H                    (0x0007)
#define RTCSS                            (0x3000)        /* */
#define RTCSS_H                          (0x0030)
#define RTCSS0                           (0x1000)        /* */
#define RTCSS0_H                         (0x0010)
#define RTCSS1                           (0x2000)        /* */
#define RTCSS1_H                         (0x0020)
#define RTCSS_0                          (0x0000)        /* Disabled */
#define RTCSS_1                          (0x1000)        /* SMCLK */
#define RTCSS_1_H                        (0x0010)
#define RTCSS_2                          (0x2000)        /* XT1CLK */
#define RTCSS_2_H                        (0x0020)
#define RTCSS_3                          (0x3000)        /* VLOCLK */
#define RTCSS_3_H                        (0x0030)
#define RTCSS__DISABLED                  (0x0000)        /* Disabled */
#define RTCSS__SMCLK                     (0x1000)        /* SMCLK */
#define RTCSS__SMCLK_H                   (0x0010)
#define RTCSS__XT1CLK                    (0x2000)        /* XT1CLK */
#define RTCSS__XT1CLK_H                  (0x0020)
#define RTCSS__VLOCLK                    (0x3000)        /* VLOCLK */
#define RTCSS__VLOCLK_H                  (0x0030)

/* RTCIV Control Bits */
#define RTCIV0                           (0x0001)        /* Real-time clock interrupt vector value */
#define RTCIV0_L                         (0x0001)
#define RTCIV1                           (0x0002)        /* Real-time clock interrupt vector value */
#define RTCIV1_L                         (0x0002)
#define RTCIV2                           (0x0004)        /* Real-time clock interrupt vector value */
#define RTCIV2_L                         (0x0004)
#define RTCIV3                           (0x0008)        /* Real-time clock interrupt vector value */
#define RTCIV3_L                         (0x0008)
#define RTCIV4                           (0x0010)        /* Real-time clock interrupt vector value */
#define RTCIV4_L                         (0x0010)
#define RTCIV5                           (0x0020)        /* Real-time clock interrupt vector value */
#define RTCIV5_L                         (0x0020)
#define RTCIV6                           (0x0040)        /* Real-time clock interrupt vector value */
#define RTCIV6_L                         (0x0040)
#define RTCIV7                           (0x0080)        /* Real-time clock interrupt vector value */
#define RTCIV7_L                         (0x0080)
#define RTCIV8                           (0x0100)        /* Real-time clock interrupt vector value */
#define RTCIV8_H                         (0x0001)
#define RTCIV9                           (0x0200)        /* Real-time clock interrupt vector value */
#define RTCIV9_H                         (0x0002)
#define RTCIV10                          (0x0400)        /* Real-time clock interrupt vector value */
#define RTCIV10_H                        (0x0004)
#define RTCIV11                          (0x0800)        /* Real-time clock interrupt vector value */
#define RTCIV11_H                        (0x0008)
#define RTCIV12                          (0x1000)        /* Real-time clock interrupt vector value */
#define RTCIV12_H                        (0x0010)
#define RTCIV13                          (0x2000)        /* Real-time clock interrupt vector value */
#define RTCIV13_H                        (0x0020)
#define RTCIV14                          (0x4000)        /* Real-time clock interrupt vector value */
#define RTCIV14_H                        (0x0040)
#define RTCIV15                          (0x8000)        /* Real-time clock interrupt vector value */
#define RTCIV15_H                        (0x0080)
#define RTCIV_0                          (0x0000)        /* No interrupt pending */
#define RTCIV_2                          (0x0002)        /* upt Source: RTC Counter Overflow; Interrupt Flag: RTCIFG */
#define RTCIV_2_L                        (0x0002)
#define RTCIV__NONE                      (0x0000)        /* No interrupt pending */
#define RTCIV__RTCIFG                    (0x0002)        /* upt Source: RTC Counter Overflow; Interrupt Flag: RTCIFG */
#define RTCIV__RTCIFG_L                  (0x0002)


/*****************************************************************************
 SAC0 Registers
*****************************************************************************/

#define __MSP430_HAS_SAC0__                   /* Definition to show that module is available */
#ifndef __MSP430_HAS_SACx__
#define __MSP430_HAS_SACx__
#endif
#define __MSP430_BASEADDRESS_SAC0__ 0x0C80
#define SAC0_BASE              __MSP430_BASEADDRESS_SAC0__
#define __MSP430_HAS_SAC0_CONFIG__ 1          /* Definition to show the Module config */
#ifndef __MSP430_HAS_SACx_CONFIG_1__
#define __MSP430_HAS_SACx_CONFIG_1__
#endif

sfr_w(SAC0OA);                                /* SAC OA Control Register */
sfr_b(SAC0OA_L);
sfr_b(SAC0OA_H);

/* SAC0 Register Offsets */
#define OFS_SAC0OA                       (0x0000)
#define OFS_SAC0OA_L                     OFS_SAC0OA
#define OFS_SAC0OA_H                     OFS_SAC0OA+1

/* SAC0 Control Bits */

/* SAC0OA Control Bits */
#define PSEL                             (0x0003)        /* SAC OA Positive input source selection */
#define PSEL_L                           (0x0003)
#define PSEL0                            (0x0001)        /* SAC OA Positive input source selection */
#define PSEL0_L                          (0x0001)
#define PSEL1                            (0x0002)        /* SAC OA Positive input source selection */
#define PSEL1_L                          (0x0002)
#define PSEL_0                           (0x0000)        /* External source selected */
#define PSEL_1                           (0x0001)        /* 12-bit reference DAC source selected */
#define PSEL_1_L                         (0x0001)
#define PSEL_2                           (0x0002)        /* Pair OA source selected */
#define PSEL_2_L                         (0x0002)
#define PMUXEN                           (0x0008)        /* SAC Positive input MUX control. */
#define PMUXEN_L                         (0x0008)
#define PMUXEN_0                         (0x0000)        /* All positive input sources are disconnected to OA positive 
                                                            port */
#define PMUXEN_1                         (0x0008)        /* All positive input sources are connected to OA positive port */
#define PMUXEN_1_L                       (0x0008)
#define NSEL                             (0x0030)        /* SAC OA Negative input source selection */
#define NSEL_L                           (0x0030)
#define NSEL0                            (0x0010)        /* SAC OA Negative input source selection */
#define NSEL0_L                          (0x0010)
#define NSEL1                            (0x0020)        /* SAC OA Negative input source selection */
#define NSEL1_L                          (0x0020)
#define NSEL_0                           (0x0000)        /* External source selected */
#define NSEL_1                           (0x0010)        /* PGA source selected */
#define NSEL_1_L                         (0x0010)
#define NSEL_2                           (0x0020)        /* Device Specific */
#define NSEL_2_L                         (0x0020)
#define NMUXEN                           (0x0080)        /* SAC Negative input MUX controL */
#define NMUXEN_L                         (0x0080)
#define NMUXEN_0                         (0x0000)        /* All negative input sources are disconnected to OA negative 
                                                            port */
#define NMUXEN_1                         (0x0080)        /* All negative input sources are connected to OA negative port */
#define NMUXEN_1_L                       (0x0080)
#define OAEN                             (0x0100)        /* SAC OA Enable selection */
#define OAEN_H                           (0x0001)
#define OAEN_0                           (0x0000)        /* SAC OA is disabled, then the SAC OA output high impedance */
#define OAEN_1                           (0x0100)        /* SAC OA is enabled, normal mode */
#define OAEN_1_H                         (0x0001)
#define OAPM                             (0x0200)        /* SAC OA power mode selection */
#define OAPM_H                           (0x0002)
#define OAPM_0                           (0x0000)        /* High speed and high power */
#define OAPM_1                           (0x0200)        /* Llow speed and low power */
#define OAPM_1_H                         (0x0002)
#define SACEN                            (0x0400)        /* SAC Enable selection */
#define SACEN_H                          (0x0004)
#define SACEN_0                          (0x0000)        /* SAC all modules are disabled, then the SAC output high 
                                                            impedance */
#define SACEN_1                          (0x0400)        /* SAC all modules are enabled, normal mode */
#define SACEN_1_H                        (0x0004)


/*****************************************************************************
 SFR Registers
*****************************************************************************/

#define __MSP430_HAS_SFR__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SFR__ 0x0100
#define SFR_BASE               __MSP430_BASEADDRESS_SFR__

sfr_w(SFRIE1);                                /* Interrupt Enable */
sfr_b(SFRIE1_L);
sfr_b(SFRIE1_H);
sfr_w(SFRIFG1);                               /* Interrupt Flag */
sfr_b(SFRIFG1_L);
sfr_b(SFRIFG1_H);
sfr_w(SFRRPCR);                               /* Reset Pin Control */
sfr_b(SFRRPCR_L);
sfr_b(SFRRPCR_H);

/* SFR Register Offsets */
#define OFS_SFRIE1                       (0x0000)
#define OFS_SFRIE1_L                     OFS_SFRIE1
#define OFS_SFRIE1_H                     OFS_SFRIE1+1
#define OFS_SFRIFG1                      (0x0002)
#define OFS_SFRIFG1_L                    OFS_SFRIFG1
#define OFS_SFRIFG1_H                    OFS_SFRIFG1+1
#define OFS_SFRRPCR                      (0x0004)
#define OFS_SFRRPCR_L                    OFS_SFRRPCR
#define OFS_SFRRPCR_H                    OFS_SFRRPCR+1

/* SFR Control Bits */

/* SFRIE1 Control Bits */
#define WDTIE                            (0x0001)        /* Watchdog timer interrupt enable */
#define WDTIE_L                          (0x0001)
#define WDTIE_0                          (0x0000)        /* Interrupts disabled */
#define WDTIE_1                          (0x0001)        /* Interrupts enabled */
#define WDTIE_1_L                        (0x0001)
#define WDTIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define WDTIE__ENABLE                    (0x0001)        /* Interrupts enabled */
#define WDTIE__ENABLE_L                  (0x0001)
#define OFIE                             (0x0002)        /* Oscillator fault interrupt enable */
#define OFIE_L                           (0x0002)
#define OFIE_0                           (0x0000)        /* Interrupts disabled */
#define OFIE_1                           (0x0002)        /* Interrupts enabled */
#define OFIE_1_L                         (0x0002)
#define OFIE__DISABLE                    (0x0000)        /* Interrupts disabled */
#define OFIE__ENABLE                     (0x0002)        /* Interrupts enabled */
#define OFIE__ENABLE_L                   (0x0002)
#define VMAIE                            (0x0008)        /* Vacant memory access interrupt enable */
#define VMAIE_L                          (0x0008)
#define VMAIE_0                          (0x0000)        /* Interrupts disabled */
#define VMAIE_1                          (0x0008)        /* Interrupts enabled */
#define VMAIE_1_L                        (0x0008)
#define VMAIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define VMAIE__ENABLE                    (0x0008)        /* Interrupts enabled */
#define VMAIE__ENABLE_L                  (0x0008)
#define NMIIE                            (0x0010)        /* NMI pin interrupt enable */
#define NMIIE_L                          (0x0010)
#define NMIIE_0                          (0x0000)        /* Interrupts disabled */
#define NMIIE_1                          (0x0010)        /* Interrupts enabled */
#define NMIIE_1_L                        (0x0010)
#define NMIIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define NMIIE__ENABLE                    (0x0010)        /* Interrupts enabled */
#define NMIIE__ENABLE_L                  (0x0010)
#define JMBINIE                          (0x0040)        /* JTAG mailbox input interrupt enable */
#define JMBINIE_L                        (0x0040)
#define JMBINIE_0                        (0x0000)        /* Interrupts disabled */
#define JMBINIE_1                        (0x0040)        /* Interrupts enabled */
#define JMBINIE_1_L                      (0x0040)
#define JMBINIE__DISABLE                 (0x0000)        /* Interrupts disabled */
#define JMBINIE__ENABLE                  (0x0040)        /* Interrupts enabled */
#define JMBINIE__ENABLE_L                (0x0040)
#define JMBOUTIE                         (0x0080)        /* JTAG mailbox output interrupt enable */
#define JMBOUTIE_L                       (0x0080)
#define JMBOUTIE_0                       (0x0000)        /* Interrupts disabled */
#define JMBOUTIE_1                       (0x0080)        /* Interrupts enabled */
#define JMBOUTIE_1_L                     (0x0080)
#define JMBOUTIE__DISABLE                (0x0000)        /* Interrupts disabled */
#define JMBOUTIE__ENABLE                 (0x0080)        /* Interrupts enabled */
#define JMBOUTIE__ENABLE_L               (0x0080)

/* SFRIFG1 Control Bits */
#define OFIFG                            (0x0002)        /* Oscillator fault interrupt flag */
#define OFIFG_L                          (0x0002)
#define OFIFG_0                          (0x0000)        /* No interrupt pending */
#define OFIFG_1                          (0x0002)        /* Interrupt pending */
#define OFIFG_1_L                        (0x0002)
#define VMAIFG                           (0x0008)        /* Vacant memory access interrupt flag */
#define VMAIFG_L                         (0x0008)
#define VMAIFG_0                         (0x0000)        /* No interrupt pending */
#define VMAIFG_1                         (0x0008)        /* Interrupt pending */
#define VMAIFG_1_L                       (0x0008)
#define NMIIFG                           (0x0010)        /* NMI pin interrupt flag */
#define NMIIFG_L                         (0x0010)
#define NMIIFG_0                         (0x0000)        /* No interrupt pending */
#define NMIIFG_1                         (0x0010)        /* Interrupt pending */
#define NMIIFG_1_L                       (0x0010)
#define WDTIFG                           (0x0001)        /* Watchdog timer interrupt flag */
#define WDTIFG_L                         (0x0001)
#define WDTIFG_0                         (0x0000)        /* No interrupt pending */
#define WDTIFG_1                         (0x0001)        /* Interrupt pending */
#define WDTIFG_1_L                       (0x0001)
#define JMBINIFG                         (0x0040)        /* JTAG mailbox input interrupt flag */
#define JMBINIFG_L                       (0x0040)
#define JMBINIFG_0                       (0x0000)        /* No interrupt pending. When in 16-bit mode (JMBMODE = 0), this 
                                                            bit is cleared automatically when JMBI0 is read by the CPU. 
                                                            When in 32-bit mode (JMBMODE = 1), this bit is cleared 
                                                            automatically when both JMBI0 and JMBI1 have been read by the 
                                                            CPU. This bit is also cleared when the associated vector in 
                                                            SYSUNIV has been read */
#define JMBINIFG_1                       (0x0040)        /* Interrupt pending. A message is waiting in the JMBIN 
                                                            registers. In 16-bit mode (JMBMODE = 0) when JMBI0 has been 
                                                            written by the JTAG module. In 32-bit mode (JMBMODE = 1) when 
                                                            JMBI0 and JMBI1 have been written by the JTAG module. */
#define JMBINIFG_1_L                     (0x0040)
#define JMBOUTIFG                        (0x0080)        /* JTAG mailbox output interrupt flag */
#define JMBOUTIFG_L                      (0x0080)
#define JMBOUTIFG_0                      (0x0000)        /* No interrupt pending. When in 16-bit mode (JMBMODE = 0), this 
                                                            bit is cleared automatically when JMBO0 has been written with 
                                                            a new message to the JTAG module by the CPU. When in 32-bit 
                                                            mode (JMBMODE = 1), this bit is cleared automatically when 
                                                            both JMBO0 and JMBO1 have been written with new messages to 
                                                            the JTAG module by the CPU. This bit is also cleared when the 
                                                            associated vector in SYSUNIV has been read. */
#define JMBOUTIFG_1                      (0x0080)        /* Interrupt pending. JMBO registers are ready for new messages. 
                                                            In 16-bit mode (JMBMODE = 0), JMBO0 has been received by the 
                                                            JTAG module and is ready for a new message from the CPU. In 
                                                            32-bit mode (JMBMODE = 1), JMBO0 and JMBO1 have been received 
                                                            by the JTAG module and are ready for new messages from the 
                                                            CPU. */
#define JMBOUTIFG_1_L                    (0x0080)

/* SFRRPCR Control Bits */
#define SYSNMI                           (0x0001)        /* NMI select */
#define SYSNMI_L                         (0x0001)
#define SYSNMI_0                         (0x0000)        /* Reset function */
#define SYSNMI_1                         (0x0001)        /* NMI function */
#define SYSNMI_1_L                       (0x0001)
#define SYSNMI__RESET                    (0x0000)        /* Reset function */
#define SYSNMI__NMI                      (0x0001)        /* NMI function */
#define SYSNMI__NMI_L                    (0x0001)
#define SYSNMIIES                        (0x0002)        /* NMI edge select */
#define SYSNMIIES_L                      (0x0002)
#define SYSNMIIES_0                      (0x0000)        /* NMI on rising edge */
#define SYSNMIIES_1                      (0x0002)        /* NMI on falling edge */
#define SYSNMIIES_1_L                    (0x0002)
#define SYSNMIIES__RISING                (0x0000)        /* NMI on rising edge */
#define SYSNMIIES__FALLING               (0x0002)        /* NMI on falling edge */
#define SYSNMIIES__FALLING_L             (0x0002)
#define SYSRSTUP                         (0x0004)        /* Reset resistor pin pullup or pulldown */
#define SYSRSTUP_L                       (0x0004)
#define SYSRSTUP_0                       (0x0000)        /* Pulldown is selected */
#define SYSRSTUP_1                       (0x0004)        /* Pullup is selected */
#define SYSRSTUP_1_L                     (0x0004)
#define SYSRSTUP__PULLDOWN               (0x0000)        /* Pulldown is selected */
#define SYSRSTUP__PULLUP                 (0x0004)        /* Pullup is selected */
#define SYSRSTUP__PULLUP_L               (0x0004)
#define SYSRSTRE                         (0x0008)        /* Reset pin resistor enable */
#define SYSRSTRE_L                       (0x0008)
#define SYSRSTRE_0                       (0x0000)        /* Pullup or pulldown resistor at the RST/NMI pin is disabled */
#define SYSRSTRE_1                       (0x0008)        /* Pullup or pulldown resistor at the RST/NMI pin is enabled */
#define SYSRSTRE_1_L                     (0x0008)
#define SYSRSTRE__DISABLE                (0x0000)        /* Pullup or pulldown resistor at the RST/NMI pin is disabled */
#define SYSRSTRE__ENABLE                 (0x0008)        /* Pullup or pulldown resistor at the RST/NMI pin is enabled */
#define SYSRSTRE__ENABLE_L               (0x0008)


/*****************************************************************************
 SYS Registers
*****************************************************************************/

#define __MSP430_HAS_SYS__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SYS__ 0x0140
#define SYS_BASE               __MSP430_BASEADDRESS_SYS__

sfr_w(SYSCTL);                                /* System Control */
sfr_b(SYSCTL_L);
sfr_b(SYSCTL_H);
sfr_w(SYSBSLC);                               /* Bootstrap Loader Configuration Register */
sfr_b(SYSBSLC_L);
sfr_b(SYSBSLC_H);
sfr_w(SYSJMBC);                               /* JTAG Mailbox Control */
sfr_b(SYSJMBC_L);
sfr_b(SYSJMBC_H);
sfr_w(SYSJMBI0);                              /* JTAG Mailbox Input */
sfr_b(SYSJMBI0_L);
sfr_b(SYSJMBI0_H);
sfr_w(SYSJMBI1);                              /* JTAG Mailbox Input 1 Register */
sfr_b(SYSJMBI1_L);
sfr_b(SYSJMBI1_H);
sfr_w(SYSJMBO0);                              /* JTAG Mailbox Output */
sfr_b(SYSJMBO0_L);
sfr_b(SYSJMBO0_H);
sfr_w(SYSJMBO1);                              /* JTAG Mailbox Output 1 Register */
sfr_b(SYSJMBO1_L);
sfr_b(SYSJMBO1_H);
sfr_w(SYSUNIV);                               /* User NMI Vector Generator */
sfr_b(SYSUNIV_L);
sfr_b(SYSUNIV_H);
sfr_w(SYSSNIV);                               /* System NMI Vector Generator */
sfr_b(SYSSNIV_L);
sfr_b(SYSSNIV_H);
sfr_w(SYSRSTIV);                              /* Reset Vector Generator */
sfr_b(SYSRSTIV_L);
sfr_b(SYSRSTIV_H);
sfr_w(SYSCFG0);                               /* System Configuration Register 0 */
sfr_b(SYSCFG0_L);
sfr_b(SYSCFG0_H);
sfr_w(SYSCFG1);                               /* System Configuration Register 1 */
sfr_b(SYSCFG1_L);
sfr_b(SYSCFG1_H);
sfr_w(SYSCFG2);                               /* System Configuration Register 2 */
sfr_b(SYSCFG2_L);
sfr_b(SYSCFG2_H);

/* SYS Register Offsets */
#define OFS_SYSCTL                       (0x0000)
#define OFS_SYSCTL_L                     OFS_SYSCTL
#define OFS_SYSCTL_H                     OFS_SYSCTL+1
#define OFS_SYSBSLC                      (0x0002)
#define OFS_SYSBSLC_L                    OFS_SYSBSLC
#define OFS_SYSBSLC_H                    OFS_SYSBSLC+1
#define OFS_SYSJMBC                      (0x0006)
#define OFS_SYSJMBC_L                    OFS_SYSJMBC
#define OFS_SYSJMBC_H                    OFS_SYSJMBC+1
#define OFS_SYSJMBI0                     (0x0008)
#define OFS_SYSJMBI0_L                   OFS_SYSJMBI0
#define OFS_SYSJMBI0_H                   OFS_SYSJMBI0+1
#define OFS_SYSJMBI1                     (0x000A)
#define OFS_SYSJMBI1_L                   OFS_SYSJMBI1
#define OFS_SYSJMBI1_H                   OFS_SYSJMBI1+1
#define OFS_SYSJMBO0                     (0x000C)
#define OFS_SYSJMBO0_L                   OFS_SYSJMBO0
#define OFS_SYSJMBO0_H                   OFS_SYSJMBO0+1
#define OFS_SYSJMBO1                     (0x000E)
#define OFS_SYSJMBO1_L                   OFS_SYSJMBO1
#define OFS_SYSJMBO1_H                   OFS_SYSJMBO1+1
#define OFS_SYSUNIV                      (0x001A)
#define OFS_SYSUNIV_L                    OFS_SYSUNIV
#define OFS_SYSUNIV_H                    OFS_SYSUNIV+1
#define OFS_SYSSNIV                      (0x001C)
#define OFS_SYSSNIV_L                    OFS_SYSSNIV
#define OFS_SYSSNIV_H                    OFS_SYSSNIV+1
#define OFS_SYSRSTIV                     (0x001E)
#define OFS_SYSRSTIV_L                   OFS_SYSRSTIV
#define OFS_SYSRSTIV_H                   OFS_SYSRSTIV+1
#define OFS_SYSCFG0                      (0x0020)
#define OFS_SYSCFG0_L                    OFS_SYSCFG0
#define OFS_SYSCFG0_H                    OFS_SYSCFG0+1
#define OFS_SYSCFG1                      (0x0022)
#define OFS_SYSCFG1_L                    OFS_SYSCFG1
#define OFS_SYSCFG1_H                    OFS_SYSCFG1+1
#define OFS_SYSCFG2                      (0x0024)
#define OFS_SYSCFG2_L                    OFS_SYSCFG2
#define OFS_SYSCFG2_H                    OFS_SYSCFG2+1

/* SYS Control Bits */

/* SYSCTL Control Bits */
#define SYSRIVECT                        (0x0001)        /* RAM-based interrupt vectors */
#define SYSRIVECT_L                      (0x0001)
#define SYSRIVECT_0                      (0x0000)        /* Interrupt vectors generated with end address TOP of lower 64K 
                                                            FRAM FFFFh */
#define SYSRIVECT_1                      (0x0001)        /* Interrupt vectors generated with end address TOP of RAM, when 
                                                            RAM available */
#define SYSRIVECT_1_L                    (0x0001)
#define SYSRIVECT__FRAM                  (0x0000)        /* Interrupt vectors generated with end address TOP of lower 64K 
                                                            FRAM FFFFh */
#define SYSRIVECT__RAM                   (0x0001)        /* Interrupt vectors generated with end address TOP of RAM, when 
                                                            RAM available */
#define SYSRIVECT__RAM_L                 (0x0001)
#define SYSPMMPE                         (0x0004)        /* PMM access protect */
#define SYSPMMPE_L                       (0x0004)
#define SYSPMMPE_0                       (0x0000)        /* Access from anywhere in memory */
#define SYSPMMPE_1                       (0x0004)        /* Access only from the BSL segments */
#define SYSPMMPE_1_L                     (0x0004)
#define SYSBSLIND                        (0x0010)        /* BSL entry indication */
#define SYSBSLIND_L                      (0x0010)
#define SYSBSLIND_0                      (0x0000)        /* No BSL entry sequence detected */
#define SYSBSLIND_1                      (0x0010)        /* BSL entry sequence detected */
#define SYSBSLIND_1_L                    (0x0010)
#define SYSJTAGPIN                       (0x0020)        /* Dedicated JTAG pins enable */
#define SYSJTAGPIN_L                     (0x0020)
#define SYSJTAGPIN_0                     (0x0000)        /* Shared JTAG pins (JTAG mode selectable using SBW sequence) */
#define SYSJTAGPIN_1                     (0x0020)        /* Dedicated JTAG pins (explicit 4-wire JTAG mode selection) */
#define SYSJTAGPIN_1_L                   (0x0020)
#define SYSJTAGPIN__SHARED               (0x0000)        /* Shared JTAG pins (JTAG mode selectable using SBW sequence) */
#define SYSJTAGPIN__DEDICATED            (0x0020)        /* Dedicated JTAG pins (explicit 4-wire JTAG mode selection) */
#define SYSJTAGPIN__DEDICATED_L          (0x0020)

/* SYSBSLC Control Bits */
#define SYSBSLR                          (0x0004)        /* */
#define SYSBSLR_L                        (0x0004)
#define SYSBSLR_0                        (0x0000)        /* No RAM assigned to BSL area */
#define SYSBSLR_1                        (0x0004)        /* Lowest 16 bytes of RAM assigned to BSL */
#define SYSBSLR_1_L                      (0x0004)
#define SYSBSLOFF                        (0x4000)        /* */
#define SYSBSLOFF_H                      (0x0040)
#define SYSBSLOFF_0                      (0x0000)        /* BSL memory is addressed when this area is read. */
#define SYSBSLOFF_1                      (0x4000)        /* BSL memory behaves like vacant memory. Reads cause 3FFFh to be
                                                            read. Fetches cause JMP $ to be executed. */
#define SYSBSLOFF_1_H                    (0x0040)
#define SYSBSLPE                         (0x8000)        /* */
#define SYSBSLPE_H                       (0x0080)
#define SYSBSLPE_0                       (0x0000)        /* Area not protected. Read, program, and erase of BSL memory is 
                                                            possible. */
#define SYSBSLPE_1                       (0x8000)        /* Area protected */
#define SYSBSLPE_1_H                     (0x0080)

/* SYSJMBC Control Bits */
#define JMBIN0FG                         (0x0001)        /* Incoming JTAG Mailbox 0 flag */
#define JMBIN0FG_L                       (0x0001)
#define JMBIN0FG_0                       (0x0000)        /* JMBI0 has no new data */
#define JMBIN0FG_1                       (0x0001)        /* JMBI0 has new data available */
#define JMBIN0FG_1_L                     (0x0001)
#define JMBIN1FG                         (0x0002)        /* Incoming JTAG Mailbox 1 flag */
#define JMBIN1FG_L                       (0x0002)
#define JMBIN1FG_0                       (0x0000)        /* JMBI1 has no new data */
#define JMBIN1FG_1                       (0x0002)        /* JMBI1 has new data available */
#define JMBIN1FG_1_L                     (0x0002)
#define JMBOUT0FG                        (0x0004)        /* Outgoing JTAG Mailbox 0 flag */
#define JMBOUT0FG_L                      (0x0004)
#define JMBOUT0FG_0                      (0x0000)        /* JMBO0 is not ready to receive new data */
#define JMBOUT0FG_1                      (0x0004)        /* JMBO0 is ready to receive new data */
#define JMBOUT0FG_1_L                    (0x0004)
#define JMBOUT1FG                        (0x0008)        /* Outgoing JTAG Mailbox 1 flag */
#define JMBOUT1FG_L                      (0x0008)
#define JMBOUT1FG_0                      (0x0000)        /* JMBO1 is not ready to receive new data */
#define JMBOUT1FG_1                      (0x0008)        /* JMBO1 is ready to receive new data */
#define JMBOUT1FG_1_L                    (0x0008)
#define JMBMODE                          (0x0010)        /* Operation mode of JMB */
#define JMBMODE_L                        (0x0010)
#define JMBMODE_0                        (0x0000)        /* 16-bit transfers using JMBO0 and JMBI0 only */
#define JMBMODE_1                        (0x0010)        /* 32-bit transfers using JMBO0 with JMBO1 and JMBI0 with JMBI1 */
#define JMBMODE_1_L                      (0x0010)
#define JMBMODE__16BIT                   (0x0000)        /* 16-bit transfers using JMBO0 and JMBI0 only */
#define JMBMODE__32BIT                   (0x0010)        /* 32-bit transfers using JMBO0 with JMBO1 and JMBI0 with JMBI1 */
#define JMBMODE__32BIT_L                 (0x0010)
#define JMBCLR0OFF                       (0x0040)        /* Incoming JTAG Mailbox 0 flag auto-clear disable */
#define JMBCLR0OFF_L                     (0x0040)
#define JMBCLR0OFF_0                     (0x0000)        /* JMBIN0FG cleared on read of JMB0IN register */
#define JMBCLR0OFF_1                     (0x0040)        /* JMBIN0FG cleared by software */
#define JMBCLR0OFF_1_L                   (0x0040)
#define JMBCLR1OFF                       (0x0080)        /* Incoming JTAG Mailbox 1 flag auto-clear disable */
#define JMBCLR1OFF_L                     (0x0080)
#define JMBCLR1OFF_0                     (0x0000)        /* JMBIN1FG cleared on read of JMB1IN register */
#define JMBCLR1OFF_1                     (0x0080)        /* JMBIN1FG cleared by software */
#define JMBCLR1OFF_1_L                   (0x0080)

/* SYSJMBI0 Control Bits */
#define MSGLO                            (0x00ff)        /* JTAG mailbox incoming message low byte */
#define MSGLO_L                          (0x00ff)
#define MSGLO0                           (0x0001)        /* JTAG mailbox incoming message low byte */
#define MSGLO0_L                         (0x0001)
#define MSGLO1                           (0x0002)        /* JTAG mailbox incoming message low byte */
#define MSGLO1_L                         (0x0002)
#define MSGLO2                           (0x0004)        /* JTAG mailbox incoming message low byte */
#define MSGLO2_L                         (0x0004)
#define MSGLO3                           (0x0008)        /* JTAG mailbox incoming message low byte */
#define MSGLO3_L                         (0x0008)
#define MSGLO4                           (0x0010)        /* JTAG mailbox incoming message low byte */
#define MSGLO4_L                         (0x0010)
#define MSGLO5                           (0x0020)        /* JTAG mailbox incoming message low byte */
#define MSGLO5_L                         (0x0020)
#define MSGLO6                           (0x0040)        /* JTAG mailbox incoming message low byte */
#define MSGLO6_L                         (0x0040)
#define MSGLO7                           (0x0080)        /* JTAG mailbox incoming message low byte */
#define MSGLO7_L                         (0x0080)
#define MSGHI                            (0xff00)        /* JTAG mailbox incoming message high byte */
#define MSGHI_H                          (0x00ff)
#define MSGHI0                           (0x0100)        /* JTAG mailbox incoming message high byte */
#define MSGHI0_H                         (0x0001)
#define MSGHI1                           (0x0200)        /* JTAG mailbox incoming message high byte */
#define MSGHI1_H                         (0x0002)
#define MSGHI2                           (0x0400)        /* JTAG mailbox incoming message high byte */
#define MSGHI2_H                         (0x0004)
#define MSGHI3                           (0x0800)        /* JTAG mailbox incoming message high byte */
#define MSGHI3_H                         (0x0008)
#define MSGHI4                           (0x1000)        /* JTAG mailbox incoming message high byte */
#define MSGHI4_H                         (0x0010)
#define MSGHI5                           (0x2000)        /* JTAG mailbox incoming message high byte */
#define MSGHI5_H                         (0x0020)
#define MSGHI6                           (0x4000)        /* JTAG mailbox incoming message high byte */
#define MSGHI6_H                         (0x0040)
#define MSGHI7                           (0x8000)        /* JTAG mailbox incoming message high byte */
#define MSGHI7_H                         (0x0080)

/* SYSUNIV Control Bits */
#define SYSUNIV0                         (0x0001)        /* User NMI vector */
#define SYSUNIV0_L                       (0x0001)
#define SYSUNIV1                         (0x0002)        /* User NMI vector */
#define SYSUNIV1_L                       (0x0002)
#define SYSUNIV2                         (0x0004)        /* User NMI vector */
#define SYSUNIV2_L                       (0x0004)
#define SYSUNIV3                         (0x0008)        /* User NMI vector */
#define SYSUNIV3_L                       (0x0008)
#define SYSUNIV4                         (0x0010)        /* User NMI vector */
#define SYSUNIV4_L                       (0x0010)
#define SYSUNIV5                         (0x0020)        /* User NMI vector */
#define SYSUNIV5_L                       (0x0020)
#define SYSUNIV6                         (0x0040)        /* User NMI vector */
#define SYSUNIV6_L                       (0x0040)
#define SYSUNIV7                         (0x0080)        /* User NMI vector */
#define SYSUNIV7_L                       (0x0080)
#define SYSUNIV8                         (0x0100)        /* User NMI vector */
#define SYSUNIV8_H                       (0x0001)
#define SYSUNIV9                         (0x0200)        /* User NMI vector */
#define SYSUNIV9_H                       (0x0002)
#define SYSUNIV10                        (0x0400)        /* User NMI vector */
#define SYSUNIV10_H                      (0x0004)
#define SYSUNIV11                        (0x0800)        /* User NMI vector */
#define SYSUNIV11_H                      (0x0008)
#define SYSUNIV12                        (0x1000)        /* User NMI vector */
#define SYSUNIV12_H                      (0x0010)
#define SYSUNIV13                        (0x2000)        /* User NMI vector */
#define SYSUNIV13_H                      (0x0020)
#define SYSUNIV14                        (0x4000)        /* User NMI vector */
#define SYSUNIV14_H                      (0x0040)
#define SYSUNIV15                        (0x8000)        /* User NMI vector */
#define SYSUNIV15_H                      (0x0080)
#define SYSUNIV_0                        (0x0000)        /* No interrupt pending */
#define SYSUNIV_2                        (0x0002)        /* NMIIFG NMI pin */
#define SYSUNIV_2_L                      (0x0002)
#define SYSUNIV_4                        (0x0004)        /* OFIFG oscillator fault */
#define SYSUNIV_4_L                      (0x0004)
#define SYSUNIV__NONE                    (0x0000)        /* No interrupt pending */
#define SYSUNIV__NMIIFG                  (0x0002)        /* NMIIFG NMI pin */
#define SYSUNIV__NMIIFG_L                (0x0002)
#define SYSUNIV__OFIFG                   (0x0004)        /* OFIFG oscillator fault */
#define SYSUNIV__OFIFG_L                 (0x0004)

/* SYSSNIV Control Bits */
#define SYSSNIV0                         (0x0001)        /* System NMI vector */
#define SYSSNIV0_L                       (0x0001)
#define SYSSNIV1                         (0x0002)        /* System NMI vector */
#define SYSSNIV1_L                       (0x0002)
#define SYSSNIV2                         (0x0004)        /* System NMI vector */
#define SYSSNIV2_L                       (0x0004)
#define SYSSNIV3                         (0x0008)        /* System NMI vector */
#define SYSSNIV3_L                       (0x0008)
#define SYSSNIV4                         (0x0010)        /* System NMI vector */
#define SYSSNIV4_L                       (0x0010)
#define SYSSNIV5                         (0x0020)        /* System NMI vector */
#define SYSSNIV5_L                       (0x0020)
#define SYSSNIV6                         (0x0040)        /* System NMI vector */
#define SYSSNIV6_L                       (0x0040)
#define SYSSNIV7                         (0x0080)        /* System NMI vector */
#define SYSSNIV7_L                       (0x0080)
#define SYSSNIV8                         (0x0100)        /* System NMI vector */
#define SYSSNIV8_H                       (0x0001)
#define SYSSNIV9                         (0x0200)        /* System NMI vector */
#define SYSSNIV9_H                       (0x0002)
#define SYSSNIV10                        (0x0400)        /* System NMI vector */
#define SYSSNIV10_H                      (0x0004)
#define SYSSNIV11                        (0x0800)        /* System NMI vector */
#define SYSSNIV11_H                      (0x0008)
#define SYSSNIV12                        (0x1000)        /* System NMI vector */
#define SYSSNIV12_H                      (0x0010)
#define SYSSNIV13                        (0x2000)        /* System NMI vector */
#define SYSSNIV13_H                      (0x0020)
#define SYSSNIV14                        (0x4000)        /* System NMI vector */
#define SYSSNIV14_H                      (0x0040)
#define SYSSNIV15                        (0x8000)        /* System NMI vector */
#define SYSSNIV15_H                      (0x0080)
#define SYSSNIV_0                        (0x0000)        /* No interrupt pending */
#define SYSSNIV_2                        (0x0002)        /* SVS low-power reset entry */
#define SYSSNIV_2_L                      (0x0002)
#define SYSSNIV_4                        (0x0004)        /* Uncorrectable FRAM bit error detection */
#define SYSSNIV_4_L                      (0x0004)
#define SYSSNIV_6                        (0x0006)        /* FRAM Access Time Error */
#define SYSSNIV_6_L                      (0x0006)
#define SYSSNIV_8                        (0x0008)        /* Reserved */
#define SYSSNIV_8_L                      (0x0008)
#define SYSSNIV_10                       (0x000a)        /* Reserved */
#define SYSSNIV_10_L                     (0x000a)
#define SYSSNIV_12                       (0x000c)        /* Reserved */
#define SYSSNIV_12_L                     (0x000c)
#define SYSSNIV_14                       (0x000e)        /* Reserved */
#define SYSSNIV_14_L                     (0x000e)
#define SYSSNIV_16                       (0x0010)        /* Reserved */
#define SYSSNIV_16_L                     (0x0010)
#define SYSSNIV_18                       (0x0012)        /* VMAIFG Vacant memory access */
#define SYSSNIV_18_L                     (0x0012)
#define SYSSNIV_20                       (0x0014)        /* JMBINIFG JTAG mailbox input */
#define SYSSNIV_20_L                     (0x0014)
#define SYSSNIV_22                       (0x0016)        /* JMBOUTIFG JTAG mailbox output */
#define SYSSNIV_22_L                     (0x0016)
#define SYSSNIV_24                       (0x0018)        /* Correctable FRAM bit error detection */
#define SYSSNIV_24_L                     (0x0018)
#define SYSSNIV__NONE                    (0x0000)        /* No interrupt pending */
#define SYSSNIV__SVSLIFG                 (0x0002)        /* SVS low-power reset entry */
#define SYSSNIV__SVSLIFG_L               (0x0002)
#define SYSSNIV__UBDIFG                  (0x0004)        /* Uncorrectable FRAM bit error detection */
#define SYSSNIV__UBDIFG_L                (0x0004)
#define SYSSNIV__ACCTEIFG                (0x0006)        /* FRAM Access Time Error */
#define SYSSNIV__ACCTEIFG_L              (0x0006)
#define SYSSNIV__VMAIFG                  (0x0012)        /* VMAIFG Vacant memory access */
#define SYSSNIV__VMAIFG_L                (0x0012)
#define SYSSNIV__JMBINIFG                (0x0014)        /* JMBINIFG JTAG mailbox input */
#define SYSSNIV__JMBINIFG_L              (0x0014)
#define SYSSNIV__JMBOUTIFG               (0x0016)        /* JMBOUTIFG JTAG mailbox output */
#define SYSSNIV__JMBOUTIFG_L             (0x0016)
#define SYSSNIV__CBDIFG                  (0x0018)        /* Correctable FRAM bit error detection */
#define SYSSNIV__CBDIFG_L                (0x0018)

/* SYSRSTIV Control Bits */
#define SYSRSTIV0                        (0x0001)        /* Reset interrupt vector */
#define SYSRSTIV0_L                      (0x0001)
#define SYSRSTIV1                        (0x0002)        /* Reset interrupt vector */
#define SYSRSTIV1_L                      (0x0002)
#define SYSRSTIV2                        (0x0004)        /* Reset interrupt vector */
#define SYSRSTIV2_L                      (0x0004)
#define SYSRSTIV3                        (0x0008)        /* Reset interrupt vector */
#define SYSRSTIV3_L                      (0x0008)
#define SYSRSTIV4                        (0x0010)        /* Reset interrupt vector */
#define SYSRSTIV4_L                      (0x0010)
#define SYSRSTIV5                        (0x0020)        /* Reset interrupt vector */
#define SYSRSTIV5_L                      (0x0020)
#define SYSRSTIV6                        (0x0040)        /* Reset interrupt vector */
#define SYSRSTIV6_L                      (0x0040)
#define SYSRSTIV7                        (0x0080)        /* Reset interrupt vector */
#define SYSRSTIV7_L                      (0x0080)
#define SYSRSTIV8                        (0x0100)        /* Reset interrupt vector */
#define SYSRSTIV8_H                      (0x0001)
#define SYSRSTIV9                        (0x0200)        /* Reset interrupt vector */
#define SYSRSTIV9_H                      (0x0002)
#define SYSRSTIV10                       (0x0400)        /* Reset interrupt vector */
#define SYSRSTIV10_H                     (0x0004)
#define SYSRSTIV11                       (0x0800)        /* Reset interrupt vector */
#define SYSRSTIV11_H                     (0x0008)
#define SYSRSTIV12                       (0x1000)        /* Reset interrupt vector */
#define SYSRSTIV12_H                     (0x0010)
#define SYSRSTIV13                       (0x2000)        /* Reset interrupt vector */
#define SYSRSTIV13_H                     (0x0020)
#define SYSRSTIV14                       (0x4000)        /* Reset interrupt vector */
#define SYSRSTIV14_H                     (0x0040)
#define SYSRSTIV15                       (0x8000)        /* Reset interrupt vector */
#define SYSRSTIV15_H                     (0x0080)
#define SYSRSTIV_0                       (0x0000)        /* No interrupt pending */
#define SYSRSTIV_2                       (0x0002)        /* Brownout */
#define SYSRSTIV_2_L                     (0x0002)
#define SYSRSTIV_4                       (0x0004)        /* RSTIFG RST/NMI */
#define SYSRSTIV_4_L                     (0x0004)
#define SYSRSTIV_6                       (0x0006)        /* PMMSWBOR software BOR */
#define SYSRSTIV_6_L                     (0x0006)
#define SYSRSTIV_8                       (0x0008)        /* LPMx.5 wakeup */
#define SYSRSTIV_8_L                     (0x0008)
#define SYSRSTIV_10                      (0x000a)        /* Security violation */
#define SYSRSTIV_10_L                    (0x000a)
#define SYSRSTIV_12                      (0x000c)        /* Reserved */
#define SYSRSTIV_12_L                    (0x000c)
#define SYSRSTIV_14                      (0x000e)        /* SVSHIFG SVSH event */
#define SYSRSTIV_14_L                    (0x000e)
#define SYSRSTIV_16                      (0x0010)        /* Reserved */
#define SYSRSTIV_16_L                    (0x0010)
#define SYSRSTIV_18                      (0x0012)        /* Reserved */
#define SYSRSTIV_18_L                    (0x0012)
#define SYSRSTIV_20                      (0x0014)        /* PMMSWPOR software POR */
#define SYSRSTIV_20_L                    (0x0014)
#define SYSRSTIV_22                      (0x0016)        /* WDTIFG watchdog timeout */
#define SYSRSTIV_22_L                    (0x0016)
#define SYSRSTIV_24                      (0x0018)        /* WDTPW watchdog password violation */
#define SYSRSTIV_24_L                    (0x0018)
#define SYSRSTIV_26                      (0x001a)        /* FRCTLPW password violation */
#define SYSRSTIV_26_L                    (0x001a)
#define SYSRSTIV_28                      (0x001c)        /* Uncorrectable FRAM bit error detection */
#define SYSRSTIV_28_L                    (0x001c)
#define SYSRSTIV_30                      (0x001e)        /* Peripheral area fetch */
#define SYSRSTIV_30_L                    (0x001e)
#define SYSRSTIV_32                      (0x0020)        /* PMM password violation */
#define SYSRSTIV_32_L                    (0x0020)
#define SYSRSTIV_34                      (0x0022)        /* Reserved */
#define SYSRSTIV_34_L                    (0x0022)
#define SYSRSTIV_36                      (0x0024)        /* FLL unlock (PUC) */
#define SYSRSTIV_36_L                    (0x0024)
#define SYSRSTIV__NONE                   (0x0000)        /* No interrupt pending */
#define SYSRSTIV__BOR                    (0x0002)        /* Brownout */
#define SYSRSTIV__BOR_L                  (0x0002)
#define SYSRSTIV__RSTNMI                 (0x0004)        /* RSTIFG RST/NMI */
#define SYSRSTIV__RSTNMI_L               (0x0004)
#define SYSRSTIV__PMMSWBOR               (0x0006)        /* PMMSWBOR software BOR */
#define SYSRSTIV__PMMSWBOR_L             (0x0006)
#define SYSRSTIV__LPM5WU                 (0x0008)        /* LPMx.5 wakeup */
#define SYSRSTIV__LPM5WU_L               (0x0008)
#define SYSRSTIV__SECYV                  (0x000a)        /* Security violation */
#define SYSRSTIV__SECYV_L                (0x000a)
#define SYSRSTIV__SVSHIFG                (0x000e)        /* SVSHIFG SVSH event */
#define SYSRSTIV__SVSHIFG_L              (0x000e)
#define SYSRSTIV__PMMSWPOR               (0x0014)        /* PMMSWPOR software POR */
#define SYSRSTIV__PMMSWPOR_L             (0x0014)
#define SYSRSTIV__WDTIFG                 (0x0016)        /* WDTIFG watchdog timeout */
#define SYSRSTIV__WDTIFG_L               (0x0016)
#define SYSRSTIV__WDTPW                  (0x0018)        /* WDTPW watchdog password violation */
#define SYSRSTIV__WDTPW_L                (0x0018)
#define SYSRSTIV__FRCTLPW                (0x001a)        /* FRCTLPW password violation */
#define SYSRSTIV__FRCTLPW_L              (0x001a)
#define SYSRSTIV__UBDIFG                 (0x001c)        /* Uncorrectable FRAM bit error detection */
#define SYSRSTIV__UBDIFG_L               (0x001c)
#define SYSRSTIV__PERF                   (0x001e)        /* Peripheral area fetch */
#define SYSRSTIV__PERF_L                 (0x001e)
#define SYSRSTIV__PMMPW                  (0x0020)        /* PMM password violation */
#define SYSRSTIV__PMMPW_L                (0x0020)
#define SYSRSTIV__FLLUL                  (0x0024)        /* FLL unlock (PUC) */
#define SYSRSTIV__FLLUL_L                (0x0024)

/* SYSCFG0 Control Bits */
#define PFWP                             (0x0001)        /* */
#define PFWP_L                           (0x0001)
#define PFWP_0                           (0x0000)        /* Program FRAM write enable */
#define PFWP_1                           (0x0001)        /* Program FRAM write protected (not writable) */
#define PFWP_1_L                         (0x0001)
#define FRWPPW                           (0xa500)        /* FRAM protection password */
#define FRWPPW_H                         (0x00a5)
#define FRWPPW0                          (0x0100)        /* FRAM protection password */
#define FRWPPW0_H                        (0x0001)
#define FRWPPW1                          (0x0200)        /* FRAM protection password */
#define FRWPPW1_H                        (0x0002)
#define FRWPPW2                          (0x0400)        /* FRAM protection password */
#define FRWPPW2_H                        (0x0004)
#define FRWPPW3                          (0x0800)        /* FRAM protection password */
#define FRWPPW3_H                        (0x0008)
#define FRWPPW4                          (0x1000)        /* FRAM protection password */
#define FRWPPW4_H                        (0x0010)
#define FRWPPW5                          (0x2000)        /* FRAM protection password */
#define FRWPPW5_H                        (0x0020)
#define FRWPPW6                          (0x4000)        /* FRAM protection password */
#define FRWPPW6_H                        (0x0040)
#define FRWPPW7                          (0x8000)        /* FRAM protection password */
#define FRWPPW7_H                        (0x0080)

/* SYSCFG1 Control Bits */
#define IREN                             (0x0001)        /* */
#define IREN_L                           (0x0001)
#define IREN_0                           (0x0000)        /* Infrared function disabled */
#define IREN_1                           (0x0001)        /* Infrared function enabled */
#define IREN_1_L                         (0x0001)
#define IRPSEL                           (0x0002)        /* */
#define IRPSEL_L                         (0x0002)
#define IRPSEL_0                         (0x0000)        /* Normal polarity */
#define IRPSEL_1                         (0x0002)        /* Inverted polarity */
#define IRPSEL_1_L                       (0x0002)
#define IRMSEL                           (0x0004)        /* */
#define IRMSEL_L                         (0x0004)
#define IRMSEL_0                         (0x0000)        /* FSK mode */
#define IRMSEL_1                         (0x0004)        /* ASK mode */
#define IRMSEL_1_L                       (0x0004)
#define IRDSSEL                          (0x0008)        /* */
#define IRDSSEL_L                        (0x0008)
#define IRDSSEL_0                        (0x0000)        /* From hardware peripherals upon device configuration */
#define IRDSSEL_1                        (0x0008)        /* From IRDATA bit */
#define IRDSSEL_1_L                      (0x0008)
#define IRDATA                           (0x0010)        /* */
#define IRDATA_L                         (0x0010)
#define IRDATA_0                         (0x0000)        /* Infrared data logic 0 */
#define IRDATA_1                         (0x0010)        /* Infrared data logic 1 */
#define IRDATA_1_L                       (0x0010)

/* SYSCFG2 Control Bits */
#define RTCCKSEL                         (0x0400)        /* RTC clock selection */
#define RTCCKSEL_H                       (0x0004)
#define RTCCKSEL_0                       (0x0000)        /* SMCLK is selected */
#define RTCCKSEL_1                       (0x0400)        /* ACLK is selected */
#define RTCCKSEL_1_H                     (0x0004)
#define RTCCKSEL__SMCLK                  (0x0000)        /* SMCLK is selected */
#define RTCCKSEL__ACLK                   (0x0400)        /* ACLK is selected */
#define RTCCKSEL__ACLK_H                 (0x0004)
#define USCIBRMP                         (0x0800)        /* eUSCIB Remapping source selection */
#define USCIBRMP_H                       (0x0008)
#define USCIBRMP_0                       (0x0000)        /* P1.0 - P1.3 is selected */
#define USCIBRMP_1                       (0x0800)        /* P2.2 - P2.5 is selected */
#define USCIBRMP_1_H                     (0x0008)
#define TB1TRGSEL                        (0x4000)        /* TB1OUTH trigger source selection */
#define TB1TRGSEL_H                      (0x0040)
#define TB1TRGSEL_0                      (0x0000)        /* Internal source selected */
#define TB1TRGSEL_1                      (0x4000)        /* External source selected */
#define TB1TRGSEL_1_H                    (0x0040)
#define TB1TRGSEL__INTERNAL              (0x0000)        /* Internal source selected */
#define TB1TRGSEL__EXTERNAL              (0x4000)        /* External source selected */
#define TB1TRGSEL__EXTERNAL_H            (0x0040)
#define TB0TRGSEL                        (0x8000)        /* TB0OUTH trigger source selection */
#define TB0TRGSEL_H                      (0x0080)
#define TB0TRGSEL_0                      (0x0000)        /* Internal source selected */
#define TB0TRGSEL_1                      (0x8000)        /* External source selected */
#define TB0TRGSEL_1_H                    (0x0080)
#define TB0TRGSEL__INTERNAL              (0x0000)        /* Internal source selected */
#define TB0TRGSEL__EXTERNAL              (0x8000)        /* External source selected */
#define TB0TRGSEL__EXTERNAL_H            (0x0080)


/*****************************************************************************
 TB0 Registers
*****************************************************************************/

#define __MSP430_HAS_TB0__ 3                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TBx__
#define __MSP430_HAS_TBx__
#endif
#define __MSP430_BASEADDRESS_TB0__ 0x0380
#define TB0_BASE               __MSP430_BASEADDRESS_TB0__

sfr_w(TB0CTL);                                /* Timer_B Control Register */
sfr_b(TB0CTL_L);
sfr_b(TB0CTL_H);
sfr_w(TB0CCTL0);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL0_L);
sfr_b(TB0CCTL0_H);
sfr_w(TB0CCTL1);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL1_L);
sfr_b(TB0CCTL1_H);
sfr_w(TB0CCTL2);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL2_L);
sfr_b(TB0CCTL2_H);
sfr_w(TB0R);                                  /* Timer_B count register */
sfr_b(TB0R_L);
sfr_b(TB0R_H);
sfr_w(TB0CCR0);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR0_L);
sfr_b(TB0CCR0_H);
sfr_w(TB0CCR1);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR1_L);
sfr_b(TB0CCR1_H);
sfr_w(TB0CCR2);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR2_L);
sfr_b(TB0CCR2_H);
sfr_w(TB0EX0);                                /* Timer_Bx Expansion Register 0 */
sfr_b(TB0EX0_L);
sfr_b(TB0EX0_H);
sfr_w(TB0IV);                                 /* Timer_Bx Interrupt Vector Register */
sfr_b(TB0IV_L);
sfr_b(TB0IV_H);

/* TB0 Register Offsets */
#define OFS_TB0CTL                       (0x0000)
#define OFS_TB0CTL_L                     OFS_TB0CTL
#define OFS_TB0CTL_H                     OFS_TB0CTL+1
#define OFS_TB0CCTL0                     (0x0002)
#define OFS_TB0CCTL0_L                   OFS_TB0CCTL0
#define OFS_TB0CCTL0_H                   OFS_TB0CCTL0+1
#define OFS_TB0CCTL1                     (0x0004)
#define OFS_TB0CCTL1_L                   OFS_TB0CCTL1
#define OFS_TB0CCTL1_H                   OFS_TB0CCTL1+1
#define OFS_TB0CCTL2                     (0x0006)
#define OFS_TB0CCTL2_L                   OFS_TB0CCTL2
#define OFS_TB0CCTL2_H                   OFS_TB0CCTL2+1
#define OFS_TB0R                         (0x0010)
#define OFS_TB0R_L                       OFS_TB0R
#define OFS_TB0R_H                       OFS_TB0R+1
#define OFS_TB0CCR0                      (0x0012)
#define OFS_TB0CCR0_L                    OFS_TB0CCR0
#define OFS_TB0CCR0_H                    OFS_TB0CCR0+1
#define OFS_TB0CCR1                      (0x0014)
#define OFS_TB0CCR1_L                    OFS_TB0CCR1
#define OFS_TB0CCR1_H                    OFS_TB0CCR1+1
#define OFS_TB0CCR2                      (0x0016)
#define OFS_TB0CCR2_L                    OFS_TB0CCR2
#define OFS_TB0CCR2_H                    OFS_TB0CCR2+1
#define OFS_TB0EX0                       (0x0020)
#define OFS_TB0EX0_L                     OFS_TB0EX0
#define OFS_TB0EX0_H                     OFS_TB0EX0+1
#define OFS_TB0IV                        (0x002E)
#define OFS_TB0IV_L                      OFS_TB0IV
#define OFS_TB0IV_H                      OFS_TB0IV+1

/* TB0 Control Bits */

/* TB0CTL Control Bits */
#define TBIFG                            (0x0001)        /* TimerB interrupt flag */
#define TBIFG_L                          (0x0001)
#define TBIFG_0                          (0x0000)        /* No interrupt pending */
#define TBIFG_1                          (0x0001)        /* Interrupt pending */
#define TBIFG_1_L                        (0x0001)
#define TBIE                             (0x0002)        /* TimerB interrupt enable */
#define TBIE_L                           (0x0002)
#define TBIE_0                           (0x0000)        /* Interrupt disabled */
#define TBIE_1                           (0x0002)        /* Interrupt enabled */
#define TBIE_1_L                         (0x0002)
#define TBCLR                            (0x0004)        /* TimerB clear */
#define TBCLR_L                          (0x0004)
#define MC                               (0x0030)        /* Mode control */
#define MC_L                             (0x0030)
#define MC0                              (0x0010)        /* Mode control */
#define MC0_L                            (0x0010)
#define MC1                              (0x0020)        /* Mode control */
#define MC1_L                            (0x0020)
#define MC_0                             (0x0000)        /* Stop mode: Timer is halted */
#define MC_1                             (0x0010)        /* Up mode: Timer counts up to TBxCL0 */
#define MC_1_L                           (0x0010)
#define MC_2                             (0x0020)        /* Continuous mode: Timer counts up to the value set by CNTL */
#define MC_2_L                           (0x0020)
#define MC_3                             (0x0030)        /* Up/down mode: Timer counts up to TBxCL0 then down to 0000h */
#define MC_3_L                           (0x0030)
#define MC__STOP                         (0x0000)        /* Stop mode: Timer is halted */
#define MC__UP                           (0x0010)        /* Up mode: Timer counts up to TBxCL0 */
#define MC__UP_L                         (0x0010)
#define MC__CONTINUOUS                   (0x0020)        /* Continuous mode: Timer counts up to the value set by CNTL */
#define MC__CONTINUOUS_L                 (0x0020)
#define MC__UPDOWN                       (0x0030)        /* Up/down mode: Timer counts up to TBxCL0 then down to 0000h */
#define MC__UPDOWN_L                     (0x0030)
#define ID                               (0x00c0)        /* Input divider */
#define ID_L                             (0x00c0)
#define ID0                              (0x0040)        /* Input divider */
#define ID0_L                            (0x0040)
#define ID1                              (0x0080)        /* Input divider */
#define ID1_L                            (0x0080)
#define ID_0                             (0x0000)        /* /1 */
#define ID_1                             (0x0040)        /* /2 */
#define ID_1_L                           (0x0040)
#define ID_2                             (0x0080)        /* /4 */
#define ID_2_L                           (0x0080)
#define ID_3                             (0x00c0)        /* /8 */
#define ID_3_L                           (0x00c0)
#define ID__1                            (0x0000)        /* /1 */
#define ID__2                            (0x0040)        /* /2 */
#define ID__2_L                          (0x0040)
#define ID__4                            (0x0080)        /* /4 */
#define ID__4_L                          (0x0080)
#define ID__8                            (0x00c0)        /* /8 */
#define ID__8_L                          (0x00c0)
#define TBSSEL                           (0x0300)        /* TimerB clock source select */
#define TBSSEL_H                         (0x0003)
#define TBSSEL0                          (0x0100)        /* TimerB clock source select */
#define TBSSEL0_H                        (0x0001)
#define TBSSEL1                          (0x0200)        /* TimerB clock source select */
#define TBSSEL1_H                        (0x0002)
#define TBSSEL_0                         (0x0000)        /* TBxCLK */
#define TBSSEL_1                         (0x0100)        /* ACLK */
#define TBSSEL_1_H                       (0x0001)
#define TBSSEL_2                         (0x0200)        /* SMCLK */
#define TBSSEL_2_H                       (0x0002)
#define TBSSEL_3                         (0x0300)        /* INCLK */
#define TBSSEL_3_H                       (0x0003)
#define TBSSEL__TBCLK                    (0x0000)        /* TBxCLK */
#define TBSSEL__ACLK                     (0x0100)        /* ACLK */
#define TBSSEL__ACLK_H                   (0x0001)
#define TBSSEL__SMCLK                    (0x0200)        /* SMCLK */
#define TBSSEL__SMCLK_H                  (0x0002)
#define TBSSEL__INCLK                    (0x0300)        /* INCLK */
#define TBSSEL__INCLK_H                  (0x0003)
#define CNTL                             (0x1800)        /* Counter length */
#define CNTL_H                           (0x0018)
#define CNTL0                            (0x0800)        /* Counter length */
#define CNTL0_H                          (0x0008)
#define CNTL1                            (0x1000)        /* Counter length */
#define CNTL1_H                          (0x0010)
#define CNTL_0                           (0x0000)        /* 16-bit, TBxR(max) = 0FFFFh */
#define CNTL_1                           (0x0800)        /* 12-bit, TBxR(max) = 0FFFh */
#define CNTL_1_H                         (0x0008)
#define CNTL_2                           (0x1000)        /* 10-bit, TBxR(max) = 03FFh */
#define CNTL_2_H                         (0x0010)
#define CNTL_3                           (0x1800)        /* 8-bit, TBxR(max) = 0FFh */
#define CNTL_3_H                         (0x0018)
#define CNTL__16                         (0x0000)        /* 16-bit, TBxR(max) = 0FFFFh */
#define CNTL__12                         (0x0800)        /* 12-bit, TBxR(max) = 0FFFh */
#define CNTL__12_H                       (0x0008)
#define CNTL__10                         (0x1000)        /* 10-bit, TBxR(max) = 03FFh */
#define CNTL__10_H                       (0x0010)
#define CNTL__8                          (0x1800)        /* 8-bit, TBxR(max) = 0FFh */
#define CNTL__8_H                        (0x0018)
#define TBCLGRP                          (0x6000)        /* TBxCLn group */
#define TBCLGRP_H                        (0x0060)
#define TBCLGRP0                         (0x2000)        /* TBxCLn group */
#define TBCLGRP0_H                       (0x0020)
#define TBCLGRP1                         (0x4000)        /* TBxCLn group */
#define TBCLGRP1_H                       (0x0040)
#define TBCLGRP_0                        (0x0000)        /* Each TBxCLn latch loads independently */
#define TBCLGRP_1                        (0x2000)        /* TBxCL1+TBxCL2 (TBxCCR1 CLLD bits control the update); 
                                                            TBxCL3+TBxCL4 (TBxCCR3 CLLD bits control the update); 
                                                            TBxCL5+TBxCL6 (TBxCCR5 CLLD bits control the update); TBxCL0 
                                                            independent */
#define TBCLGRP_1_H                      (0x0020)
#define TBCLGRP_2                        (0x4000)        /* TBxCL1+TBxCL2+TBxCL3 (TBxCCR1 CLLD bits control the update); 
                                                            TBxCL4+TBxCL5+TBxCL6 (TBxCCR4 CLLD bits control the update); 
                                                            TBxCL0 independent */
#define TBCLGRP_2_H                      (0x0040)
#define TBCLGRP_3                        (0x6000)        /* TBxCL0+TBxCL1+TBxCL2+TBxCL3+TBxCL4+TBxCL5+TBxCL6 (TBxCCR1 CLLD
                                                            bits control the update) */
#define TBCLGRP_3_H                      (0x0060)

/* TB0CCTL Control Bits */
#define CCIFG                            (0x0001)        /* Capture/compare interrupt flag */
#define CCIFG_L                          (0x0001)
#define CCIFG_0                          (0x0000)        /* No interrupt pending */
#define CCIFG_1                          (0x0001)        /* Interrupt pending */
#define CCIFG_1_L                        (0x0001)
#define COV                              (0x0002)        /* Capture overflow */
#define COV_L                            (0x0002)
#define COV_0                            (0x0000)        /* No capture overflow occurred */
#define COV_1                            (0x0002)        /* Capture overflow occurred */
#define COV_1_L                          (0x0002)
#define OUT                              (0x0004)        /* Output */
#define OUT_L                            (0x0004)
#define OUT_0                            (0x0000)        /* Output low */
#define OUT_1                            (0x0004)        /* Output high */
#define OUT_1_L                          (0x0004)
#define OUT__LOW                         (0x0000)        /* Output low */
#define OUT__HIGH                        (0x0004)        /* Output high */
#define OUT__HIGH_L                      (0x0004)
#define CCI                              (0x0008)        /* Capture/compare input */
#define CCI_L                            (0x0008)
#define CCIE                             (0x0010)        /* Capture/compare interrupt enable */
#define CCIE_L                           (0x0010)
#define CCIE_0                           (0x0000)        /* Interrupt disabled */
#define CCIE_1                           (0x0010)        /* Interrupt enabled */
#define CCIE_1_L                         (0x0010)
#define OUTMOD                           (0x00e0)        /* Output mode */
#define OUTMOD_L                         (0x00e0)
#define OUTMOD0                          (0x0020)        /* Output mode */
#define OUTMOD0_L                        (0x0020)
#define OUTMOD1                          (0x0040)        /* Output mode */
#define OUTMOD1_L                        (0x0040)
#define OUTMOD2                          (0x0080)        /* Output mode */
#define OUTMOD2_L                        (0x0080)
#define OUTMOD_0                         (0x0000)        /* OUT bit value */
#define OUTMOD_1                         (0x0020)        /* Set */
#define OUTMOD_1_L                       (0x0020)
#define OUTMOD_2                         (0x0040)        /* Toggle/reset */
#define OUTMOD_2_L                       (0x0040)
#define OUTMOD_3                         (0x0060)        /* Set/reset */
#define OUTMOD_3_L                       (0x0060)
#define OUTMOD_4                         (0x0080)        /* Toggle */
#define OUTMOD_4_L                       (0x0080)
#define OUTMOD_5                         (0x00a0)        /* Reset */
#define OUTMOD_5_L                       (0x00a0)
#define OUTMOD_6                         (0x00c0)        /* Toggle/set */
#define OUTMOD_6_L                       (0x00c0)
#define OUTMOD_7                         (0x00e0)        /* Reset/set */
#define OUTMOD_7_L                       (0x00e0)
#define CAP                              (0x0100)        /* Capture mode */
#define CAP_H                            (0x0001)
#define CAP_0                            (0x0000)        /* Compare mode */
#define CAP_1                            (0x0100)        /* Capture mode */
#define CAP_1_H                          (0x0001)
#define CAP__COMPARE                     (0x0000)        /* Compare mode */
#define CAP__CAPTURE                     (0x0100)        /* Capture mode */
#define CAP__CAPTURE_H                   (0x0001)
#define CLLD                             (0x0600)        /* Compare latch load */
#define CLLD_H                           (0x0006)
#define CLLD0                            (0x0200)        /* Compare latch load */
#define CLLD0_H                          (0x0002)
#define CLLD1                            (0x0400)        /* Compare latch load */
#define CLLD1_H                          (0x0004)
#define CLLD_0                           (0x0000)        /* TBxCLn loads on write to TBxCCRn */
#define CLLD_1                           (0x0200)        /* TBxCLn loads when TBxR counts to 0 */
#define CLLD_1_H                         (0x0002)
#define CLLD_2                           (0x0400)        /* TBxCLn loads when TBxR counts to 0 (up or continuous mode). 
                                                            TBxCLn loads when TBxR counts to TBxCL0 or to 0 (up/down 
                                                            mode). */
#define CLLD_2_H                         (0x0004)
#define CLLD_3                           (0x0600)        /* TBxCLn loads when TBxR counts to TBxCLn */
#define CLLD_3_H                         (0x0006)
#define SCS                              (0x0800)        /* Synchronize capture source */
#define SCS_H                            (0x0008)
#define SCS_0                            (0x0000)        /* Asynchronous capture */
#define SCS_1                            (0x0800)        /* Synchronous capture */
#define SCS_1_H                          (0x0008)
#define SCS__ASYNC                       (0x0000)        /* Asynchronous capture */
#define SCS__SYNC                        (0x0800)        /* Synchronous capture */
#define SCS__SYNC_H                      (0x0008)
#define CCIS                             (0x3000)        /* Capture/compare input select */
#define CCIS_H                           (0x0030)
#define CCIS0                            (0x1000)        /* Capture/compare input select */
#define CCIS0_H                          (0x0010)
#define CCIS1                            (0x2000)        /* Capture/compare input select */
#define CCIS1_H                          (0x0020)
#define CCIS_0                           (0x0000)        /* CCIxA */
#define CCIS_1                           (0x1000)        /* CCIxB */
#define CCIS_1_H                         (0x0010)
#define CCIS_2                           (0x2000)        /* GND */
#define CCIS_2_H                         (0x0020)
#define CCIS_3                           (0x3000)        /* VCC */
#define CCIS_3_H                         (0x0030)
#define CCIS__CCIA                       (0x0000)        /* CCIxA */
#define CCIS__CCIB                       (0x1000)        /* CCIxB */
#define CCIS__CCIB_H                     (0x0010)
#define CCIS__GND                        (0x2000)        /* GND */
#define CCIS__GND_H                      (0x0020)
#define CCIS__VCC                        (0x3000)        /* VCC */
#define CCIS__VCC_H                      (0x0030)
#define CM                               (0xc000)        /* Capture mode */
#define CM_H                             (0x00c0)
#define CM0                              (0x4000)        /* Capture mode */
#define CM0_H                            (0x0040)
#define CM1                              (0x8000)        /* Capture mode */
#define CM1_H                            (0x0080)
#define CM_0                             (0x0000)        /* No capture */
#define CM_1                             (0x4000)        /* Capture on rising edge */
#define CM_1_H                           (0x0040)
#define CM_2                             (0x8000)        /* Capture on falling edge */
#define CM_2_H                           (0x0080)
#define CM_3                             (0xc000)        /* Capture on both rising and falling edges */
#define CM_3_H                           (0x00c0)
#define CM__NONE                         (0x0000)        /* No capture */
#define CM__RISING                       (0x4000)        /* Capture on rising edge */
#define CM__RISING_H                     (0x0040)
#define CM__FALLING                      (0x8000)        /* Capture on falling edge */
#define CM__FALLING_H                    (0x0080)
#define CM__BOTH                         (0xc000)        /* Capture on both rising and falling edges */
#define CM__BOTH_H                       (0x00c0)

/* TB0EX0 Control Bits */
#define TBIDEX                           (0x0007)        /* Input divider expansion */
#define TBIDEX_L                         (0x0007)
#define TBIDEX0                          (0x0001)        /* Input divider expansion */
#define TBIDEX0_L                        (0x0001)
#define TBIDEX1                          (0x0002)        /* Input divider expansion */
#define TBIDEX1_L                        (0x0002)
#define TBIDEX2                          (0x0004)        /* Input divider expansion */
#define TBIDEX2_L                        (0x0004)
#define TBIDEX_0                         (0x0000)        /* Divide by 1 */
#define TBIDEX_1                         (0x0001)        /* Divide by 2 */
#define TBIDEX_1_L                       (0x0001)
#define TBIDEX_2                         (0x0002)        /* Divide by 3 */
#define TBIDEX_2_L                       (0x0002)
#define TBIDEX_3                         (0x0003)        /* Divide by 4 */
#define TBIDEX_3_L                       (0x0003)
#define TBIDEX_4                         (0x0004)        /* Divide by 5 */
#define TBIDEX_4_L                       (0x0004)
#define TBIDEX_5                         (0x0005)        /* Divide by 6 */
#define TBIDEX_5_L                       (0x0005)
#define TBIDEX_6                         (0x0006)        /* Divide by 7 */
#define TBIDEX_6_L                       (0x0006)
#define TBIDEX_7                         (0x0007)        /* Divide by 8 */
#define TBIDEX_7_L                       (0x0007)
#define TBIDEX__1                        (0x0000)        /* Divide by 1 */
#define TBIDEX__2                        (0x0001)        /* Divide by 2 */
#define TBIDEX__2_L                      (0x0001)
#define TBIDEX__3                        (0x0002)        /* Divide by 3 */
#define TBIDEX__3_L                      (0x0002)
#define TBIDEX__4                        (0x0003)        /* Divide by 4 */
#define TBIDEX__4_L                      (0x0003)
#define TBIDEX__5                        (0x0004)        /* Divide by 5 */
#define TBIDEX__5_L                      (0x0004)
#define TBIDEX__6                        (0x0005)        /* Divide by 6 */
#define TBIDEX__6_L                      (0x0005)
#define TBIDEX__7                        (0x0006)        /* Divide by 7 */
#define TBIDEX__7_L                      (0x0006)
#define TBIDEX__8                        (0x0007)        /* Divide by 8 */
#define TBIDEX__8_L                      (0x0007)

/* TB0IV Control Bits */
#define TBIV                             (0xffff)        /* Timer_B interrupt vector value */
#define TBIV_L                           (0x00ff)
#define TBIV_H                           (0x00ff)
#define TBIV0                            (0x0001)        /* Timer_B interrupt vector value */
#define TBIV0_L                          (0x0001)
#define TBIV1                            (0x0002)        /* Timer_B interrupt vector value */
#define TBIV1_L                          (0x0002)
#define TBIV2                            (0x0004)        /* Timer_B interrupt vector value */
#define TBIV2_L                          (0x0004)
#define TBIV3                            (0x0008)        /* Timer_B interrupt vector value */
#define TBIV3_L                          (0x0008)
#define TBIV4                            (0x0010)        /* Timer_B interrupt vector value */
#define TBIV4_L                          (0x0010)
#define TBIV5                            (0x0020)        /* Timer_B interrupt vector value */
#define TBIV5_L                          (0x0020)
#define TBIV6                            (0x0040)        /* Timer_B interrupt vector value */
#define TBIV6_L                          (0x0040)
#define TBIV7                            (0x0080)        /* Timer_B interrupt vector value */
#define TBIV7_L                          (0x0080)
#define TBIV8                            (0x0100)        /* Timer_B interrupt vector value */
#define TBIV8_H                          (0x0001)
#define TBIV9                            (0x0200)        /* Timer_B interrupt vector value */
#define TBIV9_H                          (0x0002)
#define TBIV10                           (0x0400)        /* Timer_B interrupt vector value */
#define TBIV10_H                         (0x0004)
#define TBIV11                           (0x0800)        /* Timer_B interrupt vector value */
#define TBIV11_H                         (0x0008)
#define TBIV12                           (0x1000)        /* Timer_B interrupt vector value */
#define TBIV12_H                         (0x0010)
#define TBIV13                           (0x2000)        /* Timer_B interrupt vector value */
#define TBIV13_H                         (0x0020)
#define TBIV14                           (0x4000)        /* Timer_B interrupt vector value */
#define TBIV14_H                         (0x0040)
#define TBIV15                           (0x8000)        /* Timer_B interrupt vector value */
#define TBIV15_H                         (0x0080)
#define TBIV_0                           (0x0000)        /* No interrupt pending */
#define TBIV_2                           (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TBxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TBIV_2_L                         (0x0002)
#define TBIV_4                           (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TBxCCR2 
                                                            CCIFG */
#define TBIV_4_L                         (0x0004)
#define TBIV_6                           (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TBxCCR3 
                                                            CCIFG */
#define TBIV_6_L                         (0x0006)
#define TBIV_8                           (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TBxCCR4 
                                                            CCIFG */
#define TBIV_8_L                         (0x0008)
#define TBIV_10                          (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TBxCCR5 
                                                            CCIFG */
#define TBIV_10_L                        (0x000a)
#define TBIV_12                          (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TBxCCR6 
                                                            CCIFG */
#define TBIV_12_L                        (0x000c)
#define TBIV_14                          (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TBxCTL 
                                                            TBIFG; Interrupt Priority: Lowest */
#define TBIV_14_L                        (0x000e)
#define TBIV__NONE                       (0x0000)        /* No interrupt pending */
#define TBIV__TBCCR1                     (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TBxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TBIV__TBCCR1_L                   (0x0002)
#define TBIV__TBCCR2                     (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TBxCCR2 
                                                            CCIFG */
#define TBIV__TBCCR2_L                   (0x0004)
#define TBIV__TBCCR3                     (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TBxCCR3 
                                                            CCIFG */
#define TBIV__TBCCR3_L                   (0x0006)
#define TBIV__TBCCR4                     (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TBxCCR4 
                                                            CCIFG */
#define TBIV__TBCCR4_L                   (0x0008)
#define TBIV__TBCCR5                     (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TBxCCR5 
                                                            CCIFG */
#define TBIV__TBCCR5_L                   (0x000a)
#define TBIV__TBCCR6                     (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TBxCCR6 
                                                            CCIFG */
#define TBIV__TBCCR6_L                   (0x000c)
#define TBIV__TBIFG                      (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TBxCTL 
                                                            TBIFG; Interrupt Priority: Lowest */
#define TBIV__TBIFG_L                    (0x000e)


/*****************************************************************************
 TB1 Registers
*****************************************************************************/

#define __MSP430_HAS_TB1__ 3                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TBx__
#define __MSP430_HAS_TBx__
#endif
#define __MSP430_BASEADDRESS_TB1__ 0x03C0
#define TB1_BASE               __MSP430_BASEADDRESS_TB1__

sfr_w(TB1CTL);                                /* Timer_B Control Register */
sfr_b(TB1CTL_L);
sfr_b(TB1CTL_H);
sfr_w(TB1CCTL0);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB1CCTL0_L);
sfr_b(TB1CCTL0_H);
sfr_w(TB1CCTL1);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB1CCTL1_L);
sfr_b(TB1CCTL1_H);
sfr_w(TB1CCTL2);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB1CCTL2_L);
sfr_b(TB1CCTL2_H);
sfr_w(TB1R);                                  /* Timer_B count register */
sfr_b(TB1R_L);
sfr_b(TB1R_H);
sfr_w(TB1CCR0);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB1CCR0_L);
sfr_b(TB1CCR0_H);
sfr_w(TB1CCR1);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB1CCR1_L);
sfr_b(TB1CCR1_H);
sfr_w(TB1CCR2);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB1CCR2_L);
sfr_b(TB1CCR2_H);
sfr_w(TB1EX0);                                /* Timer_Bx Expansion Register 0 */
sfr_b(TB1EX0_L);
sfr_b(TB1EX0_H);
sfr_w(TB1IV);                                 /* Timer_Bx Interrupt Vector Register */
sfr_b(TB1IV_L);
sfr_b(TB1IV_H);

/* TB1 Register Offsets */
#define OFS_TB1CTL                       (0x0000)
#define OFS_TB1CTL_L                     OFS_TB1CTL
#define OFS_TB1CTL_H                     OFS_TB1CTL+1
#define OFS_TB1CCTL0                     (0x0002)
#define OFS_TB1CCTL0_L                   OFS_TB1CCTL0
#define OFS_TB1CCTL0_H                   OFS_TB1CCTL0+1
#define OFS_TB1CCTL1                     (0x0004)
#define OFS_TB1CCTL1_L                   OFS_TB1CCTL1
#define OFS_TB1CCTL1_H                   OFS_TB1CCTL1+1
#define OFS_TB1CCTL2                     (0x0006)
#define OFS_TB1CCTL2_L                   OFS_TB1CCTL2
#define OFS_TB1CCTL2_H                   OFS_TB1CCTL2+1
#define OFS_TB1R                         (0x0010)
#define OFS_TB1R_L                       OFS_TB1R
#define OFS_TB1R_H                       OFS_TB1R+1
#define OFS_TB1CCR0                      (0x0012)
#define OFS_TB1CCR0_L                    OFS_TB1CCR0
#define OFS_TB1CCR0_H                    OFS_TB1CCR0+1
#define OFS_TB1CCR1                      (0x0014)
#define OFS_TB1CCR1_L                    OFS_TB1CCR1
#define OFS_TB1CCR1_H                    OFS_TB1CCR1+1
#define OFS_TB1CCR2                      (0x0016)
#define OFS_TB1CCR2_L                    OFS_TB1CCR2
#define OFS_TB1CCR2_H                    OFS_TB1CCR2+1
#define OFS_TB1EX0                       (0x0020)
#define OFS_TB1EX0_L                     OFS_TB1EX0
#define OFS_TB1EX0_H                     OFS_TB1EX0+1
#define OFS_TB1IV                        (0x002E)
#define OFS_TB1IV_L                      OFS_TB1IV
#define OFS_TB1IV_H                      OFS_TB1IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 TRI0 Registers
*****************************************************************************/

#define __MSP430_HAS_TRI0__                   /* Definition to show that module is available */
#ifndef __MSP430_HAS_TRIx__
#define __MSP430_HAS_TRIx__
#endif
#define __MSP430_BASEADDRESS_TRI0__ 0x0F00
#define TRI0_BASE              __MSP430_BASEADDRESS_TRI0__

sfr_w(TRI0CTL);                               /* TRI Control Register */
sfr_b(TRI0CTL_L);
sfr_b(TRI0CTL_H);

/* TRI0 Register Offsets */
#define OFS_TRI0CTL                      (0x0000)
#define OFS_TRI0CTL_L                    OFS_TRI0CTL
#define OFS_TRI0CTL_H                    OFS_TRI0CTL+1

/* TRI0 Control Bits */

/* TRI0CTL Control Bits */
#define TRIEN                            (0x0001)        /* TRI enable. */
#define TRIEN_L                          (0x0001)
#define TRIEN_0                          (0x0000)        /* Disable the TRI module */
#define TRIEN_1                          (0x0001)        /* Enable the TRI module */
#define TRIEN_1_L                        (0x0001)
#define TRIEN__DISABLE                   (0x0000)        /* Disable the TRI module */
#define TRIEN__ENABLE                    (0x0001)        /* Enable the TRI module */
#define TRIEN__ENABLE_L                  (0x0001)
#define TRIPM                            (0x0002)        /* TRI power mode select. */
#define TRIPM_L                          (0x0002)
#define TRIPM_0                          (0x0000)        /* High speed and high power */
#define TRIPM_1                          (0x0002)        /* Low speed and low power */
#define TRIPM_1_L                        (0x0002)
#define TRIPSEL                          (0x00c0)        /* TRI positive input select. */
#define TRIPSEL_L                        (0x00c0)
#define TRIPSEL0                         (0x0040)        /* TRI positive input select. */
#define TRIPSEL0_L                       (0x0040)
#define TRIPSEL1                         (0x0080)        /* TRI positive input select. */
#define TRIPSEL1_L                       (0x0080)
#define TRIPSEL_0                        (0x0000)        /* External source (package terminal) */
#define TRIPSEL_1                        (0x0040)        /* Device specific; refer to the device-specific sheet for 
                                                            details */
#define TRIPSEL_1_L                      (0x0040)
#define TRIPSEL_2                        (0x0080)        /* Device specific; refer to the device-specific sheet for 
                                                            details */
#define TRIPSEL_2_L                      (0x0080)
#define TRIPSEL_3                        (0x00c0)        /* Device specific; refer to the device-specific sheet for 
                                                            details */
#define TRIPSEL_3_L                      (0x00c0)


/*****************************************************************************
 WDT_A Registers
*****************************************************************************/

#define __MSP430_HAS_WDT_A__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_WDT_A__ 0x01CC
#define WDT_A_BASE             __MSP430_BASEADDRESS_WDT_A__

sfr_w(WDTCTL);                                /* Watchdog Timer Control Register */
sfr_b(WDTCTL_L);
sfr_b(WDTCTL_H);

/* WDT_A Register Offsets */
#define OFS_WDTCTL                       (0x0000)
#define OFS_WDTCTL_L                     OFS_WDTCTL
#define OFS_WDTCTL_H                     OFS_WDTCTL+1

/* WDT_A Control Bits */

/* WDTCTL Control Bits */
#define WDTIS                            (0x0007)        /* Watchdog timer interval select */
#define WDTIS_L                          (0x0007)
#define WDTIS0                           (0x0001)        /* Watchdog timer interval select */
#define WDTIS0_L                         (0x0001)
#define WDTIS1                           (0x0002)        /* Watchdog timer interval select */
#define WDTIS1_L                         (0x0002)
#define WDTIS2                           (0x0004)        /* Watchdog timer interval select */
#define WDTIS2_L                         (0x0004)
#define WDTIS_0                          (0x0000)        /* Watchdog clock source / (2^(31)) (18:12:16 at 32.768 kHz) */
#define WDTIS_1                          (0x0001)        /* Watchdog clock source /(2^(27)) (01:08:16 at 32.768 kHz) */
#define WDTIS_1_L                        (0x0001)
#define WDTIS_2                          (0x0002)        /* Watchdog clock source /(2^(23)) (00:04:16 at 32.768 kHz) */
#define WDTIS_2_L                        (0x0002)
#define WDTIS_3                          (0x0003)        /* Watchdog clock source /(2^(19)) (00:00:16 at 32.768 kHz) */
#define WDTIS_3_L                        (0x0003)
#define WDTIS_4                          (0x0004)        /* Watchdog clock source /(2^(15)) (1 s at 32.768 kHz) */
#define WDTIS_4_L                        (0x0004)
#define WDTIS_5                          (0x0005)        /* Watchdog clock source / (2^(13)) (250 ms at 32.768 kHz) */
#define WDTIS_5_L                        (0x0005)
#define WDTIS_6                          (0x0006)        /* Watchdog clock source / (2^(9)) (15.625 ms at 32.768 kHz) */
#define WDTIS_6_L                        (0x0006)
#define WDTIS_7                          (0x0007)        /* Watchdog clock source / (2^(6)) (1.95 ms at 32.768 kHz) */
#define WDTIS_7_L                        (0x0007)
#define WDTIS__2G                        (0x0000)        /* Watchdog clock source / (2^(31)) (18:12:16 at 32.768 kHz) */
#define WDTIS__128M                      (0x0001)        /* Watchdog clock source /(2^(27)) (01:08:16 at 32.768 kHz) */
#define WDTIS__128M_L                    (0x0001)
#define WDTIS__8192K                     (0x0002)        /* Watchdog clock source /(2^(23)) (00:04:16 at 32.768 kHz) */
#define WDTIS__8192K_L                   (0x0002)
#define WDTIS__512K                      (0x0003)        /* Watchdog clock source /(2^(19)) (00:00:16 at 32.768 kHz) */
#define WDTIS__512K_L                    (0x0003)
#define WDTIS__32K                       (0x0004)        /* Watchdog clock source /(2^(15)) (1 s at 32.768 kHz) */
#define WDTIS__32K_L                     (0x0004)
#define WDTIS__8192                      (0x0005)        /* Watchdog clock source / (2^(13)) (250 ms at 32.768 kHz) */
#define WDTIS__8192_L                    (0x0005)
#define WDTIS__512                       (0x0006)        /* Watchdog clock source / (2^(9)) (15.625 ms at 32.768 kHz) */
#define WDTIS__512_L                     (0x0006)
#define WDTIS__64                        (0x0007)        /* Watchdog clock source / (2^(6)) (1.95 ms at 32.768 kHz) */
#define WDTIS__64_L                      (0x0007)
#define WDTCNTCL                         (0x0008)        /* Watchdog timer counter clear */
#define WDTCNTCL_L                       (0x0008)
#define WDTCNTCL_0                       (0x0000)        /* No action */
#define WDTCNTCL_1                       (0x0008)        /* WDTCNT = 0000h */
#define WDTCNTCL_1_L                     (0x0008)
#define WDTTMSEL                         (0x0010)        /* Watchdog timer mode select */
#define WDTTMSEL_L                       (0x0010)
#define WDTTMSEL_0                       (0x0000)        /* Watchdog mode */
#define WDTTMSEL_1                       (0x0010)        /* Interval timer mode */
#define WDTTMSEL_1_L                     (0x0010)
#define WDTSSEL                          (0x0060)        /* Watchdog timer clock source select */
#define WDTSSEL_L                        (0x0060)
#define WDTSSEL0                         (0x0020)        /* Watchdog timer clock source select */
#define WDTSSEL0_L                       (0x0020)
#define WDTSSEL1                         (0x0040)        /* Watchdog timer clock source select */
#define WDTSSEL1_L                       (0x0040)
#define WDTSSEL_0                        (0x0000)        /* SMCLK */
#define WDTSSEL_1                        (0x0020)        /* ACLK */
#define WDTSSEL_1_L                      (0x0020)
#define WDTSSEL_2                        (0x0040)        /* VLOCLK */
#define WDTSSEL_2_L                      (0x0040)
#define WDTSSEL_3                        (0x0060)        /* BCLK */
#define WDTSSEL_3_L                      (0x0060)
#define WDTSSEL__SMCLK                   (0x0000)        /* SMCLK */
#define WDTSSEL__ACLK                    (0x0020)        /* ACLK */
#define WDTSSEL__ACLK_L                  (0x0020)
#define WDTSSEL__VLOCLK                  (0x0040)        /* VLOCLK */
#define WDTSSEL__VLOCLK_L                (0x0040)
#define WDTSSEL__BCLK                    (0x0060)        /* BCLK */
#define WDTSSEL__BCLK_L                  (0x0060)
#define WDTHOLD                          (0x0080)        /* Watchdog timer hold */
#define WDTHOLD_L                        (0x0080)
#define WDTHOLD_0                        (0x0000)        /* Watchdog timer is not stopped */
#define WDTHOLD_1                        (0x0080)        /* Watchdog timer is stopped */
#define WDTHOLD_1_L                      (0x0080)
#define WDTHOLD__UNHOLD                  (0x0000)        /* Watchdog timer is not stopped */
#define WDTHOLD__HOLD                    (0x0080)        /* Watchdog timer is stopped */
#define WDTHOLD__HOLD_L                  (0x0080)
#define WDTPW                            (0x5a00)        /* Watchdog timer password */
#define WDTPW_H                          (0x005a)
#define WDTPW0                           (0x0100)        /* Watchdog timer password */
#define WDTPW0_H                         (0x0001)
#define WDTPW1                           (0x0200)        /* Watchdog timer password */
#define WDTPW1_H                         (0x0002)
#define WDTPW2                           (0x0400)        /* Watchdog timer password */
#define WDTPW2_H                         (0x0004)
#define WDTPW3                           (0x0800)        /* Watchdog timer password */
#define WDTPW3_H                         (0x0008)
#define WDTPW4                           (0x1000)        /* Watchdog timer password */
#define WDTPW4_H                         (0x0010)
#define WDTPW5                           (0x2000)        /* Watchdog timer password */
#define WDTPW5_H                         (0x0020)
#define WDTPW6                           (0x4000)        /* Watchdog timer password */
#define WDTPW6_H                         (0x0040)
#define WDTPW7                           (0x8000)        /* Watchdog timer password */
#define WDTPW7_H                         (0x0080)


/*****************************************************************************
 eCOMP0 Registers
*****************************************************************************/

#define __MSP430_HAS_ECOMP0__                 /* Definition to show that module is available */
#ifndef __MSP430_HAS_ECOMPx__
#define __MSP430_HAS_ECOMPx__
#endif
#define __MSP430_BASEADDRESS_ECOMP0__ 0x08E0
#define ECOMP0_BASE            __MSP430_BASEADDRESS_ECOMP0__

sfr_w(CPCTL0);                                /* Comparator Control Register 0 */
sfr_b(CPCTL0_L);
sfr_b(CPCTL0_H);
sfr_w(CPCTL1);                                /* Comparator Control Register 1 */
sfr_b(CPCTL1_L);
sfr_b(CPCTL1_H);
sfr_w(CPINT);                                 /* Comparator Interrupt Control Register */
sfr_b(CPINT_L);
sfr_b(CPINT_H);
sfr_w(CPIV);                                  /* Comparator Interrupt Vector Word Register */
sfr_b(CPIV_L);
sfr_b(CPIV_H);
sfr_w(CPDACCTL);                              /* 6-bit Comparator built-in DAC Control Register */
sfr_b(CPDACCTL_L);
sfr_b(CPDACCTL_H);
sfr_w(CPDACDATA);                             /* 6-bit Comparator built-in DAC Data Register */
sfr_b(CPDACDATA_L);
sfr_b(CPDACDATA_H);

/* eCOMP0 Register Offsets */
#define OFS_CPCTL0                       (0x0000)
#define OFS_CPCTL0_L                     OFS_CPCTL0
#define OFS_CPCTL0_H                     OFS_CPCTL0+1
#define OFS_CPCTL1                       (0x0002)
#define OFS_CPCTL1_L                     OFS_CPCTL1
#define OFS_CPCTL1_H                     OFS_CPCTL1+1
#define OFS_CPINT                        (0x0006)
#define OFS_CPINT_L                      OFS_CPINT
#define OFS_CPINT_H                      OFS_CPINT+1
#define OFS_CPIV                         (0x0008)
#define OFS_CPIV_L                       OFS_CPIV
#define OFS_CPIV_H                       OFS_CPIV+1
#define OFS_CPDACCTL                     (0x0010)
#define OFS_CPDACCTL_L                   OFS_CPDACCTL
#define OFS_CPDACCTL_H                   OFS_CPDACCTL+1
#define OFS_CPDACDATA                    (0x0012)
#define OFS_CPDACDATA_L                  OFS_CPDACDATA
#define OFS_CPDACDATA_H                  OFS_CPDACDATA+1

/* eCOMP0 Control Bits */

/* CPCTL0 Control Bits */
#define CPPEN                            (0x0010)        /* Channel input enable for the V+ terminal */
#define CPPEN_L                          (0x0010)
#define CPPEN_0                          (0x0000)        /* Selected analog input channel for V+ terminal is disabled. */
#define CPPEN_1                          (0x0010)        /* Selected analog input channel for V+ terminal is enabled. */
#define CPPEN_1_L                        (0x0010)
#define CPNSEL                           (0x0700)        /* Channel input selected for the - terminal */
#define CPNSEL_H                         (0x0007)
#define CPNSEL0                          (0x0100)        /* Channel input selected for the - terminal */
#define CPNSEL0_H                        (0x0001)
#define CPNSEL1                          (0x0200)        /* Channel input selected for the - terminal */
#define CPNSEL1_H                        (0x0002)
#define CPNSEL2                          (0x0400)        /* Channel input selected for the - terminal */
#define CPNSEL2_H                        (0x0004)
#define CPNSEL_0                         (0x0000)        /* select external input source */
#define CPNSEL_1                         (0x0100)        /* select external input source */
#define CPNSEL_1_H                       (0x0001)
#define CPNSEL_2                         (0x0200)        /* select external input source */
#define CPNSEL_2_H                       (0x0002)
#define CPNSEL_3                         (0x0300)        /* select external input source */
#define CPNSEL_3_H                       (0x0003)
#define CPNSEL_4                         (0x0400)        /* device specific, please refer to device data sheet for details */
#define CPNSEL_4_H                       (0x0004)
#define CPNSEL_5                         (0x0500)        /* device specific, please refer to device data sheet for details */
#define CPNSEL_5_H                       (0x0005)
#define CPNSEL_6                         (0x0600)        /* 6-bit DAC */
#define CPNSEL_6_H                       (0x0006)
#define CPNSEL_7                         (0x0700)        /* Reserved */
#define CPNSEL_7_H                       (0x0007)
#define CPNEN                            (0x1000)        /* Channel input enable for the - terminal */
#define CPNEN_H                          (0x0010)
#define CPNEN_0                          (0x0000)        /* Selected analog input channel for V- terminal is disabled. */
#define CPNEN_1                          (0x1000)        /* Selected analog input channel for V- terminal is enabled. */
#define CPNEN_1_H                        (0x0010)
#define CPPSEL                           (0x0007)        /* Channel input selected for the V+ terminal */
#define CPPSEL_L                         (0x0007)
#define CPPSEL0                          (0x0001)        /* Channel input selected for the V+ terminal */
#define CPPSEL0_L                        (0x0001)
#define CPPSEL1                          (0x0002)        /* Channel input selected for the V+ terminal */
#define CPPSEL1_L                        (0x0002)
#define CPPSEL2                          (0x0004)        /* Channel input selected for the V+ terminal */
#define CPPSEL2_L                        (0x0004)
#define CPPSEL_0                         (0x0000)        /* select external input source */
#define CPPSEL_1                         (0x0001)        /* select external input source */
#define CPPSEL_1_L                       (0x0001)
#define CPPSEL_2                         (0x0002)        /* select external input source */
#define CPPSEL_2_L                       (0x0002)
#define CPPSEL_3                         (0x0003)        /* select external input source */
#define CPPSEL_3_L                       (0x0003)
#define CPPSEL_4                         (0x0004)        /* device specific, please refer to device data sheet for details */
#define CPPSEL_4_L                       (0x0004)
#define CPPSEL_5                         (0x0005)        /* device specific, please refer to device data sheet for details */
#define CPPSEL_5_L                       (0x0005)
#define CPPSEL_6                         (0x0006)        /* 6-bit DAC */
#define CPPSEL_6_L                       (0x0006)
#define CPPSEL_7                         (0x0007)        /* Reserved */
#define CPPSEL_7_L                       (0x0007)

/* CPCTL1 Control Bits */
#define CPOUT                            (0x0001)        /* Comparator output value */
#define CPOUT_L                          (0x0001)
#define CPINV                            (0x0002)        /* Comparator output polarity */
#define CPINV_L                          (0x0002)
#define CPINV_0                          (0x0000)        /* Comparator output is non-inverted */
#define CPINV_1                          (0x0002)        /* Comparator output is inverted */
#define CPINV_1_L                        (0x0002)
#define CPIES                            (0x0010)        /* Interrupt edge select for CEIIFG and CEIFG */
#define CPIES_L                          (0x0010)
#define CPIES_0                          (0x0000)        /* Rising edge for CPIFG, falling edge for CPIIFG */
#define CPIES_1                          (0x0010)        /* Falling edge for CPIFG, rising edge for CPIIFG */
#define CPIES_1_L                        (0x0010)
#define CPFLT                            (0x0020)        /* */
#define CPFLT_L                          (0x0020)
#define CPFLT_0                          (0x0000)        /* Comparator output is not filtered */
#define CPFLT_1                          (0x0020)        /* Comparator output is filtered */
#define CPFLT_1_L                        (0x0020)
#define CPFLTDLY                         (0x00c0)        /* */
#define CPFLTDLY_L                       (0x00c0)
#define CPFLTDLY0                        (0x0040)        /* */
#define CPFLTDLY0_L                      (0x0040)
#define CPFLTDLY1                        (0x0080)        /* */
#define CPFLTDLY1_L                      (0x0080)
#define CPFLTDLY_0                       (0x0000)        /* Typical filter delay of 450ns */
#define CPFLTDLY_1                       (0x0040)        /* Typical filter delay of 900ns */
#define CPFLTDLY_1_L                     (0x0040)
#define CPFLTDLY_2                       (0x0080)        /* Typical filter delay of 1800ns */
#define CPFLTDLY_2_L                     (0x0080)
#define CPFLTDLY_3                       (0x00c0)        /* Typical filter delay of 3600ns */
#define CPFLTDLY_3_L                     (0x00c0)
#define CPMSEL                           (0x0100)        /* */
#define CPMSEL_H                         (0x0001)
#define CPMSEL_0                         (0x0000)        /* High-power & High speed mode (500nA) */
#define CPMSEL_1                         (0x0100)        /* Low-power & Low speed mode (10nA) */
#define CPMSEL_1_H                       (0x0001)
#define CPEN                             (0x0200)        /* */
#define CPEN_H                           (0x0002)
#define CPEN_0                           (0x0000)        /* Comparator is disabled */
#define CPEN_1                           (0x0200)        /* Comparator is enabled */
#define CPEN_1_H                         (0x0002)
#define CPHSEL                           (0x0c00)        /* */
#define CPHSEL_H                         (0x000c)
#define CPHSEL0                          (0x0400)        /* */
#define CPHSEL0_H                        (0x0004)
#define CPHSEL1                          (0x0800)        /* */
#define CPHSEL1_H                        (0x0008)
#define CPHSEL_0                         (0x0000)        /* disable */
#define CPHSEL_1                         (0x0400)        /* 10mV */
#define CPHSEL_1_H                       (0x0004)
#define CPHSEL_2                         (0x0800)        /* 20mV */
#define CPHSEL_2_H                       (0x0008)
#define CPHSEL_3                         (0x0c00)        /* 30mV */
#define CPHSEL_3_H                       (0x000c)
#define CPIE                             (0x4000)        /* */
#define CPIE_H                           (0x0040)
#define CPIE_0                           (0x0000)        /* Interrupt output is disabled */
#define CPIE_1                           (0x4000)        /* Interrupt output is enabled */
#define CPIE_1_H                         (0x0040)
#define CPIIE                            (0x8000)        /* */
#define CPIIE_H                          (0x0080)
#define CPIIE_0                          (0x0000)        /* Interrupt inverted output is disabled */
#define CPIIE_1                          (0x8000)        /* Interrupt inverted output is enabled */
#define CPIIE_1_H                        (0x0080)

/* CPINT Control Bits */
#define CPIFG                            (0x0001)        /* Comparator output interrupt flag */
#define CPIFG_L                          (0x0001)
#define CPIFG_0                          (0x0000)        /* No interrupt pending. */
#define CPIFG_1                          (0x0001)        /* Output interrupt pending. */
#define CPIFG_1_L                        (0x0001)
#define CPIIFG                           (0x0002)        /* Comparator output inverted interrupt flag */
#define CPIIFG_L                         (0x0002)
#define CPIIFG_0                         (0x0000)        /* No interrupt pending. */
#define CPIIFG_1                         (0x0002)        /* Output interrupt pending. */
#define CPIIFG_1_L                       (0x0002)

/* CPIV Control Bits */
#define CPIV0                            (0x0001)        /* Comparator interrupt vector word register */
#define CPIV0_L                          (0x0001)
#define CPIV1                            (0x0002)        /* Comparator interrupt vector word register */
#define CPIV1_L                          (0x0002)
#define CPIV2                            (0x0004)        /* Comparator interrupt vector word register */
#define CPIV2_L                          (0x0004)
#define CPIV3                            (0x0008)        /* Comparator interrupt vector word register */
#define CPIV3_L                          (0x0008)
#define CPIV4                            (0x0010)        /* Comparator interrupt vector word register */
#define CPIV4_L                          (0x0010)
#define CPIV5                            (0x0020)        /* Comparator interrupt vector word register */
#define CPIV5_L                          (0x0020)
#define CPIV6                            (0x0040)        /* Comparator interrupt vector word register */
#define CPIV6_L                          (0x0040)
#define CPIV7                            (0x0080)        /* Comparator interrupt vector word register */
#define CPIV7_L                          (0x0080)
#define CPIV8                            (0x0100)        /* Comparator interrupt vector word register */
#define CPIV8_H                          (0x0001)
#define CPIV9                            (0x0200)        /* Comparator interrupt vector word register */
#define CPIV9_H                          (0x0002)
#define CPIV10                           (0x0400)        /* Comparator interrupt vector word register */
#define CPIV10_H                         (0x0004)
#define CPIV11                           (0x0800)        /* Comparator interrupt vector word register */
#define CPIV11_H                         (0x0008)
#define CPIV12                           (0x1000)        /* Comparator interrupt vector word register */
#define CPIV12_H                         (0x0010)
#define CPIV13                           (0x2000)        /* Comparator interrupt vector word register */
#define CPIV13_H                         (0x0020)
#define CPIV14                           (0x4000)        /* Comparator interrupt vector word register */
#define CPIV14_H                         (0x0040)
#define CPIV15                           (0x8000)        /* Comparator interrupt vector word register */
#define CPIV15_H                         (0x0080)
#define CPIV_0                           (0x0000)        /* No interrupt pending */
#define CEIV_2                           (0x0002)        /* CPIFG */
#define CEIV_2_L                         (0x0002)
#define CPIV_4                           (0x0004)        /* CPIIFG */
#define CPIV_4_L                         (0x0004)
#define CPIV__NONE                       (0x0000)        /* No interrupt pending */
#define CPIV__CPIFG                      (0x0002)        /* CPIFG */
#define CPIV__CPIFG_L                    (0x0002)
#define CPIV__CPIIFG                     (0x0004)        /* CPIIFG */
#define CPIV__CPIIFG_L                   (0x0004)

/* CPDACCTL Control Bits */
#define CPDACSW                          (0x0001)        /* */
#define CPDACSW_L                        (0x0001)
#define CPDACSW_0                        (0x0000)        /* CPDACBUF1 selected */
#define CPDACSW_1                        (0x0001)        /* CPDACBUF2 selected */
#define CPDACSW_1_L                      (0x0001)
#define CPDACBUFS                        (0x0002)        /* */
#define CPDACBUFS_L                      (0x0002)
#define CPDACBUFS_0                      (0x0000)        /* Comparator output is selected as the buffer control source */
#define CPDACBUFS_1                      (0x0002)        /* CPDACSW bit is selected as the buffer control source */
#define CPDACBUFS_1_L                    (0x0002)
#define CPDACREFS                        (0x0004)        /* */
#define CPDACREFS_L                      (0x0004)
#define CPDACREFS_0                      (0x0000)        /* VDD selected */
#define CPDACREFS_1                      (0x0004)        /* on-chip VREF selected */
#define CPDACREFS_1_L                    (0x0004)
#define CPDACEN                          (0x0080)        /* */
#define CPDACEN_L                        (0x0080)
#define CPDACEN_0                        (0x0000)        /* DAC output is disabled. */
#define CPDACEN_1                        (0x0080)        /* DAC output is enabled. */
#define CPDACEN_1_L                      (0x0080)

/* CPDACDATA Control Bits */
#define CPDACBUF1                        (0x003f)        /* */
#define CPDACBUF1_L                      (0x003f)
#define CPDACBUF10                       (0x0001)        /* */
#define CPDACBUF10_L                     (0x0001)
#define CPDACBUF11                       (0x0002)        /* */
#define CPDACBUF11_L                     (0x0002)
#define CPDACBUF12                       (0x0004)        /* */
#define CPDACBUF12_L                     (0x0004)
#define CPDACBUF13                       (0x0008)        /* */
#define CPDACBUF13_L                     (0x0008)
#define CPDACBUF14                       (0x0010)        /* */
#define CPDACBUF14_L                     (0x0010)
#define CPDACBUF15                       (0x0020)        /* */
#define CPDACBUF15_L                     (0x0020)
#define CPDACBUF1_0                      (0x0000)        /* 0v */
#define CPDACBUF1_1                      (0x0001)        /* selected reference voltage * 1/64 */
#define CPDACBUF1_1_L                    (0x0001)
#define CPDACBUF1_2                      (0x0002)        /* selected reference voltage * 2/64 */
#define CPDACBUF1_2_L                    (0x0002)
#define CPDACBUF1_3                      (0x0003)        /* selected reference voltage * 3/64 */
#define CPDACBUF1_3_L                    (0x0003)
#define CPDACBUF1_4                      (0x0004)        /* selected reference voltage * 4/64 */
#define CPDACBUF1_4_L                    (0x0004)
#define CPDACBUF1_5                      (0x0005)        /* selected reference voltage * 5/64 */
#define CPDACBUF1_5_L                    (0x0005)
#define CPDACBUF1_6                      (0x0006)        /* selected reference voltage * 6/64 */
#define CPDACBUF1_6_L                    (0x0006)
#define CPDACBUF1_7                      (0x0007)        /* selected reference voltage * 7/64 */
#define CPDACBUF1_7_L                    (0x0007)
#define CPDACBUF1_8                      (0x0008)        /* selected reference voltage * 8/64 */
#define CPDACBUF1_8_L                    (0x0008)
#define CPDACBUF1_9                      (0x0009)        /* selected reference voltage *9/64 */
#define CPDACBUF1_9_L                    (0x0009)
#define CPDACBUF1_10                     (0x000a)        /* selected reference voltage * 10/64 */
#define CPDACBUF1_10_L                   (0x000a)
#define CPDACBUF1_11                     (0x000b)        /* selected reference voltage * 11/64 */
#define CPDACBUF1_11_L                   (0x000b)
#define CPDACBUF1_12                     (0x000c)        /* selected reference voltage * 12/64 */
#define CPDACBUF1_12_L                   (0x000c)
#define CPDACBUF1_13                     (0x000d)        /* selected reference voltage * 13/64 */
#define CPDACBUF1_13_L                   (0x000d)
#define CPDACBUF1_14                     (0x000e)        /* selected reference voltage * 14/64 */
#define CPDACBUF1_14_L                   (0x000e)
#define CPDACBUF1_15                     (0x000f)        /* selected reference voltage * 15/64 */
#define CPDACBUF1_15_L                   (0x000f)
#define CPDACBUF1_16                     (0x0010)        /* selected reference voltage * 16/64 */
#define CPDACBUF1_16_L                   (0x0010)
#define CPDACBUF1_17                     (0x0011)        /* selected reference voltage * 17/64 */
#define CPDACBUF1_17_L                   (0x0011)
#define CPDACBUF1_18                     (0x0012)        /* selected reference voltage * 18/64 */
#define CPDACBUF1_18_L                   (0x0012)
#define CPDACBUF1_19                     (0x0013)        /* selected reference voltage * 19/64 */
#define CPDACBUF1_19_L                   (0x0013)
#define CPDACBUF1_20                     (0x0014)        /* selected reference voltage * 20/64 */
#define CPDACBUF1_20_L                   (0x0014)
#define CPDACBUF1_21                     (0x0015)        /* selected reference voltage * 21/64 */
#define CPDACBUF1_21_L                   (0x0015)
#define CPDACBUF1_22                     (0x0016)        /* selected reference voltage * 22/64 */
#define CPDACBUF1_22_L                   (0x0016)
#define CPDACBUF1_23                     (0x0017)        /* selected reference voltage * 23/64 */
#define CPDACBUF1_23_L                   (0x0017)
#define CPDACBUF1_24                     (0x0018)        /* selected reference voltage * 24/64 */
#define CPDACBUF1_24_L                   (0x0018)
#define CPDACBUF1_25                     (0x0019)        /* selected reference voltage * 25/64 */
#define CPDACBUF1_25_L                   (0x0019)
#define CPDACBUF1_26                     (0x001a)        /* selected reference voltage * 26/64 */
#define CPDACBUF1_26_L                   (0x001a)
#define CPDACBUF1_27                     (0x001b)        /* selected reference voltage * 27/64 */
#define CPDACBUF1_27_L                   (0x001b)
#define CPDACBUF1_28                     (0x001c)        /* selected reference voltage * 28/64 */
#define CPDACBUF1_28_L                   (0x001c)
#define CPDACBUF1_29                     (0x001d)        /* selected reference voltage * 29/64 */
#define CPDACBUF1_29_L                   (0x001d)
#define CPDACBUF1_30                     (0x001e)        /* selected reference voltage * 30/64 */
#define CPDACBUF1_30_L                   (0x001e)
#define CPDACBUF1_31                     (0x001f)        /* selected reference voltage * 31/64 */
#define CPDACBUF1_31_L                   (0x001f)
#define CPDACBUF1_32                     (0x0020)        /* selected reference voltage * 32/64 */
#define CPDACBUF1_32_L                   (0x0020)
#define CPDACBUF1_33                     (0x0021)        /* selected reference voltage * 33/64 */
#define CPDACBUF1_33_L                   (0x0021)
#define CPDACBUF1_34                     (0x0022)        /* selected reference voltage * 34/64 */
#define CPDACBUF1_34_L                   (0x0022)
#define CPDACBUF1_35                     (0x0023)        /* selected reference voltage * 35/64 */
#define CPDACBUF1_35_L                   (0x0023)
#define CPDACBUF1_36                     (0x0024)        /* selected reference voltage * 36/64 */
#define CPDACBUF1_36_L                   (0x0024)
#define CPDACBUF1_37                     (0x0025)        /* selected reference voltage * 37/64 */
#define CPDACBUF1_37_L                   (0x0025)
#define CPDACBUF1_38                     (0x0026)        /* selected reference voltage * 38/64 */
#define CPDACBUF1_38_L                   (0x0026)
#define CPDACBUF1_39                     (0x0027)        /* selected reference voltage * 39/64 */
#define CPDACBUF1_39_L                   (0x0027)
#define CPDACBUF1_40                     (0x0028)        /* selected reference voltage * 40/64 */
#define CPDACBUF1_40_L                   (0x0028)
#define CPDACBUF1_41                     (0x0029)        /* selected reference voltage * 41/64 */
#define CPDACBUF1_41_L                   (0x0029)
#define CPDACBUF1_42                     (0x002a)        /* selected reference voltage * 42/64 */
#define CPDACBUF1_42_L                   (0x002a)
#define CPDACBUF1_43                     (0x002b)        /* selected reference voltage * 43/64 */
#define CPDACBUF1_43_L                   (0x002b)
#define CPDACBUF1_44                     (0x002c)        /* selected reference voltage * 44/64 */
#define CPDACBUF1_44_L                   (0x002c)
#define CPDACBUF1_45                     (0x002d)        /* selected reference voltage * 45/64 */
#define CPDACBUF1_45_L                   (0x002d)
#define CPDACBUF1_46                     (0x002e)        /* selected reference voltage * 46/64 */
#define CPDACBUF1_46_L                   (0x002e)
#define CPDACBUF1_47                     (0x002f)        /* selected reference voltage * 47/64 */
#define CPDACBUF1_47_L                   (0x002f)
#define CPDACBUF1_48                     (0x0030)        /* selected reference voltage * 48/64 */
#define CPDACBUF1_48_L                   (0x0030)
#define CPDACBUF1_49                     (0x0031)        /* selected reference voltage * 49/64 */
#define CPDACBUF1_49_L                   (0x0031)
#define CPDACBUF1_50                     (0x0032)        /* selected reference voltage * 50/64 */
#define CPDACBUF1_50_L                   (0x0032)
#define CPDACBUF1_51                     (0x0033)        /* selected reference voltage * 51/64 */
#define CPDACBUF1_51_L                   (0x0033)
#define CPDACBUF1_52                     (0x0034)        /* selected reference voltage * 52/64 */
#define CPDACBUF1_52_L                   (0x0034)
#define CPDACBUF1_53                     (0x0035)        /* selected reference voltage * 53/64 */
#define CPDACBUF1_53_L                   (0x0035)
#define CPDACBUF1_54                     (0x0036)        /* selected reference voltage * 54/64 */
#define CPDACBUF1_54_L                   (0x0036)
#define CPDACBUF1_55                     (0x0037)        /* selected reference voltage * 55/64 */
#define CPDACBUF1_55_L                   (0x0037)
#define CPDACBUF1_56                     (0x0038)        /* selected reference voltage * 56/64 */
#define CPDACBUF1_56_L                   (0x0038)
#define CPDACBUF1_57                     (0x0039)        /* selected reference voltage * 57/64 */
#define CPDACBUF1_57_L                   (0x0039)
#define CPDACBUF1_58                     (0x003a)        /* selected reference voltage * 58/64 */
#define CPDACBUF1_58_L                   (0x003a)
#define CPDACBUF1_59                     (0x003b)        /* selected reference voltage * 59/64 */
#define CPDACBUF1_59_L                   (0x003b)
#define CPDACBUF1_60                     (0x003c)        /* selected reference voltage * 60/64 */
#define CPDACBUF1_60_L                   (0x003c)
#define CPDACBUF1_61                     (0x003d)        /* selected reference voltage * 61/64 */
#define CPDACBUF1_61_L                   (0x003d)
#define CPDACBUF1_62                     (0x003e)        /* selected reference voltage * 62/64 */
#define CPDACBUF1_62_L                   (0x003e)
#define CPDACBUF1_63                     (0x003f)        /* selected reference voltage * 63/64 */
#define CPDACBUF1_63_L                   (0x003f)
#define CPDACBUF2                        (0x3f00)        /* */
#define CPDACBUF2_H                      (0x003f)
#define CPDACBUF20                       (0x0100)        /* */
#define CPDACBUF20_H                     (0x0001)
#define CPDACBUF21                       (0x0200)        /* */
#define CPDACBUF21_H                     (0x0002)
#define CPDACBUF22                       (0x0400)        /* */
#define CPDACBUF22_H                     (0x0004)
#define CPDACBUF23                       (0x0800)        /* */
#define CPDACBUF23_H                     (0x0008)
#define CPDACBUF24                       (0x1000)        /* */
#define CPDACBUF24_H                     (0x0010)
#define CPDACBUF25                       (0x2000)        /* */
#define CPDACBUF25_H                     (0x0020)
#define CPDACBUF2_0                      (0x0000)        /* 0v */
#define CPDACBUF2_1                      (0x0100)        /* selected reference voltage * 1/64 */
#define CPDACBUF2_1_H                    (0x0001)
#define CPDACBUF2_2                      (0x0200)        /* selected reference voltage * 2/64 */
#define CPDACBUF2_2_H                    (0x0002)
#define CPDACBUF2_3                      (0x0300)        /* selected reference voltage * 3/64 */
#define CPDACBUF2_3_H                    (0x0003)
#define CPDACBUF2_4                      (0x0400)        /* selected reference voltage * 4/64 */
#define CPDACBUF2_4_H                    (0x0004)
#define CPDACBUF2_5                      (0x0500)        /* selected reference voltage * 5/64 */
#define CPDACBUF2_5_H                    (0x0005)
#define CPDACBUF2_6                      (0x0600)        /* selected reference voltage * 6/64 */
#define CPDACBUF2_6_H                    (0x0006)
#define CPDACBUF2_7                      (0x0700)        /* selected reference voltage * 7/64 */
#define CPDACBUF2_7_H                    (0x0007)
#define CPDACBUF2_8                      (0x0800)        /* selected reference voltage * 8/64 */
#define CPDACBUF2_8_H                    (0x0008)
#define CPDACBUF2_9                      (0x0900)        /* selected reference voltage * 9/64 */
#define CPDACBUF2_9_H                    (0x0009)
#define CPDACBUF2_10                     (0x0a00)        /* selected reference voltage * 10/64 */
#define CPDACBUF2_10_H                   (0x000a)
#define CPDACBUF2_11                     (0x0b00)        /* selected reference voltage * 11/64 */
#define CPDACBUF2_11_H                   (0x000b)
#define CPDACBUF2_12                     (0x0c00)        /* selected reference voltage * 12/64 */
#define CPDACBUF2_12_H                   (0x000c)
#define CPDACBUF2_13                     (0x0d00)        /* selected reference voltage * 13/64 */
#define CPDACBUF2_13_H                   (0x000d)
#define CPDACBUF2_14                     (0x0e00)        /* selected reference voltage * 14/64 */
#define CPDACBUF2_14_H                   (0x000e)
#define CPDACBUF2_15                     (0x0f00)        /* selected reference voltage * 15/64 */
#define CPDACBUF2_15_H                   (0x000f)
#define CPDACBUF2_16                     (0x1000)        /* selected reference voltage * 16/64 */
#define CPDACBUF2_16_H                   (0x0010)
#define CPDACBUF2_17                     (0x1100)        /* selected reference voltage * 17/64 */
#define CPDACBUF2_17_H                   (0x0011)
#define CPDACBUF2_18                     (0x1200)        /* selected reference voltage * 18/64 */
#define CPDACBUF2_18_H                   (0x0012)
#define CPDACBUF2_19                     (0x1300)        /* selected reference voltage * 19/64 */
#define CPDACBUF2_19_H                   (0x0013)
#define CPDACBUF2_20                     (0x1400)        /* selected reference voltage * 20/64 */
#define CPDACBUF2_20_H                   (0x0014)
#define CPDACBUF2_21                     (0x1500)        /* selected reference voltage * 21/64 */
#define CPDACBUF2_21_H                   (0x0015)
#define CPDACBUF2_22                     (0x1600)        /* selected reference voltage * 22/64 */
#define CPDACBUF2_22_H                   (0x0016)
#define CPDACBUF2_23                     (0x1700)        /* selected reference voltage * 23/64 */
#define CPDACBUF2_23_H                   (0x0017)
#define CPDACBUF2_24                     (0x1800)        /* selected reference voltage * 24/64 */
#define CPDACBUF2_24_H                   (0x0018)
#define CPDACBUF2_25                     (0x1900)        /* selected reference voltage * 25/64 */
#define CPDACBUF2_25_H                   (0x0019)
#define CPDACBUF2_26                     (0x1a00)        /* selected reference voltage * 26/64 */
#define CPDACBUF2_26_H                   (0x001a)
#define CPDACBUF2_27                     (0x1b00)        /* selected reference voltage * 27/64 */
#define CPDACBUF2_27_H                   (0x001b)
#define CPDACBUF2_28                     (0x1c00)        /* selected reference voltage * 28/64 */
#define CPDACBUF2_28_H                   (0x001c)
#define CPDACBUF2_29                     (0x1d00)        /* selected reference voltage * 29/64 */
#define CPDACBUF2_29_H                   (0x001d)
#define CPDACBUF2_30                     (0x1e00)        /* selected reference voltage * 30/64 */
#define CPDACBUF2_30_H                   (0x001e)
#define CPDACBUF2_31                     (0x1f00)        /* selected reference voltage * 31/64 */
#define CPDACBUF2_31_H                   (0x001f)
#define CPDACBUF2_32                     (0x2000)        /* selected reference voltage * 32/64 */
#define CPDACBUF2_32_H                   (0x0020)
#define CPDACBUF2_33                     (0x2100)        /* selected reference voltage * 33/64 */
#define CPDACBUF2_33_H                   (0x0021)
#define CPDACBUF2_34                     (0x2200)        /* selected reference voltage * 34/64 */
#define CPDACBUF2_34_H                   (0x0022)
#define CPDACBUF2_35                     (0x2300)        /* selected reference voltage * 35/64 */
#define CPDACBUF2_35_H                   (0x0023)
#define CPDACBUF2_36                     (0x2400)        /* selected reference voltage * 36/64 */
#define CPDACBUF2_36_H                   (0x0024)
#define CPDACBUF2_37                     (0x2500)        /* selected reference voltage * 37/64 */
#define CPDACBUF2_37_H                   (0x0025)
#define CPDACBUF2_38                     (0x2600)        /* selected reference voltage * 38/64 */
#define CPDACBUF2_38_H                   (0x0026)
#define CPDACBUF2_39                     (0x2700)        /* selected reference voltage * 39/64 */
#define CPDACBUF2_39_H                   (0x0027)
#define CPDACBUF2_40                     (0x2800)        /* selected reference voltage * 40/64 */
#define CPDACBUF2_40_H                   (0x0028)
#define CPDACBUF2_41                     (0x2900)        /* selected reference voltage * 41/64 */
#define CPDACBUF2_41_H                   (0x0029)
#define CPDACBUF2_42                     (0x2a00)        /* selected reference voltage * 42/64 */
#define CPDACBUF2_42_H                   (0x002a)
#define CPDACBUF2_43                     (0x2b00)        /* selected reference voltage * 43/64 */
#define CPDACBUF2_43_H                   (0x002b)
#define CPDACBUF2_44                     (0x2c00)        /* selected reference voltage * 44/64 */
#define CPDACBUF2_44_H                   (0x002c)
#define CPDACBUF2_45                     (0x2d00)        /* selected reference voltage * 45/64 */
#define CPDACBUF2_45_H                   (0x002d)
#define CPDACBUF2_46                     (0x2e00)        /* selected reference voltage * 46/64 */
#define CPDACBUF2_46_H                   (0x002e)
#define CPDACBUF2_47                     (0x2f00)        /* selected reference voltage * 47/64 */
#define CPDACBUF2_47_H                   (0x002f)
#define CPDACBUF2_48                     (0x3000)        /* selected reference voltage * 48/64 */
#define CPDACBUF2_48_H                   (0x0030)
#define CPDACBUF2_49                     (0x3100)        /* selected reference voltage * 49/64 */
#define CPDACBUF2_49_H                   (0x0031)
#define CPDACBUF2_50                     (0x3200)        /* selected reference voltage * 50/64 */
#define CPDACBUF2_50_H                   (0x0032)
#define CPDACBUF2_51                     (0x3300)        /* selected reference voltage * 51/64 */
#define CPDACBUF2_51_H                   (0x0033)
#define CPDACBUF2_52                     (0x3400)        /* selected reference voltage * 52/64 */
#define CPDACBUF2_52_H                   (0x0034)
#define CPDACBUF2_53                     (0x3500)        /* selected reference voltage * 53/64 */
#define CPDACBUF2_53_H                   (0x0035)
#define CPDACBUF2_54                     (0x3600)        /* selected reference voltage * 54/64 */
#define CPDACBUF2_54_H                   (0x0036)
#define CPDACBUF2_55                     (0x3700)        /* selected reference voltage * 55/64 */
#define CPDACBUF2_55_H                   (0x0037)
#define CPDACBUF2_56                     (0x3800)        /* selected reference voltage * 56/64 */
#define CPDACBUF2_56_H                   (0x0038)
#define CPDACBUF2_57                     (0x3900)        /* selected reference voltage * 57/64 */
#define CPDACBUF2_57_H                   (0x0039)
#define CPDACBUF2_58                     (0x3a00)        /* selected reference voltage * 58/64 */
#define CPDACBUF2_58_H                   (0x003a)
#define CPDACBUF2_59                     (0x3b00)        /* selected reference voltage * 59/64 */
#define CPDACBUF2_59_H                   (0x003b)
#define CPDACBUF2_60                     (0x3c00)        /* selected reference voltage * 60/64 */
#define CPDACBUF2_60_H                   (0x003c)
#define CPDACBUF2_61                     (0x3d00)        /* selected reference voltage * 61/64 */
#define CPDACBUF2_61_H                   (0x003d)
#define CPDACBUF2_62                     (0x3e00)        /* selected reference voltage * 62/64 */
#define CPDACBUF2_62_H                   (0x003e)
#define CPDACBUF2_63                     (0x3f00)        /* selected reference voltage * 63/64 */
#define CPDACBUF2_63_H                   (0x003f)


/*****************************************************************************
 eUSCI_A0 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_A0__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Ax__
#define __MSP430_HAS_EUSCI_Ax__
#endif
#define __MSP430_BASEADDRESS_EUSCI_A0__ 0x0500
#define EUSCI_A0_BASE          __MSP430_BASEADDRESS_EUSCI_A0__

sfr_w(UCA0CTLW0);                             /* eUSCI_Ax Control Word Register 0 */
sfr_b(UCA0CTLW0_L);
sfr_b(UCA0CTLW0_H);
sfr_w(UCA0CTLW1);                             /* eUSCI_Ax Control Word Register 1 */
sfr_b(UCA0CTLW1_L);
sfr_b(UCA0CTLW1_H);
sfr_w(UCA0BRW);                               /* eUSCI_Ax Baud Rate Control Word Register */
sfr_b(UCA0BRW_L);
sfr_b(UCA0BRW_H);
sfr_w(UCA0MCTLW);                             /* eUSCI_Ax Modulation Control Word Register */
sfr_b(UCA0MCTLW_L);
sfr_b(UCA0MCTLW_H);
sfr_w(UCA0STATW);                             /* eUSCI_Ax Status Register */
sfr_b(UCA0STATW_L);
sfr_b(UCA0STATW_H);
sfr_w(UCA0RXBUF);                             /* eUSCI_Ax Receive Buffer Register */
sfr_b(UCA0RXBUF_L);
sfr_b(UCA0RXBUF_H);
sfr_w(UCA0TXBUF);                             /* eUSCI_Ax Transmit Buffer Register */
sfr_b(UCA0TXBUF_L);
sfr_b(UCA0TXBUF_H);
sfr_w(UCA0ABCTL);                             /* eUSCI_Ax Auto Baud Rate Control Register */
sfr_b(UCA0ABCTL_L);
sfr_b(UCA0ABCTL_H);
sfr_w(UCA0IRCTL);                             /* eUSCI_Ax IrDA Control Word Register */
sfr_b(UCA0IRCTL_L);
sfr_b(UCA0IRCTL_H);
sfr_w(UCA0IE);                                /* eUSCI_Ax Interrupt Enable Register */
sfr_b(UCA0IE_L);
sfr_b(UCA0IE_H);
sfr_w(UCA0IFG);                               /* eUSCI_Ax Interrupt Flag Register */
sfr_b(UCA0IFG_L);
sfr_b(UCA0IFG_H);
sfr_w(UCA0IV);                                /* eUSCI_Ax Interrupt Vector Register */
sfr_b(UCA0IV_L);
sfr_b(UCA0IV_H);

/* eUSCI_A0 Register Offsets */
#define OFS_UCA0CTLW0                    (0x0000)
#define OFS_UCA0CTLW0_L                  OFS_UCA0CTLW0
#define OFS_UCA0CTLW0_H                  OFS_UCA0CTLW0+1
#define OFS_UCA0CTLW1                    (0x0002)
#define OFS_UCA0CTLW1_L                  OFS_UCA0CTLW1
#define OFS_UCA0CTLW1_H                  OFS_UCA0CTLW1+1
#define OFS_UCA0BRW                      (0x0006)
#define OFS_UCA0BRW_L                    OFS_UCA0BRW
#define OFS_UCA0BRW_H                    OFS_UCA0BRW+1
#define OFS_UCA0MCTLW                    (0x0008)
#define OFS_UCA0MCTLW_L                  OFS_UCA0MCTLW
#define OFS_UCA0MCTLW_H                  OFS_UCA0MCTLW+1
#define OFS_UCA0STATW                    (0x000A)
#define OFS_UCA0STATW_L                  OFS_UCA0STATW
#define OFS_UCA0STATW_H                  OFS_UCA0STATW+1
#define OFS_UCA0RXBUF                    (0x000C)
#define OFS_UCA0RXBUF_L                  OFS_UCA0RXBUF
#define OFS_UCA0RXBUF_H                  OFS_UCA0RXBUF+1
#define OFS_UCA0TXBUF                    (0x000E)
#define OFS_UCA0TXBUF_L                  OFS_UCA0TXBUF
#define OFS_UCA0TXBUF_H                  OFS_UCA0TXBUF+1
#define OFS_UCA0ABCTL                    (0x0010)
#define OFS_UCA0ABCTL_L                  OFS_UCA0ABCTL
#define OFS_UCA0ABCTL_H                  OFS_UCA0ABCTL+1
#define OFS_UCA0IRCTL                    (0x0012)
#define OFS_UCA0IRCTL_L                  OFS_UCA0IRCTL
#define OFS_UCA0IRCTL_H                  OFS_UCA0IRCTL+1
#define OFS_UCA0IE                       (0x001A)
#define OFS_UCA0IE_L                     OFS_UCA0IE
#define OFS_UCA0IE_H                     OFS_UCA0IE+1
#define OFS_UCA0IFG                      (0x001C)
#define OFS_UCA0IFG_L                    OFS_UCA0IFG
#define OFS_UCA0IFG_H                    OFS_UCA0IFG+1
#define OFS_UCA0IV                       (0x001E)
#define OFS_UCA0IV_L                     OFS_UCA0IV
#define OFS_UCA0IV_H                     OFS_UCA0IV+1

/* eUSCI_A0 Control Bits */

/* UCA0CTLW0 Control Bits */
#define UCSWRST                          (0x0001)        /* Software reset enable */
#define UCSWRST_L                        (0x0001)
#define UCSWRST_0                        (0x0000)        /* Disabled. eUSCI_A reset released for operation */
#define UCSWRST_1                        (0x0001)        /* Enabled. eUSCI_A logic held in reset state */
#define UCSWRST_1_L                      (0x0001)
#define UCSWRST__DISABLE                 (0x0000)        /* Disabled. eUSCI_A reset released for operation */
#define UCSWRST__ENABLE                  (0x0001)        /* Enabled. eUSCI_A logic held in reset state */
#define UCSWRST__ENABLE_L                (0x0001)
#define UCTXBRK                          (0x0002)        /* Transmit break */
#define UCTXBRK_L                        (0x0002)
#define UCTXBRK_0                        (0x0000)        /* Next frame transmitted is not a break */
#define UCTXBRK_1                        (0x0002)        /* Next frame transmitted is a break or a break/synch */
#define UCTXBRK_1_L                      (0x0002)
#define UCTXADDR                         (0x0004)        /* Transmit address */
#define UCTXADDR_L                       (0x0004)
#define UCTXADDR_0                       (0x0000)        /* Next frame transmitted is data */
#define UCTXADDR_1                       (0x0004)        /* Next frame transmitted is an address */
#define UCTXADDR_1_L                     (0x0004)
#define UCDORM                           (0x0008)        /* Dormant */
#define UCDORM_L                         (0x0008)
#define UCDORM_0                         (0x0000)        /* Not dormant. All received characters set UCRXIFG. */
#define UCDORM_1                         (0x0008)        /* Dormant. Only characters that are preceded by an idle-line or 
                                                            with address bit set UCRXIFG. In UART mode with automatic 
                                                            baud-rate detection, only the combination of a break and synch
                                                            field sets UCRXIFG. */
#define UCDORM_1_L                       (0x0008)
#define UCBRKIE                          (0x0010)        /* Receive break character interrupt enable */
#define UCBRKIE_L                        (0x0010)
#define UCBRKIE_0                        (0x0000)        /* Received break characters do not set UCRXIFG */
#define UCBRKIE_1                        (0x0010)        /* Received break characters set UCRXIFG */
#define UCBRKIE_1_L                      (0x0010)
#define UCRXEIE                          (0x0020)        /* Receive erroneous-character interrupt enable */
#define UCRXEIE_L                        (0x0020)
#define UCRXEIE_0                        (0x0000)        /* Erroneous characters rejected and UCRXIFG is not set */
#define UCRXEIE_1                        (0x0020)        /* Erroneous characters received set UCRXIFG */
#define UCRXEIE_1_L                      (0x0020)
#define UCSSEL                           (0x00c0)        /* eUSCI_A clock source select */
#define UCSSEL_L                         (0x00c0)
#define UCSSEL0                          (0x0040)        /* eUSCI_A clock source select */
#define UCSSEL0_L                        (0x0040)
#define UCSSEL1                          (0x0080)        /* eUSCI_A clock source select */
#define UCSSEL1_L                        (0x0080)
#define UCSSEL_0                         (0x0000)        /* UCLK */
#define UCSSEL_1                         (0x0040)        /* ACLK */
#define UCSSEL_1_L                       (0x0040)
#define UCSSEL_2                         (0x0080)        /* SMCLK */
#define UCSSEL_2_L                       (0x0080)
#define UCSSEL_3                         (0x00c0)        /* SMCLK */
#define UCSSEL_3_L                       (0x00c0)
#define UCSSEL__UCLK                     (0x0000)        /* UCLK */
#define UCSSEL__ACLK                     (0x0040)        /* ACLK */
#define UCSSEL__ACLK_L                   (0x0040)
#define UCSSEL__SMCLK                    (0x0080)        /* SMCLK */
#define UCSSEL__SMCLK_L                  (0x0080)
#define UCSYNC                           (0x0100)        /* Synchronous mode enable */
#define UCSYNC_H                         (0x0001)
#define UCSYNC_0                         (0x0000)        /* Asynchronous mode */
#define UCSYNC_1                         (0x0100)        /* Synchronous mode */
#define UCSYNC_1_H                       (0x0001)
#define UCSYNC__ASYNC                    (0x0000)        /* Asynchronous mode */
#define UCSYNC__SYNC                     (0x0100)        /* Synchronous mode */
#define UCSYNC__SYNC_H                   (0x0001)
#define UCMODE                           (0x0600)        /* eUSCI_A mode */
#define UCMODE_H                         (0x0006)
#define UCMODE0                          (0x0200)        /* eUSCI_A mode */
#define UCMODE0_H                        (0x0002)
#define UCMODE1                          (0x0400)        /* eUSCI_A mode */
#define UCMODE1_H                        (0x0004)
#define UCMODE_0                         (0x0000)        /* UART mode */
#define UCMODE_1                         (0x0200)        /* Idle-line multiprocessor mode */
#define UCMODE_1_H                       (0x0002)
#define UCMODE_2                         (0x0400)        /* Address-bit multiprocessor mode */
#define UCMODE_2_H                       (0x0004)
#define UCMODE_3                         (0x0600)        /* UART mode with automatic baud-rate detection */
#define UCMODE_3_H                       (0x0006)
#define UCSPB                            (0x0800)        /* Stop bit select */
#define UCSPB_H                          (0x0008)
#define UCSPB_0                          (0x0000)        /* One stop bit */
#define UCSPB_1                          (0x0800)        /* Two stop bits */
#define UCSPB_1_H                        (0x0008)
#define UC7BIT                           (0x1000)        /* Character length */
#define UC7BIT_H                         (0x0010)
#define UC7BIT_0                         (0x0000)        /* 8-bit data */
#define UC7BIT_1                         (0x1000)        /* 7-bit data */
#define UC7BIT_1_H                       (0x0010)
#define UC7BIT__8BIT                     (0x0000)        /* 8-bit data */
#define UC7BIT__7BIT                     (0x1000)        /* 7-bit data */
#define UC7BIT__7BIT_H                   (0x0010)
#define UCMSB                            (0x2000)        /* MSB first select */
#define UCMSB_H                          (0x0020)
#define UCMSB_0                          (0x0000)        /* LSB first */
#define UCMSB_1                          (0x2000)        /* MSB first */
#define UCMSB_1_H                        (0x0020)
#define UCPAR                            (0x4000)        /* Parity select */
#define UCPAR_H                          (0x0040)
#define UCPAR_0                          (0x0000)        /* Odd parity */
#define UCPAR_1                          (0x4000)        /* Even parity */
#define UCPAR_1_H                        (0x0040)
#define UCPAR__ODD                       (0x0000)        /* Odd parity */
#define UCPAR__EVEN                      (0x4000)        /* Even parity */
#define UCPAR__EVEN_H                    (0x0040)
#define UCPEN                            (0x8000)        /* Parity enable */
#define UCPEN_H                          (0x0080)
#define UCPEN_0                          (0x0000)        /* Parity disabled */
#define UCPEN_1                          (0x8000)        /* Parity enabled. Parity bit is generated (UCAxTXD) and expected
                                                            (UCAxRXD). In address-bit multiprocessor mode, the address bit
                                                            is included in the parity calculation. */
#define UCPEN_1_H                        (0x0080)

/* UCA0CTLW0_SPI Control Bits */
#define UCSTEM                           (0x0002)        /* STE mode select in master mode. */
#define UCSTEM_L                         (0x0002)
#define UCSTEM_0                         (0x0000)        /* STE pin is used to prevent conflicts with other masters */
#define UCSTEM_1                         (0x0002)        /* STE pin is used to generate the enable signal for a 4-wire 
                                                            slave */
#define UCSTEM_1_L                       (0x0002)
#define UCMST                            (0x0800)        /* Master mode select */
#define UCMST_H                          (0x0008)
#define UCMST_0                          (0x0000)        /* Slave mode */
#define UCMST_1                          (0x0800)        /* Master mode */
#define UCMST_1_H                        (0x0008)
#define UCMST__SLAVE                     (0x0000)        /* Slave mode */
#define UCMST__MASTER                    (0x0800)        /* Master mode */
#define UCMST__MASTER_H                  (0x0008)
#define UCCKPL                           (0x4000)        /* Clock polarity select */
#define UCCKPL_H                         (0x0040)
#define UCCKPL_0                         (0x0000)        /* The inactive state is low */
#define UCCKPL_1                         (0x4000)        /* The inactive state is high */
#define UCCKPL_1_H                       (0x0040)
#define UCCKPL__LOW                      (0x0000)        /* The inactive state is low */
#define UCCKPL__HIGH                     (0x4000)        /* The inactive state is high */
#define UCCKPL__HIGH_H                   (0x0040)
#define UCCKPH                           (0x8000)        /* Clock phase select */
#define UCCKPH_H                         (0x0080)
#define UCCKPH_0                         (0x0000)        /* Data is changed on the first UCLK edge and captured on the 
                                                            following edge. */
#define UCCKPH_1                         (0x8000)        /* Data is captured on the first UCLK edge and changed on the 
                                                            following edge. */
#define UCCKPH_1_H                       (0x0080)

/* UCA0CTLW1 Control Bits */
#define UCGLIT                           (0x0003)        /* Deglitch time */
#define UCGLIT_L                         (0x0003)
#define UCGLIT0                          (0x0001)        /* Deglitch time */
#define UCGLIT0_L                        (0x0001)
#define UCGLIT1                          (0x0002)        /* Deglitch time */
#define UCGLIT1_L                        (0x0002)
#define UCGLIT_0                         (0x0000)        /* Approximately 2 ns (equivalent of 1 delay element) */
#define UCGLIT_1                         (0x0001)        /* Approximately 50 ns */
#define UCGLIT_1_L                       (0x0001)
#define UCGLIT_2                         (0x0002)        /* Approximately 100 ns */
#define UCGLIT_2_L                       (0x0002)
#define UCGLIT_3                         (0x0003)        /* Approximately 200 ns */
#define UCGLIT_3_L                       (0x0003)

/* UCA0BRW Control Bits */
#define UCBR                             (0xffff)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR_L                           (0x00ff)
#define UCBR_H                           (0x00ff)
#define UCBR0                            (0x0001)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR0_L                          (0x0001)
#define UCBR1                            (0x0002)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR1_L                          (0x0002)
#define UCBR2                            (0x0004)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR2_L                          (0x0004)
#define UCBR3                            (0x0008)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR3_L                          (0x0008)
#define UCBR4                            (0x0010)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR4_L                          (0x0010)
#define UCBR5                            (0x0020)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR5_L                          (0x0020)
#define UCBR6                            (0x0040)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR6_L                          (0x0040)
#define UCBR7                            (0x0080)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR7_L                          (0x0080)
#define UCBR8                            (0x0100)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR8_H                          (0x0001)
#define UCBR9                            (0x0200)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR9_H                          (0x0002)
#define UCBR10                           (0x0400)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR10_H                         (0x0004)
#define UCBR11                           (0x0800)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR11_H                         (0x0008)
#define UCBR12                           (0x1000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR12_H                         (0x0010)
#define UCBR13                           (0x2000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR13_H                         (0x0020)
#define UCBR14                           (0x4000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR14_H                         (0x0040)
#define UCBR15                           (0x8000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR15_H                         (0x0080)

/* UCA0MCTLW Control Bits */
#define UCOS16                           (0x0001)        /* Oversampling mode enabled */
#define UCOS16_L                         (0x0001)
#define UCOS16_0                         (0x0000)        /* Disabled */
#define UCOS16_1                         (0x0001)        /* Enabled */
#define UCOS16_1_L                       (0x0001)
#define UCBRF                            (0x00f0)        /* First modulation stage select */
#define UCBRF_L                          (0x00f0)
#define UCBRF0                           (0x0010)        /* First modulation stage select */
#define UCBRF0_L                         (0x0010)
#define UCBRF1                           (0x0020)        /* First modulation stage select */
#define UCBRF1_L                         (0x0020)
#define UCBRF2                           (0x0040)        /* First modulation stage select */
#define UCBRF2_L                         (0x0040)
#define UCBRF3                           (0x0080)        /* First modulation stage select */
#define UCBRF3_L                         (0x0080)
#define UCBRS                            (0xff00)        /* Second modulation stage select */
#define UCBRS_H                          (0x00ff)
#define UCBRS0                           (0x0100)        /* Second modulation stage select */
#define UCBRS0_H                         (0x0001)
#define UCBRS1                           (0x0200)        /* Second modulation stage select */
#define UCBRS1_H                         (0x0002)
#define UCBRS2                           (0x0400)        /* Second modulation stage select */
#define UCBRS2_H                         (0x0004)
#define UCBRS3                           (0x0800)        /* Second modulation stage select */
#define UCBRS3_H                         (0x0008)
#define UCBRS4                           (0x1000)        /* Second modulation stage select */
#define UCBRS4_H                         (0x0010)
#define UCBRS5                           (0x2000)        /* Second modulation stage select */
#define UCBRS5_H                         (0x0020)
#define UCBRS6                           (0x4000)        /* Second modulation stage select */
#define UCBRS6_H                         (0x0040)
#define UCBRS7                           (0x8000)        /* Second modulation stage select */
#define UCBRS7_H                         (0x0080)

/* UCA0STATW Control Bits */
#define UCBUSY                           (0x0001)        /* eUSCI_A busy */
#define UCBUSY_L                         (0x0001)
#define UCBUSY_0                         (0x0000)        /* eUSCI_A inactive */
#define UCBUSY_1                         (0x0001)        /* eUSCI_A transmitting or receiving */
#define UCBUSY_1_L                       (0x0001)
#define UCBUSY__IDLE                     (0x0000)        /* eUSCI_A inactive */
#define UCBUSY__BUSY                     (0x0001)        /* eUSCI_A transmitting or receiving */
#define UCBUSY__BUSY_L                   (0x0001)
#define UCADDR_UCIDLE                    (0x0002)        /* Address received / Idle line detected */
#define UCADDR_UCIDLE_L                  (0x0002)
#define UCADDR_UCIDLE_0                  (0x0000)        /* UCADDR: Received character is data. UCIDLE: No idle line 
                                                            detected */
#define UCADDR_UCIDLE_1                  (0x0002)        /* UCADDR: Received character is an address. UCIDLE: Idle line 
                                                            detected */
#define UCADDR_UCIDLE_1_L                (0x0002)
#define UCRXERR                          (0x0004)        /* Receive error flag */
#define UCRXERR_L                        (0x0004)
#define UCRXERR_0                        (0x0000)        /* No receive errors detected */
#define UCRXERR_1                        (0x0004)        /* Receive error detected */
#define UCRXERR_1_L                      (0x0004)
#define UCBRK                            (0x0008)        /* Break detect flag */
#define UCBRK_L                          (0x0008)
#define UCBRK_0                          (0x0000)        /* No break condition */
#define UCBRK_1                          (0x0008)        /* Break condition occurred */
#define UCBRK_1_L                        (0x0008)
#define UCPE                             (0x0010)        /* */
#define UCPE_L                           (0x0010)
#define UCPE_0                           (0x0000)        /* No error */
#define UCPE_1                           (0x0010)        /* Character received with parity error */
#define UCPE_1_L                         (0x0010)
#define UCOE                             (0x0020)        /* Overrun error flag */
#define UCOE_L                           (0x0020)
#define UCOE_0                           (0x0000)        /* No error */
#define UCOE_1                           (0x0020)        /* Overrun error occurred */
#define UCOE_1_L                         (0x0020)
#define UCFE                             (0x0040)        /* Framing error flag */
#define UCFE_L                           (0x0040)
#define UCFE_0                           (0x0000)        /* No error */
#define UCFE_1                           (0x0040)        /* Character received with low stop bit */
#define UCFE_1_L                         (0x0040)
#define UCLISTEN                         (0x0080)        /* Listen enable */
#define UCLISTEN_L                       (0x0080)
#define UCLISTEN_0                       (0x0000)        /* Disabled */
#define UCLISTEN_1                       (0x0080)        /* Enabled. UCAxTXD is internally fed back to the receiver */
#define UCLISTEN_1_L                     (0x0080)

/* UCA0RXBUF Control Bits */
#define UCRXBUF                          (0x00ff)        /* Receive data buffer */
#define UCRXBUF_L                        (0x00ff)
#define UCRXBUF0                         (0x0001)        /* Receive data buffer */
#define UCRXBUF0_L                       (0x0001)
#define UCRXBUF1                         (0x0002)        /* Receive data buffer */
#define UCRXBUF1_L                       (0x0002)
#define UCRXBUF2                         (0x0004)        /* Receive data buffer */
#define UCRXBUF2_L                       (0x0004)
#define UCRXBUF3                         (0x0008)        /* Receive data buffer */
#define UCRXBUF3_L                       (0x0008)
#define UCRXBUF4                         (0x0010)        /* Receive data buffer */
#define UCRXBUF4_L                       (0x0010)
#define UCRXBUF5                         (0x0020)        /* Receive data buffer */
#define UCRXBUF5_L                       (0x0020)
#define UCRXBUF6                         (0x0040)        /* Receive data buffer */
#define UCRXBUF6_L                       (0x0040)
#define UCRXBUF7                         (0x0080)        /* Receive data buffer */
#define UCRXBUF7_L                       (0x0080)

/* UCA0TXBUF Control Bits */
#define UCTXBUF                          (0x00ff)        /* Transmit data buffer */
#define UCTXBUF_L                        (0x00ff)
#define UCTXBUF0                         (0x0001)        /* Transmit data buffer */
#define UCTXBUF0_L                       (0x0001)
#define UCTXBUF1                         (0x0002)        /* Transmit data buffer */
#define UCTXBUF1_L                       (0x0002)
#define UCTXBUF2                         (0x0004)        /* Transmit data buffer */
#define UCTXBUF2_L                       (0x0004)
#define UCTXBUF3                         (0x0008)        /* Transmit data buffer */
#define UCTXBUF3_L                       (0x0008)
#define UCTXBUF4                         (0x0010)        /* Transmit data buffer */
#define UCTXBUF4_L                       (0x0010)
#define UCTXBUF5                         (0x0020)        /* Transmit data buffer */
#define UCTXBUF5_L                       (0x0020)
#define UCTXBUF6                         (0x0040)        /* Transmit data buffer */
#define UCTXBUF6_L                       (0x0040)
#define UCTXBUF7                         (0x0080)        /* Transmit data buffer */
#define UCTXBUF7_L                       (0x0080)

/* UCA0ABCTL Control Bits */
#define UCABDEN                          (0x0001)        /* Automatic baud-rate detect enable */
#define UCABDEN_L                        (0x0001)
#define UCABDEN_0                        (0x0000)        /* Baud-rate detection disabled. Length of break and synch field 
                                                            is not measured. */
#define UCABDEN_1                        (0x0001)        /* Baud-rate detection enabled. Length of break and synch field 
                                                            is measured and baud-rate settings are changed accordingly. */
#define UCABDEN_1_L                      (0x0001)
#define UCBTOE                           (0x0004)        /* Break time out error */
#define UCBTOE_L                         (0x0004)
#define UCBTOE_0                         (0x0000)        /* No error */
#define UCBTOE_1                         (0x0004)        /* Length of break field exceeded 22 bit times */
#define UCBTOE_1_L                       (0x0004)
#define UCSTOE                           (0x0008)        /* Synch field time out error */
#define UCSTOE_L                         (0x0008)
#define UCSTOE_0                         (0x0000)        /* No error */
#define UCSTOE_1                         (0x0008)        /* Length of synch field exceeded measurable time */
#define UCSTOE_1_L                       (0x0008)
#define UCDELIM                          (0x0030)        /* Break/synch delimiter length */
#define UCDELIM_L                        (0x0030)
#define UCDELIM0                         (0x0010)        /* Break/synch delimiter length */
#define UCDELIM0_L                       (0x0010)
#define UCDELIM1                         (0x0020)        /* Break/synch delimiter length */
#define UCDELIM1_L                       (0x0020)
#define UCDELIM_0                        (0x0000)        /* 1 bit time */
#define UCDELIM_1                        (0x0010)        /* 2 bit times */
#define UCDELIM_1_L                      (0x0010)
#define UCDELIM_2                        (0x0020)        /* 3 bit times */
#define UCDELIM_2_L                      (0x0020)
#define UCDELIM_3                        (0x0030)        /* 4 bit times */
#define UCDELIM_3_L                      (0x0030)

/* UCA0IRCTL Control Bits */
#define UCIREN                           (0x0001)        /* IrDA encoder/decoder enable */
#define UCIREN_L                         (0x0001)
#define UCIREN_0                         (0x0000)        /* IrDA encoder/decoder disabled */
#define UCIREN_1                         (0x0001)        /* IrDA encoder/decoder enabled */
#define UCIREN_1_L                       (0x0001)
#define UCIRTXCLK                        (0x0002)        /* IrDA transmit pulse clock select */
#define UCIRTXCLK_L                      (0x0002)
#define UCIRTXCLK_0                      (0x0000)        /* BRCLK */
#define UCIRTXCLK_1                      (0x0002)        /* BITCLK16 when UCOS16 = 1. Otherwise, BRCLK. */
#define UCIRTXCLK_1_L                    (0x0002)
#define UCIRTXPL                         (0x00fc)        /* Transmit pulse length */
#define UCIRTXPL_L                       (0x00fc)
#define UCIRTXPL0                        (0x0004)        /* Transmit pulse length */
#define UCIRTXPL0_L                      (0x0004)
#define UCIRTXPL1                        (0x0008)        /* Transmit pulse length */
#define UCIRTXPL1_L                      (0x0008)
#define UCIRTXPL2                        (0x0010)        /* Transmit pulse length */
#define UCIRTXPL2_L                      (0x0010)
#define UCIRTXPL3                        (0x0020)        /* Transmit pulse length */
#define UCIRTXPL3_L                      (0x0020)
#define UCIRTXPL4                        (0x0040)        /* Transmit pulse length */
#define UCIRTXPL4_L                      (0x0040)
#define UCIRTXPL5                        (0x0080)        /* Transmit pulse length */
#define UCIRTXPL5_L                      (0x0080)
#define UCIRRXFE                         (0x0100)        /* IrDA receive filter enabled */
#define UCIRRXFE_H                       (0x0001)
#define UCIRRXFE_0                       (0x0000)        /* Receive filter disabled */
#define UCIRRXFE_1                       (0x0100)        /* Receive filter enabled */
#define UCIRRXFE_1_H                     (0x0001)
#define UCIRRXPL                         (0x0200)        /* IrDA receive input UCAxRXD polarity */
#define UCIRRXPL_H                       (0x0002)
#define UCIRRXPL_0                       (0x0000)        /* IrDA transceiver delivers a high pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL_1                       (0x0200)        /* IrDA transceiver delivers a low pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL_1_H                     (0x0002)
#define UCIRRXPL__HIGH                   (0x0000)        /* IrDA transceiver delivers a high pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL__LOW                    (0x0200)        /* IrDA transceiver delivers a low pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL__LOW_H                  (0x0002)
#define UCIRRXFL                         (0xfc00)        /* Receive filter length */
#define UCIRRXFL_H                       (0x00fc)
#define UCIRRXFL0                        (0x0400)        /* Receive filter length */
#define UCIRRXFL0_H                      (0x0004)
#define UCIRRXFL1                        (0x0800)        /* Receive filter length */
#define UCIRRXFL1_H                      (0x0008)
#define UCIRRXFL2                        (0x1000)        /* Receive filter length */
#define UCIRRXFL2_H                      (0x0010)
#define UCIRRXFL3                        (0x2000)        /* Receive filter length */
#define UCIRRXFL3_H                      (0x0020)
#define UCIRRXFL4                        (0x4000)        /* Receive filter length */
#define UCIRRXFL4_H                      (0x0040)
#define UCIRRXFL5                        (0x8000)        /* Receive filter length */
#define UCIRRXFL5_H                      (0x0080)

/* UCA0IE Control Bits */
#define UCRXIE                           (0x0001)        /* Receive interrupt enable */
#define UCRXIE_L                         (0x0001)
#define UCRXIE_0                         (0x0000)        /* Interrupt disabled */
#define UCRXIE_1                         (0x0001)        /* Interrupt enabled */
#define UCRXIE_1_L                       (0x0001)
#define UCTXIE                           (0x0002)        /* Transmit interrupt enable */
#define UCTXIE_L                         (0x0002)
#define UCTXIE_0                         (0x0000)        /* Interrupt disabled */
#define UCTXIE_1                         (0x0002)        /* Interrupt enabled */
#define UCTXIE_1_L                       (0x0002)
#define UCSTTIE                          (0x0004)        /* Start bit interrupt enable */
#define UCSTTIE_L                        (0x0004)
#define UCSTTIE_0                        (0x0000)        /* Interrupt disabled */
#define UCSTTIE_1                        (0x0004)        /* Interrupt enabled */
#define UCSTTIE_1_L                      (0x0004)
#define UCTXCPTIE                        (0x0008)        /* Transmit complete interrupt enable */
#define UCTXCPTIE_L                      (0x0008)
#define UCTXCPTIE_0                      (0x0000)        /* Interrupt disabled */
#define UCTXCPTIE_1                      (0x0008)        /* Interrupt enabled */
#define UCTXCPTIE_1_L                    (0x0008)

/* UCA0IFG Control Bits */
#define UCRXIFG                          (0x0001)        /* Receive interrupt flag */
#define UCRXIFG_L                        (0x0001)
#define UCRXIFG_0                        (0x0000)        /* No interrupt pending */
#define UCRXIFG_1                        (0x0001)        /* Interrupt pending */
#define UCRXIFG_1_L                      (0x0001)
#define UCTXIFG                          (0x0002)        /* Transmit interrupt flag */
#define UCTXIFG_L                        (0x0002)
#define UCTXIFG_0                        (0x0000)        /* No interrupt pending */
#define UCTXIFG_1                        (0x0002)        /* Interrupt pending */
#define UCTXIFG_1_L                      (0x0002)
#define UCSTTIFG                         (0x0004)        /* Start bit interrupt flag */
#define UCSTTIFG_L                       (0x0004)
#define UCSTTIFG_0                       (0x0000)        /* No interrupt pending */
#define UCSTTIFG_1                       (0x0004)        /* Interrupt pending */
#define UCSTTIFG_1_L                     (0x0004)
#define UCTXCPTIFG                       (0x0008)        /* Transmit ready interrupt enable */
#define UCTXCPTIFG_L                     (0x0008)
#define UCTXCPTIFG_0                     (0x0000)        /* No interrupt pending */
#define UCTXCPTIFG_1                     (0x0008)        /* Interrupt pending */
#define UCTXCPTIFG_1_L                   (0x0008)

/* UCA0IV Control Bits */
#define UCIV                             (0xffff)        /* eUSCI_A interrupt vector value */
#define UCIV_L                           (0x00ff)
#define UCIV_H                           (0x00ff)
#define UCIV0                            (0x0001)        /* eUSCI_A interrupt vector value */
#define UCIV0_L                          (0x0001)
#define UCIV1                            (0x0002)        /* eUSCI_A interrupt vector value */
#define UCIV1_L                          (0x0002)
#define UCIV2                            (0x0004)        /* eUSCI_A interrupt vector value */
#define UCIV2_L                          (0x0004)
#define UCIV3                            (0x0008)        /* eUSCI_A interrupt vector value */
#define UCIV3_L                          (0x0008)
#define UCIV4                            (0x0010)        /* eUSCI_A interrupt vector value */
#define UCIV4_L                          (0x0010)
#define UCIV5                            (0x0020)        /* eUSCI_A interrupt vector value */
#define UCIV5_L                          (0x0020)
#define UCIV6                            (0x0040)        /* eUSCI_A interrupt vector value */
#define UCIV6_L                          (0x0040)
#define UCIV7                            (0x0080)        /* eUSCI_A interrupt vector value */
#define UCIV7_L                          (0x0080)
#define UCIV8                            (0x0100)        /* eUSCI_A interrupt vector value */
#define UCIV8_H                          (0x0001)
#define UCIV9                            (0x0200)        /* eUSCI_A interrupt vector value */
#define UCIV9_H                          (0x0002)
#define UCIV10                           (0x0400)        /* eUSCI_A interrupt vector value */
#define UCIV10_H                         (0x0004)
#define UCIV11                           (0x0800)        /* eUSCI_A interrupt vector value */
#define UCIV11_H                         (0x0008)
#define UCIV12                           (0x1000)        /* eUSCI_A interrupt vector value */
#define UCIV12_H                         (0x0010)
#define UCIV13                           (0x2000)        /* eUSCI_A interrupt vector value */
#define UCIV13_H                         (0x0020)
#define UCIV14                           (0x4000)        /* eUSCI_A interrupt vector value */
#define UCIV14_H                         (0x0040)
#define UCIV15                           (0x8000)        /* eUSCI_A interrupt vector value */
#define UCIV15_H                         (0x0080)
#define UCIV_0                           (0x0000)        /* No interrupt pending */
#define UCIV_2                           (0x0002)        /* Interrupt Source: Receive buffer full; Interrupt Flag: 
                                                            UCRXIFG; Interrupt Priority: Highest */
#define UCIV_2_L                         (0x0002)
#define UCIV_4                           (0x0004)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG */
#define UCIV_4_L                         (0x0004)
#define UCIV_6                           (0x0006)        /* Interrupt Source: Start bit received; Interrupt Flag: UCSTTIFG */
#define UCIV_6_L                         (0x0006)
#define UCIV_8                           (0x0008)        /* Interrupt Source: Transmit complete; Interrupt Flag: 
                                                            UCTXCPTIFG; Interrupt Priority: Lowest */
#define UCIV_8_L                         (0x0008)
#define UCIV__NONE                       (0x0000)        /* No interrupt pending */
#define UCIV__UCRXIFG                    (0x0002)        /* Interrupt Source: Receive buffer full; Interrupt Flag: 
                                                            UCRXIFG; Interrupt Priority: Highest */
#define UCIV__UCRXIFG_L                  (0x0002)
#define UCIV__UCTXIFG                    (0x0004)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG */
#define UCIV__UCTXIFG_L                  (0x0004)
#define UCIV__UCSTTIFG                   (0x0006)        /* Interrupt Source: Start bit received; Interrupt Flag: UCSTTIFG */
#define UCIV__UCSTTIFG_L                 (0x0006)
#define UCIV__UCTXCPTIFG                 (0x0008)        /* Interrupt Source: Transmit complete; Interrupt Flag: 
                                                            UCTXCPTIFG; Interrupt Priority: Lowest */
#define UCIV__UCTXCPTIFG_L               (0x0008)


/*****************************************************************************
 eUSCI_B0 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_B0__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Bx__
#define __MSP430_HAS_EUSCI_Bx__
#endif
#define __MSP430_BASEADDRESS_EUSCI_B0__ 0x0540
#define EUSCI_B0_BASE          __MSP430_BASEADDRESS_EUSCI_B0__

sfr_w(UCB0CTLW0);                             /* eUSCI_Bx Control Word Register 0 */
sfr_b(UCB0CTLW0_L);
sfr_b(UCB0CTLW0_H);
sfr_w(UCB0CTLW1);                             /* eUSCI_Bx Control Word Register 1 */
sfr_b(UCB0CTLW1_L);
sfr_b(UCB0CTLW1_H);
sfr_w(UCB0BRW);                               /* eUSCI_Bx Baud Rate Control Word Register */
sfr_b(UCB0BRW_L);
sfr_b(UCB0BRW_H);
sfr_w(UCB0STATW);                             /* eUSCI_Bx Status Register */
sfr_b(UCB0STATW_L);
sfr_b(UCB0STATW_H);
sfr_w(UCB0TBCNT);                             /* eUSCI_Bx Byte Counter Threshold Register */
sfr_b(UCB0TBCNT_L);
sfr_b(UCB0TBCNT_H);
sfr_w(UCB0RXBUF);                             /* eUSCI_Bx Receive Buffer Register */
sfr_b(UCB0RXBUF_L);
sfr_b(UCB0RXBUF_H);
sfr_w(UCB0TXBUF);                             /* eUSCI_Bx Transmit Buffer Register */
sfr_b(UCB0TXBUF_L);
sfr_b(UCB0TXBUF_H);
sfr_w(UCB0I2COA0);                            /* eUSCI_Bx I2C Own Address 0 Register */
sfr_b(UCB0I2COA0_L);
sfr_b(UCB0I2COA0_H);
sfr_w(UCB0I2COA1);                            /* eUSCI_Bx I2C Own Address 1 Register */
sfr_b(UCB0I2COA1_L);
sfr_b(UCB0I2COA1_H);
sfr_w(UCB0I2COA2);                            /* eUSCI_Bx I2C Own Address 2 Register */
sfr_b(UCB0I2COA2_L);
sfr_b(UCB0I2COA2_H);
sfr_w(UCB0I2COA3);                            /* eUSCI_Bx I2C Own Address 3 Register */
sfr_b(UCB0I2COA3_L);
sfr_b(UCB0I2COA3_H);
sfr_w(UCB0ADDRX);                             /* eUSCI_Bx I2C Received Address Register */
sfr_b(UCB0ADDRX_L);
sfr_b(UCB0ADDRX_H);
sfr_w(UCB0ADDMASK);                           /* eUSCI_Bx I2C Address Mask Register */
sfr_b(UCB0ADDMASK_L);
sfr_b(UCB0ADDMASK_H);
sfr_w(UCB0I2CSA);                             /* eUSCI_Bx I2C Slave Address Register */
sfr_b(UCB0I2CSA_L);
sfr_b(UCB0I2CSA_H);
sfr_w(UCB0IE);                                /* eUSCI_Bx Interrupt Enable Register */
sfr_b(UCB0IE_L);
sfr_b(UCB0IE_H);
sfr_w(UCB0IFG);                               /* eUSCI_Bx Interrupt Flag Register */
sfr_b(UCB0IFG_L);
sfr_b(UCB0IFG_H);
sfr_w(UCB0IV);                                /* eUSCI_Bx Interrupt Vector Register */
sfr_b(UCB0IV_L);
sfr_b(UCB0IV_H);

/* eUSCI_B0 Register Offsets */
#define OFS_UCB0CTLW0                    (0x0000)
#define OFS_UCB0CTLW0_L                  OFS_UCB0CTLW0
#define OFS_UCB0CTLW0_H                  OFS_UCB0CTLW0+1
#define OFS_UCB0CTLW1                    (0x0002)
#define OFS_UCB0CTLW1_L                  OFS_UCB0CTLW1
#define OFS_UCB0CTLW1_H                  OFS_UCB0CTLW1+1
#define OFS_UCB0BRW                      (0x0006)
#define OFS_UCB0BRW_L                    OFS_UCB0BRW
#define OFS_UCB0BRW_H                    OFS_UCB0BRW+1
#define OFS_UCB0STATW                    (0x0008)
#define OFS_UCB0STATW_L                  OFS_UCB0STATW
#define OFS_UCB0STATW_H                  OFS_UCB0STATW+1
#define OFS_UCB0TBCNT                    (0x000A)
#define OFS_UCB0TBCNT_L                  OFS_UCB0TBCNT
#define OFS_UCB0TBCNT_H                  OFS_UCB0TBCNT+1
#define OFS_UCB0RXBUF                    (0x000C)
#define OFS_UCB0RXBUF_L                  OFS_UCB0RXBUF
#define OFS_UCB0RXBUF_H                  OFS_UCB0RXBUF+1
#define OFS_UCB0TXBUF                    (0x000E)
#define OFS_UCB0TXBUF_L                  OFS_UCB0TXBUF
#define OFS_UCB0TXBUF_H                  OFS_UCB0TXBUF+1
#define OFS_UCB0I2COA0                   (0x0014)
#define OFS_UCB0I2COA0_L                 OFS_UCB0I2COA0
#define OFS_UCB0I2COA0_H                 OFS_UCB0I2COA0+1
#define OFS_UCB0I2COA1                   (0x0016)
#define OFS_UCB0I2COA1_L                 OFS_UCB0I2COA1
#define OFS_UCB0I2COA1_H                 OFS_UCB0I2COA1+1
#define OFS_UCB0I2COA2                   (0x0018)
#define OFS_UCB0I2COA2_L                 OFS_UCB0I2COA2
#define OFS_UCB0I2COA2_H                 OFS_UCB0I2COA2+1
#define OFS_UCB0I2COA3                   (0x001A)
#define OFS_UCB0I2COA3_L                 OFS_UCB0I2COA3
#define OFS_UCB0I2COA3_H                 OFS_UCB0I2COA3+1
#define OFS_UCB0ADDRX                    (0x001C)
#define OFS_UCB0ADDRX_L                  OFS_UCB0ADDRX
#define OFS_UCB0ADDRX_H                  OFS_UCB0ADDRX+1
#define OFS_UCB0ADDMASK                  (0x001E)
#define OFS_UCB0ADDMASK_L                OFS_UCB0ADDMASK
#define OFS_UCB0ADDMASK_H                OFS_UCB0ADDMASK+1
#define OFS_UCB0I2CSA                    (0x0020)
#define OFS_UCB0I2CSA_L                  OFS_UCB0I2CSA
#define OFS_UCB0I2CSA_H                  OFS_UCB0I2CSA+1
#define OFS_UCB0IE                       (0x002A)
#define OFS_UCB0IE_L                     OFS_UCB0IE
#define OFS_UCB0IE_H                     OFS_UCB0IE+1
#define OFS_UCB0IFG                      (0x002C)
#define OFS_UCB0IFG_L                    OFS_UCB0IFG
#define OFS_UCB0IFG_H                    OFS_UCB0IFG+1
#define OFS_UCB0IV                       (0x002E)
#define OFS_UCB0IV_L                     OFS_UCB0IV
#define OFS_UCB0IV_H                     OFS_UCB0IV+1

/* eUSCI_B0 Control Bits */

/* UCB0CTLW0 Control Bits */
#define UCTXSTT                          (0x0002)        /* Transmit START condition in master mode */
#define UCTXSTT_L                        (0x0002)
#define UCTXSTT_0                        (0x0000)        /* Do not generate START condition */
#define UCTXSTT_1                        (0x0002)        /* Generate START condition */
#define UCTXSTT_1_L                      (0x0002)
#define UCTXSTP                          (0x0004)        /* Transmit STOP condition in master mode */
#define UCTXSTP_L                        (0x0004)
#define UCTXSTP_0                        (0x0000)        /* No STOP generated */
#define UCTXSTP_1                        (0x0004)        /* Generate STOP */
#define UCTXSTP_1_L                      (0x0004)
#define UCTXNACK                         (0x0008)        /* Transmit a NACK */
#define UCTXNACK_L                       (0x0008)
#define UCTXNACK_0                       (0x0000)        /* Acknowledge normally */
#define UCTXNACK_1                       (0x0008)        /* Generate NACK */
#define UCTXNACK_1_L                     (0x0008)
#define UCTR                             (0x0010)        /* Transmitter/receiver */
#define UCTR_L                           (0x0010)
#define UCTR_0                           (0x0000)        /* Receiver */
#define UCTR_1                           (0x0010)        /* Transmitter */
#define UCTR_1_L                         (0x0010)
#define UCTR__RX                         (0x0000)        /* Receiver */
#define UCTR__TX                         (0x0010)        /* Transmitter */
#define UCTR__TX_L                       (0x0010)
#define UCTXACK                          (0x0020)        /* Transmit ACK condition in slave mode */
#define UCTXACK_L                        (0x0020)
#define UCTXACK_0                        (0x0000)        /* Do not acknowledge the slave address */
#define UCTXACK_1                        (0x0020)        /* Acknowledge the slave address */
#define UCTXACK_1_L                      (0x0020)
#define UCSSEL__UCLKI                    (0x0000)        /* UCLKI */
#define UCMM                             (0x2000)        /* Multi-master environment select */
#define UCMM_H                           (0x0020)
#define UCMM_0                           (0x0000)        /* Single master environment. There is no other master in the 
                                                            system. The address compare unit is disabled. */
#define UCMM_1                           (0x2000)        /* Multi-master environment */
#define UCMM_1_H                         (0x0020)
#define UCMM__SINGLE                     (0x0000)        /* Single master environment. There is no other master in the 
                                                            system. The address compare unit is disabled. */
#define UCMM__MULTI                      (0x2000)        /* Multi-master environment */
#define UCMM__MULTI_H                    (0x0020)
#define UCSLA10                          (0x4000)        /* Slave addressing mode select */
#define UCSLA10_H                        (0x0040)
#define UCSLA10_0                        (0x0000)        /* Address slave with 7-bit address */
#define UCSLA10_1                        (0x4000)        /* Address slave with 10-bit address */
#define UCSLA10_1_H                      (0x0040)
#define UCSLA10__7BIT                    (0x0000)        /* Address slave with 7-bit address */
#define UCSLA10__10BIT                   (0x4000)        /* Address slave with 10-bit address */
#define UCSLA10__10BIT_H                 (0x0040)
#define UCA10                            (0x8000)        /* Own addressing mode select */
#define UCA10_H                          (0x0080)
#define UCA10_0                          (0x0000)        /* Own address is a 7-bit address */
#define UCA10_1                          (0x8000)        /* Own address is a 10-bit address */
#define UCA10_1_H                        (0x0080)

/* UCB0CTLW1 Control Bits */
#define UCASTP                           (0x000c)        /* Automatic STOP condition generation */
#define UCASTP_L                         (0x000c)
#define UCASTP0                          (0x0004)        /* Automatic STOP condition generation */
#define UCASTP0_L                        (0x0004)
#define UCASTP1                          (0x0008)        /* Automatic STOP condition generation */
#define UCASTP1_L                        (0x0008)
#define UCASTP_0                         (0x0000)        /* No automatic STOP generation. The STOP condition is generated 
                                                            after the user sets the UCTXSTP bit. The value in UCBxTBCNT is
                                                            a don't care. */
#define UCASTP_1                         (0x0004)        /* UCBCNTIFG is set with the byte counter reaches the threshold 
                                                            defined in UCBxTBCNT */
#define UCASTP_1_L                       (0x0004)
#define UCASTP_2                         (0x0008)        /* A STOP condition is generated automatically after the byte 
                                                            counter value reached UCBxTBCNT. UCBCNTIFG is set with the 
                                                            byte counter reaching the threshold */
#define UCASTP_2_L                       (0x0008)
#define UCASTP_3                         (0x000c)        /* Reserved */
#define UCASTP_3_L                       (0x000c)
#define UCSWACK                          (0x0010)        /* SW or HW ACK control */
#define UCSWACK_L                        (0x0010)
#define UCSWACK_0                        (0x0000)        /* The address acknowledge of the slave is controlled by the 
                                                            eUSCI_B module */
#define UCSWACK_1                        (0x0010)        /* The user needs to trigger the sending of the address ACK by 
                                                            issuing UCTXACK */
#define UCSWACK_1_L                      (0x0010)
#define UCSTPNACK                        (0x0020)        /* ACK all master bytes */
#define UCSTPNACK_L                      (0x0020)
#define UCSTPNACK_0                      (0x0000)        /* Send a non-acknowledge before the STOP condition as a master 
                                                            receiver (conform to I2C standard) */
#define UCSTPNACK_1                      (0x0020)        /* All bytes are acknowledged by the eUSCI_B when configured as 
                                                            master receiver */
#define UCSTPNACK_1_L                    (0x0020)
#define UCCLTO                           (0x00c0)        /* Clock low timeout select */
#define UCCLTO_L                         (0x00c0)
#define UCCLTO0                          (0x0040)        /* Clock low timeout select */
#define UCCLTO0_L                        (0x0040)
#define UCCLTO1                          (0x0080)        /* Clock low timeout select */
#define UCCLTO1_L                        (0x0080)
#define UCCLTO_0                         (0x0000)        /* Disable clock low timeout counter */
#define UCCLTO_1                         (0x0040)        /* 135 000 SYSCLK cycles (approximately 28 ms) */
#define UCCLTO_1_L                       (0x0040)
#define UCCLTO_2                         (0x0080)        /* 150 000 SYSCLK cycles (approximately 31 ms) */
#define UCCLTO_2_L                       (0x0080)
#define UCCLTO_3                         (0x00c0)        /* 165 000 SYSCLK cycles (approximately 34 ms) */
#define UCCLTO_3_L                       (0x00c0)
#define UCETXINT                         (0x0100)        /* Early UCTXIFG0 */
#define UCETXINT_H                       (0x0001)
#define UCETXINT_0                       (0x0000)        /* UCTXIFGx is set after an address match with UCxI2COAx and the 
                                                            direction bit indicating slave transmit */
#define UCETXINT_1                       (0x0100)        /* UCTXIFG0 is set for each START condition */
#define UCETXINT_1_H                     (0x0001)

/* UCB0STATW Control Bits */
#define UCBBUSY                          (0x0010)        /* Bus busy */
#define UCBBUSY_L                        (0x0010)
#define UCBBUSY_0                        (0x0000)        /* Bus inactive */
#define UCBBUSY_1                        (0x0010)        /* Bus busy */
#define UCBBUSY_1_L                      (0x0010)
#define UCBBUSY__IDLE                    (0x0000)        /* Bus inactive */
#define UCBBUSY__BUSY                    (0x0010)        /* Bus busy */
#define UCBBUSY__BUSY_L                  (0x0010)
#define UCGC                             (0x0020)        /* General call address received */
#define UCGC_L                           (0x0020)
#define UCGC_0                           (0x0000)        /* No general call address received */
#define UCGC_1                           (0x0020)        /* General call address received */
#define UCGC_1_L                         (0x0020)
#define UCSCLLOW                         (0x0040)        /* SCL low */
#define UCSCLLOW_L                       (0x0040)
#define UCSCLLOW_0                       (0x0000)        /* SCL is not held low */
#define UCSCLLOW_1                       (0x0040)        /* SCL is held low */
#define UCSCLLOW_1_L                     (0x0040)
#define UCBCNT                           (0xff00)        /* Hardware byte counter value */
#define UCBCNT_H                         (0x00ff)
#define UCBCNT0                          (0x0100)        /* Hardware byte counter value */
#define UCBCNT0_H                        (0x0001)
#define UCBCNT1                          (0x0200)        /* Hardware byte counter value */
#define UCBCNT1_H                        (0x0002)
#define UCBCNT2                          (0x0400)        /* Hardware byte counter value */
#define UCBCNT2_H                        (0x0004)
#define UCBCNT3                          (0x0800)        /* Hardware byte counter value */
#define UCBCNT3_H                        (0x0008)
#define UCBCNT4                          (0x1000)        /* Hardware byte counter value */
#define UCBCNT4_H                        (0x0010)
#define UCBCNT5                          (0x2000)        /* Hardware byte counter value */
#define UCBCNT5_H                        (0x0020)
#define UCBCNT6                          (0x4000)        /* Hardware byte counter value */
#define UCBCNT6_H                        (0x0040)
#define UCBCNT7                          (0x8000)        /* Hardware byte counter value */
#define UCBCNT7_H                        (0x0080)

/* UCB0TBCNT Control Bits */
#define UCTBCNT                          (0x00ff)        /* Byte counter threshold value */
#define UCTBCNT_L                        (0x00ff)
#define UCTBCNT0                         (0x0001)        /* Byte counter threshold value */
#define UCTBCNT0_L                       (0x0001)
#define UCTBCNT1                         (0x0002)        /* Byte counter threshold value */
#define UCTBCNT1_L                       (0x0002)
#define UCTBCNT2                         (0x0004)        /* Byte counter threshold value */
#define UCTBCNT2_L                       (0x0004)
#define UCTBCNT3                         (0x0008)        /* Byte counter threshold value */
#define UCTBCNT3_L                       (0x0008)
#define UCTBCNT4                         (0x0010)        /* Byte counter threshold value */
#define UCTBCNT4_L                       (0x0010)
#define UCTBCNT5                         (0x0020)        /* Byte counter threshold value */
#define UCTBCNT5_L                       (0x0020)
#define UCTBCNT6                         (0x0040)        /* Byte counter threshold value */
#define UCTBCNT6_L                       (0x0040)
#define UCTBCNT7                         (0x0080)        /* Byte counter threshold value */
#define UCTBCNT7_L                       (0x0080)

/* UCB0I2COA0 Control Bits */
#define I2COA0                           (0x03ff)        /* I2C own address */
#define I2COA0_L                         (0x00ff)
#define I2COA0_H                         (0x0003)
#define I2COA00                          (0x0001)        /* I2C own address */
#define I2COA00_L                        (0x0001)
#define I2COA01                          (0x0002)        /* I2C own address */
#define I2COA01_L                        (0x0002)
#define I2COA02                          (0x0004)        /* I2C own address */
#define I2COA02_L                        (0x0004)
#define I2COA03                          (0x0008)        /* I2C own address */
#define I2COA03_L                        (0x0008)
#define I2COA04                          (0x0010)        /* I2C own address */
#define I2COA04_L                        (0x0010)
#define I2COA05                          (0x0020)        /* I2C own address */
#define I2COA05_L                        (0x0020)
#define I2COA06                          (0x0040)        /* I2C own address */
#define I2COA06_L                        (0x0040)
#define I2COA07                          (0x0080)        /* I2C own address */
#define I2COA07_L                        (0x0080)
#define I2COA08                          (0x0100)        /* I2C own address */
#define I2COA08_H                        (0x0001)
#define I2COA09                          (0x0200)        /* I2C own address */
#define I2COA09_H                        (0x0002)
#define UCOAEN                           (0x0400)        /* Own Address enable register */
#define UCOAEN_H                         (0x0004)
#define UCOAEN_0                         (0x0000)        /* The slave address defined in I2COA0 is disabled */
#define UCOAEN_1                         (0x0400)        /* The slave address defined in I2COA0 is enabled */
#define UCOAEN_1_H                       (0x0004)
#define UCOAEN__DISABLE                  (0x0000)        /* The slave address defined in I2COA0 is disabled */
#define UCOAEN__ENABLE                   (0x0400)        /* The slave address defined in I2COA0 is enabled */
#define UCOAEN__ENABLE_H                 (0x0004)
#define UCGCEN                           (0x8000)        /* General call response enable */
#define UCGCEN_H                         (0x0080)
#define UCGCEN_0                         (0x0000)        /* Do not respond to a general call */
#define UCGCEN_1                         (0x8000)        /* Respond to a general call */
#define UCGCEN_1_H                       (0x0080)

/* UCB0I2COA1 Control Bits */
#define I2COA1                           (0x03ff)        /* I2C own address */
#define I2COA1_L                         (0x00ff)
#define I2COA1_H                         (0x0003)
#define I2COA10                          (0x0001)        /* I2C own address */
#define I2COA10_L                        (0x0001)
#define I2COA11                          (0x0002)        /* I2C own address */
#define I2COA11_L                        (0x0002)
#define I2COA12                          (0x0004)        /* I2C own address */
#define I2COA12_L                        (0x0004)
#define I2COA13                          (0x0008)        /* I2C own address */
#define I2COA13_L                        (0x0008)
#define I2COA14                          (0x0010)        /* I2C own address */
#define I2COA14_L                        (0x0010)
#define I2COA15                          (0x0020)        /* I2C own address */
#define I2COA15_L                        (0x0020)
#define I2COA16                          (0x0040)        /* I2C own address */
#define I2COA16_L                        (0x0040)
#define I2COA17                          (0x0080)        /* I2C own address */
#define I2COA17_L                        (0x0080)
#define I2COA18                          (0x0100)        /* I2C own address */
#define I2COA18_H                        (0x0001)
#define I2COA19                          (0x0200)        /* I2C own address */
#define I2COA19_H                        (0x0002)

/* UCB0I2COA2 Control Bits */
#define I2COA2                           (0x03ff)        /* I2C own address */
#define I2COA2_L                         (0x00ff)
#define I2COA2_H                         (0x0003)
#define I2COA20                          (0x0001)        /* I2C own address */
#define I2COA20_L                        (0x0001)
#define I2COA21                          (0x0002)        /* I2C own address */
#define I2COA21_L                        (0x0002)
#define I2COA22                          (0x0004)        /* I2C own address */
#define I2COA22_L                        (0x0004)
#define I2COA23                          (0x0008)        /* I2C own address */
#define I2COA23_L                        (0x0008)
#define I2COA24                          (0x0010)        /* I2C own address */
#define I2COA24_L                        (0x0010)
#define I2COA25                          (0x0020)        /* I2C own address */
#define I2COA25_L                        (0x0020)
#define I2COA26                          (0x0040)        /* I2C own address */
#define I2COA26_L                        (0x0040)
#define I2COA27                          (0x0080)        /* I2C own address */
#define I2COA27_L                        (0x0080)
#define I2COA28                          (0x0100)        /* I2C own address */
#define I2COA28_H                        (0x0001)
#define I2COA29                          (0x0200)        /* I2C own address */
#define I2COA29_H                        (0x0002)

/* UCB0I2COA3 Control Bits */
#define I2COA3                           (0x03ff)        /* I2C own address */
#define I2COA3_L                         (0x00ff)
#define I2COA3_H                         (0x0003)
#define I2COA30                          (0x0001)        /* I2C own address */
#define I2COA30_L                        (0x0001)
#define I2COA31                          (0x0002)        /* I2C own address */
#define I2COA31_L                        (0x0002)
#define I2COA32                          (0x0004)        /* I2C own address */
#define I2COA32_L                        (0x0004)
#define I2COA33                          (0x0008)        /* I2C own address */
#define I2COA33_L                        (0x0008)
#define I2COA34                          (0x0010)        /* I2C own address */
#define I2COA34_L                        (0x0010)
#define I2COA35                          (0x0020)        /* I2C own address */
#define I2COA35_L                        (0x0020)
#define I2COA36                          (0x0040)        /* I2C own address */
#define I2COA36_L                        (0x0040)
#define I2COA37                          (0x0080)        /* I2C own address */
#define I2COA37_L                        (0x0080)
#define I2COA38                          (0x0100)        /* I2C own address */
#define I2COA38_H                        (0x0001)
#define I2COA39                          (0x0200)        /* I2C own address */
#define I2COA39_H                        (0x0002)

/* UCB0ADDRX Control Bits */
#define ADDRX                            (0x03ff)        /* Received Address Register */
#define ADDRX_L                          (0x00ff)
#define ADDRX_H                          (0x0003)
#define ADDRX0                           (0x0001)        /* Received Address Register */
#define ADDRX0_L                         (0x0001)
#define ADDRX1                           (0x0002)        /* Received Address Register */
#define ADDRX1_L                         (0x0002)
#define ADDRX2                           (0x0004)        /* Received Address Register */
#define ADDRX2_L                         (0x0004)
#define ADDRX3                           (0x0008)        /* Received Address Register */
#define ADDRX3_L                         (0x0008)
#define ADDRX4                           (0x0010)        /* Received Address Register */
#define ADDRX4_L                         (0x0010)
#define ADDRX5                           (0x0020)        /* Received Address Register */
#define ADDRX5_L                         (0x0020)
#define ADDRX6                           (0x0040)        /* Received Address Register */
#define ADDRX6_L                         (0x0040)
#define ADDRX7                           (0x0080)        /* Received Address Register */
#define ADDRX7_L                         (0x0080)
#define ADDRX8                           (0x0100)        /* Received Address Register */
#define ADDRX8_H                         (0x0001)
#define ADDRX9                           (0x0200)        /* Received Address Register */
#define ADDRX9_H                         (0x0002)

/* UCB0ADDMASK Control Bits */
#define ADDMASK                          (0x03ff)        /* */
#define ADDMASK_L                        (0x00ff)
#define ADDMASK_H                        (0x0003)
#define ADDMASK0                         (0x0001)        /* */
#define ADDMASK0_L                       (0x0001)
#define ADDMASK1                         (0x0002)        /* */
#define ADDMASK1_L                       (0x0002)
#define ADDMASK2                         (0x0004)        /* */
#define ADDMASK2_L                       (0x0004)
#define ADDMASK3                         (0x0008)        /* */
#define ADDMASK3_L                       (0x0008)
#define ADDMASK4                         (0x0010)        /* */
#define ADDMASK4_L                       (0x0010)
#define ADDMASK5                         (0x0020)        /* */
#define ADDMASK5_L                       (0x0020)
#define ADDMASK6                         (0x0040)        /* */
#define ADDMASK6_L                       (0x0040)
#define ADDMASK7                         (0x0080)        /* */
#define ADDMASK7_L                       (0x0080)
#define ADDMASK8                         (0x0100)        /* */
#define ADDMASK8_H                       (0x0001)
#define ADDMASK9                         (0x0200)        /* */
#define ADDMASK9_H                       (0x0002)

/* UCB0I2CSA Control Bits */
#define I2CSA                            (0x03ff)        /* I2C slave address */
#define I2CSA_L                          (0x00ff)
#define I2CSA_H                          (0x0003)
#define I2CSA0                           (0x0001)        /* I2C slave address */
#define I2CSA0_L                         (0x0001)
#define I2CSA1                           (0x0002)        /* I2C slave address */
#define I2CSA1_L                         (0x0002)
#define I2CSA2                           (0x0004)        /* I2C slave address */
#define I2CSA2_L                         (0x0004)
#define I2CSA3                           (0x0008)        /* I2C slave address */
#define I2CSA3_L                         (0x0008)
#define I2CSA4                           (0x0010)        /* I2C slave address */
#define I2CSA4_L                         (0x0010)
#define I2CSA5                           (0x0020)        /* I2C slave address */
#define I2CSA5_L                         (0x0020)
#define I2CSA6                           (0x0040)        /* I2C slave address */
#define I2CSA6_L                         (0x0040)
#define I2CSA7                           (0x0080)        /* I2C slave address */
#define I2CSA7_L                         (0x0080)
#define I2CSA8                           (0x0100)        /* I2C slave address */
#define I2CSA8_H                         (0x0001)
#define I2CSA9                           (0x0200)        /* I2C slave address */
#define I2CSA9_H                         (0x0002)

/* UCB0IE Control Bits */
#define UCRXIE0                          (0x0001)        /* Receive interrupt enable 0 */
#define UCRXIE0_L                        (0x0001)
#define UCRXIE0_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE0_1                        (0x0001)        /* Interrupt enabled */
#define UCRXIE0_1_L                      (0x0001)
#define UCTXIE0                          (0x0002)        /* Transmit interrupt enable 0 */
#define UCTXIE0_L                        (0x0002)
#define UCTXIE0_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE0_1                        (0x0002)        /* Interrupt enabled */
#define UCTXIE0_1_L                      (0x0002)
#define UCSTPIE                          (0x0008)        /* STOP condition interrupt enable */
#define UCSTPIE_L                        (0x0008)
#define UCSTPIE_0                        (0x0000)        /* Interrupt disabled */
#define UCSTPIE_1                        (0x0008)        /* Interrupt enabled */
#define UCSTPIE_1_L                      (0x0008)
#define UCALIE                           (0x0010)        /* Arbitration lost interrupt enable */
#define UCALIE_L                         (0x0010)
#define UCALIE_0                         (0x0000)        /* Interrupt disabled */
#define UCALIE_1                         (0x0010)        /* Interrupt enabled */
#define UCALIE_1_L                       (0x0010)
#define UCNACKIE                         (0x0020)        /* Not-acknowledge interrupt enable */
#define UCNACKIE_L                       (0x0020)
#define UCNACKIE_0                       (0x0000)        /* Interrupt disabled */
#define UCNACKIE_1                       (0x0020)        /* Interrupt enabled */
#define UCNACKIE_1_L                     (0x0020)
#define UCBCNTIE                         (0x0040)        /* Byte counter interrupt enable */
#define UCBCNTIE_L                       (0x0040)
#define UCBCNTIE_0                       (0x0000)        /* Interrupt disabled */
#define UCBCNTIE_1                       (0x0040)        /* Interrupt enabled */
#define UCBCNTIE_1_L                     (0x0040)
#define UCCLTOIE                         (0x0080)        /* Clock low timeout interrupt enable */
#define UCCLTOIE_L                       (0x0080)
#define UCCLTOIE_0                       (0x0000)        /* Interrupt disabled */
#define UCCLTOIE_1                       (0x0080)        /* Interrupt enabled */
#define UCCLTOIE_1_L                     (0x0080)
#define UCRXIE1                          (0x0100)        /* Receive interrupt enable 1 */
#define UCRXIE1_H                        (0x0001)
#define UCRXIE1_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE1_1                        (0x0100)        /* Interrupt enabled */
#define UCRXIE1_1_H                      (0x0001)
#define UCTXIE1                          (0x0200)        /* Transmit interrupt enable 1 */
#define UCTXIE1_H                        (0x0002)
#define UCTXIE1_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE1_1                        (0x0200)        /* Interrupt enabled */
#define UCTXIE1_1_H                      (0x0002)
#define UCRXIE2                          (0x0400)        /* Receive interrupt enable 2 */
#define UCRXIE2_H                        (0x0004)
#define UCRXIE2_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE2_1                        (0x0400)        /* Interrupt enabled */
#define UCRXIE2_1_H                      (0x0004)
#define UCTXIE2                          (0x0800)        /* Transmit interrupt enable 2 */
#define UCTXIE2_H                        (0x0008)
#define UCTXIE2_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE2_1                        (0x0800)        /* Interrupt enabled */
#define UCTXIE2_1_H                      (0x0008)
#define UCRXIE3                          (0x1000)        /* Receive interrupt enable 3 */
#define UCRXIE3_H                        (0x0010)
#define UCRXIE3_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE3_1                        (0x1000)        /* Interrupt enabled */
#define UCRXIE3_1_H                      (0x0010)
#define UCTXIE3                          (0x2000)        /* Transmit interrupt enable 3 */
#define UCTXIE3_H                        (0x0020)
#define UCTXIE3_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE3_1                        (0x2000)        /* Interrupt enabled */
#define UCTXIE3_1_H                      (0x0020)
#define UCBIT9IE                         (0x4000)        /* Bit position 9 interrupt enable */
#define UCBIT9IE_H                       (0x0040)
#define UCBIT9IE_0                       (0x0000)        /* Interrupt disabled */
#define UCBIT9IE_1                       (0x4000)        /* Interrupt enabled */
#define UCBIT9IE_1_H                     (0x0040)

/* UCB0IFG Control Bits */
#define UCRXIFG0                         (0x0001)        /* eUSCI_B receive interrupt flag 0 */
#define UCRXIFG0_L                       (0x0001)
#define UCRXIFG0_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG0_1                       (0x0001)        /* Interrupt pending */
#define UCRXIFG0_1_L                     (0x0001)
#define UCTXIFG0                         (0x0002)        /* eUSCI_B transmit interrupt flag 0 */
#define UCTXIFG0_L                       (0x0002)
#define UCTXIFG0_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG0_1                       (0x0002)        /* Interrupt pending */
#define UCTXIFG0_1_L                     (0x0002)
#define UCSTPIFG                         (0x0008)        /* STOP condition interrupt flag */
#define UCSTPIFG_L                       (0x0008)
#define UCSTPIFG_0                       (0x0000)        /* No interrupt pending */
#define UCSTPIFG_1                       (0x0008)        /* Interrupt pending */
#define UCSTPIFG_1_L                     (0x0008)
#define UCALIFG                          (0x0010)        /* Arbitration lost interrupt flag */
#define UCALIFG_L                        (0x0010)
#define UCALIFG_0                        (0x0000)        /* No interrupt pending */
#define UCALIFG_1                        (0x0010)        /* Interrupt pending */
#define UCALIFG_1_L                      (0x0010)
#define UCNACKIFG                        (0x0020)        /* Not-acknowledge received interrupt flag */
#define UCNACKIFG_L                      (0x0020)
#define UCNACKIFG_0                      (0x0000)        /* No interrupt pending */
#define UCNACKIFG_1                      (0x0020)        /* Interrupt pending */
#define UCNACKIFG_1_L                    (0x0020)
#define UCBCNTIFG                        (0x0040)        /* Byte counter interrupt flag */
#define UCBCNTIFG_L                      (0x0040)
#define UCBCNTIFG_0                      (0x0000)        /* No interrupt pending */
#define UCBCNTIFG_1                      (0x0040)        /* Interrupt pending */
#define UCBCNTIFG_1_L                    (0x0040)
#define UCCLTOIFG                        (0x0080)        /* Clock low timeout interrupt flag */
#define UCCLTOIFG_L                      (0x0080)
#define UCCLTOIFG_0                      (0x0000)        /* No interrupt pending */
#define UCCLTOIFG_1                      (0x0080)        /* Interrupt pending */
#define UCCLTOIFG_1_L                    (0x0080)
#define UCRXIFG1                         (0x0100)        /* eUSCI_B receive interrupt flag 1 */
#define UCRXIFG1_H                       (0x0001)
#define UCRXIFG1_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG1_1                       (0x0100)        /* Interrupt pending */
#define UCRXIFG1_1_H                     (0x0001)
#define UCTXIFG1                         (0x0200)        /* eUSCI_B transmit interrupt flag 1 */
#define UCTXIFG1_H                       (0x0002)
#define UCTXIFG1_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG1_1                       (0x0200)        /* Interrupt pending */
#define UCTXIFG1_1_H                     (0x0002)
#define UCRXIFG2                         (0x0400)        /* eUSCI_B receive interrupt flag 2 */
#define UCRXIFG2_H                       (0x0004)
#define UCRXIFG2_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG2_1                       (0x0400)        /* Interrupt pending */
#define UCRXIFG2_1_H                     (0x0004)
#define UCTXIFG2                         (0x0800)        /* eUSCI_B transmit interrupt flag 2 */
#define UCTXIFG2_H                       (0x0008)
#define UCTXIFG2_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG2_1                       (0x0800)        /* Interrupt pending */
#define UCTXIFG2_1_H                     (0x0008)
#define UCRXIFG3                         (0x1000)        /* eUSCI_B receive interrupt flag 3 */
#define UCRXIFG3_H                       (0x0010)
#define UCRXIFG3_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG3_1                       (0x1000)        /* Interrupt pending */
#define UCRXIFG3_1_H                     (0x0010)
#define UCTXIFG3                         (0x2000)        /* eUSCI_B transmit interrupt flag 3 */
#define UCTXIFG3_H                       (0x0020)
#define UCTXIFG3_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG3_1                       (0x2000)        /* Interrupt pending */
#define UCTXIFG3_1_H                     (0x0020)
#define UCBIT9IFG                        (0x4000)        /* Bit position 9 interrupt flag */
#define UCBIT9IFG_H                      (0x0040)
#define UCBIT9IFG_0                      (0x0000)        /* No interrupt pending */
#define UCBIT9IFG_1                      (0x4000)        /* Interrupt pending */
#define UCBIT9IFG_1_H                    (0x0040)

/* UCB0IV Control Bits */
#define UCIV_10                          (0x000a)        /* Interrupt Source: Slave 3 Data received; Interrupt Flag: 
                                                            UCRXIFG3 */
#define UCIV_10_L                        (0x000a)
#define UCIV_12                          (0x000c)        /* Interrupt Source: Slave 3 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG3 */
#define UCIV_12_L                        (0x000c)
#define UCIV_14                          (0x000e)        /* Interrupt Source: Slave 2 Data received; Interrupt Flag: 
                                                            UCRXIFG2 */
#define UCIV_14_L                        (0x000e)
#define UCIV_16                          (0x0010)        /* Interrupt Source: Slave 2 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG2 */
#define UCIV_16_L                        (0x0010)
#define UCIV_18                          (0x0012)        /* Interrupt Source: Slave 1 Data received; Interrupt Flag: 
                                                            UCRXIFG1 */
#define UCIV_18_L                        (0x0012)
#define UCIV_20                          (0x0014)        /* Interrupt Source: Slave 1 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG1 */
#define UCIV_20_L                        (0x0014)
#define UCIV_22                          (0x0016)        /* Interrupt Source: Data received; Interrupt Flag: UCRXIFG0 */
#define UCIV_22_L                        (0x0016)
#define UCIV_24                          (0x0018)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG0 */
#define UCIV_24_L                        (0x0018)
#define UCIV_26                          (0x001a)        /* Interrupt Source: Byte counter zero; Interrupt Flag: UCBCNTIFG */
#define UCIV_26_L                        (0x001a)
#define UCIV_28                          (0x001c)        /* Interrupt Source: Clock low timeout; Interrupt Flag: UCCLTOIFG */
#define UCIV_28_L                        (0x001c)
#define UCIV_30                          (0x001e)        /* Interrupt Source: Nineth bit position; Interrupt Flag: 
                                                            UCBIT9IFG; Priority: Lowest */
#define UCIV_30_L                        (0x001e)
#define UCIV__UCALIFG                    (0x0002)        /* Interrupt Source: Arbitration lost; Interrupt Flag: UCALIFG; 
                                                            Interrupt Priority: Highest */
#define UCIV__UCALIFG_L                  (0x0002)
#define UCIV__UCNACKIFG                  (0x0004)        /* Interrupt Source: Not acknowledgment; Interrupt Flag: 
                                                            UCNACKIFG */
#define UCIV__UCNACKIFG_L                (0x0004)
#define UCIV__UCSTPIFG                   (0x0008)        /* Interrupt Source: Stop condition received; Interrupt Flag: 
                                                            UCSTPIFG */
#define UCIV__UCSTPIFG_L                 (0x0008)
#define UCIV__UCRXIFG3                   (0x000a)        /* Interrupt Source: Slave 3 Data received; Interrupt Flag: 
                                                            UCRXIFG3 */
#define UCIV__UCRXIFG3_L                 (0x000a)
#define UCIV__UCTXIFG3                   (0x000c)        /* Interrupt Source: Slave 3 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG3 */
#define UCIV__UCTXIFG3_L                 (0x000c)
#define UCIV__UCRXIFG2                   (0x000e)        /* Interrupt Source: Slave 2 Data received; Interrupt Flag: 
                                                            UCRXIFG2 */
#define UCIV__UCRXIFG2_L                 (0x000e)
#define UCIV__UCTXIFG2                   (0x0010)        /* Interrupt Source: Slave 2 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG2 */
#define UCIV__UCTXIFG2_L                 (0x0010)
#define UCIV__UCRXIFG1                   (0x0012)        /* Interrupt Source: Slave 1 Data received; Interrupt Flag: 
                                                            UCRXIFG1 */
#define UCIV__UCRXIFG1_L                 (0x0012)
#define UCIV__UCTXIFG1                   (0x0014)        /* Interrupt Source: Slave 1 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG1 */
#define UCIV__UCTXIFG1_L                 (0x0014)
#define UCIV__UCRXIFG0                   (0x0016)        /* Interrupt Source: Data received; Interrupt Flag: UCRXIFG0 */
#define UCIV__UCRXIFG0_L                 (0x0016)
#define UCIV__UCTXIFG0                   (0x0018)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG0 */
#define UCIV__UCTXIFG0_L                 (0x0018)
#define UCIV__UCBCNTIFG                  (0x001a)        /* Interrupt Source: Byte counter zero; Interrupt Flag: UCBCNTIFG */
#define UCIV__UCBCNTIFG_L                (0x001a)
#define UCIV__UCCLTOIFG                  (0x001c)        /* Interrupt Source: Clock low timeout; Interrupt Flag: UCCLTOIFG */
#define UCIV__UCCLTOIFG_L                (0x001c)
#define UCIV__UCBIT9IFG                  (0x001e)        /* Interrupt Source: Nineth bit position; Interrupt Flag: 
                                                            UCBIT9IFG; Priority: Lowest */
#define UCIV__UCBIT9IFG_L                (0x001e)


/************************************************************
* TLV Descriptors
************************************************************/

#define __MSP430_HAS_TLV__                    /* Definition to show that Module is available */

#define TLV_CRC_LENGTH         (0x1A01)       /* CRC length of the TLV structure */
#define TLV_CRC_VALUE          (0x1A02)       /* CRC value of the TLV structure */
#define TLV_START              (0x1A08)       /* Start Address of the TLV structure */
#define TLV_END                (0x1AFF)       /* End Address of the TLV structure */
#define TLV_CRC_START          (0x1A04)       /* Start Address of the CRC protected structure */
#define TLV_CRC_END            (0x1A77)       /* End Address of the TLV protected structure */

#define TLV_LDTAG              (0x01)         /*  Legacy descriptor (1xx, 2xx, 4xx families) */
#define TLV_PDTAG              (0x02)         /*  Peripheral discovery descriptor */
#define TLV_Reserved3          (0x03)         /*  Future usage */
#define TLV_Reserved4          (0x04)         /*  Future usage */
#define TLV_BLANK              (0x05)         /*  Blank descriptor */
#define TLV_Reserved6          (0x06)         /*  Future usage */
#define TLV_Reserved7          (0x07)         /*  Serial Number */
#define TLV_DIERECORD          (0x08)         /*  Die Record  */
#define TLV_ADCCAL             (0x11)         /*  ADC12 calibration */
#define TLV_ADC12CAL           (0x11)         /*  ADC12 calibration */
#define TLV_ADC10CAL           (0x13)         /*  ADC10 calibration */
#define TLV_REFCAL             (0x12)         /*  REF calibration */
#define TLV_TAGEXT             (0xFE)         /*  Tag extender */
#define TLV_TAGEND             (0xFF)         //  Tag End of Table

/************************************************************
* Interrupt Vectors (offset from 0xFF80 + 0x10 for Password)
************************************************************/

#define ECOMP0_VECTOR          (45)                     /* 0xFFE2 */
#define PORT2_VECTOR           (46)                     /* 0xFFE4 */
#define PORT1_VECTOR           (47)                     /* 0xFFE6 */
#define ADC_VECTOR             (48)                     /* 0xFFE8 */
#define EUSCI_B0_VECTOR        (49)                     /* 0xFFEA */
#define EUSCI_A0_VECTOR        (50)                     /* 0xFFEC */
#define WDT_VECTOR             (51)                     /* 0xFFEE */
#define RTC_VECTOR             (52)                     /* 0xFFF0 */
#define TIMER1_B1_VECTOR       (53)                     /* 0xFFF2 */
#define TIMER1_B0_VECTOR       (54)                     /* 0xFFF4 */
#define TIMER0_B1_VECTOR       (55)                     /* 0xFFF6 */
#define TIMER0_B0_VECTOR       (56)                     /* 0xFFF8 */
#define UNMI_VECTOR            (57)                     /* 0xFFFA */
#define SYSNMI_VECTOR          (58)                     /* 0xFFFC */
#define RESET_VECTOR           ("reset")                /* 0xFFFE Reset (Highest Priority) */


/************************************************************
* Memory Boundary Definitions
************************************************************/

#define BSL0_START              0x1000
#define BSL0_LENGTH             0x0800
#define RAM_START               0x2000
#define RAM_LENGTH              0x0400
#define FRAM_START              0xF100
#define FRAM_LENGTH             0x0F00
#define BSL1_START              0xFFC00
#define BSL1_LENGTH             0x0400

/************************************************************
* End of Modules
************************************************************/

#ifdef __cplusplus
}
#endif /* extern "C" */

#ifndef EXCLUDE_LEGACY
#include "legacy.h"
#endif

#endif /* #ifndef __MSP430FR2311 */


