/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;

public class ThisExp
extends ReferenceExp {
    Expression context;

    public ThisExp() {
        super("$this$");
    }

    public ThisExp(Expression context) {
        super("$this$");
        this.context = context;
    }

    public ThisExp(Declaration binding) {
        super("$this", binding);
    }

    public ThisExp(ClassType type) {
        this(new Declaration("this", type));
    }

    public void compile(Compilation comp, Target target) {
        if (this.binding != null && this.binding.field != null) {
            this.binding.load(comp);
        } else {
            comp.getCode().emitPushThis();
        }
        target.compileFromStack(comp, comp.getCode().topType());
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkThisExp(this);
    }

    public final Type getType() {
        if (this.binding != null) {
            return this.binding.getType();
        }
        if (this.context != null && this.context instanceof ClassExp) {
            return ((ClassExp)this.context).getType();
        }
        return Type.pointer_type;
    }
}

