/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import bossa.util.Util;
import java.util.Map;
import mlsub.typing.FunTypeKind;
import mlsub.typing.Monotype;
import mlsub.typing.lowlevel.Kind;

public final class FunType
extends Monotype {
    Kind kind;
    private Monotype[] in;
    private Monotype out;

    FunType(FunTypeKind kind, Monotype[] in, Monotype out) {
        this.in = in == null ? Monotype.zeroMonotypes : in;
        this.out = out;
        this.kind = kind;
    }

    public FunType(Monotype[] in, Monotype out) {
        this(FunTypeKind.get(in == null ? 0 : in.length), in, out);
    }

    public boolean isRigid() {
        return this.out.isRigid() && Monotype.isRigid(this.in);
    }

    Monotype substitute(Map map2) {
        return new FunType(Monotype.substitute(map2, this.in), this.out.substitute(map2));
    }

    public Monotype[] domain() {
        return this.in;
    }

    public Monotype codomain() {
        return this.out;
    }

    public int getId() {
        return -1;
    }

    public void setId(int value) {
        throw new Error();
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        throw new Error();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunType)) {
            return false;
        }
        FunType that = (FunType)o;
        return this.out.equals(that.out) && this.in.equals(that.in);
    }

    public String toString() {
        return this.toString(false, null);
    }

    public String toString(boolean isNull, String suffix) {
        StringBuffer res = new StringBuffer();
        if (suffix != null) {
            res.append('(');
        }
        res.append('(').append(Util.map("", ", ", "", this.in)).append(')');
        if (isNull) {
            res.append('?');
        }
        res.append("->").append(this.out);
        if (suffix != null) {
            res.append(')').append(suffix);
        }
        return res.toString();
    }

    void tag(int variance) {
        this.out.tag(variance);
        Monotype.tag(this.in, -1 * variance);
    }

    Monotype canonify() {
        this.out = this.out.canonify();
        this.in = Monotype.canonify(this.in);
        return this;
    }
}

