/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Collection;
import java.util.Iterator;
import mlsub.typing.AtomicKind;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Constraint;
import mlsub.typing.Debug;
import mlsub.typing.Domain;
import mlsub.typing.FunTypeKind;
import mlsub.typing.Interface;
import mlsub.typing.InternalError;
import mlsub.typing.KindingEx;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeLeqEx;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.TypingEx;
import mlsub.typing.Variance;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;
import nice.tools.typing.Types;

public final class Typing {
    static int level = 0;
    public static boolean dbg = bossa.util.Debug.typing;

    public static int enter() {
        return Typing.enter(false);
    }

    public static int enter(boolean tentative) {
        if (dbg) {
            Debug.println("ENTER " + level);
        }
        Engine.enter(tentative);
        return level++;
    }

    public static int enter(String message) {
        if (message != null && dbg) {
            Debug.println("## Typechecking " + message);
        }
        return Typing.enter();
    }

    public static void introduce(Element e) {
        if (dbg) {
            Debug.println("Typing introduced " + e);
        }
        if (e instanceof MonotypeVar) {
            ((MonotypeVar)e).reset();
        }
        Engine.register(e);
    }

    public static void introduce(Element[] elements) {
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            Typing.introduce(elements[i]);
        }
    }

    public static void introduceTypeSymbols(TypeSymbol[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            Typing.introduce((Element)((Object)elements[i]));
        }
    }

    public static int leave() throws TypingEx {
        return Typing.leave(false, false);
    }

    public static int leave(boolean tentative, boolean commit) throws TypingEx {
        if (dbg) {
            Debug.println("LEAVE " + (level - 1));
        }
        try {
            Engine.leave(tentative, commit);
        }
        catch (Unsatisfiable e) {
            if (dbg) {
                e.printStackTrace();
            }
            throw new TypingEx("Unsatisfiable 1:" + e.getMessage());
        }
        return --level;
    }

    public static void implies() throws TypingEx {
        if (dbg) {
            Debug.println("IMPLIES");
        }
        try {
            Engine.implies();
        }
        catch (Unsatisfiable e) {
            throw new TypingEx("Not satisfiable " + e.getMessage());
        }
    }

    public static void startNewCompilation() {
        Engine.reset();
        FunTypeKind.reset();
    }

    public static void createInitialContext() {
        try {
            Engine.createInitialContext();
        }
        catch (Unsatisfiable e) {
            throw new InternalError("Initial context is not satisfiable: " + e);
        }
    }

    public static void releaseInitialContext() {
        Engine.releaseInitialContext();
    }

    public static boolean isInRigidContext() {
        return Engine.isInRigidContext();
    }

    public static void leq(Collection c1, Collection c2) throws TypingEx {
        if (c1.size() != c2.size()) {
            throw new InternalError("Unequal sizes in leq");
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        while (i1.hasNext()) {
            Typing.leq((Polytype)i1.next(), (Polytype)i2.next());
        }
    }

    public static void initialLeq(TypeConstructor t, TypeConstructor[] ts) throws TypingEx {
        for (int i = 0; i < ts.length; ++i) {
            Typing.initialLeq(t, ts[i]);
        }
    }

    public static void leq(TypeConstructor t, Collection c) throws TypingEx {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Typing.leq(t, (TypeConstructor)i.next());
        }
    }

    public static void leq(TypeConstructor t, Monotype m) throws TypingEx {
        if (t == null) {
            return;
        }
        if (Typing.isTop(m)) {
            return;
        }
        AtomicKind v = t.variance;
        if (v == null) {
            throw new InternalError("Don't know how to handle this");
        }
        try {
            Engine.setKind(m, v);
        }
        catch (Unsatisfiable e) {
            if (dbg) {
                throw new TypingEx(t + " < " + m + "'s head :" + e);
            }
            throw new TypingEx("Debugging off");
        }
        Typing.leq(t, ((MonotypeConstructor)m.equivalent()).getTC());
    }

    public static void leq(TypeConstructor[] ts, Monotype[] ms) throws TypingEx {
        for (int i = 0; i < ts.length; ++i) {
            Typing.leq(ts[i], ms[i]);
        }
    }

    public static void leq(Monotype m, TypeConstructor t) throws TypingEx {
        AtomicKind v = t.variance;
        if (v == null) {
            throw new InternalError("Don't know how to handle this");
        }
        try {
            Engine.setKind(m, v);
        }
        catch (Unsatisfiable e) {
            throw new TypingEx(t + " > " + m + "'s head");
        }
        Typing.leq(((MonotypeConstructor)m.equivalent()).getTC(), t);
    }

    public static void leqHead(Monotype[] vars, Monotype[] base) throws TypingEx {
        for (int i = 0; i < vars.length; ++i) {
            TypeConstructor tag;
            Monotype var = vars[i];
            Types.setMarkedKind(var);
            Types.setMarkedKind(base[i]);
            TypeConstructor baseMarker = base[i].head();
            if (baseMarker != null) {
                Typing.leq(var.head(), baseMarker);
            }
            if ((tag = Types.constructor(base[i])) == null) continue;
            Typing.leq(Types.equivalent(vars[i]), tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leq(Polytype t1, Polytype t2) throws TypingEx {
        if (!Constraint.hasBinders(t1.getConstraint()) && !Constraint.hasBinders(t2.getConstraint())) {
            Typing.leq(t1.getMonotype(), t2.getMonotype());
            return;
        }
        if (dbg) {
            Debug.println("Polytype leq: " + t1 + " <: " + t2);
        }
        int l = Typing.enter(true);
        try {
            if (!t2.isMonomorphic()) {
                Constraint.enter(t2.getConstraint());
                Typing.implies();
            }
            Constraint.enter(t1.getConstraint());
            Typing.leq(t1.getMonotype(), t2.getMonotype());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (Typing.leave(true, false) != l) {
                throw new InternalError("Unmatched enters and leaves");
            }
            throw throwable;
        }
        if (Typing.leave(true, false) != l) {
            throw new InternalError("Unmatched enters and leaves");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leq(Polytype t1, Monotype m2) throws TypingEx {
        if (!Constraint.hasBinders(t1.getConstraint())) {
            Typing.leq(t1.getMonotype(), m2);
            return;
        }
        if (dbg) {
            Debug.println("Polytype leq: " + t1 + " <: " + m2);
        }
        int l = Typing.enter();
        try {
            Constraint.enter(t1.getConstraint());
            Typing.leq(t1.getMonotype(), m2);
        }
        finally {
            if (Typing.leave() != l) {
                throw new InternalError("Unmatched enters and leaves");
            }
        }
    }

    public static void leq(Monotype m1, Monotype m2) throws TypingEx {
        if (dbg) {
            Debug.println("Monotype leq: " + m1 + " <: " + m2);
        }
        try {
            Engine.leq(m1, m2);
        }
        catch (Unsatisfiable e) {
            if (dbg) {
                e.printStackTrace();
            }
            throw new MonotypeLeqEx(m1, m2, e);
        }
    }

    public static void eq(Monotype m1, Monotype m2) throws TypingEx {
        Typing.leq(m1, m2);
        Typing.leq(m2, m1);
    }

    public static void leq(Monotype[] ms1, Monotype[] ms2) throws TypingEx {
        for (int i = 0; i < ms1.length; ++i) {
            Typing.leq(ms1[i], ms2[i]);
        }
    }

    public static void leq(Monotype[] ms1, Monotype[] ms2, boolean dispatchable) throws TypingEx {
        if (!dispatchable) {
            for (int i = 0; i < ms1.length; ++i) {
                Typing.leq(ms1[i], ms2[i]);
            }
        } else {
            for (int i = 0; i < ms1.length; ++i) {
                Monotype m1 = ms1[i];
                Monotype m2 = ms2[i];
                Typing.leq(m1, m2);
                if (Types.isDispatchable(m2)) continue;
                Typing.leq(m2, m1);
            }
        }
    }

    public static void initialLeq(TypeConstructor t1, TypeConstructor t2) throws TypingEx {
        if (dbg) {
            Debug.println("Initial leq: " + t1 + " < " + t2);
        }
        try {
            Engine.leq(t1, t2, true);
        }
        catch (Unsatisfiable e) {
            throw new KindingEx(t1, t2);
        }
    }

    public static void leq(TypeConstructor t1, TypeConstructor t2) throws TypingEx {
        if (dbg) {
            Debug.println("TC leq: " + t1 + " < " + t2);
        }
        try {
            Engine.leq(t1, t2, false);
        }
        catch (Unsatisfiable e) {
            throw new TypingEx("Not satisfiable 4:" + e.getMessage());
        }
    }

    public static boolean testLeq(TypeConstructor t1, TypeConstructor t2) {
        if (t1.getKind() == null || t2.getKind() == null) {
            throw new InternalError("Null kind for " + t1 + " or " + t2);
        }
        try {
            Engine.leq(t1, t2, false);
            return true;
        }
        catch (Unsatisfiable e) {
            return false;
        }
    }

    public static void leq(Domain d1, Domain d2) throws TypingEx {
        Typing.leq(d1, d2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leq(Domain d1, Domain d2, boolean dispatchable) throws TypingEx {
        if (dbg) {
            Debug.println(d1 + " leq " + d2);
        }
        if (d1 == Domain.bot) {
            return;
        }
        if (!Constraint.hasBinders(d1.getConstraint()) && !Constraint.hasBinders(d2.getConstraint())) {
            Typing.leq(d1.getMonotypes(), d2.getMonotypes(), dispatchable);
            return;
        }
        Typing.enter(true);
        try {
            Constraint.enter(d1.getConstraint());
            Typing.implies();
            Constraint.enter(d2.getConstraint());
            Typing.leq(d1.getMonotypes(), d2.getMonotypes(), dispatchable);
        }
        finally {
            Typing.leave(true, false);
        }
    }

    public static boolean smaller(Domain d1, Domain d2) {
        try {
            Typing.leq(d1, d2);
            return true;
        }
        catch (TypingEx ex) {
            return false;
        }
    }

    public static boolean smaller(Domain d1, Domain d2, boolean dispatchable) {
        try {
            Typing.leq(d1, d2, dispatchable);
            return true;
        }
        catch (TypingEx ex) {
            return false;
        }
    }

    public static void in(Polytype type, Monotype domain) throws TypingEx {
        if (dbg) {
            Debug.println(type + " in " + domain);
        }
        Constraint.enter(type.getConstraint());
        Typing.leq(type.getMonotype(), domain);
    }

    public static void in(Polytype[] types, Monotype[] domains) throws TypingEx {
        int expected = domains.length;
        int actual = types.length;
        if (expected != actual) {
            throw new BadSizeEx(expected, actual);
        }
        for (int i = 0; i < actual; ++i) {
            Typing.in(types[i], domains[i]);
        }
    }

    public static void assertLeq(Interface i, Interface j) throws KindingEx {
        if (dbg) {
            Debug.println(i + " < " + j);
        }
        if (!i.variance.equals(j.variance)) {
            throw new KindingEx(i, j);
        }
        i.variance.subInterface(i.itf, j.itf);
    }

    public static void assertLeq(Interface itf, Interface[] is) throws KindingEx {
        int i = is.length;
        while (--i >= 0) {
            Typing.assertLeq(itf, is[i]);
        }
    }

    public static void assertImp(TypeConstructor t, Interface i, boolean initial) throws TypingEx {
        if (dbg) {
            Debug.println(t + " imp " + i);
        }
        try {
            Engine.setKind(t, i.variance.getConstraint());
        }
        catch (Unsatisfiable e) {
            throw new KindingEx(t, i);
        }
        try {
            if (initial) {
                ((Variance)t.variance).initialImplements(t.getId(), i.itf);
            } else {
                ((Variance)t.variance).indexImplements(t.getId(), i.itf);
            }
            TypeConstructor tc = i.associatedTC();
            if (tc != null) {
                Engine.leq(t, tc, initial);
            }
        }
        catch (Unsatisfiable e) {
            throw new TypingEx(e.getMessage());
        }
    }

    public static void assertAbs(TypeConstructor t, Interface i) throws TypingEx {
        if (dbg) {
            Debug.println(t + " abs " + i);
        }
        if (Engine.isRigid(t)) {
            throw new InternalError("Abstraction required on a rigid type constructor : \n" + t + " required to abstract " + i);
        }
        i.variance.initialAbstracts(t.getId(), i.itf);
    }

    public static void assertImp(TypeConstructor t, Interface[] is, boolean initial) throws TypingEx {
        for (int i = 0; i < is.length; ++i) {
            Typing.assertImp(t, is[i], initial);
        }
    }

    public static void assertAbs(TypeConstructor t, Interface[] is) throws TypingEx {
        for (int i = 0; i < is.length; ++i) {
            Typing.assertAbs(t, is[i]);
        }
    }

    public static boolean testRigidLeq(TypeConstructor t1, TypeConstructor t2) {
        if (t1.getKind() == null || t2.getKind() == null) {
            throw new InternalError("Null kind for " + t1 + " or " + t2);
        }
        if (t1.getKind() != t2.getKind()) {
            return false;
        }
        return ((Engine.Constraint)t1.getKind()).isLeq(t1, t2);
    }

    public static TypeConstructor lowestInstance(TypeConstructor tc) {
        Engine.Constraint cst = (Engine.Constraint)tc.getKind();
        if (!cst.isValid(tc)) {
            System.out.println("Warning: lowestInstance called inapropriately for " + tc);
            return null;
        }
        return (TypeConstructor)cst.lowestInstance(tc);
    }

    static boolean isTop(Monotype m) {
        return m.getKind() == TopMonotype.TopKind.instance;
    }
}

