/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.IntVect;
import mlsub.typing.lowlevel.K0;

class Interface {
    private K0 k0;
    private int iid;
    BitVector subInterfaces = new BitVector();
    BitVector rigidImplementors = null;
    BitVector implementors = new BitVector();
    BitVector abstractors = new BitVector();
    private final IntVect approx = new IntVect(Integer.MIN_VALUE);
    private final BitVector hasapprox = new BitVector();

    Interface(K0 k0, int iid) {
        this.k0 = k0;
        this.iid = iid;
    }

    int getIndex() {
        return this.iid;
    }

    public BitVector getHasApprox() {
        return this.hasapprox;
    }

    public void setApprox(int node, int approx) {
        if (node >= this.approx.size()) {
            this.approx.setSize(node + 1, Integer.MIN_VALUE);
        }
        this.approx.set(node, approx);
        if (approx == Integer.MIN_VALUE) {
            this.hasapprox.clear(node);
        } else {
            this.hasapprox.set(node);
        }
    }

    public int getApprox(int node) {
        return this.approx.get(node);
    }

    void setIndexSize(int n) {
        this.implementors.truncate(n);
        this.approx.setSize(n, Integer.MIN_VALUE);
        this.hasapprox.truncate(n);
    }

    void indexMove(int src, int dest) {
        this.implementors.bitCopy(src, dest);
        this.approx.set(dest, this.approx.get(src));
        this.hasapprox.set(dest);
        if (this.k0.isRigid(src)) {
            this.rigidImplementors.bitCopy(src, dest);
            this.abstractors.bitCopy(src, dest);
        }
    }

    void indexMerge(int src, int dest) {
        this.implementors.bitMerge(src, dest);
        if (this.k0.isRigid(src)) {
            this.rigidImplementors.bitMerge(src, dest);
            this.abstractors.bitMerge(src, dest);
        }
    }

    public String toString() {
        return this.k0.interfaceToString(this.iid);
    }
}

