/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.compiler;

import bossa.modules.Compilation;
import bossa.modules.Exit;
import bossa.modules.Package;
import bossa.util.Internal;
import bossa.util.Location;
import bossa.util.UserError;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import nice.tools.compiler.StatusCodeListener;
import nice.tools.compiler.dispatch;
import nice.tools.compiler.fun$waitFor;

public class fun {
    public static final int OK = 0;
    public static final int BUG = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final String versionNumber = "0.9.13 prerelease";
    public static final String buildDate = "2006.12.17, 10:18:17 UTC";
    public static final String javaVersion = "1.4.2_13";

    public static List load(Compilation compilation, String mainPackage) {
        Throwable uncaughtException = null;
        try {
            Package.currentCompilation = compilation;
            if (compilation.runtimeFile == null) {
                compilation.runtimeFile = dispatch.getNiceRuntime();
            }
            compilation.setMainPackage(mainPackage);
            return nice.lang.dispatch.flatten(mlsub.compilation.dispatch.load(compilation));
        }
        catch (Exit e) {
        }
        catch (UserError e) {
            Internal.warning("user error only caught in main");
            compilation.listener.error(e.location, (String)nice.lang.dispatch.notNull(e.message));
        }
        catch (ExceptionInInitializerError e) {
            uncaughtException = e.getException();
        }
        catch (Throwable e) {
            uncaughtException = e;
        }
        if (uncaughtException != null) {
            StringWriter stackTrace = new StringWriter(500);
            uncaughtException.printStackTrace(new PrintWriter(stackTrace));
            compilation.listener.bug(stackTrace.toString(), "http://sourceforge.net/tracker/?func=add&group_id=12788&atid=112788");
            throw uncaughtException;
        }
        throw new Exit();
    }

    public static int waitFor(Process p, Writer w) {
        fun$waitFor fun$waitFor = new fun$waitFor();
        fun$waitFor.out = new BufferedReader(new InputStreamReader(p.getInputStream()));
        fun$waitFor.err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        fun$waitFor.printer = new PrintWriter(w);
        Thread consumeOut = nice.lang.dispatch.thread(fun$waitFor.lambda$Fn34);
        Thread consumeErr = nice.lang.dispatch.thread(fun$waitFor.lambda$Fn35);
        consumeOut.start();
        consumeErr.start();
        consumeOut.join();
        consumeErr.join();
        return p.waitFor();
    }

    public static void fail(String msg) {
        nice.lang.dispatch.print("Native compilation with gcj failed");
        if (msg != null) {
            nice.lang.dispatch.println(nice.lang.dispatch.$$002b(": ", msg));
        } else {
            System.out.println();
        }
    }

    public static void compileWithGcj(String gcj, String pkg, String output, String jar) {
        block7: {
            if (gcj == null) {
                dispatch.fail("gcj was not found in the path");
                return;
            }
            try {
                Process p = Runtime.getRuntime().exec(new String[]{gcj, "--classpath=", nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("--main=", pkg), ".fun"), "-o", output, jar});
                CharArrayWriter out = new CharArrayWriter();
                int exitValue = dispatch.waitFor(p, out);
                if (exitValue == 0) break block7;
                dispatch.fail(null);
                BufferedReader in = new BufferedReader(new CharArrayReader(out.toCharArray()));
                try {
                    String line = in.readLine();
                    while (line != null) {
                        nice.lang.dispatch.println(line);
                        line = in.readLine();
                    }
                }
                catch (IOException ex) {
                }
            }
            catch (IOException e) {
                dispatch.fail(e.getMessage());
            }
            catch (SecurityException e) {
                dispatch.fail(e.getMessage());
            }
        }
    }

    public static void produceNativeProgram(String nativeCompiler, String pkg, String output, String jar) {
        dispatch.compileWithGcj(nativeCompiler, pkg, output, jar);
    }

    public static String getNiceRuntime() {
        String resource = "/nice/tools/compiler/fun.class";
        URL classUrl = Class.forName("nice.tools.compiler.dispatch").getResource(resource);
        if (classUrl == null) {
            return null;
        }
        String file = (String)nice.lang.dispatch.notNull(classUrl.getFile());
        try {
            return file.substring(file.indexOf(":") + 1, file.indexOf("!"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return file.substring(0, file.indexOf(resource));
        }
    }

    public static void compile(Compilation compilation, String mainPackage, String nativeProgram, String nativeCompiler, boolean editorMode) {
        Throwable uncaughtException = null;
        try {
            Package.currentCompilation = compilation;
            Location.editorMode = editorMode;
            if (compilation.runtimeFile == null) {
                compilation.runtimeFile = dispatch.getNiceRuntime();
            }
            compilation.setMainPackage(mainPackage);
            mlsub.compilation.dispatch.make(compilation);
            String jar = compilation.output;
            if (nativeProgram != null && jar != null) {
                dispatch.produceNativeProgram(nativeCompiler, mainPackage, nativeProgram, jar);
            }
        }
        catch (Exit e) {
        }
        catch (UserError e) {
            Internal.warning("user error only caught in main");
            compilation.listener.error(e.location, (String)nice.lang.dispatch.notNull(e.message));
        }
        catch (ExceptionInInitializerError e) {
            uncaughtException = e.getException();
        }
        catch (Throwable e) {
            uncaughtException = e;
        }
        if (uncaughtException != null) {
            StringWriter stackTrace = new StringWriter(500);
            nice.lang.dispatch.printStackTraceWithSourceInfo(uncaughtException, new PrintWriter(stackTrace));
            compilation.listener.bug(stackTrace.toString(), "http://sourceforge.net/tracker/?func=add&group_id=12788&atid=112788");
        }
    }

    public static void bug(StatusCodeListener this_, String stackTrace, String url) {
        this_.setStatusCode(BUG);
    }

    public static void error(StatusCodeListener this_, Location location, String message) {
        this_.setStatusCode(ERROR);
    }

    public static boolean worse(int status, int than) {
        if (than == OK) {
            return true;
        }
        if (than == BUG) {
            return false;
        }
        if (than == ERROR) {
            return false;
        }
        if (than == WARNING) {
            return status == BUG || status == ERROR;
        }
        return false;
    }

    public static void setStatusCode(StatusCodeListener this_, int status) {
        if (dispatch.worse(status, this_.statusCode)) {
            this_.statusCode = status;
        }
    }

    public static void warning(StatusCodeListener this_, Location location, String message) {
        this_.setStatusCode(WARNING);
    }
}

