/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PackageNamesLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID = "-//Puppy Crawl//DTD Package Names 1.0//EN";
    private static final String DTD_RESOURCE_NAME = "com/puppycrawl/tools/checkstyle/packages_1_0.dtd";
    private static final String DEFAULT_PACKAGES = "com/puppycrawl/tools/checkstyle/checkstyle_packages.xml";
    private final PackageObjectFactory mModuleFactory = new PackageObjectFactory();
    private Stack mPackageStack = new Stack();

    private PackageNamesLoader() throws ParserConfigurationException, SAXException {
        super(DTD_PUBLIC_ID, DTD_RESOURCE_NAME);
    }

    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        if (aQName.equals("package")) {
            String name = aAtts.getValue("name");
            if (name == null) {
                throw new SAXException("missing package name");
            }
            this.mPackageStack.push(name);
        }
    }

    private String getPackageName() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.mPackageStack.iterator();
        while (it.hasNext()) {
            String subPackage = (String)it.next();
            buf.append(subPackage);
            if (subPackage.endsWith(".")) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    private ModuleFactory getModuleFactory() {
        return this.mModuleFactory;
    }

    public void endElement(String aNamespaceURI, String aLocalName, String aQName) {
        if (aQName.equals("package")) {
            this.mModuleFactory.addPackage(this.getPackageName());
            this.mPackageStack.pop();
        }
    }

    public static ModuleFactory loadModuleFactory(ClassLoader aClassLoader) throws CheckstyleException {
        InputStream stream = aClassLoader.getResourceAsStream(DEFAULT_PACKAGES);
        InputSource source = new InputSource(stream);
        return PackageNamesLoader.loadModuleFactory(source, "default package names");
    }

    public static ModuleFactory loadModuleFactory(String aFilename) throws CheckstyleException {
        FileReader reader = null;
        try {
            reader = new FileReader(aFilename);
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aFilename, e);
        }
        InputSource source = new InputSource(reader);
        return PackageNamesLoader.loadModuleFactory(source, aFilename);
    }

    private static ModuleFactory loadModuleFactory(InputSource aSource, String aSourceName) throws CheckstyleException {
        try {
            PackageNamesLoader nameLoader = new PackageNamesLoader();
            nameLoader.parseInputSource(aSource);
            return nameLoader.getModuleFactory();
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aSourceName, e);
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aSourceName, e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aSourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aSourceName, e);
        }
    }
}

