/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Properties;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private final String mDetailsFile;
    private final Properties mDetails;
    private static char[] sHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MASK_0X0F = 15;
    private static final int SHIFT_4 = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    PropertyCacheFile(Configuration aCurrentConfig, String aFileName) {
        block16: {
            super();
            this.mDetails = new Properties();
            setInActive = true;
            fileName = aFileName;
            if (fileName != null) {
                inStream = null;
                try {
                    block15: {
                        inStream = new FileInputStream(fileName);
                        this.mDetails.load(inStream);
                        cachedConfigHash = this.mDetails.getProperty("configuration*?");
                        currentConfigHash = this.getConfigHashCode(aCurrentConfig);
                        setInActive = false;
                        if (cachedConfigHash != null && cachedConfigHash.equals(currentConfigHash)) break block15;
                        this.mDetails.clear();
                        this.mDetails.put("configuration*?", currentConfigHash);
                    }
                    var9_10 = null;
                    ** if (inStream == null) goto lbl-1000
                }
                catch (Throwable var8_18) {
                    var9_13 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ex) {
                            System.out.println("Unable to close cache file.");
                            ex.printStackTrace(System.out);
                        }
                    }
                    throw var8_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to close cache file.");
                        ex.printStackTrace(System.out);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (FileNotFoundException e) {
                        setInActive = false;
                        var9_11 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {
                                System.out.println("Unable to close cache file.");
                                ex.printStackTrace(System.out);
                            }
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        System.out.println("Unable to open cache file, ignoring.");
                        e.printStackTrace(System.out);
                        var9_12 = null;
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {
                                System.out.println("Unable to close cache file.");
                                ex.printStackTrace(System.out);
                            }
                        }
                    }
                }
            }
        }
        this.mDetailsFile = setInActive != false ? null : fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void destroy() {
        if (this.mDetailsFile == null) return;
        FileOutputStream out = null;
        out = new FileOutputStream(this.mDetailsFile);
        this.mDetails.store(out, null);
        Object var4_2 = null;
        if (out == null) return;
        try {
            out.flush();
            out.close();
            return;
        }
        catch (IOException ex) {
            System.out.println("Unable to close cache file");
            ex.printStackTrace(System.out);
        }
        return;
        {
            catch (IOException e) {
                System.out.println("Unable to save cache file");
                e.printStackTrace(System.out);
                Object var4_3 = null;
                if (out == null) return;
                try {
                    out.flush();
                    out.close();
                    return;
                }
                catch (IOException ex) {
                    System.out.println("Unable to close cache file");
                    ex.printStackTrace(System.out);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (out == null) throw throwable;
            try {
                out.flush();
                out.close();
                throw throwable;
            }
            catch (IOException ex) {
                System.out.println("Unable to close cache file");
                ex.printStackTrace(System.out);
            }
            throw throwable;
        }
    }

    boolean alreadyChecked(String aFileName, long aTimestamp) {
        String lastChecked = this.mDetails.getProperty(aFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(aTimestamp));
    }

    void checkedOk(String aFileName, long aTimestamp) {
        this.mDetails.put(aFileName, Long.toString(aTimestamp));
    }

    private String getConfigHashCode(Serializable aConfiguration) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(aConfiguration);
            oos.flush();
            oos.close();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(baos.toByteArray());
            return PropertyCacheFile.hexEncode(md.digest());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ALWAYS FRESH: " + System.currentTimeMillis();
        }
    }

    private static String hexEncode(byte[] aByteArray) {
        StringBuffer buf = new StringBuffer(2 * aByteArray.length);
        for (int i = 0; i < aByteArray.length; ++i) {
            byte b = aByteArray[i];
            int low = b & 0xF;
            int high = b >> 4 & 0xF;
            buf.append(sHexChars[high]);
            buf.append(sHexChars[low]);
        }
        return buf.toString();
    }
}

