/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.checks.javadoc.HtmlTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.Point;
import java.util.LinkedList;
import java.util.List;

class TagParser {
    private final List mTags = new LinkedList();

    public TagParser(String[] aText, int aLineNo) {
        this.parseTags(aText, aLineNo);
    }

    public HtmlTag nextTag() {
        return (HtmlTag)this.mTags.remove(0);
    }

    public boolean hasNextTag() {
        return this.mTags.size() > 0;
    }

    private void add(HtmlTag aTag) {
        this.mTags.add(aTag);
    }

    private void parseTags(String[] aText, int aLineNo) {
        int nLines = aText.length;
        Point position = new Point(0, 0);
        position = this.findChar(aText, '<', position);
        while (position.getLineNo() < nLines) {
            if (this.isCommentTag(aText, position)) {
                position = this.skipHtmlComment(aText, position);
            } else if (!this.isTag(aText, position)) {
                position = this.getNextCharPos(aText, position);
            } else {
                Point endTag = this.findChar(aText, '>', position);
                boolean incompleteTag = endTag.getLineNo() >= nLines;
                String tagId = incompleteTag ? "" : this.getTagId(aText, position);
                boolean closedTag = endTag.getLineNo() < nLines && endTag.getColumnNo() > 0 && aText[endTag.getLineNo()].charAt(endTag.getColumnNo() - 1) == '/';
                this.add(new HtmlTag(tagId, position.getLineNo() + aLineNo, position.getColumnNo(), closedTag, incompleteTag, aText[position.getLineNo()]));
                position = endTag;
            }
            position = this.findChar(aText, '<', position);
        }
    }

    private boolean isTag(String[] aText, Point aPos) {
        String text;
        int column = aPos.getColumnNo() + 1;
        return column < (text = aText[aPos.getLineNo()]).length() && (text.charAt(column) >= 'A' && text.charAt(column) <= 'Z' || text.charAt(column) >= 'a' && text.charAt(column) <= 'z' || text.charAt(column) == '/') || column >= text.length();
    }

    private String getTagId(String[] aText, Point aTagStart) {
        String text;
        int column = aTagStart.getColumnNo() + 1;
        if (column >= (text = aText[aTagStart.getLineNo()]).length()) {
            return "";
        }
        if (text.charAt(column) == '/') {
            ++column;
        }
        text = text.substring(column).trim();
        for (column = 0; column < text.length() && (text.charAt(column) >= 'A' && text.charAt(column) <= 'Z' || text.charAt(column) >= 'a' && text.charAt(column) <= 'z'); ++column) {
        }
        return text.substring(0, column);
    }

    private boolean isCommentTag(String[] aText, Point aPos) {
        return aText[aPos.getLineNo()].startsWith("<!--", aPos.getColumnNo());
    }

    private Point skipHtmlComment(String[] aText, Point aFrom) {
        Point to = aFrom;
        to = this.findChar(aText, '>', to);
        while (to.getLineNo() < aText.length && !aText[to.getLineNo()].substring(0, to.getColumnNo()).endsWith("-->")) {
            to = this.findChar(aText, '>', this.getNextCharPos(aText, to));
        }
        return to;
    }

    private Point findChar(String[] aText, char aChar, Point aFrom) {
        Point curr = new Point(aFrom.getLineNo(), aFrom.getColumnNo());
        while (curr.getLineNo() < aText.length && aText[curr.getLineNo()].charAt(curr.getColumnNo()) != aChar) {
            curr = this.getNextCharPos(aText, curr);
        }
        return curr;
    }

    private Point getNextCharPos(String[] aText, Point aFrom) {
        int line = aFrom.getLineNo();
        int column = aFrom.getColumnNo() + 1;
        while (line < aText.length && column >= aText[line].length()) {
            column = 0;
            if (++line >= aText.length) continue;
            String currentLine = aText[line];
            while (column < currentLine.length() && (Character.isWhitespace(currentLine.charAt(column)) || currentLine.charAt(column) == '*')) {
                if (++column >= currentLine.length() || currentLine.charAt(column - 1) != '*' || currentLine.charAt(column) != '/') continue;
                column = currentLine.length();
            }
        }
        return new Point(line, column);
    }
}

