/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.json.ParseException;
import net.sourceforge.plantuml.tim.EaterAffectation;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;
import net.sourceforge.plantuml.utils.StringLocated;

public class CodeIteratorAffectation
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorAffectation(CodeIterator source, TContext context, TMemory memory, List<StringLocated> log) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = log;
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (result.getType() != TLineType.AFFECTATION) break;
            this.logs.add(result);
            this.doAffectation(result);
            this.next();
        }
        return result;
    }

    private void doAffectation(StringLocated result) throws EaterException, EaterExceptionLocated {
        int lastLocation = -1;
        for (int i = 0; i < 9999; ++i) {
            try {
                this.executeAffectation(this.context, this.memory, result);
                return;
            }
            catch (ParseException e) {
                if (e.getColumn() <= lastLocation) {
                    throw EaterException.located("Error in JSON format");
                }
                lastLocation = e.getColumn();
                this.next();
                StringLocated forward = this.source.peek();
                result = result.append(forward.getString());
                continue;
            }
        }
    }

    private void executeAffectation(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        new EaterAffectation(s).analyze(context, memory);
    }
}

