/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.gitlog.Commit;
import net.sourceforge.plantuml.gitlog.CursorPosition;

public class GitTextArea {
    private final List<String> lines = new ArrayList<String>();
    private final List<Commit> commits = new ArrayList<Commit>();

    public void add(String s) {
        this.lines.add(s);
    }

    public List<Commit> getAllCommits() {
        if (this.commits.size() == 0) {
            for (int y = 0; y < this.lines.size(); ++y) {
                String s = this.lines.get(y);
                String name = CursorPosition.getCommitNameInLine(s);
                int x = s.indexOf("*");
                assert (name == null == (x == -1));
                if (x == -1) continue;
                this.commits.add(new Commit(name, new CursorPosition(this, x, y)));
            }
        }
        return Collections.unmodifiableList(this.commits);
    }

    public char charAt(int x, int y) {
        return this.lines.get(y).charAt(x);
    }

    public String getLine(int y) {
        if (y >= this.lines.size()) {
            return "";
        }
        return this.lines.get(y);
    }

    public Commit getCommitByName(String name) {
        for (Commit commit : this.getAllCommits()) {
            if (!commit.getName().equals(name)) continue;
            return commit;
        }
        return null;
    }
}

