/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.abel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Bag;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.EntityFactory;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.abel.EntityUtils;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.Hideable;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.LineConfigurable;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.Removeable;
import net.sourceforge.plantuml.abel.SpecificBackcolorable;
import net.sourceforge.plantuml.abel.Together;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.dot.Neighborhood;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockEmpty;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereostyles;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.Position;

public final class Entity
implements SpecificBackcolorable,
Hideable,
Removeable,
LineConfigurable,
Bag {
    private final EntityFactory entityFactory;
    private final Quark<Entity> quark;
    private Url url;
    private final Bodier bodier;
    private final String uid;
    private Display display = Display.empty();
    private DisplayPositioned legend = null;
    private LeafType leafType;
    private Stereotype stereotype;
    private Stereostyles stereostyles = Stereostyles.NONE;
    private String generic;
    private GroupType groupType;
    private Margins margins = Margins.NONE;
    private final Collection<String> portShortNames = new HashSet<String>();
    private int xposition;
    private IEntityImage svekImage;
    private USymbol symbol;
    private final int rawLayout;
    private char concurrentSeparator;
    private LineLocation codeLine;
    private Set<Stereotag> tags = new LinkedHashSet<Stereotag>();
    private final List<CucaNote> notesTop = new ArrayList<CucaNote>();
    private final List<CucaNote> notesBottom = new ArrayList<CucaNote>();
    private Together together;
    private Neighborhood neighborhood;
    private final Map<String, Display> tips = new LinkedHashMap<String, Display>();
    private Colors colors = Colors.empty();
    private VisibilityModifier visibility;
    private final Map<Direction, List<Kal>> kals = new EnumMap<Direction, List<Kal>>(Direction.class);
    private boolean isStatic;

    public void addNote(Display note, Position position, Colors colors) {
        if (position == Position.TOP) {
            this.notesTop.add(CucaNote.build(note, position, colors));
        } else if (position == Position.BOTTOM) {
            this.notesBottom.add(CucaNote.build(note, position, colors));
        }
    }

    public List<CucaNote> getNotes(Position position) {
        if (position == Position.TOP) {
            return Collections.unmodifiableList(this.notesTop);
        }
        if (position == Position.BOTTOM) {
            return Collections.unmodifiableList(this.notesBottom);
        }
        throw new IllegalArgumentException();
    }

    public void addStereotag(Stereotag tag) {
        this.tags.add(tag);
    }

    public Set<Stereotag> stereotags() {
        return Collections.unmodifiableSet(this.tags);
    }

    private Entity(Quark<Entity> quark, EntityFactory entityFactory, Bodier bodier, int rawLayout) {
        this.quark = Objects.requireNonNull(quark);
        this.uid = quark.isRoot() ? "clroot" : StringUtils.getUid("cl", entityFactory.getDiagram().getUniqueSequence());
        this.entityFactory = entityFactory;
        this.bodier = bodier;
        this.rawLayout = rawLayout;
        this.quark.setData(this);
    }

    Entity(Quark<Entity> quark, EntityFactory entityFactory, Bodier bodier, LeafType leafType, int rawLayout) {
        this(Objects.requireNonNull(quark), entityFactory, bodier, rawLayout);
        this.leafType = leafType;
    }

    Entity(Quark<Entity> quark, EntityFactory entityFactory, Bodier bodier, GroupType groupType, int rawLayout) {
        this(Objects.requireNonNull(quark), entityFactory, bodier, rawLayout);
        this.groupType = groupType;
    }

    public LeafType getLeafType() {
        return this.leafType;
    }

    public void muteToType(LeafType newType) {
        if (this.leafType == LeafType.CLASS && newType == LeafType.OBJECT) {
            this.bodier.muteClassToObject();
        }
        this.groupType = null;
        this.leafType = newType;
    }

    public void muteToGroupType(GroupType newType) {
        this.groupType = newType;
        this.leafType = null;
    }

    public boolean muteToType(LeafType newType, USymbol newSymbol) {
        Objects.requireNonNull(newType);
        if (this.leafType != LeafType.STILL_UNKNOWN) {
            if (newType == this.leafType) {
                return true;
            }
            if (this.leafType != LeafType.ANNOTATION && this.leafType != LeafType.ABSTRACT_CLASS && this.leafType != LeafType.CLASS && this.leafType != LeafType.ENUM && this.leafType != LeafType.INTERFACE) {
                return false;
            }
            if (newType != LeafType.ANNOTATION && newType != LeafType.ABSTRACT_CLASS && newType != LeafType.CLASS && newType != LeafType.ENUM && newType != LeafType.INTERFACE && newType != LeafType.OBJECT) {
                return false;
            }
        }
        if (this.leafType == LeafType.CLASS && newType == LeafType.OBJECT) {
            this.bodier.muteClassToObject();
        }
        this.leafType = newType;
        this.symbol = newSymbol;
        return true;
    }

    public Quark<Entity> getQuark() {
        return this.quark;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public String getUid() {
        return this.uid;
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public String toString() {
        return this.quark.toString() + " " + this.display + "(" + (Object)((Object)this.leafType) + ")[" + (Object)((Object)this.groupType) + "] " + this.getUid();
    }

    public final Url getUrl99() {
        return this.url;
    }

    public boolean hasUrl() {
        if (!Display.isNull(this.display) && this.display.hasUrl()) {
            return true;
        }
        if (this.bodier == null) {
            return false;
        }
        if (this.bodier.hasUrl()) {
            return true;
        }
        return this.url != null;
    }

    public final void addUrl(Url url) {
        this.url = url;
    }

    public final Margins getMargins() {
        this.checkNotGroup();
        return this.margins;
    }

    public final void ensureMargins(Margins newMargins) {
        this.margins = this.margins.merge(newMargins);
    }

    public int getXposition() {
        this.checkNotGroup();
        return this.xposition;
    }

    public void setXposition(int pos) {
        this.checkNotGroup();
        this.xposition = pos;
    }

    public final IEntityImage getSvekImage() {
        this.checkNotGroup();
        return this.svekImage;
    }

    public final void setSvekImage(IEntityImage svekImage) {
        this.checkNotGroup();
        this.svekImage = svekImage;
    }

    public final void setGeneric(String generic) {
        this.checkNotGroup();
        this.generic = generic;
    }

    public final String getGeneric() {
        this.checkNotGroup();
        return this.generic;
    }

    public Bodier getBodier() {
        return this.bodier;
    }

    public EntityPosition getEntityPosition() {
        if (this.leafType == LeafType.PORTIN) {
            return EntityPosition.PORTIN;
        }
        if (this.leafType == LeafType.PORTOUT) {
            return EntityPosition.PORTOUT;
        }
        if (this.leafType != LeafType.STATE) {
            return EntityPosition.NORMAL;
        }
        if (this.quark.isRoot()) {
            return EntityPosition.NORMAL;
        }
        Stereotype stereotype = this.getStereotype();
        if (stereotype == null) {
            return EntityPosition.NORMAL;
        }
        return EntityPosition.fromStereotype(stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR));
    }

    private void checkGroup() {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkNotGroup() {
        if (this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    public GroupType getGroupType() {
        this.checkGroup();
        return this.groupType;
    }

    public PackageStyle getPackageStyle() {
        this.checkGroup();
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }

    public boolean isGroup() {
        if (this.groupType != null && this.leafType != null) {
            throw new IllegalStateException();
        }
        assert (this.groupType == null || this.leafType == null);
        if (this.groupType != null) {
            return true;
        }
        if (this.leafType != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    public void overrideImage(IEntityImage img, LeafType leafType) {
        this.checkGroup();
        this.svekImage = img;
        this.url = null;
        for (Link link : new ArrayList<Link>(this.entityFactory.getLinks())) {
            if (!EntityUtils.isPureInnerLink12(this, link)) continue;
            this.entityFactory.removeLink(link);
        }
        this.groupType = null;
        this.leafType = leafType;
    }

    public USymbol getUSymbol() {
        if (this.getLeafType() == LeafType.CIRCLE) {
            return USymbols.INTERFACE;
        }
        return this.symbol;
    }

    public void setUSymbol(USymbol symbol) {
        this.symbol = symbol;
    }

    public SingleStrategy getSingleStrategy() {
        return SingleStrategy.SQUARE;
    }

    @Override
    public boolean isHidden() {
        if (this.getParentContainer() != null && this.getParentContainer().isHidden()) {
            return true;
        }
        return this.isHiddenInternal();
    }

    private boolean isHiddenInternal() {
        if (this.quark.isRoot()) {
            return false;
        }
        if (this.isGroup()) {
            if (this.entityFactory.isHidden(this)) {
                return true;
            }
            if (this.leafs().size() == 0) {
                return false;
            }
            for (Entity leaf : this.leafs()) {
                if (leaf.isHiddenInternal()) continue;
                return false;
            }
            for (Entity g : this.groups()) {
                if (g.isHiddenInternal()) continue;
                return false;
            }
            return true;
        }
        return this.entityFactory.isHidden(this);
    }

    @Override
    public boolean isRemoved() {
        if (this.getParentContainer() != null && this.getParentContainer().isRemoved()) {
            return true;
        }
        return this.isRemovedInternal();
    }

    private boolean isRemovedInternal() {
        if (this.isGroup()) {
            if (this.entityFactory.isRemoved(this)) {
                return true;
            }
            if (this.leafs().size() == 0 && this.groups().size() == 0) {
                return false;
            }
            for (Entity leaf : this.leafs()) {
                if (leaf.isRemovedInternal()) continue;
                return false;
            }
            for (Entity g : this.groups()) {
                if (g.isRemovedInternal()) continue;
                return false;
            }
            return true;
        }
        return this.entityFactory.isRemoved(this);
    }

    public boolean isAloneAndUnlinked() {
        if (this.isGroup()) {
            return false;
        }
        for (Link link : this.entityFactory.getLinks()) {
            Entity other;
            boolean removed;
            if (!link.contains(this) || (removed = this.entityFactory.isRemovedIgnoreUnlinked(other = link.getOther(this))) || link.getType().isInvisible()) continue;
            return false;
        }
        return true;
    }

    private FontParam getTitleFontParam() {
        return this.getGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
    }

    public FontConfiguration getFontConfigurationForTitle(ISkinParam skinParam) {
        FontParam fontParam = this.getTitleFontParam();
        HColor fontHtmlColor = skinParam.getFontHtmlColor(this.getStereotype(), fontParam, FontParam.PACKAGE);
        UFont font = skinParam.getFont(this.getStereotype(), true, fontParam, FontParam.PACKAGE);
        FontConfiguration fontConfiguration = FontConfiguration.create(font, fontHtmlColor, skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink(), skinParam.getTabSize());
        return fontConfiguration;
    }

    public final int getRawLayout() {
        return this.rawLayout;
    }

    public char getConcurrentSeparator() {
        return this.concurrentSeparator;
    }

    public void setConcurrentSeparator(char separator) {
        this.concurrentSeparator = separator;
    }

    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }

    public void putTip(String member, Display display) {
        this.tips.put(member, display);
    }

    public Map<String, Display> getTips() {
        return Collections.unmodifiableMap(this.tips);
    }

    @Override
    public Colors getColors() {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public void setSpecificColorTOBEREMOVED(ColorType type, HColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    public Collection<String> getPortShortNames() {
        this.checkNotGroup();
        return Collections.unmodifiableCollection(this.portShortNames);
    }

    public void addPortShortName(String portShortName) {
        this.portShortNames.add(portShortName);
    }

    public void setVisibilityModifier(VisibilityModifier visibility) {
        this.visibility = visibility;
    }

    public VisibilityModifier getVisibilityModifier() {
        return this.visibility;
    }

    public void setLegend(DisplayPositioned legend) {
        this.checkGroup();
        this.legend = legend;
    }

    public DisplayPositioned getLegend() {
        return this.legend;
    }

    public String getCodeLine() {
        if (this.codeLine == null) {
            return null;
        }
        return "" + this.codeLine.getPosition();
    }

    public void setCodeLine(LineLocation codeLine) {
        this.codeLine = codeLine;
    }

    public void setStereostyle(String stereo) {
        this.stereostyles = Stereostyles.build(stereo);
    }

    public Stereostyles getStereostyles() {
        return this.stereostyles;
    }

    public void addKal(Kal kal) {
        Direction position = kal.getPosition();
        List<Kal> list = this.kals.get((Object)position);
        if (list == null) {
            list = new ArrayList<Kal>();
            this.kals.put(position, list);
        }
        list.add(kal);
    }

    public List<Kal> getKals(Direction position) {
        List<Kal> result = this.kals.get((Object)position);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    public ICucaDiagram getDiagram() {
        return this.entityFactory.getDiagram();
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public TextBlock getStateHeader(ISkinParam skinParam) {
        this.checkGroup();
        Style style = EntityImageStateCommon.getStyleStateHeader(this, skinParam);
        List<CharSequence> details = this.getBodier().getRawBody();
        if (details.size() == 0) {
            return new TextBlockEmpty();
        }
        if (style == null) {
            throw new IllegalArgumentException();
        }
        FontConfiguration fontConfiguration = FontConfiguration.create(skinParam, style);
        Display display = null;
        for (CharSequence s : details) {
            if (display == null) {
                display = Display.getWithNewlines(s.toString());
                continue;
            }
            display = display.addAll(Display.getWithNewlines(s.toString()));
        }
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
    }

    public void setTogether(Together together) {
        this.together = together;
    }

    public Together getTogether() {
        return this.together;
    }

    public Entity getParentContainer() {
        if (this.quark.isRoot()) {
            return null;
        }
        return this.quark.getParent().getData();
    }

    public Collection<Entity> leafs() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> child : this.quark.getChildren()) {
            Entity data = child.getData();
            if (data == null || data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<Entity> groups() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> child : this.quark.getChildren()) {
            Entity data = child.getData();
            if (data == null || !data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public int countChildren() {
        return this.getQuark().countChildren();
    }

    public boolean isRoot() {
        return this.getQuark().isRoot();
    }

    public final boolean isEmpty() {
        return this.countChildren() == 0;
    }

    public String getName() {
        return this.getQuark().getName();
    }

    public boolean isAutarkic() {
        if (this.getGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (this.getGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (this.getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (this.getGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        for (Link link : this.entityFactory.getLinks()) {
            if (EntityUtils.isPureInnerLink3(this, link)) continue;
            return false;
        }
        for (Entity leaf : this.leafs()) {
            if (leaf.getEntityPosition() == EntityPosition.NORMAL) continue;
            return false;
        }
        return true;
    }
}

