/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class FtileCircleSpot
extends AbstractFtile {
    private static final int SIZE = 20;
    private final Swimlane swimlane;
    private final String spot;
    private final FontConfiguration fc;
    private final HColor backColor;
    private final Style style;

    public FtileCircleSpot(ISkinParam skinParam, Swimlane swimlane, String spot, UFont font, HColor backColor, Style style) {
        super(skinParam);
        this.style = style;
        this.spot = spot;
        this.swimlane = swimlane;
        this.backColor = backColor;
        this.fc = FontConfiguration.create(skinParam, FontParam.ACTIVITY, null);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(20.0, 20.0);
        HColor backColor = this.backColor == null ? this.style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet()) : this.backColor;
        HColor borderColor = this.style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        double shadow = this.style.value(PName.Shadowing).asDouble();
        circle.setDeltaShadow(shadow);
        ug.apply(borderColor).apply(backColor.bg()).apply(this.getThickness(this.style)).draw(circle);
        ug.apply(this.fc.getColor()).apply(new UTranslate(10.0, 10.0)).draw(new UCenteredCharacter(this.spot.charAt(0), this.fc.getFont()));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0, 20.0);
    }
}

