/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;

public class TimeHeaderWeekly
extends TimeHeaderCalendar {
    private final WeekNumberStrategy weekNumberStrategy;
    private final boolean withCalendarDate;

    @Override
    public double getTimeHeaderHeight() {
        return 29.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 16.0;
    }

    public TimeHeaderWeekly(TimeHeaderParameters thParam, WeekNumberStrategy weekNumberStrategy, boolean withCalendarDate) {
        super(thParam, new TimeScaleCompressed(thParam.getStartingDay(), thParam.getScale()));
        this.weekNumberStrategy = weekNumberStrategy;
        this.withCalendarDate = withCalendarDate;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawCalendar(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.Y_POS_ROW16());
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawHline(ug, 0.0);
        this.printMonths(ug);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawCalendar(UGraphic ug, double totalHeightWithoutFooter) {
        this.printDaysOfMonth(ug);
        this.printSmallVbars(ug, totalHeightWithoutFooter);
        this.printMonths(ug);
    }

    private void printMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVbar(ug, x1, 0.0, this.Y_POS_ROW16(), false);
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, this.Y_POS_ROW16(), false);
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printSmallVbars(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), this.Y_POS_ROW16(), totalHeightWithoutFooter, false);
            }
            wink = wink.increment();
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), this.Y_POS_ROW16(), totalHeightWithoutFooter, false);
    }

    private void printDaysOfMonth(UGraphic ug) {
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                String num = this.withCalendarDate ? "" + wink.getDayOfMonth() : "" + wink.getWeekOfYear(this.weekNumberStrategy);
                TextBlock textBlock = this.getTextBlock(num, 10, false, this.openFontColor());
                this.printLeft(ug.apply(UTranslate.dy(this.Y_POS_ROW16())), textBlock, this.getTimeScale().getStartingPosition(wink) + 5.0);
            }
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(monthYear.shortName(this.locale()), 12, true, this.openFontColor());
        TextBlock big = this.getTextBlock(monthYear.shortNameYYYY(this.locale()), 12, true, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

