/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

class CircleAndArrow
implements UDrawable {
    private final AffineTransform at;
    private final AffineTransform at2;
    private int radius;
    private final XPoint2D center;
    private final XPoint2D p1;
    private final XPoint2D p2;
    private XPoint2D p3;
    private XPoint2D p4;

    public CircleAndArrow(XPoint2D p1, XPoint2D p2) {
        this.center = new XPoint2D((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        this.at = AffineTransform.getTranslateInstance(-this.center.getX(), -this.center.getY());
        this.at2 = AffineTransform.getTranslateInstance(this.center.getX(), this.center.getY());
        this.radius = (int)(p1.distance(p2) / 2.0);
        if (this.radius % 2 == 0) {
            --this.radius;
        }
        this.p1 = this.putOnCircle(p1);
        this.p2 = this.putOnCircle(p2);
        this.p3 = this.p1.transform(this.at);
        this.p3 = new XPoint2D(this.p3.getY(), -this.p3.getX());
        this.p3 = this.p3.transform(this.at2);
        this.p4 = this.p2.transform(this.at);
        this.p4 = new XPoint2D(this.p4.getY(), -this.p4.getX());
        this.p4 = this.p4.transform(this.at2);
    }

    private XPoint2D putOnCircle(XPoint2D p) {
        p = p.transform(this.at);
        double coef = p.distance(new XPoint2D()) / (double)this.radius;
        p = new XPoint2D(p.getX() / coef, p.getY() / coef);
        return p.transform(this.at2);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(this.radius * 2, this.radius * 2);
        ug.apply(new UTranslate(this.center.getX() - (double)this.radius, this.center.getY() - (double)this.radius)).draw(circle);
    }
}

