/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;

public class EntityImageStateBorder
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImageStateBorder(Entity leaf, ISkinParam skinParam, Cluster stateParent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, stateParent, bibliotekon, FontParam.STATE);
        this.sname = sname;
    }

    @Override
    protected StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname);
    }

    private boolean upPosition() {
        if (this.parent == null) {
            return false;
        }
        XPoint2D clusterCenter = this.parent.getRectangleArea().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public final void drawU(UGraphic ug) {
        TextBlock desc = this.getDesc();
        double y = 0.0;
        XDimension2D dimDesc = desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        desc.drawU(ug.apply(new UTranslate(x, y)));
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(this.getUStroke()).apply(borderColor);
        ug = ug.apply(backcolor.bg());
        this.entityPosition.drawSymbol(ug, this.rankdir);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        TextBlock desc = this.getDesc();
        XDimension2D dimDesc = desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }
}

