/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItemMultiline
extends CommandMultilines2<WBSDiagram> {
    public CommandWBSItemMultiline() {
        super(CommandWBSItemMultiline.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSItemMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf(":"), new RegexLeaf("DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);(?:\\s*\\<\\<(.+)\\>\\>)?$";
    }

    static IRegex getRegexConcatOld() {
        return RegexConcat.build(CommandWBSItemMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(WBSDiagram diagram, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getString());
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 1);
        String stereotype = lineLast.get(1);
        if (stereotype != null) {
            lines = lines.overrideLastLine(lineLast.get(0));
        }
        String type = line0.get("TYPE", 0);
        String stringColor = line0.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = Direction.RIGHT;
        return diagram.addIdea(null, backColor, diagram.getSmartLevel(type), lines.toDisplay(), stereotype, dir, IdeaShape.fromDesc(line0.get("SHAPE", 0)));
    }
}

