/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandFactoryNoteOnEntity
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;
    private final String key;

    public CommandFactoryNoteOnEntity(String key, IRegex partialPattern) {
        this.partialPattern = partialPattern;
        this.key = key;
    }

    private IRegex getRegexConcatSingleLine(IRegex partialPattern) {
        return RegexConcat.build(CommandFactoryNoteOnEntity.class.getName() + this.key + "single", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern), new RegexLeaf("")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), CommandFactoryNoteOnEntity.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private IRegex getRegexConcatMultiLine(IRegex partialPattern, boolean withBracket) {
        if (withBracket) {
            return RegexConcat.build(CommandFactoryNoteOnEntity.class.getName() + this.key + "multi" + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern), new RegexLeaf("")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), CommandFactoryNoteOnEntity.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandFactoryNoteOnEntity.class.getName() + this.key + "multi" + withBracket, RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), partialPattern), new RegexLeaf("")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), CommandFactoryNoteOnEntity.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram system, LineLocation location, RegexResult arg) throws NoSuchColorException {
                String s = arg.get("NOTE", 0);
                return CommandFactoryNoteOnEntity.this.executeInternal(arg, system, null, BlocLines.getWithNewlines(s));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern, withBracket), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                if (withBracket) {
                    return "^(\\})$";
                }
                return "^[%s]*(end[%s]?note)$";
            }

            @Override
            protected CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Url url = null;
                if (line0.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                    url = urlBuilder.getUrl(line0.get("URL", 0));
                }
                return CommandFactoryNoteOnEntity.this.executeInternal(line0, system, url, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult line0, AbstractEntityDiagram diagram, Url url, BlocLines strings) throws NoSuchColorException {
        Link link;
        IEntity cl1;
        String pos = line0.get("POSITION", 0);
        String idShort = line0.get("ENTITY", 0);
        if (idShort == null) {
            cl1 = diagram.getLastEntity();
            if (cl1 == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            Ident ident = diagram.buildLeafIdent(idShort);
            Code code = diagram.buildCode(idShort);
            cl1 = diagram.isGroup(code) ? diagram.getGroup(code) : diagram.getOrCreateLeaf(ident, code, null, null);
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(pos)).withRankdir(diagram.getSkinParam().getRankdir());
        Colors colors = CommandFactoryNoteOnEntity.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
            colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
        }
        if (diagram.getPragma().useKermor() && cl1.isGroup()) {
            cl1.addNote(strings.toDisplay(), position, colors);
            return CommandExecutionResult.ok();
        }
        String tmp = diagram.getUniqueSequence("GMN");
        Ident idNewLong = diagram.buildLeafIdent(tmp);
        ILeaf note = diagram.createLeaf(idNewLong, diagram.buildCode(tmp), strings.toDisplay(), LeafType.NOTE, null);
        if (stereotypeString != null) {
            note.setStereotype(stereotype);
        }
        note.setColors(colors);
        if (url != null) {
            note.addUrl(url);
        }
        CommandCreateClassMultilines.addTags(note, line0.getLazzy("TAGS", 0));
        LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).goDashed();
        if (position == Position.RIGHT) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, note, type, LinkArg.noDisplay(1));
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), note, cl1, type, LinkArg.noDisplay(1));
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, note, type, LinkArg.noDisplay(2));
        } else if (position == Position.TOP) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), note, cl1, type, LinkArg.noDisplay(2));
        } else {
            throw new IllegalArgumentException();
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

