/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.Splitter;

public class CommandCreoleEmoji
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(" + Splitter.emojiPattern + ")");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleEmoji() {
    }

    public static Command create() {
        return new CommandCreoleEmoji();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String color = m.group(2);
        String emoji = m.group(3);
        stripe.addEmoji(emoji, color);
        return line.substring(m.group(1).length());
    }
}

