/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.AbstractImageHandlerGraphics2D;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class PDFImageHandlerGraphics2D
extends AbstractImageHandlerGraphics2D {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D};

    @Override
    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PDFRenderingContext pdfContext = (PDFRenderingContext)context;
        PDFContentGenerator generator = pdfContext.getGenerator();
        ImageGraphics2D imageG2D = (ImageGraphics2D)image;
        float fwidth = (float)pos.width / 1000.0f;
        float fheight = (float)pos.height / 1000.0f;
        float fx = (float)pos.x / 1000.0f;
        float fy = (float)pos.y / 1000.0f;
        Dimension dim = image.getInfo().getSize().getDimensionMpt();
        float imw = (float)dim.getWidth() / 1000.0f;
        float imh = (float)dim.getHeight() / 1000.0f;
        float sx = fwidth / imw;
        float sy = fheight / imh;
        generator.comment("G2D start");
        boolean accessibilityEnabled = context.getUserAgent().isAccessibilityEnabled();
        if (accessibilityEnabled) {
            PDFLogicalStructureHandler.MarkedContentInfo mci = pdfContext.getMarkedContentInfo();
            generator.saveGraphicsState(mci.tag, mci.mcid);
        } else {
            generator.saveGraphicsState();
        }
        generator.updateColor(Color.black, false, null);
        generator.updateColor(Color.black, true, null);
        generator.add(sx + " 0 0 " + sy + " " + fx + " " + fy + " cm\n");
        boolean textAsShapes = false;
        PDFGraphics2D graphics = new PDFGraphics2D(false, pdfContext.getFontInfo(), generator.getDocument(), generator.getResourceContext(), pdfContext.getPage().makeReference(), "", 0.0f, null);
        graphics.setGraphicContext(new GraphicContext());
        AffineTransform transform = new AffineTransform();
        transform.translate(fx, fy);
        generator.getState().concatenate(transform);
        graphics.setPaintingState(generator.getState());
        graphics.setOutputStream(generator.getOutputStream());
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, imw, imh);
        imageG2D.getGraphics2DImagePainter().paint(graphics, area);
        generator.add(graphics.getString());
        if (accessibilityEnabled) {
            generator.restoreGraphicsStateAccess();
        } else {
            generator.restoreGraphicsState();
        }
        generator.comment("G2D end");
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, Image image) {
        String mode;
        boolean supported;
        boolean bl = supported = (image == null || image instanceof ImageGraphics2D) && targetContext instanceof PDFRenderingContext;
        if (supported && ImageHandlerUtil.isConversionModeBitmap(mode = (String)targetContext.getHint(ImageHandlerUtil.CONVERSION_MODE))) {
            return false;
        }
        return supported;
    }
}

