/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.SName;

class USymbolStack
extends USymbol {
    USymbolStack() {
    }

    @Override
    public SName getSName() {
        return SName.stack;
    }

    private void drawQueue(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        double border = 15.0;
        URectangle rect = new URectangle(width - 30.0, height).rounded(roundCorner);
        ug.apply(HColors.none()).apply(UTranslate.dx(15.0)).draw(rect);
        UPath path = new UPath();
        if (roundCorner == 0.0) {
            path.moveTo(0.0, 0.0);
            path.lineTo(15.0, 0.0);
            path.lineTo(15.0, height);
            path.lineTo(width - 15.0, height);
            path.lineTo(width - 15.0, 0.0);
            path.lineTo(width, 0.0);
        } else {
            path.moveTo(0.0, 0.0);
            path.lineTo(15.0 - roundCorner / 2.0, 0.0);
            path.arcTo(new XPoint2D(15.0, roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(15.0, height - roundCorner / 2.0);
            path.arcTo(new XPoint2D(15.0 + roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - 15.0 - roundCorner / 2.0, height);
            path.arcTo(new XPoint2D(width - 15.0, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - 15.0, roundCorner / 2.0);
            path.arcTo(new XPoint2D(width - 15.0 + roundCorner / 2.0, 0.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(width, 0.0);
        }
        path.setDeltaShadow(shadowing);
        ug.apply(HColors.none().bg()).draw(path);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(25.0, 25.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolStack.this.drawQueue(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolStack.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolStack.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolStack.this.drawQueue(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 13.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 13.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

