/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;

public final class InnerActivity
extends AbstractTextBlock
implements IEntityImage {
    private final IEntityImage im;
    private final HColor borderColor;
    private final double shadowing;
    private final HColor backColor;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerActivity(IEntityImage im, HColor borderColor, HColor backColor, double shadowing) {
        this.im = im;
        this.backColor = backColor;
        this.borderColor = borderColor;
        this.shadowing = shadowing;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D total = this.calculateDimension(ug.getStringBounder());
        ug = ug.apply(this.backColor.bg()).apply(this.borderColor).apply(new UStroke(1.5));
        URectangle rect = new URectangle(total.getWidth(), total.getHeight()).rounded(25.0);
        rect.setDeltaShadow(this.shadowing);
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        this.im.drawU(ug);
    }

    @Override
    public HColor getBackcolor() {
        return this.im.getBackcolor();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D img = this.im.calculateDimension(stringBounder);
        return img;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

