/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.extensions.prepress.PageBoundaries;
import org.apache.fop.render.extensions.prepress.PageScale;
import org.apache.fop.render.java2d.Base14FontCollection;
import org.apache.fop.render.java2d.ConfiguredFontCollection;
import org.apache.fop.render.java2d.InstalledFontCollection;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.java2d.Java2DGraphics2DAdapter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRendererOption;
import org.apache.fop.render.java2d.Java2DUtil;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public abstract class Java2DRenderer
extends AbstractPathOrientedRenderer
implements Printable {
    protected double scaleFactor = 1.0;
    protected int pageWidth;
    protected int pageHeight;
    protected List pageViewportList = new ArrayList();
    private int currentPageNumber;
    protected boolean antialiasing = true;
    protected boolean qualityRendering = true;
    protected boolean transparentPageBackground;
    protected Java2DGraphicsState state;
    private final Stack stateStack = new Stack();
    private boolean renderingDone;
    private GeneralPath currentPath;
    private static final ImageFlavor[] FLAVOURS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D, ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE, ImageFlavor.XML_DOM};

    public Java2DRenderer(FOUserAgent userAgent) {
        super(userAgent);
        userAgent.setRendererOverride(this);
        String s = (String)userAgent.getRendererOption(Java2DRendererOption.JAVA2D_TRANSPARENT_PAGE_BACKGROUND);
        if (s != null) {
            this.transparentPageBackground = "true".equalsIgnoreCase(s);
        }
    }

    @Override
    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        Java2DFontMetrics java2DFontMetrics = new Java2DFontMetrics();
        FontManager fontManager = this.userAgent.getFontManager();
        FontCollection[] fontCollections = new FontCollection[]{new Base14FontCollection(java2DFontMetrics), new InstalledFontCollection(java2DFontMetrics), new ConfiguredFontCollection(fontManager.getResourceResolver(), this.getFontList(), this.userAgent.isComplexScriptFeaturesEnabled())};
        fontManager.setup(this.getFontInfo(), fontCollections);
    }

    @Override
    public Graphics2DAdapter getGraphics2DAdapter() {
        return new Java2DGraphics2DAdapter();
    }

    public void setScaleFactor(double newScaleFactor) {
        this.scaleFactor = newScaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void startRenderer(OutputStream out) throws IOException {
        super.startRenderer(out);
    }

    @Override
    public void stopRenderer() throws IOException {
        log.debug("Java2DRenderer stopped");
        this.renderingDone = true;
        int numberOfPages = this.currentPageNumber;
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(int c) {
        this.currentPageNumber = c;
    }

    public int getNumberOfPages() {
        return this.pageViewportList.size();
    }

    public void clearViewportList() {
        this.pageViewportList.clear();
        this.setCurrentPageNumber(0);
    }

    @Override
    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        try {
            this.rememberPage((PageViewport)pageViewport.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new FOPException(e);
        }
        ++this.currentPageNumber;
    }

    protected void rememberPage(PageViewport pageViewport) {
        assert (pageViewport.getPageIndex() >= 0);
        this.pageViewportList.add(pageViewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getPageImage(PageViewport pageViewport) {
        this.currentPageViewport = pageViewport;
        try {
            PageBoundaries boundaries = new PageBoundaries(pageViewport.getViewArea().getSize(), pageViewport.getForeignAttributes());
            Rectangle bounds = boundaries.getCropBox();
            Rectangle bleedBox = boundaries.getBleedBox();
            this.pageWidth = (int)Math.round(bounds.getWidth() / 1000.0);
            this.pageHeight = (int)Math.round(bounds.getHeight() / 1000.0);
            log.info("Rendering Page " + pageViewport.getPageNumberString() + " (pageWidth " + this.pageWidth + ", pageHeight " + this.pageHeight + ")");
            double scaleX = this.scaleFactor;
            double scaleY = this.scaleFactor;
            String scale = this.currentPageViewport.getForeignAttributes().get(PageScale.EXT_PAGE_SCALE);
            Point2D scales = PageScale.getScale(scale);
            if (scales != null) {
                scaleX *= scales.getX();
                scaleY *= scales.getY();
            }
            scaleX = scaleX * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            scaleY = scaleY * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            int bitmapWidth = (int)((double)this.pageWidth * scaleX + 0.5);
            int bitmapHeight = (int)((double)this.pageHeight * scaleY + 0.5);
            BufferedImage currentPageImage = this.getBufferedImage(bitmapWidth, bitmapHeight);
            Graphics2D graphics = currentPageImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (this.antialiasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.qualityRendering) {
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            AffineTransform at = graphics.getTransform();
            at.scale(scaleX, scaleY);
            at.translate(bounds.getMinX() / -1000.0, bounds.getMinY() / -1000.0);
            graphics.setTransform(at);
            if (!this.transparentPageBackground) {
                graphics.setColor(Color.white);
                graphics.fillRect((int)Math.round(bleedBox.getMinX() / 1000.0), (int)Math.round(bleedBox.getMinY() / 1000.0), (int)Math.round(bleedBox.getWidth() / 1000.0), (int)Math.round(bleedBox.getHeight() / 1000.0));
            }
            this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
            try {
                this.currentBPPosition = 0;
                this.currentIPPosition = 0;
                this.renderPageAreas(pageViewport.getPage());
            }
            finally {
                this.state = null;
            }
            BufferedImage bufferedImage = currentPageImage;
            return bufferedImage;
        }
        finally {
            this.currentPageViewport = null;
        }
    }

    protected BufferedImage getBufferedImage(int bitmapWidth, int bitmapHeight) {
        return new BufferedImage(bitmapWidth, bitmapHeight, 2);
    }

    public PageViewport getPageViewport(int pageIndex) throws FOPException {
        if (pageIndex < 0 || pageIndex >= this.pageViewportList.size()) {
            throw new FOPException("Requested page number is out of range: " + pageIndex + "; only " + this.pageViewportList.size() + " page(s) available.");
        }
        return (PageViewport)this.pageViewportList.get(pageIndex);
    }

    public BufferedImage getPageImage(int pageNum) throws FOPException {
        return this.getPageImage(this.getPageViewport(pageNum));
    }

    @Override
    protected void saveGraphicsState() {
        this.stateStack.push(this.state);
        this.state = new Java2DGraphicsState(this.state);
    }

    @Override
    protected void restoreGraphicsState() {
        this.state.dispose();
        this.state = (Java2DGraphicsState)this.stateStack.pop();
    }

    @Override
    protected void concatenateTransformationMatrix(AffineTransform at) {
        this.state.transform(at);
    }

    @Override
    protected void startVParea(CTM ctm, Rectangle clippingRect) {
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        this.state.transform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
    }

    @Override
    protected void endVParea() {
        this.restoreGraphicsState();
    }

    @Override
    protected void startLayer(String layer) {
    }

    @Override
    protected void endLayer() {
    }

    @Override
    protected List breakOutOfStateStack() {
        log.debug("Block.FIXED --> break out");
        ArrayList<Java2DGraphicsState> breakOutList = new ArrayList<Java2DGraphicsState>();
        while (!this.stateStack.isEmpty()) {
            breakOutList.add(0, this.state);
            this.state = (Java2DGraphicsState)this.stateStack.pop();
        }
        return breakOutList;
    }

    @Override
    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        log.debug("Block.FIXED --> restoring context after break-out");
        for (Object aBreakOutList : breakOutList) {
            Java2DGraphicsState s = (Java2DGraphicsState)aBreakOutList;
            this.stateStack.push(this.state);
            this.state = s;
        }
    }

    @Override
    protected void updateColor(Color col, boolean fill) {
        this.state.updateColor(col);
    }

    @Override
    protected void clip() {
        if (this.currentPath == null) {
            throw new IllegalStateException("No current path available!");
        }
        this.state.updateClip(this.currentPath);
        this.currentPath = null;
    }

    @Override
    protected void closePath() {
        this.currentPath.closePath();
    }

    @Override
    protected void lineTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.lineTo(x, y);
    }

    @Override
    protected void moveTo(float x, float y) {
        if (this.currentPath == null) {
            this.currentPath = new GeneralPath();
        }
        this.currentPath.moveTo(x, y);
    }

    @Override
    protected void clipRect(float x, float y, float width, float height) {
        this.state.updateClip(new Rectangle2D.Float(x, y, width, height));
    }

    @Override
    protected void fillRect(float x, float y, float width, float height) {
        this.state.getGraph().fill(new Rectangle2D.Float(x, y, width, height));
    }

    @Override
    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        Graphics2D g2d = this.state.getGraph();
        float width = x2 - x1;
        float height = y2 - y1;
        Java2DRenderer.drawBorderLine(new Rectangle2D.Float(x1, y1, width, height), horz, startOrBefore, style, col, g2d);
    }

    public static void drawBorderLine(Rectangle2D.Float lineRect, boolean horz, boolean startOrBefore, int style, Color col, Graphics2D g2d) {
        float x1 = lineRect.x;
        float y1 = lineRect.y;
        float x2 = x1 + lineRect.width;
        float y2 = y1 + lineRect.height;
        float w = lineRect.width;
        float h = lineRect.height;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                g2d.setColor(col);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 0, 0, 10.0f, new float[]{unit}, 0.0f);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 36: {
                g2d.setColor(col);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    float ym = y1 + h / 2.0f;
                    BasicStroke s = new BasicStroke(h, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                float xm = x1 + w / 2.0f;
                BasicStroke s = new BasicStroke(w, 1, 0, 10.0f, new float[]{0.0f, unit}, 0.0f);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
                break;
            }
            case 37: {
                g2d.setColor(col);
                if (horz) {
                    float h3 = h / 3.0f;
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    BasicStroke s = new BasicStroke(h3);
                    g2d.setStroke(s);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    g2d.draw(new Line2D.Float(x1, ym2, x2, ym2));
                    break;
                }
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                BasicStroke s = new BasicStroke(w3);
                g2d.setStroke(s);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                g2d.draw(new Line2D.Float(xm2, y1, xm2, y2));
                break;
            }
            case 55: 
            case 119: {
                float colFactor;
                float f = colFactor = style == 55 ? 0.4f : -0.4f;
                if (horz) {
                    Color uppercol = ColorUtil.lightenColor(col, -colFactor);
                    Color lowercol = ColorUtil.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    float ym1 = y1 + h3 / 2.0f;
                    g2d.setStroke(new BasicStroke(h3));
                    g2d.setColor(uppercol);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    g2d.setColor(col);
                    g2d.draw(new Line2D.Float(x1, ym1 + h3, x2, ym1 + h3));
                    g2d.setColor(lowercol);
                    g2d.draw(new Line2D.Float(x1, ym1 + h3 + h3, x2, ym1 + h3 + h3));
                    break;
                }
                Color leftcol = ColorUtil.lightenColor(col, -colFactor);
                Color rightcol = ColorUtil.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                g2d.setStroke(new BasicStroke(w3));
                g2d.setColor(leftcol);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                g2d.setColor(col);
                g2d.draw(new Line2D.Float(xm1 + w3, y1, xm1 + w3, y2));
                g2d.setColor(rightcol);
                g2d.draw(new Line2D.Float(xm1 + w3 + w3, y1, xm1 + w3 + w3, y2));
                break;
            }
            case 67: 
            case 101: {
                float colFactor;
                float f = colFactor = style == 101 ? 0.4f : -0.4f;
                if (horz) {
                    col = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                    g2d.setStroke(new BasicStroke(h));
                    float ym1 = y1 + h / 2.0f;
                    g2d.setColor(col);
                    g2d.draw(new Line2D.Float(x1, ym1, x2, ym1));
                    break;
                }
                col = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                float xm1 = x1 + w / 2.0f;
                g2d.setStroke(new BasicStroke(w));
                g2d.setColor(col);
                g2d.draw(new Line2D.Float(xm1, y1, xm1, y2));
                break;
            }
            case 57: {
                break;
            }
            default: {
                g2d.setColor(col);
                if (horz) {
                    float ym = y1 + h / 2.0f;
                    g2d.setStroke(new BasicStroke(h));
                    g2d.draw(new Line2D.Float(x1, ym, x2, ym));
                    break;
                }
                float xm = x1 + w / 2.0f;
                g2d.setStroke(new BasicStroke(w));
                g2d.draw(new Line2D.Float(xm, y1, xm, y2));
            }
        }
    }

    @Override
    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getBlockProgressionOffset() + text.getBaselineOffset();
        int saveIP = this.currentIPPosition;
        Font font = this.getFontFromArea(text);
        this.state.updateFont(font.getFontName(), font.getFontSize());
        this.saveGraphicsState();
        AffineTransform at = new AffineTransform();
        at.translate((float)rx / 1000.0f, (float)bl / 1000.0f);
        this.state.transform(at);
        Java2DRenderer.renderText(text, this.state.getGraph(), font, this.fontInfo);
        this.restoreGraphicsState();
        this.currentIPPosition = saveIP + text.getAllocIPD();
        Typeface tf = this.fontInfo.getFonts().get(font.getFontName());
        int fontsize = text.getTraitAsInteger(Trait.FONT_SIZE);
        this.renderTextDecoration(tf, fontsize, text, bl, rx);
    }

    public static void renderText(TextArea text, Graphics2D g2d, Font font, FontInfo fontInfo) {
        Color col = (Color)text.getTrait(Trait.COLOR);
        g2d.setColor(col);
        float textCursor = 0.0f;
        for (InlineArea child : text.getChildAreas()) {
            String s;
            if (child instanceof WordArea) {
                WordArea word = (WordArea)child;
                s = word.getWord();
                int[] letterAdjust = word.getLetterAdjustArray();
                GlyphVector gv = Java2DUtil.createGlyphVector(s, g2d, font, fontInfo);
                double additionalWidth = 0.0;
                if (letterAdjust != null || text.getTextLetterSpaceAdjust() != 0 || text.getTextWordSpaceAdjust() != 0) {
                    int[] offsets = Java2DRenderer.getGlyphOffsets(s, font, text, letterAdjust);
                    float cursor = 0.0f;
                    if (offsets.length != gv.getNumGlyphs()) {
                        log.error(String.format("offsets length different from glyphNumber: %d != %d", offsets.length, gv.getNumGlyphs()));
                    }
                    for (int i = 0; i < Math.min(offsets.length, gv.getNumGlyphs()); ++i) {
                        Point2D pt = gv.getGlyphPosition(i);
                        pt.setLocation(cursor, pt.getY());
                        gv.setGlyphPosition(i, pt);
                        cursor += (float)offsets[i] / 1000.0f;
                    }
                    additionalWidth = (double)cursor - gv.getLogicalBounds().getWidth();
                }
                g2d.drawGlyphVector(gv, textCursor, 0.0f);
                textCursor = (float)((double)textCursor + (gv.getLogicalBounds().getWidth() + additionalWidth));
                continue;
            }
            if (child instanceof SpaceArea) {
                SpaceArea space = (SpaceArea)child;
                s = space.getSpace();
                char sp = s.charAt(0);
                int tws = space.isAdjustable() ? text.getTextWordSpaceAdjust() + 2 * text.getTextLetterSpaceAdjust() : 0;
                textCursor += (float)(font.getCharWidth(sp) + tws) / 1000.0f;
                continue;
            }
            throw new IllegalStateException("Unsupported child element: " + child);
        }
    }

    private static int[] getGlyphOffsets(String s, Font font, TextArea text, int[] letterAdjust) {
        int textLen = s.codePointCount(0, s.length());
        int[] offsets = new int[textLen];
        for (int i = 0; i < textLen; ++i) {
            int c = s.codePointAt(i);
            int mapped = font.mapCodePoint(c);
            int wordSpace = CharUtilities.isAdjustableSpace(mapped) ? text.getTextWordSpaceAdjust() : 0;
            int cw = font.getWidth(mapped);
            int ladj = letterAdjust != null && i < textLen - 1 ? letterAdjust[i + 1] : 0;
            int tls = i < textLen - 1 ? text.getTextLetterSpaceAdjust() : 0;
            offsets[i] = cw + ladj + tls + wordSpace;
        }
        return offsets;
    }

    @Override
    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getBlockProgressionOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        this.state.updateColor(col);
        Line2D.Float line = new Line2D.Float();
        ((Line2D)line).setLine(startx, starty, endx, starty);
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        int style = area.getRuleStyle();
        switch (style) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 36: {
                this.state.updateStroke(ruleThickness, style);
                float rt2 = ruleThickness / 2.0f;
                ((Line2D)line).setLine(((Line2D)line).getX1(), ((Line2D)line).getY1() + (double)rt2, ((Line2D)line).getX2(), ((Line2D)line).getY2() + (double)rt2);
                this.state.getGraph().draw(line);
                break;
            }
            case 55: 
            case 119: {
                float half = (float)area.getRuleThickness() / 2000.0f;
                this.state.updateColor(ColorUtil.lightenColor(col, 0.6f));
                this.moveTo(startx, starty);
                this.lineTo(endx, starty);
                this.lineTo(endx, starty + 2.0f * half);
                this.lineTo(startx, starty + 2.0f * half);
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
                this.state.updateColor(col);
                if (style == 55) {
                    this.moveTo(startx, starty);
                    this.lineTo(endx, starty);
                    this.lineTo(endx, starty + half);
                    this.lineTo(startx + half, starty + half);
                    this.lineTo(startx, starty + 2.0f * half);
                } else {
                    this.moveTo(endx, starty);
                    this.lineTo(endx, starty + 2.0f * half);
                    this.lineTo(startx, starty + 2.0f * half);
                    this.lineTo(startx, starty + half);
                    this.lineTo(endx - half, starty + half);
                }
                this.closePath();
                this.state.getGraph().fill(this.currentPath);
                this.currentPath = null;
                break;
            }
            case 95: {
                break;
            }
        }
        super.renderLeader(area);
    }

    @Override
    public void renderImage(Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.drawImage(url, pos);
    }

    @Override
    protected void drawImage(String uri, Rectangle2D pos, Map foreignAttributes) {
        int x = this.currentIPPosition + (int)Math.round(pos.getX());
        int y = this.currentBPPosition + (int)Math.round(pos.getY());
        uri = URISpecification.getURL(uri);
        ImageManager manager = this.getUserAgent().getImageManager();
        ImageInfo info = null;
        try {
            ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
            info = manager.getImageInfo(uri, sessionContext);
            Map hints = ImageUtil.getDefaultHints(sessionContext);
            org.apache.xmlgraphics.image.loader.Image img = manager.getImage(info, FLAVOURS, hints, sessionContext);
            if (img instanceof ImageGraphics2D) {
                ImageGraphics2D imageG2D = (ImageGraphics2D)img;
                int width = (int)pos.getWidth();
                int height = (int)pos.getHeight();
                RendererContext context = this.createRendererContext(x, y, width, height, foreignAttributes);
                this.getGraphics2DAdapter().paintImage(imageG2D.getGraphics2DImagePainter(), context, x, y, width, height);
            } else if (img instanceof ImageRendered) {
                ImageRendered imgRend = (ImageRendered)img;
                AffineTransform at = new AffineTransform();
                at.translate((float)x / 1000.0f, (float)y / 1000.0f);
                double sx = pos.getWidth() / (double)info.getSize().getWidthMpt();
                double sy = pos.getHeight() / (double)info.getSize().getHeightMpt();
                at.scale(sx *= (double)this.userAgent.getSourceResolution() / info.getSize().getDpiHorizontal(), sy *= (double)this.userAgent.getSourceResolution() / info.getSize().getDpiVertical());
                this.state.getGraph().drawRenderedImage(imgRend.getRenderedImage(), at);
            } else if (img instanceof ImageXMLDOM) {
                ImageXMLDOM imgXML = (ImageXMLDOM)img;
                this.renderDocument(imgXML.getDocument(), imgXML.getRootNamespace(), pos, foreignAttributes);
            }
        }
        catch (ImageException ie) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageError(this, info != null ? info.toString() : uri, ie, null);
        }
        catch (FileNotFoundException fe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageNotFound(this, info != null ? info.toString() : uri, fe, null);
        }
        catch (IOException ioe) {
            ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            eventProducer.imageIOError(this, info != null ? info.toString() : uri, ioe, null);
        }
    }

    @Override
    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("state", this.state);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        if (this.state != null) {
            throw new IllegalStateException("state must be null");
        }
        Graphics2D graphics = (Graphics2D)g;
        try {
            PageViewport viewport = this.getPageViewport(pageIndex);
            AffineTransform at = graphics.getTransform();
            this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            super.renderPage(viewport);
            int n = 0;
            return n;
        }
        catch (FOPException e) {
            log.error(e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            log.error(e);
            int n = 1;
            return n;
        }
        finally {
            this.state = null;
        }
    }

    @Override
    protected void beginTextObject() {
    }

    @Override
    protected void endTextObject() {
    }

    public void setTransparentPageBackground(boolean transparentPageBackground) {
        this.transparentPageBackground = transparentPageBackground;
    }
}

