/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public abstract class AbstractLayoutManager
extends AbstractBaseLayoutManager
implements Constants {
    private static Log log = LogFactory.getLog(AbstractLayoutManager.class);
    protected LayoutManager parentLayoutManager;
    protected List<LayoutManager> childLMs;
    protected ListIterator fobjIter;
    private Map<String, Marker> markers;
    private boolean isFinished;
    protected LayoutManager curChildLM;
    protected ListIterator<LayoutManager> childLMiter;
    private int lastGeneratedPosition = -1;
    private int smallestPosNumberChecked = Integer.MAX_VALUE;
    private boolean preserveChildrenAtEndOfLayout;

    public AbstractLayoutManager() {
    }

    public AbstractLayoutManager(FObj fo) {
        super(fo);
        this.markers = fo.getMarkers();
        this.fobjIter = fo.getChildNodes();
        this.childLMiter = new LMiter(this);
    }

    @Override
    public void setParent(LayoutManager lm) {
        this.parentLayoutManager = lm;
    }

    @Override
    public LayoutManager getParent() {
        return this.parentLayoutManager;
    }

    @Override
    public void initialize() {
    }

    protected LayoutManager getChildLM() {
        if (this.curChildLM != null && !this.curChildLM.isFinished()) {
            return this.curChildLM;
        }
        if (this.childLMiter.hasNext()) {
            this.curChildLM = this.childLMiter.next();
            this.curChildLM.initialize();
            return this.curChildLM;
        }
        return null;
    }

    protected void setCurrentChildLM(LayoutManager childLM) {
        this.curChildLM = childLM;
        this.childLMiter = new LMiter(this);
        do {
            this.curChildLM = this.childLMiter.next();
        } while (this.curChildLM != childLM);
    }

    protected boolean hasNextChildLM() {
        return this.childLMiter.hasNext();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean fin) {
        this.isFinished = fin;
    }

    @Override
    public void addAreas(PositionIterator posIter, LayoutContext context) {
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        log.warn("null implementation of getNextKnuthElements() called!");
        this.setFinished(true);
        return null;
    }

    @Override
    public List getChangedKnuthElements(List oldList, int alignment) {
        log.warn("null implementation of getChangeKnuthElement() called!");
        return null;
    }

    @Override
    public Area getParentArea(Area childArea) {
        return null;
    }

    @Override
    public void addChildArea(Area childArea) {
    }

    protected List<LayoutManager> createChildLMs(int size) {
        if (this.fobjIter == null) {
            return null;
        }
        ArrayList<LayoutManager> newLMs = new ArrayList<LayoutManager>(size);
        while (this.fobjIter.hasNext() && newLMs.size() < size) {
            Object theobj = this.fobjIter.next();
            if (!(theobj instanceof FONode)) continue;
            FONode foNode = (FONode)theobj;
            if (foNode instanceof RetrieveMarker) {
                foNode = this.getPSLM().resolveRetrieveMarker((RetrieveMarker)foNode);
            }
            if (foNode == null) continue;
            this.getPSLM().getLayoutManagerMaker().makeLayoutManagers(foNode, newLMs);
        }
        return newLMs;
    }

    @Override
    public PageSequenceLayoutManager getPSLM() {
        return this.parentLayoutManager.getPSLM();
    }

    public Page getCurrentPage() {
        return this.getPSLM().getCurrentPage();
    }

    public PageViewport getCurrentPV() {
        return this.getPSLM().getCurrentPage().getPageViewport();
    }

    @Override
    public boolean createNextChildLMs(int pos) {
        List<LayoutManager> newLMs = this.createChildLMs(pos + 1 - this.childLMs.size());
        this.addChildLMs(newLMs);
        return pos < this.childLMs.size();
    }

    @Override
    public List<LayoutManager> getChildLMs() {
        if (this.childLMs == null) {
            this.childLMs = new ArrayList<LayoutManager>(10);
        }
        return this.childLMs;
    }

    @Override
    public void addChildLM(LayoutManager lm) {
        if (lm == null) {
            return;
        }
        lm.setParent(this);
        if (this.childLMs == null) {
            this.childLMs = new ArrayList<LayoutManager>(10);
        }
        this.childLMs.add(lm);
        if (log.isTraceEnabled()) {
            log.trace(this.getClass().getName() + ": Adding child LM " + lm.getClass().getName());
        }
    }

    @Override
    public void addChildLMs(List newLMs) {
        if (newLMs == null || newLMs.size() == 0) {
            return;
        }
        for (LayoutManager newLM : newLMs) {
            this.addChildLM(newLM);
        }
    }

    @Override
    public Position notifyPos(Position pos) {
        if (pos.getIndex() >= 0) {
            throw new IllegalStateException("Position already got its index");
        }
        pos.setIndex(++this.lastGeneratedPosition);
        return pos;
    }

    private void verifyNonNullPosition(Position pos) {
        if (pos == null || pos.getIndex() < 0) {
            throw new IllegalArgumentException("Only non-null Positions with an index can be checked");
        }
    }

    public boolean isFirst(Position pos) {
        this.verifyNonNullPosition(pos);
        if (pos.getIndex() == this.smallestPosNumberChecked) {
            return true;
        }
        if (pos.getIndex() < this.smallestPosNumberChecked) {
            this.smallestPosNumberChecked = pos.getIndex();
            return true;
        }
        return false;
    }

    public boolean isLast(Position pos) {
        this.verifyNonNullPosition(pos);
        return pos.getIndex() == this.lastGeneratedPosition && this.isFinished();
    }

    @Override
    public boolean hasLineAreaDescendant() {
        if (this.childLMs == null || this.childLMs.isEmpty()) {
            return false;
        }
        for (LayoutManager childLM : this.childLMs) {
            if (!childLM.hasLineAreaDescendant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBaselineOffset() {
        if (this.childLMs != null) {
            for (LayoutManager childLM : this.childLMs) {
                if (!childLM.hasLineAreaDescendant()) continue;
                return childLM.getBaselineOffset();
            }
        }
        throw this.newNoLineAreaDescendantException();
    }

    protected IllegalStateException newNoLineAreaDescendantException() {
        return new IllegalStateException("getBaselineOffset called on an object that has no line-area descendant");
    }

    protected void transferForeignAttributes(AreaTreeObject targetArea) {
        Map atts = this.fobj.getForeignAttributes();
        targetArea.setForeignAttributes(atts);
    }

    protected void transferExtensionAttachments(AreaTreeObject targetArea) {
        if (this.fobj.hasExtensionAttachments()) {
            targetArea.setExtensionAttachments(this.fobj.getExtensionAttachments());
        }
    }

    protected void transferExtensions(AreaTreeObject targetArea) {
        this.transferForeignAttributes(targetArea);
        this.transferExtensionAttachments(targetArea);
    }

    protected void registerMarkers(boolean isStarting, boolean isFirst, boolean isLast) {
        if (this.markers != null) {
            this.getCurrentPV().registerMarkers(this.markers, isStarting, isFirst, isLast);
            this.possiblyRegisterMarkersForTables(this.markers, isStarting, isFirst, isLast);
        }
    }

    protected void addId() {
        if (this.fobj != null) {
            this.getPSLM().addIDToPage(this.fobj.getId());
        }
    }

    protected void notifyEndOfLayout() {
        if (this.fobj != null) {
            this.getPSLM().notifyEndOfLayout(this.fobj.getId());
        }
    }

    protected void checkEndOfLayout(Position pos) {
        if (pos != null && pos.getLM() == this && this.isLast(pos)) {
            this.notifyEndOfLayout();
            if (!this.preserveChildrenAtEndOfLayout) {
                this.childLMs = null;
                this.curChildLM = null;
                this.childLMiter = null;
            }
            this.markers = null;
            LayoutManager lm = this.parentLayoutManager;
            while (!(lm instanceof FlowLayoutManager) && !(lm instanceof PageSequenceLayoutManager)) {
                lm = lm.getParent();
            }
            if (lm instanceof FlowLayoutManager && !this.preserveChildrenAtEndOfLayout) {
                this.fobj.clearChildNodes();
                this.fobjIter = null;
            }
        }
    }

    @Override
    public void preserveChildrenAtEndOfLayout() {
        this.preserveChildrenAtEndOfLayout = true;
    }

    public String toString() {
        return super.toString() + (this.fobj != null ? "{fobj = " + this.fobj.toString() + "}" : "");
    }

    @Override
    public void reset() {
        this.isFinished = false;
        this.curChildLM = null;
        this.childLMiter = new LMiter(this);
        for (LayoutManager childLM : this.getChildLMs()) {
            childLM.reset();
        }
        if (this.fobj != null) {
            this.markers = this.fobj.getMarkers();
        }
        this.lastGeneratedPosition = -1;
    }

    @Override
    public void recreateChildrenLMs() {
        this.childLMs = new ArrayList<LayoutManager>();
        this.isFinished = false;
        if (this.fobj == null) {
            return;
        }
        this.fobjIter = this.fobj.getChildNodes();
        int position = 0;
        while (this.createNextChildLMs(position++)) {
        }
        this.childLMiter = new LMiter(this);
        LMiter iter = new LMiter(this);
        while (iter.hasNext()) {
            AbstractBaseLayoutManager alm = (AbstractBaseLayoutManager)iter.next();
            alm.initialize();
            alm.recreateChildrenLMs();
            alm.preserveChildrenAtEndOfLayout();
        }
        this.curChildLM = this.getChildLM();
    }

    protected void possiblyRegisterMarkersForTables(Map<String, Marker> markers, boolean isStarting, boolean isFirst, boolean isLast) {
        LayoutManager lm = this.parentLayoutManager;
        if (lm instanceof FlowLayoutManager || lm instanceof PageSequenceLayoutManager || !(lm instanceof AbstractLayoutManager)) {
            return;
        }
        ((AbstractLayoutManager)lm).possiblyRegisterMarkersForTables(markers, isStarting, isFirst, isLast);
    }

    public boolean handlingFloat() {
        if (this.parentLayoutManager != null && this.parentLayoutManager instanceof AbstractLayoutManager) {
            return ((AbstractLayoutManager)this.parentLayoutManager).handlingFloat();
        }
        return false;
    }
}

