# -*- coding: UTF-8 -*-
#
#
#   Copyright 2004-2008 Henning von Bargen (henning.vonbargen arcor.de)
#   This software is dual-licenced under the Apache 2.0 and the
#   2-clauses BSD license. For details, see license.txt
#
#

# Sonderfälle mit Angabe der Trennung
special_words = u"""
altbauerhaltung,TRENNUNG:alt8bau8erhal5tung
analphabet,TRENNUNG:an8alpha5bet
analphabeten,TRENNUNG:an8alpha5be5ten
analphabetismus,TRENNUNG:an8alpha5be5tis4mus
sprecherziehung,TRENNUNG:sprech8erzie4hung
urinstinkt,TRENNUNG:ur8instinkt
urinstinkte,TRENNUNG:ur8instinkte
urinstinkten,TRENNUNG:ur8instinkten
wordaxe,TRENNUNG:word8axe
"""

# Wort,property,property
roots = u"""
aas
abend
aber
achs
acht
ächt,NEED_SUFFIX
add,FREMDWORT,NEED_SUFFIX
addit,FREMDWORT,NEED_SUFFIX
adel
adler
adress
affe
affin,FREMDWORT
agent
ahn
aktion
aktiv,FREMDWORT
aktual,FREMDWORT,NEED_SUFFIX
aktuell
akut
akzept,FREMDWORT
algorithmen,FREMDWORT
algorithmik,FREMDWORT
algorithmus,FREMDWORT
all
allerg,FREMDWORT
allerlei
alliterat,FREMDWORT,NEED_SUFFIX
alm
almosen
also
alt
ameise
amerika
amput,FREMDWORT,NEED_SUFFIX
amt
analog,FREMDWORT
analys,FREMDWORT
ander
angst
annot,FREMDWORT,NEED_SUFFIX
antwort
apfel
arbeit
arbeit
archiv,FREMDWORT
argument,FREMDWORT
arm
arsch
art
artikel
artikul,FREMDWORT,NEED_SUFFIX
arzt
assembl,FREMDWORT
ast
atem
atmosphär,FREMDWORT,TRENNUNG:at2mo5sphär
attribut,FREMDWORT
auch
audio
auf
aug
auge
aus
auto
automat,FREMDWORT
autor,FREMDWORT
außen
außer
außerdem
ähn,NEED_SUFFIX
ält,NEED_SUFFIX
änder,NEED_SUFFIX
ängst,NEED_SUFFIX
ärzt
bach
bäch,NEED_SUFFIX
back
bäck,NEED_SUFFIX
bad
bäd,NEED_SUFFIX
bahn
bald
ball
bälle
banane
band
bänd,NEED_SUFFIX
bank
bänk,FREMDWORT
bann
bar
bär
barriere
barsch
bart
bärt,NEED_SUFFIX
bas,FREMDWORT,NEED_SUFFIX
bat
bau
bauch
bäuch,NEED_SUFFIX
baum
bäume
bayer
bayr
becher
bei
beim,NO_SUFFIX
bein
berg
besser
best
bet
bett
beut
beutel
biblio,FREMDWORT
bier
biet
bild
bind
binnen
birg
birn
bis
biss
bist,NO_PREFIX,NO_SUFFIX
bistum
bit
bitt
blatt
blätt,NEED_SUFFIX
blau
blech
bleib
blend
blick
blitz
block
blume
blüm,NEED_SUFFIX
bluse
blut
boden
boot
bote
box
bracht
brand
bränd
brannt
brat
brauch
bräuch,NEED_SUFFIX
braun
bräun,NEED_SUFFIX
brech
brei
breit
brems
brenn
brett
brief
bring
broch,NEED_SUFFIX
brot
bruch
brust
brüst
brut
brutal
brutto
buch
buffer,ENGLISCH
bund
büro
burg
bürg
bus
buß
butter
button,ENGLISCH
byte
cache,KEEP_TOGETHER
chance
chef
chines,NEED_SUFFIX
chiffr,NEED_SUFFIX
chip
cholesterin
client,ENGLISCH
code
codier,FREMDWORT
cola
comput,ENGLISCH
controll,ENGLISCH
copy,ENGLISCH
count,ENGLISCH,KEEP_TOGETHER
da,NO_SUFFIX
dach
daddel
dampf
dank
dann
dar
darf
darm
das,NO_SUFFIX
dass,NO_SUFFIX
darm
därm
datei
daten
datum
dauer
daumen
deck
decod,ENGLISCH
defin,FREMDWORT
definit,FREMDWORT
dehn
dein
delikt
dem,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
dem,NO_PREFIX,NO_SUFFIX,ONLY_LAST_WORD
den,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
denen,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
denk
denn,NO_SUFFIX
dennoch
der,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
deren
derer
derzeit
des,NO_PREFIX,NO_SUFFIX
design
dessen
desto,NO_SUFFIX
detail,TRENNUNG:de5tail
deut
deutsch
dialog
dick
dich,NO_SUFFIX
dicht
die
dieb
dien,NEED_SUFFIX
dienstag
dies
diesel
digital,FREMDWORT
ding
direkt,FREMDWORT
diskette
divid,FREMDWORT
doch
dokument,FREMDWORT
dom
donau
donner
doppel
doppl,NEED_SUFFIX
dorf
dort
dose
dos,FREMDWORT,NEED_SUFFIX
down,ENGLISCH
draht
drang
dräng,NEED_SUFFIX
dreh
drei
dreist
dring
dritt
druck
drück
dual
duell,FREMDWORT
dukt,FREMDWORT,NEED_PREFIX
dumm
dümmer
dünn
dukt,FREMDWORT
durch
durf,NEED_SUFFIX
dürf,NEED_SUFFIX
duz,FREMDWORT
dynam,FREMDWORT
dynamo
eben
echse
echt
eck
edel
edit,FREMDWORT
edikt,FREMDWORT
effekt,FREMDWORT
ehe,NOT_AFTER_WORD:best
eher
ei,NOT_BEFORE:n
eigen
eign,NEED_SUFFIX
eignis
eimer
ein
einig
einheit
einzel
einzig
eis
eisen
eisern
elefant
elektro
elektron
element,FREMDWORT
elter,NEED_SUFFIX
emblem
empfahl
empfand
empfand
empfang
empfehl,NEED_SUFFIX
empfind
empfing
empfohl
encod,ENGLISCH

end,NOT_LAST_WORD
# damit z.B. "lachende" nicht als zwei Wörter gesehen wird
end,NEED_SUFFIX,SINGLE_WORD
# z.B. für "beenden"
# Was macht man mit "wortenden"???
# Hier kann nur eine Unterscheidung zwischen Substantiven, Adjektiven, Verben etc. helfen!

energ,FREMDWORT
eng
englisch
erd
erst
ess
etwa
eventu,FREMDWORT,NEED_SUFFIX
exakt,TRENNUNG:ex4akt
exempel,TRENNUNG:ex2em4pel
exemplar,TRENNUNG:ex2em4plar
exist,FREMDWORT,KEEP_TOGETHER
exot
extern
extra,TRENNUNG:ex4tra
extrem,FREMDWORT
fach
fähig
fahl
fahr
fähr
fakt
falen
# von Westfalen
fälisch
fall
fäll,NEED_SUFFIX
falsch
fälsch,NEED_SUFFIX
falt
fält,NEED_SUFFIX
familie
fand
fang
farb
färb,NEED_SUFFIX
farn
fass
fast
fecht
feder
feedback
fehl
fekt,FREMDWORT,NEED_PREFIX
feier
feld
fell
fenster
fer,FREMDWORT,NEED_PREFIX
ferenz,FREMDWORT
fern
fertig
fess,FREMDWORT
fessel
fest
fete
fetisch
fett
feucht
fick
figur,FREMDWORT
film
filter,ENGLISCH
find,NEED_SUFFIX
finger
firewall,TRENNUNG:fire8wall
firm,FREMDWORT
fisch
fix,FREMDWORT
fiz,FREMDWORT,NEED_SUFFIX
flach
fläche
flamm
flasche
flat,FREMDWORT
# für Inflation
fleisch
flex,FREMDWORT
flexibel,FREMDWORT
flexible,FREMDWORT
flieg,NEED_SUFFIX
flug
flüg
flügel
fluss
flüss,NEED_SUFFIX
fluß
floss
folg
fon
fön
forder
förder
forge,ENGLISCH
form,FREMDWORT
format,FREMDWORT
forsch
fort
forward,ENGLISCH
frag,NEED_SUFFIX
frau
frei
fremd
freud
freund
fries
fried
frisch
frist
froh
fröhlich
fromm
frosch
frösch,NEED_SUFFIX
früh
frust
fug
füg
fühl
fuhr
führ
füll
fund
fünd,NEED_SUFFIX
funk
funktion,FREMDWORT
fünf
für
fuß
füß,NEED_SUFFIX
gab,NEED_SUFFIX
gabel
gam,ENGLISCH,NEED_SUFFIX
gang
gäng,NEED_SUFFIX
ganz
gänz,NEED_SUFFIX
gar
garant,FREMDWORT
garn
garnele
geb,NEED_SUFFIX
gegen
gegner
geh,NEED_SUFFIX
geh,NO_SUFFIX,NOT_BEFORE_CHAR:aeiouäüöy
geig
geil
geist
gelb
geld
gelt
gemeinde
genau
gener,FREMDWORT,NEED_SUFFIX
gerade
gern
gesund
gesünd,NEED_SUFFIX
gib
gicht
gilb
gilt
gips
glaub
gleich
gleis
glied
glossar
gold
glück
grab,NEED_SUFFIX
graf
grafik
gramm,FREMDWORT
gras
greif
grenadier
grenz
griff
grimm
grob
gröb,NEED_SUFFIX
groß
größ,NEED_SUFFIX
grün
grund
grupp,FREMDWORT
gruß
grüß,NEED_SUFFIX
gült,NEED_SUFFIX
gunst,NO_SUFFIX
günst,NEED_SUFFIX
guss
gut
güt,NEED_SUFFIX
gieß,NEED_SUFFIX
greif
griff
hab,NEED_SUFFIX
haft
hag,NEED_SUFFIX
hahn
hähne
hai
hand
händ,NEED_SUFFIX
handel
handl,NEED_SUFFIX
händler
hang
häng,NEED_SUFFIX
halb
halde
half
hälft,NEED_SUFFIX
hals
halt
hält
hammer
hamster
hämmer
hans
hardware,TRENNUNG:hard5ware
hark
hart
hass
hast
hat,NO_SUFFIX
hatt,NEED_SUFFIX
hätt,NEED_SUFFIX
hauf
häuf,NEED_SUFFIX
haupt
haus
häus,NEED_SUFFIX
haut
häut,NEED_SUFFIX
head,ENGLISCH
heb
helf
hell
heil
heim
heimat
heiser
heiß
heiter
heiz,NEED_SUFFIX
helf
hemd
hemm
her
heraus
herein
herd
heu
heute
heran
herz
hier
hilf
hin
hinder,NEED_SUFFIX
hirn
hirsch
hint,NEED_SUFFIX
histor,FREMDWORT,NEED_SUFFIX
hob
# den ich vom Boden aufhob
hobby
hobel
hoch
höchst
hof
hoff
hoh,NEED_SUFFIX
höh,NEED_SUFFIX
hol
holz
hör
horch
hose
host,ENGLISCH
hüll,NEED_SUFFIX
hund
hundert
hust,NEED_SUFFIX
hut
idee
identifiz,FREMDWORT,NEED_SUFFIX
identifik,FREMDWORT,NEED_SUFFIX
ident,FREMDWORT
igel
ignor,FREMDWORT,NEED_SUFFIX
immer
initi,FREMDWORT,NEED_SUFFIX
input,NO_SUFFIX
industr,FREMDWORT,NEED_SUFFIX
insbesonder
ihn
ihr
illegal
im,NO_PREFIX,NO_SUFFIX,SINGLE_WORD
image,KEEP_TOGETHER
in,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
ins,NO_PREFIX,NO_SUFFIX,ONLY_FIRST_WORD
indem
indes
index
indiz,FREMDWORT
individu,FREMDWORT
infolge,NO_SUFFIX
inhab,NEED_SUFFIX
inhalt
initial,FREMDWORT
inn
install,FREMDWORT,NEED_SUFFIX,TRENNUNG:in5stall
intend,FREMDWORT,NEED_SUFFIX
interess,FREMDWORT,NEED_SUFFIX
intern
internet
irak
iran
irden
irgend
ist,NO_SUFFIX
jacke
jahr
jähr,NEED_SUFFIX
jed
jedoch
jeglich
jemand
jesus
jet
jetzt
jeweil
job
jojo
joystick,TRENNUNG:joy5stick
jubel
jude
jüd,NEED_SUFFIX
jugend
jung
jüng,NEED_SUFFIX
junkt,FREMDWORT,NEED_SUFFIX
jurist,FREMDWORT
just
jux
kabel
kabin
kachel
kacke
kader
kaff
kaffee
käfig
kahl
kai
kaiman
kajal
kakao
kalender
kaliber,FREMDWORT
kalibr,FREMDWORT,NEED_SUFFIX
kalt
kam
kamera
kamm
kampf
kämpf
kandid,FREMDWORT,NEED_SUFFIX
kann
kanne
kanzel
kanzlei
kanzler
kapitän
kart,FREMDWORT,NEED_SUFFIX
käse
kast,NEED_SUFFIX
käst,NEED_SUFFIX
katze
kau
kauf
käuf,NEED_SUFFIX
kaum
kav,FREMDWORT
kein
keinerlei
kenn,NEED_SUFFIX
kern
kett
ketchup
kick
kiefer
kind
kirch
kist,NEED_SUFFIX
klamm
klar
klär
klass
klausel
klausul,FREMDWORT,NEED_SUFFIX
kleid
klein
klick
klinik
klug
klüg,NEED_SUFFIX
klud,FREMDWORT,NEED_SUFFIX
knabe
knarz
knie
knister
knot,NEED_SUFFIX
knopf
knöpf,NEED_SUFFIX
knüpf
koch,NEED_SUFFIX
kohl,NEED_SUFFIX
koll,FREMDWORT,NEED_PREFIX
kolleg,FREMDWORT
kollekt,FREMDWORT
kombin,FREMDWORT,NEED_SUFFIX
komik
komisch
komm,NEED_SUFFIX
komma
kommata
kommandier,FREMDWORT,NEED_SUFFIX
kommando
kommerz,FREMDWORT
kommun,FREMDWORT
kommuniz,FREMDWORT
kommunikat,FREMDWORT
kompatibel,FREMDWORT
kompatibil,FREMDWORT,NEED_SUFFIX
kompatibl,FREMDWORT,NEED_SUFFIX
kompil,FREMDWORT,NEED_SUFFIX
komplex,FREMDWORT
komplett
komplik,FREMDWORT,NEED_SUFFIX
kompliment
kompliz,FREMDWORT,NEED_SUFFIX
komponent,FREMDWORT
kompromiss,FREMDWORT
kompromiß,FREMDWORT
kompromitt,FREMDWORT
konflikt
konn,NEED_SUFFIX
konsol
konsolid,FREMDWORT
kontakt
kop,FREMDWORT
kopf
korb
korn
korrekt,FREMDWORT
korrig,FREMDWORT,NEED_SUFFIX
kost
kotz
kraft
kragen
kram
kram
krank
kränk
kreide
kreis
kreuch
krumm
kräft,NEED_SUFFIX
krägen
kräm,NEED_SUFFIX
kreat,FREMDWORT
kriech
krieg
krit
kriteri,FREMDWORT
kroch
kuf
kult,FREMDWORT
kunde
kunst
kur
kurs
kurs,FREMDWORT,NEED_SUFFIX
kurv,NEED_SUFFIX
kurz
könn,NEED_SUFFIX
körper
köst,NEED_SUFFIX
künd,NEED_SUFFIX
künst,NEED_SUFFIX
künstl,NEED_SUFFIX
kürz,NEED_SUFFIX
lad
lampe
land
länd,NEED_SUFFIX
lang
läng,NEED_SUFFIX
langsam
lag,NEED_SUFFIX
lapp
laptop
lass
läss,NEED_SUFFIX
last
laterne
latenz,FREMDWORT
latrine
lau
laub
lauer
lauf
läuf,NEED_SUFFIX
laug
laus
laut
läut
laser
leb
ledig
leer
leg
lehn
lehr
leib
leicht
leid
leist
leit
lenk
lern
les,NEED_SUFFIX
letz,NEED_SUFFIX
letzt
leucht
licht
lieb
lied
lief
lieferant,FREMDWORT
lieg
lier,NEED_PREFIX
limburg
limit,FREMDWORT
linear,FREMDWORT
ling
link
lischt,NEED_PREFIX
list
list,ENGLISCH
literat,FREMDWORT,NEED_SUFFIX
lizenz,FREMDWORT
load,ENGLISCH,KEEP_TOGETHER
loch
löcher
lock,NEED_SUFFIX
log
# von lüge
log,FREMDWORT
# von logik
lohn
lokal,FREMDWORT
lor,NEED_SUFFIX
los
lös
lösch
luft
lüg,NEED_SUFFIX
lung,NEED_SUFFIX
lust
mag
mach
macht
mächt,NEED_SUFFIX
mädchen
mager
mahn
mai
makler
makel
mal
manag,ENGLISCH,NEED_SUFFIX
manch
mangel
mängel
mann
männ,NEED_SUFFIX
manu,FREMDWORT,NEED_SUFFIX
mappe
mark,FREMDWORT
maß
mäß
masse
mast
material
materialien
mauer
maus
maxim,FREMDWORT,NEED_SUFFIX
medi,FREMDWORT,NEED_SUFFIX
meer
mehr
meid
meile
mein
meist
meld,NEED_SUFFIX
mensch
menü
merk
mess
messag,ENGLISCH,NEED_SUFFIX
meter,FREMDWORT
methode,TRENNUNG:me5tho5de
miet
micro,TRENNUNG:mi2cro
mikro,TRENNUNG:mi4kro
milch
milli
mind,NEED_SUFFIX
minim,FREMDWORT,NEED_SUFFIX
minister,FREMDWORT
ministeri,FREMDWORT
minus
minute
misch
miss
miss,FREMDWORT,NEED_SUFFIX
mist
mit
mitte
mittel
mittl,NEED_SUFFIX
mobil,FREMDWORT
möbel
möcht,NEED_SUFFIX
mode
modus
moment
momentan
monat
mond
monitor
monoton,FREMDWORT
monogam,FREMDWORT
mög,NEED_SUFFIX
mohr
möhr
montag
moor
most
mord
mörder
motor
mull,NO_SUFFIX
müll
multi,NO_SUFFIX
mund
münd,NEED_SUFFIX
mücke
müh
mumie
mumifik,FREMDWORT
mumifiz,FREMDWORT
muse,FREMDWORT
museum
muskel
muss
müss,NEED_SUFFIX
muster
mut
mutter
mütter
mütze
myst
myth
nach
nacht
nächst
nächt,NEED_SUFFIX
nack
näckig
nackt
nadel
nagel
nägel
nagl,NEED_SUFFIX
nah
näh,NEED_SUFFIX
nahm,NEED_SUFFIX
naiv,TRENNUNG:na5iv
nannt,NEED_PREFIX
nation,FREMDWORT
name
nase
nass
nässe
nativ
natur
natürlich
navig,FREMDWORT
#?
neben
need,ENGLISCH
neg,FREMDWORT
negat,FREMDWORT
nehm,NEED_SUFFIX
neig,NEED_SUFFIX
nein
nerv
neu
neun,NEED_SUFFIX
netto
netz
nicht
nick
nie
nieder
niedrig
niemand
nieß
nimm
noch,NO_SUFFIX
nom,FREMDWORT
nomm,NEED_PREFIX
norm,FREMDWORT
not
nötig
nug
nüg,NEED_SUFFIX
nummer,FREMDWORT
nunft
nünft,NEED_SUFFIX
null
nummer,FREMDWORT
nur,NO_SUFFIX
nutte
nutz
nütz
obacht
oben
ober
obgleich,TRENNUNG:ob5gleich
obig
objekt,FREMDWORT
oblieg,NEED_SUFFIX
obrig
obschon,TRENNUNG:ob5schon
obwohl,TRENNUNG:ob5wohl
öde
oder
ofen
offen
öffentlich
offiz,FREMDWORT
öffn,NEED_SUFFIX
ohn
ohr
okkult
öl
oliv
online,KEEP_TOGETHER
oper,FREMDWORT
opfer
optim,FREMDWORT,NEED_SUFFIX
option,FREMDWORT
orakel
ordn,NEED_SUFFIX
organ,FREMDWORT
origin,FREMDWORT
ort
ost
oster
otter
oval
ozon
ozelot
pack
paff,NEED_SUFFIX
page
paket
palm
panda
panne
panzer
papp
par,FREMDWORT
park
partikel
pass,FREMDWORT
pat,NEED_SUFFIX
patent
patz,NEED_SUFFIX
pauk,NEED_SUFFIX
pause
peripher,FREMDWORT,NEED_SUFFIX
perform,ENGLISCH
person,FREMDWORT
persön,NEED_SUFFIX
permanent
pfahl
pfähl
pfand
pfänd
pfaff
pfarr
pfeif
pfeil
pferd
pfingst
pfleg
pflicht
pflug
pflüg
phase
phob,FREMDWORT
phon
phil,FREMDWORT
plan
platt
platz,FREMDWORT
play,ENGLISCH
plem,FREMDWORT,NEED_PREFIX,NEED_SUFFIX
polygon
polyphon
pomp
port,FREMDWORT
position,FREMDWORT
positiv,FREMDWORT
post,FREMDWORT
posting
potent,FREMDWORT
potenz,FREMDWORT
power,ENGLISCH
pracht
prächt
prall
prang
prakt,FREMDWORT,NEED_SUFFIX
prank
praxis,NO_SUFFIX
preis
pret,FREMDWORT,NEED_PREFIX,NEED_SUFFIX
prinz
prinzess
prinzeß
prinzip,FREMDWORT
prior,FREMDWORT
privat,FREMDWORT
prob,FREMDWORT,NEED_SUFFIX
programm,TRENNUNG:pro5gramm
problem
projekt
proto,NEED_SUFFIX
prozess,FREMDWORT
prozeß,FREMDWORT
prüf
publik,FREMDWORT
puff
pulver
pump
punkt
pursuit,ENGLISCH,TRENNUNG:pur5suit
putz
python,TRENNUNG:py-thon
qual
quäl
qualität
quart,FREMDWORT
quell
quer
rad
rad,FREMDWORT
radi,FREMDWORT
rahm
rand
ränd,NEED_SUFFIX
rang
räng,NEED_SUFFIX
rat
rät
ratte
raub
räuber
rauch
räucher
rauf
raum
räum,NEED_SUFFIX
real,FREMDWORT
#realis,FREMDWORT
rech,NEED_SUFFIX
recherch,FREMDWORT,NEED_SUFFIX
red,NEED_SUFFIX
recht
rechn,NEED_SUFFIX
reg,NEED_SUFFIX
regel
regie
regier
region,FREMDWORT
register
registr,FREMDWORT,TRENNUNG:re3gis5tr
regl,NEED_SUFFIX
reib
reif
rein
reich
reis,NO_SUFFIX
reise
reit
rekord
rekt,FREMDWORT
relat,FREMDWORT
rempel
renn
republik
result,FREMDWORT
rest
restaur,FREMDWORT,NEED_SUFFIX
rhein
richt
riech
ries
right,ENGLISCH
ring
risiko
risiken
rock
roll
rot,FREMDWORT
route
routin,FREMDWORT,NEED_SUFFIX
ruch
# ruchlos 
ruck
rück
ruf
ruh
ruhr
rühr
rum
rund
runter
saal
sach
säch,NEED_SUFFIX
sag
saison
saite
salvator
salz
sam
samm,NEED_SUFFIX
sampl,ENGLISCH,NEED_SUFFIX
samt
sämtlich
sang
satz
sätz,NEED_SUFFIX
sau
sauber,NEED_SUFFIX
säuber
saug
säug
schab
schach
schacht
schachtel
schad,NEED_SUFFIX
schäd,NEED_SUFFIX
schaf
schaft
schäft
schaff
schal
schalt
schatt,NEED_SUFFIX
schatz
schau
schaufel
scheibe
scheid
schein
scheiß
scheit
scheitel
schenk
scher
scherbe
scherz
scheu
schicht
schick
schieb
schied
schief
schien
schiit
schilf
schiff
schirm
schlacht
schlaf
schläf,NEED_SUFFIX
schlaff
schlag
schlamm
schlämm
schlange
schlank
schlau
schlecht
schleck
schleier
schlemm
schleunig,NEED_SUFFIX
schlief
schließ
schling
schlitt
schloss
schluss
schlüss,NEED_SUFFIX
schlüssel
schmal
schmäl,NEED_SUFFIX
schmied
schmieg
schmier
schnee
schneid
schnell
schnief
schnitt
schokolade
schon
schön
schopf
schöpf
geschoren
schorf
schorle
schorn
schrank
schränk,NEED_SUFFIX
schreck
schrei
schreib
schrein
schreit
schrieb
schrift
schritt
schröpf
schrull
schub
schuh
schul
schuld
schulter
schur
schuss
schuß
schutz
schütz
schwab
schwäb,NEED_SUFFIX
schwach
schwall
schwalbe
schwamm
schwämm
schwan
schwanz
schwarm
schwärm
schwarz
schwein
schweiz
schwyz
schwester
schwer
schwierig
schwimm
schwind
schwamm
sechs
see
segment,FREMDWORT
seh
sehr
seicht
seil
sein
seit
sekunde
sekt,FREMDWORT
selb
selekt,FREMDWORT
sell,NEED_PREFIX
selten
semmel
send
senf
sent,FREMDWORT
sequenz,FREMDWORT
# Unterscheidung server/serving <-> servier
serie
serv,ENGLISCH
serv,FREMDWORT
sess,FREMDWORT
sess
setz
sheet,ENGLISCH
sicher
sich,NO_SUFFIX
sicht
sident,FREMDWORT,NEED_PREFIX
sie,NO_PREFIX,NO_SUFFIX,SINGLE_WORD
sieb
sied
sieg
sieh,NEED_SUFFIX
siel
silbe
silber
simul,FREMDWORT
sind
sing
sinn
situ,FREMDWORT,NEED_SUFFIX
sitz
sleep,ENGLISCH
# Sollte das hier stehen bleiben?
so 
socke
soft,ENGLISCH
software,TRENNUNG:soft5ware
sohn
solch
soll
solut,FREMDWORT
sommer
sonder
sonn,NEED_SUFFIX
sonst
sorg
sound,TRENNUNG:sound
source,TRENNUNG:source
spalt
span
spann
spar
spargel
spaß
spaten
spät
spatz
spazier
speck
speed,ENGLISCH
speich,NEED_SUFFIX
speis
sperr
spekul,FREMDWORT,NEED_SUFFIX
spezi,FREMDWORT,NEED_SUFFIX
spezif,NEED_SUFFIX
spezifiz,FREMDWORT,NEED_SUFFIX
spezifik,FREMDWORT,NEED_SUFFIX
sphär,FREMDWORT
spiegel
spiel
spir,FREMDWORT,NEED_SUFFIX
spitz
sport
sprach
sprang
sprech
sprich
spring
sproch,NEED_PREFIX,NEED_SUFFIX
spruch
sprüch,NEED_SUFFIX
sprung
sprüng,NEED_SUFFIX
spur
spür
stab
stäb,NEED_SUFFIX
stabil,FREMDWORT
stach
stadt
städt
stahl
stall
stalt,NEED_PREFIX
stamm
stämm,NEED_SUFFIX
stank
stand
ständ,NEED_SUFFIX
standard
stark
stärk,NEED_SUFFIX
starr
start
stat,FREMDWORT
statt
stau
staub
stäub
stauch
staun
stech
steif
steig
steil
stein
steiß
steh
stehl,NEED_SUFFIX
stell
stereo,NO_PREFIX,FREMDWORT
steuer
stich
stief
stiefel
stieg
stiel
stift
stil
still
stimm
stink
stirn
stoch
stock
stopf
stopp
stör
stoß
stöß,NEED_SUFFIX
stotter
straf
straff
strahl
strähn,NEED_SUFFIX
stramm
strang
sträng,NEED_SUFFIX
straße
strauch
strauch
streck
streif
streich
streng
streu
strich
strick
striffen
string,ENGLISCH
strom
strukt,FREMDWORT,NEED_PREFIX
struktur,FREMDWORT
strunk
stube
stumm
stunde
stunk
sturm
sturz
stürz,NEED_SUFFIX
stutz
stütz
style,ENGLISCH
such
suffiz,FREMDWORT
suffix,FREMDWORT
sult,FREMDWORT
summ,FREMDWORT
support
surf,ENGLISCH
symbol
symptom,FREMDWORT
synchron,FREMDWORT
system,FREMDWORT
tabelle
tag
täg,NEED_SUFFIX
tal
tan
tank
tasche
tasse
tast,NEED_SUFFIX
tastatur
tat
tau
taug,NEED_SUFFIX
tauch,NEED_SUFFIX
taumel
tausch
täusch,NEED_SUFFIX
tausend
team,KEEP_TOGETHER
techn,FREMDWORT,NEED_SUFFIX
teil
teller
temper,FREMDWORT,NEED_SUFFIX
tempo
temporär
termin
terrari,FREMDWORT,NEED_SUFFIX
territori,FREMDWORT
tertiär
test
text,FREMDWORT
textur,ENGLISCH
tief
tier
tiger
tisch
titel
titt,NEED_SUFFIX
toast
tob,NEED_SUFFIX
tochter
töchter
tod
töd,NEED_SUFFIX
toll
tomate
ton
topf
töpf,NEED_SUFFIX
torte
tot
töt,NEED_SUFFIX
tracht
trächt,NEED_SUFFIX
track,ENGLISCH
trad,FREMDWORT
traf
trag
träg,NEED_SUFFIX
trah,FREMDWORT,NEED_SUFFIX
train,NEED_SUFFIX
trakt,FREMDWORT
trank
trans,NO_PREFIX,NO_SUFFIX
trat
trau
traum
träum
travers,FREMDWORT
treck
treff
treib
trenn
trepp
tret
treu
tribut,FREMDWORT
trick
trieb
trief
triff
trink
tritt
trock,NEED_SUFFIX
troff
troll,FREMDWORT,NEED_PREFIX
troll
tropf
trotz
trunk
trute
# Schweiz
tschech
tube
tumult
tun
türk
turm
türm
tusch
typ,FREMDWORT
üb,NEED_SUFFIX
über
übrig
uhr
und,NO_PREFIX,NO_SUFFIX
unicode,TRENNUNG:uni8code
univers,FREMDWORT
uns,NO_PREFIX
unser,NO_PREFIX
unten
unter
upgrad,ENGLISCH
updat,ENGLISCH
urin
vater
ventil,FREMDWORT
vers,FREMDWORT
versibel,FREMDWORT
versible,FREMDWORT
vex,FREMDWORT
video
vieh
viel
vier
vir,FREMDWORT,NEED_SUFFIX
vis,FREMDWORT,NEED_SUFFIX
vogel
volk
voll
völl,NEED_SUFFIX
vom,NO_PREFIX,NO_SUFFIX
von,NO_SUFFIX
vor,NO_SUFFIX
wach
wachs
waffe
waffel
wag
wäg,NEED_SUFFIX
wahl
wähl
wahn
wähn,NEED_SUFFIX
wahr
währ
wald
wäld
walt
wand
wandel
wandl,NEED_SUFFIX
wank
wann
war
wär,NEED_SUFFIX
warum
warb
warf
warm
warn
wart
wärt,NEED_SUFFIX
warum,KEEP_TOGETHER,NO_SUFFIX
wasser
wässer
web
website,TRENNUNG:web8site
websites,TRENNUNG:web8sites
wechsel
weder
weg
wehr
weiger,NEED_SUFFIX
weil
wein
weis
weiß
weit
weizen
welch
welle
welt
wem
wen
wend
werb
werd,NEED_SUFFIX
werf
werk
wert
wesen
wessen
west
wett
wichs
wicht
wickel
wickl,NEED_SUFFIX
wider
wie,NO_SUFFIX
wieder
wiederum
wieg
wies
will
wind
window,ENGLISCH
winn
winter
wir,NO_SUFFIX
wirb
wird
wirk
wirst
wirt
wiss,NEED_SUFFIX
wo,NO_SUFFIX
woch
wöchentlich
wog
wohl
wohn
wöhn,NEED_SUFFIX
woll
worb,NEED_SUFFIX,NEED_PREFIX
word,NEED_SUFFIX
worf,NEED_PREFIX
wort
wört,NEED_SUFFIX
wunsch
wünsch
wupper
wurde
wurf
wurst
würd,NEED_SUFFIX
würg,NEED_SUFFIX
wurz
wurzel
würz
zahl
zähl
zahn
zeh
zeich
zeichn,NEED_SUFFIX
zeig
zeil,NEED_SUFFIX
zeit
zentr,FREMDWORT,NEED_SUFFIX
zerr
zeug
zess,FREMDWORT
zieh
ziel
ziffer
zimmer
zivil,FREMDWORT
zog
zög,NEED_SUFFIX
zoo
zoom,ENGLISCH
zu,NO_SUFFIX
zuck,NEED_SUFFIX
zück,NEED_SUFFIX
zug
züg,NEED_SUFFIX
zweck
zwei
zweifel
zweig
zweit
zwick
zwiebel
zwischen
zwölf
"""

prefixes = u"""
ab
an
anti,FREMDWORT
auf
#aus
be
bei
bi,FREMDWORT
co,FREMDWORT
de,FREMDWORT
dis,FREMDWORT
ein
ent
enz
er
ex,FREMDWORT
extra
fort
ge
hin
her
im,FREMDWORT
in,FREMDWORT
inter
intra,FREMDWORT
# direkt in den Stämmen mit aufgenommen: kom,FREMDWORT
kon,FREMDWORT
kontra
# mit direkt in den Stämmen mit aufgenommen: mit
nach
para,FREMDWORT
per,FREMDWORT
prä,FREMDWORT
pro,FREMDWORT
proto,FREMDWORT
re,FREMDWORT
rück
selbst
sonder
sonders,NO_SUFFIX
sub,FREMDWORT
super,FREMDWORT
tri,FREMDWORT
um
un
ur
ver
vor
zer
zu
zur
"""

suffixes = u"""
al,FREMDWORT,ONLY_FIRST
ance,ENGLISCH
at,FREMDWORT,ONLY_FIRST
ateur,FREMDWORT,ONLY_FIRST
ator,FREMDWORT,ONLY_FIRST
atur,FREMDWORT,ONLY_FIRST
ation,FREMDWORT,ONLY_FIRST
atisch,FREMDWORT,ONLY_FIRST
ant,FREMDWORT,ONLY_FIRST
bar
chen,ONLY_FIRST
e,NOT_AFTER:e
ell,FREMDWORT,ONLY_FIRST
em
en
end
#,ONLY_LAST_WORD
er
es
eur,FREMDWORT,ONLY_FIRST
heit
keit
ie,FREMDWORT
iell,FREMDWORT
ier,FREMDWORT
ig
ion,FREMDWORT,ONLY_FIRST
ional,FREMDWORT
in,NOT_AFTER:e
ing,ENGLISCH
is,FREMDWORT,ONLY_FIRST
ität,FREMDWORT
y,ENGLISCH
inter
isier,FREMDWORT,ONLY_FIRST
isation,FREMDWORT,ONLY_FIRST
isateur,FREMDWORT,ONLY_FIRST
isator,FREMDWORT,ONLY_FIRST
isch
ist,FREMDWORT,ONLY_FIRST
ismen,FREMDWORT,ONLY_FIRST,ONLY_LAST
ismus,FREMDWORT,ONLY_FIRST,ONLY_LAST
ität,FREMDWORT
ik,FREMDWORT,ONLY_FIRST
iv,FREMDWORT,ONLY_FIRST
#l,ONLY_FIRST
ler,ONLY_FIRST,ONLY_AFTER:t
lich
n,NOT_AFTER:e n in
nd,ONLY_FIRST,ONLY_LAST_WORD
nis
o,FREMDWORT,ONLY_FIRST,ONLY_LAST
or,FREMDWORT,ONLY_FIRST
s,ONLY_LAST,NOT_AFTER_CHAR:sßx,NOT_AFTER:t
# die Bedingung NOT_AFTER:t ist neu!
schaft
st
t,NOT_AFTER:ant ell em end heit ie in isch n schaft ung ös
te
ten
ter
tes
thek,FREMDWORT,ONLY_FIRST
tum
tümer
uell,FREMDWORT
um,FREMDWORT
ur,FREMDWORT,ONLY_FIRST
us,FREMDWORT
ung,NOT_AFTER:n
ös,ONLY_FIRST
"""

prefix_chars  = u"""([{\"-/¿¬¡"""

suffix_chars = u"""}]),";.:-/!=?"""
