<xsl:stylesheet id="ss" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
 xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs fc"
 xmlns:style="http://saxonica.com/ns/html-style-property"
 xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT"
 xmlns:prop="http://saxonica.com/ns/html-property"
 xmlns:fc="http://www.saxonica.com/ns/doc/functions">


 <xsl:template match="xsl:stylesheet" mode="f"/>

 <xsl:key name="fk" match="fc:function" use="fc:name"/>

 <xsl:template match="fc:description" mode="fn-description">
  <div>
   <xsl:copy-of select="child::node()"/>
  </div>
 </xsl:template>

 <xsl:template match="fc:signatures" mode="fn-description">
  <xsl:if test="fc:proto/fc:description">
   <ol>
    <xsl:for-each select="fc:proto/fc:description">
     <li>
      <xsl:value-of select="."/>
     </li>
    </xsl:for-each>
   </ol>
  </xsl:if>
 </xsl:template>

 <xsl:function name="fc:fn-list" as="element()*">
  <xsl:param name="fns" as="element()*"/>
  <xsl:perform-sort select="$fns">
   <xsl:sort select="lower-case(fc:name)" lang="en"/>
  </xsl:perform-sort>
 </xsl:function>

 <xsl:function name="fc:usual-prefix" as="xs:string">
  <xsl:param name="ns" as="xs:string"/>
  <xsl:choose>
   <xsl:when test="$ns = 'http://www.w3.org/2005/xpath-functions'">fn</xsl:when>
   <xsl:when test="$ns = 'http://saxon.sf.net/'">saxon</xsl:when>
   <xsl:when test="$ns = 'http://www.w3.org/2005/xpath-functions/map'">map</xsl:when>
   <xsl:when test="$ns = 'http://www.w3.org/2005/xpath-functions/math'">math</xsl:when>
   <xsl:when test="$ns = 'http://expath.org/ns/file'">expath-file</xsl:when>
   <xsl:when test="$ns = 'http://expath.org/ns/zip'">expath-zip</xsl:when>
   <xsl:when test="$ns = 'http://exslt.org/common'">exslt-common</xsl:when>
   <xsl:when test="$ns = 'http://exslt.org/random'">exslt-random</xsl:when>
   <xsl:when test="$ns = 'http://exslt.org/math'">exslt-math</xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$ns"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:function>

 <xsl:template match="fc:article" mode="function-list">
  <xsl:variable name="title" select="(h1|h2|h3)[1]"/>
  <h1>Function Library</h1>
  <p>This section of the documentation provides a complete list of functions implemented in the
   Saxon function library, organized by namespace. Click on a namespace to see the list of functions
   in that namespace.</p>
  <xsl:if test="exists($title)">
   <ixsl:set-property name="document.title" select="concat('Saxon ', $title)"/>
  </xsl:if>
  <ul>
   <xsl:for-each select="section">
    <xsl:variable name="prefix" select="fc:usual-prefix(fc:function[1]/fc:name/@namespace)"/>
    <li>
     <p>Namespace <span class="link" data-href="/functions/{$prefix}"><xsl:value-of select="$prefix"
       /></span>&#xa0;&#xa0;(<xsl:value-of select="fc:function[1]/fc:name/@namespace"/>)</p>
    </li>
   </xsl:for-each>
  </ul>
 </xsl:template>

 <xsl:template match="section" mode="function-list">
  <article id="functions" title="{@title}">

   <div id="fn-desc">
    <h4>Functions in namespace <xsl:value-of select="fc:function[1]/fc:name/@namespace"/></h4>
    <p>Hover over a listed function to view a brief description. For full details, select the
     function entry.</p>
   </div>

   <xsl:variable xpath-default-namespace="" name="height"
    select="ixsl:page()/html/body/div[@id = 'wrap']/div[@id = 'main']/@prop:offsetHeight - 140"/>

   <div style="overflow:auto; height:{$height}px; margin-top:5px;margin-bottom:5px">



    <xsl:variable name="sfns" as="element()*" select="fc:function"/>
    <p>Number of functions: <xsl:value-of select="count($sfns)"/></p>

    <xsl:variable name="colsize" select="xs:integer(ceiling(count($sfns) div 3))"/>

    <table width="100%">
     <tr>
      <td valign="top">
       <p>
        <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 0]" mode="index"/>
       </p>
      </td>
      <td valign="top">
       <p>
        <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 1]" mode="index"/>
       </p>
      </td>
      <td valign="top">
       <p>
        <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 2]" mode="index"/>
       </p>
      </td>
     </tr>
    </table>



   </div>

   <p class="small-note">The information in this section indicates which functions are implemented
    in this Saxon release, and any restrictions in the current implementation. It includes both the
    core functions defined in XPath, and the additional functions defined in the XSLT
    specification.</p>
   <!--
    <xsl:apply-templates select="$sfns" mode="f"/>
   -->

  </article>
 </xsl:template>



 <xsl:template match="fc:functions" mode="f">
  <article id="functions" title="Function Library">

   <div id="fn-desc">
    <h4>Function Library</h4>
    <p>Hover over a listed function to view a brief description. For full details, select the
     function entry.</p>
   </div>

   <xsl:variable xpath-default-namespace="" name="height"
    select="ixsl:page()/html/body/div[@id = 'wrap']/div[@id = 'main']/@prop:offsetHeight - 140"/>

   <div style="overflow:auto; height:{$height}px; margin-top:5px;margin-bottom:5px">

    <xsl:for-each-group select="function" group-by="name/@namespace">
     <h1>Namespace <xsl:value-of select="fc:usual-prefix(current-grouping-key())"/>
      <small>&#xa0;&#xa0;&#xa0;(<xsl:value-of select="current-grouping-key()"/>)</small></h1>
     <!-- <xsl:variable name="fns" select="function[starts-with(name, 'fn:') or starts-with(name, 'xslt:')]"/> -->
     <xsl:variable name="sfns" as="element()*" select="fc:fn-list(current-group())"/>

     <xsl:variable name="colsize" select="xs:integer(ceiling(count($sfns) div 3))"/>

     <table>
      <tr>
       <td valign="top">
        <p>
         <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 0]" mode="index"/>
        </p>
       </td>
       <td valign="top">
        <p>
         <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 1]" mode="index"/>
        </p>
       </td>
       <td valign="top">
        <p>
         <xsl:apply-templates select="$sfns[(position()-1) idiv $colsize eq 2]" mode="index"/>
        </p>
       </td>
      </tr>
     </table>

    </xsl:for-each-group>

   </div>

   <p class="small-note">The information in this section indicates which functions are implemented
    in this Saxon release, and any restrictions in the current implementation. It includes both the
    core functions defined in XPath, and the additional functions defined in the XSLT
    specification.</p>
   <!--
<xsl:apply-templates select="$sfns" mode="f"/>
-->

  </article>
 </xsl:template>

 <xsl:template match="fc:function" mode="index">
  <span class="flink" data-href="{fc:name}" data-ns="{fc:usual-prefix(fc:name/@namespace)}">
   <xsl:value-of select="fc:name"/>
  </span>
  <br/>
 </xsl:template>

 <xsl:template match="function[name/@namespace = 'http://www.w3.org/2005/xpath-functions']"
  priority="5" mode="f" xpath-default-namespace="http://www.saxonica.com/ns/doc/functions">

  <xsl:variable name="MyFunction" select="."/>
  <h1>
   <xsl:value-of select="name"/>
  </h1>
  
  <xsl:apply-templates select="description" mode="add-p-if-necessary"/>
  <xsl:variable name="same-spec-references" as="xs:boolean"
   select="every $proto in subsequence(signatures/proto, 2)
satisfies deep-equal(signatures/proto[1]/in-spec, $proto/in-spec)"/>
 

   <xsl:apply-templates select="signatures" mode="f"/>

   <xsl:if test="not($same-spec-references)">
    <xsl:variable name="fname" select="$MyFunction/name"/>
    <p>Applies to: <xsl:value-of select="fc:specs(in-spec)"/></p>
    <xsl:if test="in-spec='xpath20'">
     <p>
      <a href="http://www.w3.org/TR/xpath-functions/#func-{$fname}">XPath 2.0 Specification</a>
     </p>
    </xsl:if>
    <xsl:if test="in-spec='xpath30'">
     <p>
      <a href="http://www.w3.org/TR/xpath-functions-11/#func-{$fname}">XPath 3.0 Specification</a>
     </p>
    </xsl:if>
    <xsl:if test="in-spec='xslt20' and not(in-spec='xpath20')">
     <p>
      <a href="http://www.w3.org/TR/xslt20/#function-{$fname}">XSLT 2.0 Specification</a>
     </p>
    </xsl:if>
    <xsl:if test="in-spec='xslt30' and not(in-spec='xpath30')">
     <p>
      <a href="http://www.w3.org/TR/xslt-21/#function-{$fname}">XSLT 2.1 Specification</a>
     </p>
    </xsl:if>
   </xsl:if>

  <xsl:if test="$same-spec-references">
   <h3 class="subtitle">Links to W3C specifications</h3>
   <xsl:variable name="fname" select="$MyFunction/name"/>
   <xsl:variable name="p" select="signatures/proto[1]"/>
   <p>Namespace: <xsl:value-of select="$MyFunction/name/@namespace"/></p>
   <p>Applies to: <xsl:value-of select="fc:specs($p/in-spec)"/></p>
   <xsl:if test="$p/in-spec='xpath20'">
    <p>
     <a href="http://www.w3.org/TR/xpath-functions/#func-{$fname}">XPath 2.0 Functions and
      Operators</a>
    </p>
   </xsl:if>
   <xsl:if test="$p/in-spec='xpath30'">
    <p>
     <a href="http://www.w3.org/TR/xpath-functions-30/#func-{$fname}">XPath 3.0 Functions and
      Operators</a>
    </p>
   </xsl:if>
   <xsl:if test="$p/in-spec='xslt20' and not($p/in-spec='xpath20')">
    <p>
     <a href="http://www.w3.org/TR/xslt20/#function-{$fname}">XSLT 2.0 Specification</a>
    </p>
   </xsl:if>
   <xsl:if test="$p/in-spec='xslt30' and not($p/in-spec='xpath30')">
    <p>
     <a href="http://www.w3.org/TR/xslt-30/#function-{$fname}">XSLT 3.0 Specification</a>
    </p>
   </xsl:if>
  </xsl:if>

  <xsl:apply-templates select="status-ok|status" mode="f"/>
  <xsl:apply-templates select="notes" mode="f"/>

  <xsl:if test="see-also">
   <h3 class="subtitle">See also:</h3>
   <xsl:apply-templates select="see-also" mode="f"/>
  </xsl:if>

 </xsl:template>
 
 <xsl:template match="fc:description[p]" mode="add-p-if-necessary">
    <xsl:apply-templates/>
 </xsl:template>
 
 <xsl:template match="fc:description" mode="add-p-if-necessary">
  <p><xsl:apply-templates/></p>
 </xsl:template>

 <xsl:template match="signatures" mode="f"
  xpath-default-namespace="http://www.saxonica.com/ns/doc/functions">
  <xsl:for-each select="proto">
   <xsl:variable name="MyProto" select="."/>
   <p class="fn-sig">
    <xsl:value-of
     select="concat(@name,'(',string-join(for $arg in arg return concat('$',$arg/@name, ' as ', $arg/@type), ', ') ,')', ' → ',@return-type)"
    />
   </p>
   <table class="fn-prototype" style="margin-bottom:5px;">
    <tr>
     <td width="470" align="left" colspan="4" style="border-top:solid 1px;">
      <p>
       <i>
        <xsl:value-of select="if (exists(arg)) then 'Arguments' else 'There are no arguments'"/>
       </i>
      </p>
     </td>
    </tr>
    <xsl:for-each select="arg">
     <tr>
      <td width="40">
       <p>&#xa0;</p>
      </td>
      <td width="80" valign="top">
       <p>$<xsl:value-of select="@name"/></p>
      </td>
      <td valign="top" width="150">
       <p>
        <xsl:value-of select="@type"/>
       </p>
      </td>
      <td valign="top" width="200">
       <p>
        <xsl:value-of select="@desc"/>
       </p>
      </td>
     </tr>
    </xsl:for-each>
    <tr>
     <td colspan="2" style="border-top:solid 1px; border-bottom:solid 1px;">
      <p>
       <i>Result</i>
      </p>
     </td>

     <td style="border-top:solid 1px #3D5B96; border-bottom:solid 1px;" colspan="2">
      <p>
       <xsl:value-of select="$MyProto/@return-type"/>
      </p>
     </td>

    </tr>
   </table>
  </xsl:for-each>
 </xsl:template>

 <xsl:template match="function[name/@namespace ne 'http://www.w3.org/2005/xpath-functions']"
  priority="5" mode="f" xpath-default-namespace="http://www.saxonica.com/ns/doc/functions">

  <xsl:variable name="MyFunction" select="."/>
  <h1>
   <xsl:value-of select="fc:usual-prefix(name/@namespace), name" separator=":"/>
  </h1>

  <xsl:apply-templates select="summary" mode="f"/>
  <xsl:apply-templates select="signatures" mode="f"/>



  <xsl:apply-templates select="description/*" mode="f"/>

  <xsl:apply-templates select="status" mode="f"/>
  <xsl:apply-templates select="notes" mode="f"/>

  <xsl:if test="see-also">
   <h3 class="subtitle">See also:</h3>
   <xsl:apply-templates select="see-also" mode="f"/>
  </xsl:if>

 </xsl:template>

 <xsl:template match="div" xpath-default-namespace="" priority="8" mode="function-doc">
  <xsl:apply-templates select="child::node()" mode="function-doc"/>
 </xsl:template>

 <xsl:template match="*[namespace-uri()='']" priority="7" mode="function-doc">
  <xsl:copy-of select="."/>
 </xsl:template>

 <!--
<xsl:template match="status" mode="f">
<xsl:copy-of select="child::node()"/>
</xsl:template>

<xsl:template match="status[p]" mode="f">
<xsl:copy-of select="child::node()"/>
</xsl:template>
-->

 <xsl:function name="fc:specs" as="xs:string">
  <xsl:param name="in" as="element(fc:in-spec)*"/>
  <xsl:choose>
   <xsl:when test="$in = 'xpath20'">
    <xsl:text>XPath 2.0, XSLT 2.0, XQuery 1.0 and later versions</xsl:text>
   </xsl:when>
   <xsl:when test="$in = 'xpath30'">
    <xsl:text>XPath 3.0, XSLT 3.0, XQuery 3.0 (if enabled in Saxon: requires Saxon-PE or Saxon-EE)</xsl:text>
   </xsl:when>
   <xsl:when test="$in = 'xslt20'">
    <xsl:text>XSLT 2.0 and later versions</xsl:text>
   </xsl:when>
   <xsl:when test="$in = 'xslt30'">
    <xsl:text>XSLT 3.0 only (if enabled in Saxon: requires Saxon-PE or Saxon-EE)</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:sequence select="''"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:function>

</xsl:stylesheet>
