/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.XmlSettingsParser$1;
import org.apache.ivy.core.settings.XmlSettingsParser$IvyVariableContainerWrapper;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.Configurator$Attribute;
import org.apache.ivy.util.Configurator$MacroDef;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches", "signers");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivySettings) {
        this.ivy = ivySettings;
    }

    public final void parse(URL uRL) {
        this.configurator = new Configurator();
        this.configurator.setFileResolver(new XmlSettingsParser$1());
        Map map2 = this.ivy.getTypeDefs();
        Iterator iterator2 = map2.keySet().iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            this.configurator.typeDef(string, (Class)map2.get(string));
        }
        this.doParse(uRL);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParse(URL uRL) {
        this.settings = uRL;
        InputStream inputStream = null;
        try {
            inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
            new InputSource(inputStream).setSystemId(uRL.toExternalForm());
            SAXParserFactory.newInstance().newSAXParser().parse(uRL.toExternalForm(), (DefaultHandler)this);
            this.ivy.validate();
            if (inputStream == null) return;
        }
        catch (IOException iOException) {
            try {
                throw iOException;
                catch (Exception exception) {
                    ParseException parseException = new ParseException("failed to load settings from " + uRL + ": " + exception.getMessage(), 0);
                    parseException.initCause(exception);
                    throw parseException;
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        block62: {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                hashMap.put(attributes.getQName(i), this.ivy.substitute(attributes.getValue(i)));
            }
            try {
                if ("ivyconf".equals(string3)) {
                    this.deprecatedMessagePrinted = true;
                    Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
                }
                if (this.configurator.getCurrent() != null) {
                    this.inConfiguratorStarted(string3, hashMap);
                    return;
                }
                if ("classpath".equals(string3)) {
                    URL uRL;
                    HashMap<String, String> hashMap2 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    String string4 = (String)hashMap2.get("url");
                    if (string4 == null) {
                        String string5 = (String)hashMap2.get("file");
                        if (string5 == null) {
                            throw new IllegalArgumentException("either url or file should be given for classpath element");
                        }
                        uRL = xmlSettingsParser.urlFromFileAttribute(string5);
                    } else {
                        uRL = new URL(string4);
                    }
                    xmlSettingsParser.ivy.addClasspathURL(uRL);
                    return;
                }
                if ("typedef".equals(string3)) {
                    HashMap<String, String> hashMap3 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    String string6 = (String)hashMap3.get("name");
                    String string7 = (String)hashMap3.get("classname");
                    Class clazz = xmlSettingsParser.ivy.typeDef(string6, string7);
                    xmlSettingsParser.configurator.typeDef(string6, clazz);
                    return;
                }
                if ("property".equals(string3)) {
                    HashMap<String, String> hashMap4 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    String string8 = (String)hashMap4.get("name");
                    String string9 = (String)hashMap4.get("value");
                    String string10 = (String)hashMap4.get("override");
                    if (string8 == null) {
                        throw new IllegalArgumentException("missing attribute name on property tag");
                    }
                    if (string9 == null) {
                        throw new IllegalArgumentException("missing attribute value on property tag");
                    }
                    xmlSettingsParser.ivy.setVariable(string8, string9, string10 == null ? true : Boolean.valueOf(string10));
                    return;
                }
                if ("properties".equals(string3)) {
                    HashMap<String, String> hashMap5 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    String string11 = (String)hashMap5.get("file");
                    String string12 = (String)hashMap5.get("environment");
                    if (string11 != null) {
                        String string13 = (String)hashMap5.get("override");
                        boolean bl = string13 == null ? true : Boolean.valueOf(string13);
                        Message.verbose("loading properties: " + string11);
                        try {
                            URL uRL = xmlSettingsParser.urlFromFileAttribute(string11);
                            xmlSettingsParser.ivy.loadProperties(uRL, bl);
                            break block62;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Message.verbose("Unable to find property file: " + string11);
                            return;
                        }
                    }
                    if (string12 != null) {
                        xmlSettingsParser.ivy.getVariableContainer().setEnvironmentPrefix(string12);
                        return;
                    }
                    throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
                }
                if ("include".equals(string3)) {
                    HashMap<String, String> hashMap6 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    IvyVariableContainer ivyVariableContainer = xmlSettingsParser.ivy.getVariableContainer();
                    xmlSettingsParser.ivy.setVariableContainer(new XmlSettingsParser$IvyVariableContainerWrapper(ivyVariableContainer, 0));
                    try {
                        URL uRL;
                        String string14 = (String)hashMap6.get("file");
                        if (string14 == null) {
                            string14 = (String)hashMap6.get("url");
                            if (string14 == null) {
                                throw new IllegalArgumentException("bad include tag: specify file or url to include");
                            }
                            try {
                                uRL = new URL(string14);
                            }
                            catch (MalformedURLException malformedURLException) {
                                uRL = new URL(xmlSettingsParser.settings, string14);
                            }
                            Message.verbose("including url: " + uRL.toString());
                            xmlSettingsParser.ivy.setSettingsVariables(uRL);
                        } else {
                            uRL = xmlSettingsParser.urlFromFileAttribute(string14);
                            Message.verbose("including file: " + uRL);
                            if ("file".equals(uRL.getProtocol())) {
                                try {
                                    File file2 = new File(new URI(uRL.toExternalForm()));
                                    IvySettings ivySettings = xmlSettingsParser.ivy;
                                    String string15 = "settings include path";
                                    File file3 = file2;
                                    LogOptions.checkNotNull(file3, string15);
                                    if (!file3.isAbsolute()) {
                                        throw new IllegalArgumentException(string15 + " must be absolute: " + file3.getPath());
                                    }
                                    ivySettings.setSettingsVariables(FileUtil.normalize(file3.getPath()));
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    xmlSettingsParser.ivy.setSettingsVariables(LogOptions.checkAbsolute(uRL.getPath(), "settings include path"));
                                }
                            } else {
                                xmlSettingsParser.ivy.setSettingsVariables(uRL);
                            }
                        }
                        URL uRL2 = uRL;
                        Configurator configurator = xmlSettingsParser.configurator;
                        XmlSettingsParser xmlSettingsParser2 = new XmlSettingsParser(xmlSettingsParser.ivy);
                        new XmlSettingsParser(xmlSettingsParser.ivy).configurator = configurator;
                        xmlSettingsParser2.doParse(uRL2);
                        return;
                    }
                    finally {
                        xmlSettingsParser.ivy.setVariableContainer(ivyVariableContainer);
                    }
                }
                if ("settings".equals(string3) || "conf".equals(string3)) {
                    String string16;
                    String string17;
                    String string18;
                    String string19;
                    String string20;
                    String string21;
                    String string22;
                    String string23;
                    HashMap<String, String> hashMap7 = hashMap;
                    String string24 = string3;
                    XmlSettingsParser xmlSettingsParser = this;
                    if ("conf".equals(string24) && !xmlSettingsParser.deprecatedMessagePrinted) {
                        Message.deprecated("'conf' is deprecated, use 'settings' instead (" + xmlSettingsParser.settings + ")");
                    }
                    if ((string23 = (String)hashMap7.get("defaultCache")) != null) {
                        Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + xmlSettingsParser.settings + ")");
                        xmlSettingsParser.ivy.setDefaultCache(LogOptions.checkAbsolute(string23, "defaultCache"));
                    }
                    if ((string22 = (String)hashMap7.get("defaultBranch")) != null) {
                        xmlSettingsParser.ivy.setDefaultBranch(string22);
                    }
                    if ((string21 = (String)hashMap7.get("defaultResolveMode")) != null) {
                        xmlSettingsParser.ivy.setDefaultResolveMode(string21);
                    }
                    if ((string20 = (String)hashMap7.get("validate")) != null) {
                        xmlSettingsParser.ivy.setValidate(Boolean.valueOf(string20));
                    }
                    if ((string19 = (String)hashMap7.get("checkUpToDate")) != null) {
                        Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + xmlSettingsParser.settings + ")");
                        xmlSettingsParser.ivy.setCheckUpToDate(Boolean.valueOf(string19));
                    }
                    if ((string18 = (String)hashMap7.get("useRemoteConfig")) != null) {
                        xmlSettingsParser.ivy.setUseRemoteConfig(Boolean.valueOf(string18));
                    }
                    if ((string17 = (String)hashMap7.get("cacheIvyPattern")) != null) {
                        Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + xmlSettingsParser.settings + ")");
                        xmlSettingsParser.ivy.setDefaultCacheIvyPattern(string17);
                    }
                    if ((string16 = (String)hashMap7.get("cacheArtifactPattern")) != null) {
                        Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + xmlSettingsParser.settings + ")");
                        xmlSettingsParser.ivy.setDefaultCacheArtifactPattern(string16);
                    }
                    xmlSettingsParser.defaultResolver = (String)hashMap7.get("defaultResolver");
                    xmlSettingsParser.defaultCM = (String)hashMap7.get("defaultConflictManager");
                    xmlSettingsParser.defaultLatest = (String)hashMap7.get("defaultLatestStrategy");
                    xmlSettingsParser.defaultCircular = (String)hashMap7.get("circularDependencyStrategy");
                    String string25 = (String)hashMap7.get("httpRequestMethod");
                    if ("head".equalsIgnoreCase(string25)) {
                        URLHandlerRegistry.getHttp().setRequestMethod(2);
                        return;
                    }
                    if ("get".equalsIgnoreCase(string25)) {
                        URLHandlerRegistry.getHttp().setRequestMethod(1);
                        return;
                    }
                    if (string25 != null && string25.trim().length() > 0) {
                        throw new IllegalArgumentException("Invalid httpRequestMethod specified, must be one of {'HEAD', 'GET'}");
                    }
                    return;
                }
                if ("caches".equals(string3)) {
                    String string26;
                    String string27;
                    String string28;
                    String string29;
                    String string30;
                    String string31;
                    HashMap<String, String> hashMap8 = hashMap;
                    String string32 = string3;
                    XmlSettingsParser xmlSettingsParser = this;
                    xmlSettingsParser.anyConfiguratorStarted(string32);
                    xmlSettingsParser.defaultLock = (String)hashMap8.get("lockStrategy");
                    xmlSettingsParser.defaultCacheManager = (String)hashMap8.get("default");
                    String string33 = (String)hashMap8.get("defaultCacheDir");
                    if (string33 != null) {
                        xmlSettingsParser.ivy.setDefaultCache(LogOptions.checkAbsolute(string33, "defaultCacheDir"));
                    }
                    if ((string31 = (String)hashMap8.get("checkUpToDate")) != null) {
                        Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + xmlSettingsParser.settings + ")");
                        xmlSettingsParser.ivy.setCheckUpToDate(Boolean.valueOf(string31));
                    }
                    if ((string30 = (String)hashMap8.get("resolutionCacheDir")) != null) {
                        xmlSettingsParser.ivy.setDefaultResolutionCacheBasedir(string30);
                    }
                    if ((string29 = (String)hashMap8.get("useOrigin")) != null) {
                        xmlSettingsParser.ivy.setDefaultUseOrigin(Boolean.valueOf(string29));
                    }
                    if ((string28 = (String)hashMap8.get("ivyPattern")) != null) {
                        xmlSettingsParser.ivy.setDefaultCacheIvyPattern(string28);
                    }
                    if ((string27 = (String)hashMap8.get("artifactPattern")) != null) {
                        xmlSettingsParser.ivy.setDefaultCacheArtifactPattern(string27);
                    }
                    if ((string26 = (String)hashMap8.get("repositoryCacheDir")) != null) {
                        xmlSettingsParser.ivy.setDefaultRepositoryCacheBasedir(string26);
                    }
                    return;
                }
                if ("version-matchers".equals(string3)) {
                    HashMap<String, String> hashMap9 = hashMap;
                    String string34 = string3;
                    XmlSettingsParser xmlSettingsParser = this;
                    xmlSettingsParser.anyConfiguratorStarted(string34);
                    if ("true".equals((String)hashMap9.get("usedefaults"))) {
                        xmlSettingsParser.ivy.configureDefaultVersionMatcher();
                    }
                    return;
                }
                if ("statuses".equals(string3)) {
                    HashMap<String, String> hashMap10 = hashMap;
                    String string35 = string3;
                    XmlSettingsParser xmlSettingsParser = this;
                    this.currentConfiguratorTag = string35;
                    StatusManager statusManager = new StatusManager();
                    String string36 = (String)hashMap10.get("default");
                    if (string36 != null) {
                        statusManager.setDefaultStatus(string36);
                    }
                    xmlSettingsParser.ivy.setStatusManager(statusManager);
                    xmlSettingsParser.configurator.setRoot(statusManager);
                    return;
                }
                if (this.configuratorTags.contains(string3)) {
                    this.anyConfiguratorStarted(string3);
                    return;
                }
                if ("macrodef".equals(string3)) {
                    HashMap<String, String> hashMap11 = hashMap;
                    String string37 = string3;
                    XmlSettingsParser xmlSettingsParser = this;
                    this.currentConfiguratorTag = string37;
                    String string38 = "name";
                    Configurator$MacroDef configurator$MacroDef = xmlSettingsParser.configurator.startMacroDef((String)hashMap11.get("name"));
                    Configurator$Attribute configurator$Attribute = new Configurator$Attribute();
                    configurator$Attribute.setName(string38);
                    configurator$Attribute.setDefault(null);
                    configurator$MacroDef.addConfiguredAttribute(configurator$Attribute);
                    return;
                }
                if ("module".equals(string3)) {
                    HashMap<String, String> hashMap12 = hashMap;
                    XmlSettingsParser xmlSettingsParser = this;
                    hashMap12.put("module", (String)hashMap12.remove("name"));
                    String string39 = (String)hashMap12.remove("resolver");
                    String string40 = (String)hashMap12.remove("branch");
                    String string41 = (String)hashMap12.remove("conflict-manager");
                    String string42 = (String)hashMap12.remove("resolveMode");
                    String string43 = (String)hashMap12.remove("matcher");
                    string43 = string43 == null ? "exactOrRegexp" : string43;
                    xmlSettingsParser.ivy.addModuleConfiguration(hashMap12, xmlSettingsParser.ivy.getMatcher(string43), string39, string40, string41, string42);
                    return;
                }
                if ("credentials".equals(string3)) {
                    HashMap<String, String> hashMap13 = hashMap;
                    String string44 = (String)hashMap13.remove("realm");
                    String string45 = (String)hashMap13.remove("host");
                    String string46 = (String)hashMap13.remove("username");
                    String string47 = (String)hashMap13.remove("passwd");
                    CredentialsStore.addCredentials(string44, string45, string46, string47);
                }
                return;
            }
            catch (ParseException parseException) {
                SAXException sAXException = new SAXException("problem in config file: " + parseException.getMessage(), parseException);
                sAXException.initCause(parseException);
                throw sAXException;
            }
            catch (IOException iOException) {
                SAXException sAXException = new SAXException("io problem while parsing config file: " + iOException.getMessage(), iOException);
                sAXException.initCause(iOException);
                throw sAXException;
            }
        }
    }

    private void anyConfiguratorStarted(String string) {
        this.currentConfiguratorTag = string;
        this.configurator.setRoot(this.ivy);
    }

    private URL urlFromFileAttribute(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file2 = new File(string);
            if (file2.isAbsolute()) {
                if (!file2.exists()) {
                    throw new FileNotFoundException(file2.getAbsolutePath());
                }
                return file2.toURI().toURL();
            }
            if ("file".equals(this.settings.getProtocol())) {
                try {
                    File file3 = new File(new URI(this.settings.toExternalForm()));
                    if (!file3.exists()) {
                        throw new FileNotFoundException(file3.getAbsolutePath());
                    }
                    return new File(file3.getParentFile(), string).toURI().toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new URL(this.settings, string);
                }
            }
            return new URL(this.settings, string);
        }
    }

    private void inConfiguratorStarted(String string, Map map2) {
        Object object;
        if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(string) != null) {
            object = (String)map2.get("name");
            if (object == null) {
                map2.put("name", "@{name}");
            } else if (((String)object).indexOf("@{name}") != -1) {
                map2.put("name", object);
            } else {
                map2.put("name", "@{name}-" + (String)object);
            }
        }
        if (map2.get("ref") != null) {
            if (map2.size() != 1) {
                throw new IllegalArgumentException("ref attribute should be the only one ! found " + map2.size() + " in " + string);
            }
            object = (String)map2.get("ref");
            Object object2 = null;
            if ("resolvers".equals(this.currentConfiguratorTag) || "resolver".equals(string)) {
                object2 = this.ivy.getResolver((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown resolver " + (String)object + ": resolver should be defined before being referenced");
                }
            } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                object2 = this.ivy.getLatestStrategy((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown latest strategy " + (String)object + ": latest strategy should be defined before being referenced");
                }
            } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (object2 = this.ivy.getConflictManager((String)object)) == null) {
                throw new IllegalArgumentException("unknown conflict manager " + (String)object + ": conflict manager should be defined before being referenced");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("bad reference " + (String)object);
            }
            this.configurator.addChild(string, object2);
            return;
        }
        this.configurator.startCreateChild(string);
        object = map2.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            this.configurator.setAttribute(string2, (String)map2.get(string2));
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(string3) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
                return;
            }
            if ("macrodef".equals(string3) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
                return;
            }
            this.configurator.endCreateChild();
        }
    }

    public void endDocument() {
        Object object;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            object = this.ivy.getConflictManager(this.ivy.substitute(this.defaultCM));
            if (object == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager((ConflictManager)object);
        }
        if (this.defaultLatest != null) {
            object = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (object == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy((LatestStrategy)object);
        }
        if (this.defaultCacheManager != null) {
            object = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (object == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager((RepositoryCacheManager)object);
        }
        if (this.defaultCircular != null) {
            object = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (object == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)object);
        }
        if (this.defaultLock != null) {
            object = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (object == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)object);
        }
    }
}

