/*
    Sloth - Mac OS X Graphical User Interface front-end for lsof
    Copyright (C) 2004-2006 Sveinbjorn Thordarson <sveinbjornt@simnet.is>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#import "STGestalt.h"


@implementation STGestalt
+ (int)cpuClockSpeed
{
	long cpuSpeed;
	Gestalt (gestaltProcClkSpeed, &cpuSpeed);
	return cpuSpeed;
}

+ (NSString *)cpuClockSpeedAsString;
{
	long cpuSpeed;
	Gestalt (gestaltProcClkSpeed, &cpuSpeed);
	return ([[NSString alloc] initWithFormat:@"%d", cpuSpeed]);
}

+ (NSString *)cpuClockSpeedAsHumanReadableString;
{
	long cpuSpeed;
	Gestalt (gestaltProcClkSpeed, &cpuSpeed);
	
	//if more than 1Ghz
	if (cpuSpeed > 1000000000)
	{
		//as gigahertz
		return ([[NSString alloc] initWithFormat:@"%.2f GHz", (float)cpuSpeed/1000000000]);
	}
	//As megahertz
	return ([[NSString alloc] initWithFormat:@"%.0f MHz", (float)cpuSpeed/1000000]);
}

+ (int)OSVersionAsHex;
{
	long sysVersion;
	Gestalt (gestaltSystemVersion, &sysVersion);
	return sysVersion;
}

+ (NSString *)OSVersionAsString;
{
	NSTask			*task = [[NSTask alloc] init];
	NSPipe			*pipe = [NSPipe pipe];
	NSData			*data;

	//sw_vers -productVersion
	[task setLaunchPath: @"/usr/bin/sw_vers"];
	[task setArguments: [NSArray arrayWithObjects: @"-productVersion", nil]];
	[task setStandardOutput: pipe];
	[task launch];
	
	data = [[pipe fileHandleForReading] readDataToEndOfFile];
	
	[task release];
	
	NSString *version = [[NSString alloc] initWithData: data encoding: NSASCIIStringEncoding];
	
	return(version);
}

+ (NSString *)OSTypeAsString;
{
	NSTask			*task = [[NSTask alloc] init];
	NSPipe			*pipe = [NSPipe pipe];
	NSData			*data;

	//sw_vers -productName
	[task setLaunchPath: @"/usr/bin/sw_vers"];
	[task setArguments: [NSArray arrayWithObjects: @"-productName", nil]];
	[task setStandardOutput: pipe];
	[task launch];
	
	data = [[pipe fileHandleForReading] readDataToEndOfFile];
	
	[task release];
	
	NSString *type = [[NSString alloc] initWithData: data encoding: NSASCIIStringEncoding];
	
	return(type);
}

+ (NSString *)buildVersionAsString;
{
	NSTask			*task = [[NSTask alloc] init];
	NSPipe			*pipe = [NSPipe pipe];
	NSData			*data;

	//sw_vers -productName
	[task setLaunchPath: @"/usr/bin/sw_vers"];
	[task setArguments: [NSArray arrayWithObjects: @"-buildVersion", nil]];
	[task setStandardOutput: pipe];
	[task launch];
	
	data = [[pipe fileHandleForReading] readDataToEndOfFile];
	
	[task release];
	
	NSString *version = [[NSString alloc] initWithData: data encoding: NSASCIIStringEncoding];
	
	return(version);
}

+ (int)physicalRAMSize
{
	long ramSize;
	Gestalt (gestaltPhysicalRAMSize, &ramSize);
	return ramSize;
}

+ (NSString *)physicalRAMSizeAsString
{
	long ramSize;
	Gestalt (gestaltPhysicalRAMSize, &ramSize);
	return ([[NSString alloc] initWithFormat:@"%d", ramSize]);
}

+ (NSString *)physicalRAMSizeAsHumanReadableString
{
	long ramSize;
	Gestalt (gestaltPhysicalRAMSize, &ramSize);
	return ([[NSString alloc] initWithFormat:@"%d MB", ramSize/(1024*1024)]);
}

+ (NSString *)kernelVersionAsString
{
	NSTask			*task = [[NSTask alloc] init];
	NSPipe			*pipe = [NSPipe pipe];
	NSData			*data;

	//sw_vers -productName
	[task setLaunchPath: @"/usr/bin/uname"];
	[task setArguments: [NSArray arrayWithObjects: @"-r", nil]];
	[task setStandardOutput: pipe];
	[task launch];
	
	data = [[pipe fileHandleForReading] readDataToEndOfFile];
	
	[task release];
	
	NSString *version = [[NSString alloc] initWithData: data encoding: NSASCIIStringEncoding];
	
	return(version);
}
@end
