/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.process;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.config.java.internal.enhancement.CglibConfigurationEnhancer;
import org.springframework.config.java.internal.factory.BeanFactoryProvider;
import org.springframework.config.java.internal.factory.DefaultJavaConfigBeanFactory;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.internal.factory.support.AsmJavaConfigBeanDefinitionReader;
import org.springframework.config.java.internal.process.ChildContextRefreshingListener;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public class InternalConfigurationPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log logger = LogFactory.getLog(InternalConfigurationPostProcessor.class);
    private final AbstractApplicationContext externalContext;
    private final BeanNamingStrategy beanNamingStrategy;
    private final BeanFactoryProvider beanFactoryProvider;
    private final ArrayList<String> ignoredBeanPostProcessors = new ArrayList();

    public InternalConfigurationPostProcessor(AbstractApplicationContext enclosingContext, BeanNamingStrategy beanNamingStrategy, BeanFactoryProvider beanFactoryProvider) {
        this.externalContext = enclosingContext;
        this.beanNamingStrategy = beanNamingStrategy;
        this.beanFactoryProvider = beanFactoryProvider;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory externalBeanFactory) throws BeansException {
        JavaConfigBeanFactory internalBeanFactory = this.createInternalBeanFactory(externalBeanFactory);
        this.parseAnyConfigurationClasses(externalBeanFactory, internalBeanFactory);
        this.enhanceAnyConfigurationClasses(externalBeanFactory, internalBeanFactory);
    }

    public void addIgnoredBeanPostProcessor(String bppClassName) {
        this.ignoredBeanPostProcessors.add(bppClassName);
    }

    private JavaConfigBeanFactory createInternalBeanFactory(ConfigurableListableBeanFactory externalBeanFactory) {
        DefaultJavaConfigBeanFactory internalBeanFactory = new DefaultJavaConfigBeanFactory(externalBeanFactory, this.beanFactoryProvider);
        if (this.beanNamingStrategy != null) {
            internalBeanFactory.setBeanNamingStrategy(this.beanNamingStrategy);
        }
        this.wrapInternalBeanFactoryInApplicationContext(internalBeanFactory);
        return internalBeanFactory;
    }

    private void wrapInternalBeanFactoryInApplicationContext(DefaultJavaConfigBeanFactory internalBeanFactory) {
        GenericApplicationContext internalContext = new GenericApplicationContext((DefaultListableBeanFactory)internalBeanFactory);
        internalContext.setDisplayName("JavaConfig internal application context");
        this.externalContext.addApplicationListener((ApplicationListener)new ChildContextRefreshingListener(this.externalContext, (AbstractApplicationContext)internalContext, this.ignoredBeanPostProcessors));
    }

    private void parseAnyConfigurationClasses(ConfigurableListableBeanFactory externalBeanFactory, JavaConfigBeanFactory internalBeanFactory) {
        LinkedHashMap<String, ClassPathResource> configClassResources = new LinkedHashMap<String, ClassPathResource>();
        String[] stringArray = externalBeanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = externalBeanFactory.getBeanDefinition(beanName);
            if (!beanDef.isAbstract() && beanDef.hasAttribute("IS_CONFIGURATION_CLASS")) {
                String path = ClassUtils.convertClassNameToResourcePath((String)beanDef.getBeanClassName());
                configClassResources.put(beanName, new ClassPathResource(path));
            }
            ++n2;
        }
        AsmJavaConfigBeanDefinitionReader reader = new AsmJavaConfigBeanDefinitionReader(internalBeanFactory);
        reader.loadBeanDefinitions(configClassResources);
    }

    private void enhanceAnyConfigurationClasses(ConfigurableListableBeanFactory externalBeanFactory, JavaConfigBeanFactory internalBeanFactory) {
        CglibConfigurationEnhancer enhancer = new CglibConfigurationEnhancer(internalBeanFactory);
        int configClassesEnhanced = 0;
        String[] stringArray = externalBeanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = externalBeanFactory.getBeanDefinition(beanName);
            if (beanDef.hasAttribute("IS_CONFIGURATION_CLASS")) {
                String configClassName = beanDef.getBeanClassName();
                String enhancedClassName = enhancer.enhance(configClassName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Replacing bean definition '%s' existing class name '%s' with enhanced class name '%s'", beanName, configClassName, enhancedClassName));
                }
                beanDef.setBeanClassName(enhancedClassName);
                ++configClassesEnhanced;
            }
            ++n2;
        }
        if (configClassesEnhanced == 0) {
            logger.warn((Object)("Found no @Configuration class BeanDefinitions within " + internalBeanFactory));
        }
    }
}

