/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.config.java.internal.util.MethodAnnotationPrototype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationExtractionUtils {
    public static <A extends Annotation> A extractMethodAnnotation(Class<A> targetAnno, Class<? extends MethodAnnotationPrototype> prototype) {
        try {
            return prototype.getDeclaredMethod("targetMethod", new Class[0]).getAnnotation(targetAnno);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <A extends Annotation> A extractClassAnnotation(Class<A> targetAnno, Class<?> prototype) {
        try {
            return prototype.getAnnotation(targetAnno);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <A extends Annotation> A findAnnotation(Class<A> targetType, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.annotationType().equals(targetType)) {
                return (A)a;
            }
            ++n2;
        }
        return null;
    }

    public static Annotation[] findAnnotations(Method method) {
        return AnnotationExtractionUtils.findAnnotations(method, new AnnotationFilter(){

            public boolean accept(Annotation candidate) {
                return true;
            }
        });
    }

    public static Annotation[] findAnnotations(Method m, AnnotationFilter filter) {
        Method method = m;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class<?> cl = method.getDeclaringClass();
        while (true) {
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation candidate = annotationArray[n2];
                if (filter.accept(candidate)) {
                    annotations.add(candidate);
                }
                ++n2;
            }
            if ((cl = cl.getSuperclass()) == null) break;
            try {
                method = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            break;
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static interface AnnotationFilter {
        public boolean accept(Annotation var1);
    }
}

