/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.bpp.sjc118;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;

import org.springframework.util.Assert;


/** TODO: JAVADOC */
@Configuration
public class SpringConfig {
    private static final Log logger = LogFactory.getLog(SpringConfig.class);

    private InjectableConfigurationSupport support;

    @InjectConfigurationSupport
    public void setSupport(InjectableConfigurationSupport support) {
        this.support = support;
        logger.info("Support injected in SpringConfig: " + support);
    }

    @Bean
    public CustomBean demoBean() {
        Assert.notNull(support, "ConfigurationSupport must be injected before calling this");
        return (CustomBean) support.getObject(new JavaConfiguredBeanFactory());
    }

}
