/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.annotation.valuesource;

import static org.springframework.beans.factory.support.BeanDefinitionBuilder.rootBeanDefinition;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.valuesource.SystemPropertiesValueResolver;

/**
 * Handler for {@link SystemPropertiesValueSource} annotation. Returns a bean definition of type
 * {@link SystemPropertiesValueResolver} to be registered with the enclosing bean factory.
 * 
 * @author Chris Beams
 * 
 * @see AbstractValueSourceHandler
 * @see SystemPropertiesValueSource
 */
class SystemPropertiesValueSourceHandler extends AbstractValueSourceHandler<SystemPropertiesValueSource> {

    @Override
    public BeanDefinition doHandle(SystemPropertiesValueSource annotation, BeanDefinitionRegistry registry) {
        return rootBeanDefinition(SystemPropertiesValueResolver.class).getBeanDefinition();
    }

}
