/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.config.ChristianHoliday;
import de.jollyday.config.Holidays;
import de.jollyday.parser.impl.RelativeToEasterSundayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChristianHolidayParser
extends RelativeToEasterSundayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (ChristianHoliday ch : config.getChristianHoliday()) {
            if (!this.isValid(ch, year)) continue;
            LocalDate easterSunday = this.getEasterSunday(year, ch.getChronology());
            switch (ch.getType()) {
                case EASTER: {
                    break;
                }
                case CLEAN_MONDAY: 
                case SHROVE_MONDAY: {
                    easterSunday = easterSunday.minusDays(48);
                    break;
                }
                case MARDI_GRAS: 
                case CARNIVAL: {
                    easterSunday = easterSunday.minusDays(47);
                    break;
                }
                case ASH_WEDNESDAY: {
                    easterSunday = easterSunday.minusDays(46);
                    break;
                }
                case MAUNDY_THURSDAY: {
                    easterSunday = easterSunday.minusDays(3);
                    break;
                }
                case GOOD_FRIDAY: {
                    easterSunday = easterSunday.minusDays(2);
                    break;
                }
                case EASTER_SATURDAY: {
                    easterSunday = easterSunday.minusDays(1);
                    break;
                }
                case EASTER_MONDAY: {
                    easterSunday = easterSunday.plusDays(1);
                    break;
                }
                case EASTER_TUESDAY: {
                    easterSunday = easterSunday.plusDays(2);
                    break;
                }
                case GENERAL_PRAYER_DAY: {
                    easterSunday = easterSunday.plusDays(26);
                    break;
                }
                case ASCENSION_DAY: {
                    easterSunday = easterSunday.plusDays(39);
                    break;
                }
                case PENTECOST: 
                case WHIT_SUNDAY: {
                    easterSunday = easterSunday.plusDays(49);
                    break;
                }
                case WHIT_MONDAY: 
                case PENTECOST_MONDAY: {
                    easterSunday = easterSunday.plusDays(50);
                    break;
                }
                case CORPUS_CHRISTI: {
                    easterSunday = easterSunday.plusDays(60);
                    break;
                }
                case SACRED_HEART: {
                    easterSunday = easterSunday.plusDays(68);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown christian holiday type " + (Object)((Object)ch.getType()));
                }
            }
            easterSunday = this.moveDate(ch, easterSunday);
            String propertiesKey = "christian." + ch.getType().name();
            this.addChrstianHoliday(easterSunday, propertiesKey, ch.getLocalizedType(), holidays);
        }
    }
}

