/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapNodePattern;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.TwoDimensionalCollectionValuedMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Function;

public class CoreMapNodePatternTrigger
implements MultiPatternMatcher.NodePatternTrigger<CoreMap> {
    Collection<? extends SequencePattern<CoreMap>> patterns;
    Collection<SequencePattern<CoreMap>> alwaysTriggered = new LinkedHashSet<SequencePattern<CoreMap>>();
    TwoDimensionalCollectionValuedMap<Class, Object, SequencePattern<CoreMap>> annotationTriggers = new TwoDimensionalCollectionValuedMap();
    TwoDimensionalCollectionValuedMap<Class, String, SequencePattern<CoreMap>> lowercaseStringTriggers = new TwoDimensionalCollectionValuedMap();

    public CoreMapNodePatternTrigger(SequencePattern<CoreMap> ... patterns) {
        this(Arrays.asList(patterns));
    }

    public CoreMapNodePatternTrigger(Collection<? extends SequencePattern<CoreMap>> patterns) {
        this.patterns = patterns;
        Function<NodePattern, Triple> textTriggerFilter = in -> {
            if (in instanceof CoreMapNodePattern) {
                CoreMapNodePattern p = (CoreMapNodePattern)in;
                for (Pair<Class, NodePattern> v : p.getAnnotationPatterns()) {
                    if (v.first != CoreAnnotations.TextAnnotation.class || !(v.second instanceof CoreMapNodePattern.StringAnnotationPattern)) continue;
                    return Triple.makeTriple(v.first, ((CoreMapNodePattern.StringAnnotationPattern)v.second).target, ((CoreMapNodePattern.StringAnnotationPattern)v.second).ignoreCase());
                }
            }
            return null;
        };
        for (SequencePattern<CoreMap> sequencePattern : patterns) {
            Triple firstTextTrigger = sequencePattern.findNodePattern(textTriggerFilter);
            if (firstTextTrigger != null) {
                if (((Boolean)firstTextTrigger.third).booleanValue()) {
                    this.lowercaseStringTriggers.add((Class)firstTextTrigger.first, ((String)firstTextTrigger.second).toLowerCase(), sequencePattern);
                    continue;
                }
                this.annotationTriggers.add((Class)firstTextTrigger.first, firstTextTrigger.second, sequencePattern);
                continue;
            }
            this.alwaysTriggered.add(sequencePattern);
        }
    }

    @Override
    public Collection<SequencePattern<CoreMap>> apply(CoreMap in) {
        Collection<SequencePattern<CoreMap>> triggered;
        Object value;
        LinkedHashSet<SequencePattern<CoreMap>> triggeredPatterns = new LinkedHashSet<SequencePattern<CoreMap>>();
        triggeredPatterns.addAll(this.alwaysTriggered);
        for (Class key : this.annotationTriggers.firstKeySet()) {
            value = in.get(key);
            if (value == null || (triggered = this.annotationTriggers.get(key, value)) == null) continue;
            triggeredPatterns.addAll(triggered);
        }
        for (Class key : this.lowercaseStringTriggers.firstKeySet()) {
            value = in.get(key);
            if (value == null || !(value instanceof String) || (triggered = this.lowercaseStringTriggers.get(key, ((String)value).toLowerCase())) == null) continue;
            triggeredPatterns.addAll(triggered);
        }
        return triggeredPatterns;
    }
}

