/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;

public class TaggerFeature
extends Feature {
    private final int start;
    private final int end;
    private final FeatureKey key;
    private final int yTag;
    private final TaggerExperiments domain;

    protected TaggerFeature(int start, int end, FeatureKey key, int yTag, TaggerExperiments domain) {
        this.start = start;
        this.end = end;
        this.key = key;
        this.domain = domain;
        this.yTag = yTag;
    }

    @Override
    public double getVal(int index) {
        return 1.0;
    }

    @Override
    public int getY(int index) {
        return this.yTag;
    }

    @Override
    public int len() {
        return this.end - this.start + 1;
    }

    @Override
    public int getX(int index) {
        return this.domain.getTaggerFeatures().xIndexed[this.start + index];
    }

    public int getYTag() {
        return this.yTag;
    }

    @Override
    public double getVal(int x, int y) {
        int num = x * this.domain.ySize + y;
        if (this.getYTag() != y) {
            return 0.0;
        }
        for (int i = 0; i < this.len(); ++i) {
            if (this.getX(i) != num) continue;
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double ftilde() {
        double s = 0.0;
        int y = this.getYTag();
        for (int example = this.start; example < this.end + 1; ++example) {
            int x = this.domain.getTaggerFeatures().xIndexed[example];
            s += this.domain.ptildeXY(x, y);
        }
        return s;
    }
}

