/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class PennTreeReader
implements TreeReader {
    private static final Redwood.RedwoodChannels log = Redwood.channels(PennTreeReader.class);
    private final Reader reader;
    private final Tokenizer<String> tokenizer;
    private final TreeNormalizer treeNormalizer;
    private final TreeFactory treeFactory;
    private static final boolean DEBUG = false;
    private Tree currentTree;
    private ArrayList<Tree> stack;
    private static final String leftParen = "(";
    private static final String rightParen = ")";
    private static final Pattern STAR_PATTERN = Pattern.compile("\\\\\\*");
    private static final Pattern SLASH_PATTERN = Pattern.compile("\\\\/");
    private static final Pattern LRB_PATTERN = Pattern.compile("-LRB-|=LRB=");
    private static final Pattern RRB_PATTERN = Pattern.compile("-RRB-|=RRB=");

    public PennTreeReader(Reader in) {
        this(in, new LabeledScoredTreeFactory());
    }

    public PennTreeReader(Reader in, TreeFactory tf) {
        this(in, tf, null, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn) {
        this(in, tf, tn, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn, Tokenizer<String> st) {
        String first;
        this.reader = in;
        this.treeFactory = tf;
        this.treeNormalizer = tn;
        this.tokenizer = st;
        String string = first = st.hasNext() ? st.peek() : null;
        if (first != null && first.startsWith("*x*x*x")) {
            int foundCount = 0;
            while (foundCount < 4 && st.hasNext()) {
                first = (String)st.next();
                if (first == null || !first.startsWith("*x*x*x")) continue;
                ++foundCount;
            }
        }
    }

    @Override
    public Tree readTree() throws IOException {
        Tree t = null;
        while (this.tokenizer.hasNext() && t == null) {
            this.currentTree = null;
            this.stack = new ArrayList();
            try {
                t = this.getTreeFromInputStream();
            }
            catch (NoSuchElementException e) {
                throw new IOException("End of token stream encountered before parsing could complete.");
            }
            if (t == null) continue;
            if (this.treeNormalizer != null && this.treeFactory != null) {
                t = this.treeNormalizer.normalizeWholeTree(t, this.treeFactory);
            }
            if (t == null) continue;
            t.indexLeaves(true);
        }
        return t;
    }

    private Tree getTreeFromInputStream() throws NoSuchElementException {
        int wordIndex = 1;
        block8: while (this.tokenizer.hasNext()) {
            String token;
            switch (token = (String)this.tokenizer.next()) {
                case "(": {
                    String label = this.tokenizer.peek().equals(leftParen) ? null : (String)this.tokenizer.next();
                    if (rightParen.equals(label)) continue block8;
                    if (this.treeNormalizer != null) {
                        label = this.treeNormalizer.normalizeNonterminal(label);
                    }
                    if (label != null) {
                        label = STAR_PATTERN.matcher(label).replaceAll("*");
                        label = SLASH_PATTERN.matcher(label).replaceAll("/");
                    }
                    Tree newTree = this.treeFactory.newTreeNode(label, null);
                    if (this.currentTree == null) {
                        this.stack.add(newTree);
                    } else {
                        this.currentTree.addChild(newTree);
                        this.stack.add(this.currentTree);
                    }
                    this.currentTree = newTree;
                    continue block8;
                }
                case ")": {
                    if (this.stack.isEmpty()) {
                        log.info("PennTreeReader: warning: file has extra non-matching right parenthesis [ignored]");
                        break block8;
                    }
                    this.currentTree = this.stack.remove(this.stack.size() - 1);
                    if (!this.stack.isEmpty()) continue block8;
                    return this.currentTree;
                }
                default: {
                    if (this.currentTree == null) break block8;
                    String terminal = this.treeNormalizer == null ? token : this.treeNormalizer.normalizeTerminal(token);
                    terminal = STAR_PATTERN.matcher(terminal).replaceAll("*");
                    terminal = SLASH_PATTERN.matcher(terminal).replaceAll("/");
                    terminal = LRB_PATTERN.matcher(terminal).replaceAll(leftParen);
                    Tree leaf = this.treeFactory.newLeaf(terminal = RRB_PATTERN.matcher(terminal).replaceAll(rightParen));
                    if (leaf.label() instanceof HasIndex) {
                        HasIndex hi = (HasIndex)((Object)leaf.label());
                        hi.setIndex(wordIndex);
                    }
                    if (leaf.label() instanceof HasWord) {
                        HasWord hw = (HasWord)((Object)leaf.label());
                        hw.setWord(leaf.label().value());
                    }
                    if (leaf.label() instanceof HasTag) {
                        HasTag ht = (HasTag)((Object)leaf.label());
                        ht.setTag(this.currentTree.label().value());
                    }
                    ++wordIndex;
                    this.currentTree.addChild(leaf);
                    continue block8;
                }
            }
        }
        if (this.currentTree != null) {
            log.info("PennTreeReader: warning: incomplete tree (extra left parentheses in input): " + this.currentTree);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static void main(String[] args) {
        try {
            LabeledScoredTreeFactory tf = new LabeledScoredTreeFactory();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
            PennTreeReader tr = new PennTreeReader(r, tf);
            Tree t = tr.readTree();
            while (t != null) {
                System.out.println(t);
                System.out.println();
                t = tr.readTree();
            }
            ((Reader)r).close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }
}

